/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.builtins;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLException;
import com.oracle.truffle.sl.builtins.SLBuiltinNode;
import com.oracle.truffle.sl.runtime.SLContext;
import com.oracle.truffle.sl.runtime.SLNull;

@NodeInfo(shortName="import")
public abstract class SLImportBuiltin
extends SLBuiltinNode {
    @Specialization
    public Object importSymbol(TruffleString symbol, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @CachedLibrary(limit="3") InteropLibrary arrays, @Bind SLContext context) {
        try {
            return arrays.readMember((Object)context.getPolyglotBindings(), toJavaStringNode.execute((AbstractTruffleString)symbol));
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e) {
            return SLNull.SINGLETON;
        }
        catch (SecurityException e) {
            throw SLException.create("No polyglot access allowed.", this);
        }
    }
}

