/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.builtins.SLBuiltinNode;
import com.oracle.truffle.sl.runtime.SLContext;

@NodeInfo(shortName="eval")
public abstract class SLEvalBuiltin
extends SLBuiltinNode {
    static final int LIMIT = 2;

    @Specialization(guards={"stringsEqual(equalNodeId, cachedId, id)", "stringsEqual(equalNodeCode, cachedCode, code)"}, limit="LIMIT")
    public Object evalCached(TruffleString id, TruffleString code, @Cached(value="id") TruffleString cachedId, @Cached(value="code") TruffleString cachedCode, @Cached(value="create(parse(id, code))") DirectCallNode callNode, @Cached TruffleString.EqualNode equalNodeId, @Cached TruffleString.EqualNode equalNodeCode) {
        return callNode.call(new Object[0]);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(replaces={"evalCached"})
    public Object evalGeneric(TruffleString id, TruffleString code) {
        return this.parse(id, code).call((Node)this, new Object[0]);
    }

    protected CallTarget parse(TruffleString id, TruffleString code) {
        Source source = Source.newBuilder((String)id.toJavaStringUncached(), (CharSequence)code.toJavaStringUncached(), (String)"(eval)").build();
        return SLContext.get(this).parse(source);
    }

    protected static boolean stringsEqual(TruffleString.EqualNode node, TruffleString a, TruffleString b) {
        return node.execute((AbstractTruffleString)a, (AbstractTruffleString)b, SLLanguage.STRING_ENCODING);
    }
}

