/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.nfi.impl.ClosureNativePointer;
import com.oracle.truffle.nfi.impl.LibFFIClosure;
import com.oracle.truffle.nfi.impl.LibFFILibrary;
import com.oracle.truffle.nfi.impl.LibFFISignature;
import com.oracle.truffle.nfi.impl.LibFFISymbol;
import com.oracle.truffle.nfi.impl.LibFFIType;
import com.oracle.truffle.nfi.impl.NFILanguageImpl;
import com.oracle.truffle.nfi.impl.NativeAllocation;
import com.oracle.truffle.nfi.spi.types.NativeArrayTypeMirror;
import com.oracle.truffle.nfi.spi.types.NativeFunctionTypeMirror;
import com.oracle.truffle.nfi.spi.types.NativeSimpleType;
import com.oracle.truffle.nfi.spi.types.NativeSimpleTypeMirror;
import com.oracle.truffle.nfi.spi.types.NativeTypeMirror;
import java.util.HashMap;
import java.util.function.Supplier;

class NFIContext {
    final NFILanguageImpl language;
    TruffleLanguage.Env env;
    private long nativeContext;
    private final ThreadLocal<NativeEnv> nativeEnv = ThreadLocal.withInitial(new NativeEnvSupplier());
    @CompilerDirectives.CompilationFinal(dimensions=1)
    final LibFFIType[] simpleTypeMap = new LibFFIType[NativeSimpleType.values().length];
    @CompilerDirectives.CompilationFinal(dimensions=1)
    final LibFFIType[] arrayTypeMap = new LibFFIType[NativeSimpleType.values().length];
    private final HashMap<Long, ClosureNativePointer> nativePointerMap = new HashMap();
    @CompilerDirectives.CompilationFinal
    int RTLD_GLOBAL;
    @CompilerDirectives.CompilationFinal
    int RTLD_LOCAL;
    @CompilerDirectives.CompilationFinal
    int RTLD_LAZY;
    @CompilerDirectives.CompilationFinal
    int RTLD_NOW;

    NFIContext(NFILanguageImpl language, TruffleLanguage.Env env) {
        this.language = language;
        this.env = env;
    }

    void patchEnv(TruffleLanguage.Env newEnv) {
        this.env = newEnv;
    }

    long getNativeEnv() {
        return this.nativeEnv.get().pointer;
    }

    void initialize() {
        NFIContext.loadNFILib();
        NativeAllocation.ensureGCThreadRunning();
        this.nativeContext = this.initializeNativeContext();
        this.nativeEnv.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        if (this.nativeContext != 0L) {
            NFIContext.disposeNativeContext(this.nativeContext);
            this.nativeContext = 0L;
        }
        this.nativeEnv.set(null);
        HashMap<Long, ClosureNativePointer> hashMap = this.nativePointerMap;
        synchronized (hashMap) {
            this.nativePointerMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClosureNativePointer getClosureNativePointer(long codePointer) {
        HashMap<Long, ClosureNativePointer> hashMap = this.nativePointerMap;
        synchronized (hashMap) {
            return this.nativePointerMap.get(codePointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeClosureNativePointer(long codePointer) {
        HashMap<Long, ClosureNativePointer> hashMap = this.nativePointerMap;
        synchronized (hashMap) {
            this.nativePointerMap.remove(codePointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClosureNativePointer createClosureNativePointer(long nativeClosure, long codePointer, CallTarget callTarget, LibFFISignature signature) {
        ClosureNativePointer ret = ClosureNativePointer.create(this, nativeClosure, codePointer, callTarget, signature);
        HashMap<Long, ClosureNativePointer> hashMap = this.nativePointerMap;
        synchronized (hashMap) {
            this.nativePointerMap.put(codePointer, ret);
        }
        return ret;
    }

    void newClosureRef(long codePointer) {
        this.getClosureNativePointer(codePointer).addRef();
    }

    void releaseClosureRef(long codePointer) {
        this.getClosureNativePointer(codePointer).releaseRef();
    }

    TruffleObject getClosureObject(long codePointer) {
        return LibFFIClosure.newClosureWrapper(this.getClosureNativePointer(codePointer));
    }

    LibFFILibrary loadLibrary(String name, int flags) {
        return LibFFILibrary.create(NFIContext.loadLibrary(this.nativeContext, name, flags));
    }

    Object lookupSymbol(LibFFILibrary library, String name) {
        return LibFFISymbol.create(this.language, library, name, NFIContext.lookup(this.nativeContext, library.handle, name));
    }

    LibFFIType lookupArgType(NativeTypeMirror type) {
        return this.lookup(type, false);
    }

    LibFFIType lookupRetType(NativeTypeMirror type) {
        return this.lookup(type, true);
    }

    LibFFIType lookupSimpleType(NativeSimpleType type) {
        return this.simpleTypeMap[type.ordinal()];
    }

    private LibFFIType lookup(NativeTypeMirror type, boolean asRetType) {
        switch (type.getKind()) {
            case SIMPLE: {
                NativeSimpleTypeMirror simpleType = (NativeSimpleTypeMirror)type;
                return this.lookupSimpleType(simpleType.getSimpleType());
            }
            case ARRAY: {
                NativeArrayTypeMirror arrayType = (NativeArrayTypeMirror)type;
                NativeTypeMirror elementType = arrayType.getElementType();
                LibFFIType ret = null;
                if (elementType.getKind() == NativeTypeMirror.Kind.SIMPLE) {
                    ret = this.arrayTypeMap[((NativeSimpleTypeMirror)elementType).getSimpleType().ordinal()];
                }
                if (ret == null) {
                    throw new AssertionError((Object)"unsupported array type");
                }
                return ret;
            }
            case FUNCTION: {
                NativeFunctionTypeMirror functionType = (NativeFunctionTypeMirror)type;
                LibFFISignature signature = LibFFISignature.create(this, functionType.getSignature());
                return new LibFFIType.ClosureType(this.lookupSimpleType(NativeSimpleType.POINTER), signature, asRetType);
            }
            case ENV: {
                if (asRetType) {
                    throw new AssertionError((Object)"environment pointer can not be used as return type");
                }
                return new LibFFIType.EnvType(this.lookupSimpleType(NativeSimpleType.POINTER));
            }
        }
        throw new AssertionError((Object)"unsupported type");
    }

    protected void initializeSimpleType(NativeSimpleType simpleType, int size, int alignment, long ffiType) {
        assert (this.simpleTypeMap[simpleType.ordinal()] == null) : "initializeSimpleType called twice for " + (Object)((Object)simpleType);
        this.simpleTypeMap[simpleType.ordinal()] = LibFFIType.createSimpleType(this, simpleType, size, alignment, ffiType);
        this.arrayTypeMap[simpleType.ordinal()] = LibFFIType.createArrayType(this, simpleType);
    }

    private native long initializeNativeContext();

    private static native void disposeNativeContext(long var0);

    private static native long initializeNativeEnv(long var0);

    private static void loadNFILib() {
        String nfiLib = System.getProperty("truffle.nfi.library");
        if (nfiLib == null) {
            System.loadLibrary("trufflenfi");
        } else {
            System.load(nfiLib);
        }
    }

    ClosureNativePointer allocateClosureObjectRet(LibFFISignature signature, CallTarget callTarget) {
        return NFIContext.allocateClosureObjectRet(this.nativeContext, signature, callTarget);
    }

    ClosureNativePointer allocateClosureStringRet(LibFFISignature signature, CallTarget callTarget) {
        return NFIContext.allocateClosureStringRet(this.nativeContext, signature, callTarget);
    }

    ClosureNativePointer allocateClosureBufferRet(LibFFISignature signature, CallTarget callTarget) {
        return NFIContext.allocateClosureBufferRet(this.nativeContext, signature, callTarget);
    }

    ClosureNativePointer allocateClosureVoidRet(LibFFISignature signature, CallTarget callTarget) {
        return NFIContext.allocateClosureVoidRet(this.nativeContext, signature, callTarget);
    }

    private static native ClosureNativePointer allocateClosureObjectRet(long var0, LibFFISignature var2, CallTarget var3);

    private static native ClosureNativePointer allocateClosureStringRet(long var0, LibFFISignature var2, CallTarget var3);

    private static native ClosureNativePointer allocateClosureBufferRet(long var0, LibFFISignature var2, CallTarget var3);

    private static native ClosureNativePointer allocateClosureVoidRet(long var0, LibFFISignature var2, CallTarget var3);

    long prepareSignature(LibFFIType retType, LibFFIType ... args) {
        return NFIContext.prepareSignature(this.nativeContext, retType, args);
    }

    long prepareSignatureVarargs(LibFFIType retType, int nFixedArgs, LibFFIType ... args) {
        return NFIContext.prepareSignatureVarargs(this.nativeContext, retType, nFixedArgs, args);
    }

    private static native long prepareSignature(long var0, LibFFIType var2, LibFFIType ... var3);

    private static native long prepareSignatureVarargs(long var0, LibFFIType var2, int var3, LibFFIType ... var4);

    void executeNative(long cif, long functionPointer, byte[] primArgs, int patchCount, int[] patchOffsets, Object[] objArgs, byte[] ret) {
        NFIContext.executeNative(this.nativeContext, cif, functionPointer, primArgs, patchCount, patchOffsets, objArgs, ret);
    }

    long executePrimitive(long cif, long functionPointer, byte[] primArgs, int patchCount, int[] patchOffsets, Object[] objArgs) {
        return NFIContext.executePrimitive(this.nativeContext, cif, functionPointer, primArgs, patchCount, patchOffsets, objArgs);
    }

    TruffleObject executeObject(long cif, long functionPointer, byte[] primArgs, int patchCount, int[] patchOffsets, Object[] objArgs) {
        return NFIContext.executeObject(this.nativeContext, cif, functionPointer, primArgs, patchCount, patchOffsets, objArgs);
    }

    @CompilerDirectives.TruffleBoundary
    private static native void executeNative(long var0, long var2, long var4, byte[] var6, int var7, int[] var8, Object[] var9, byte[] var10);

    @CompilerDirectives.TruffleBoundary
    private static native long executePrimitive(long var0, long var2, long var4, byte[] var6, int var7, int[] var8, Object[] var9);

    @CompilerDirectives.TruffleBoundary
    private static native TruffleObject executeObject(long var0, long var2, long var4, byte[] var6, int var7, int[] var8, Object[] var9);

    private static native long loadLibrary(long var0, String var2, int var3);

    private static native long lookup(long var0, long var2, String var4);

    static native void freeLibrary(long var0);

    private class NativeEnvSupplier
    implements Supplier<NativeEnv> {
        private NativeEnvSupplier() {
        }

        @Override
        public NativeEnv get() {
            NativeEnv ret = new NativeEnv(NFIContext.initializeNativeEnv(NFIContext.this.nativeContext));
            NativeAllocation.getGlobalQueue().registerNativeAllocation(ret, new NativeAllocation.FreeDestructor(ret.pointer));
            return ret;
        }
    }

    private static class NativeEnv {
        private final long pointer;

        NativeEnv(long pointer) {
            this.pointer = pointer;
        }
    }
}

