/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.model;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.expression.DSLExpression;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.model.AssumptionExpression;
import com.oracle.truffle.dsl.processor.model.CacheExpression;
import com.oracle.truffle.dsl.processor.model.ExecutableTypeData;
import com.oracle.truffle.dsl.processor.model.GuardExpression;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import com.oracle.truffle.dsl.processor.model.NodeChildData;
import com.oracle.truffle.dsl.processor.model.NodeData;
import com.oracle.truffle.dsl.processor.model.NodeExecutionData;
import com.oracle.truffle.dsl.processor.model.Parameter;
import com.oracle.truffle.dsl.processor.model.SpecializationThrowsData;
import com.oracle.truffle.dsl.processor.model.TemplateMethod;
import com.oracle.truffle.dsl.processor.model.TypeSystemData;
import com.oracle.truffle.dsl.processor.parser.SpecializationGroup;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public final class SpecializationData
extends TemplateMethod {
    private final NodeData node;
    private SpecializationKind kind;
    private final List<SpecializationThrowsData> exceptions;
    private final boolean hasUnexpectedResultRewrite;
    private final List<GuardExpression> guards = new ArrayList<GuardExpression>();
    private List<CacheExpression> caches = Collections.emptyList();
    private List<AssumptionExpression> assumptionExpressions = Collections.emptyList();
    private Set<SpecializationData> replaces;
    private Set<String> replacesNames;
    private Set<SpecializationData> replacedBy;
    private String insertBeforeName;
    private SpecializationData insertBefore;
    private boolean replaced;
    private boolean reachable;
    private boolean reachesFallback;
    private int unroll;
    private int unrollIndex = -1;
    private int index;
    private DSLExpression limitExpression;
    private SpecializationData uncachedSpecialization;
    private final boolean reportPolymorphism;
    private final boolean reportMegamorphism;
    private boolean excludeForUncached;
    private Double localActivationProbability;
    private boolean aotReachable;
    private final List<SpecializationData> boxingOverloads = new ArrayList<SpecializationData>();

    public SpecializationData(NodeData node, TemplateMethod template, SpecializationKind kind, List<SpecializationThrowsData> exceptions, boolean hasUnexpectedResultRewrite, boolean reportPolymorphism, boolean reportMegamorphism) {
        super(template);
        this.node = node;
        this.kind = kind;
        this.exceptions = exceptions;
        this.hasUnexpectedResultRewrite = hasUnexpectedResultRewrite;
        this.index = template.getNaturalOrder();
        this.reportPolymorphism = reportPolymorphism;
        this.reportMegamorphism = reportMegamorphism;
    }

    public SpecializationData(NodeData node, TemplateMethod template, SpecializationKind kind) {
        this(node, template, kind, new ArrayList<SpecializationThrowsData>(), false, true, false);
    }

    public SpecializationData copy() {
        SpecializationData copy = new SpecializationData(this.node, this, this.kind, new ArrayList<SpecializationThrowsData>(this.exceptions), this.hasUnexpectedResultRewrite, this.reportPolymorphism, this.reportMegamorphism);
        copy.guards.clear();
        for (GuardExpression guard : this.guards) {
            copy.guards.add(guard.copy(copy));
        }
        copy.caches = new ArrayList<CacheExpression>(this.caches.size());
        for (CacheExpression cache : this.caches) {
            copy.caches.add(cache.copy());
        }
        copy.assumptionExpressions = new ArrayList<AssumptionExpression>(this.assumptionExpressions);
        if (this.replacesNames != null) {
            copy.replacesNames = new LinkedHashSet<String>();
            copy.replacesNames.addAll(this.replacesNames);
        }
        copy.replaced = this.replaced;
        if (this.replaces != null) {
            copy.replaces = new LinkedHashSet<SpecializationData>();
            copy.replaces.addAll(this.replaces);
        }
        if (this.replacedBy != null) {
            copy.replacedBy = new LinkedHashSet<SpecializationData>();
            copy.replacedBy.addAll(this.replacedBy);
        }
        copy.insertBeforeName = this.insertBeforeName;
        copy.reachable = this.reachable;
        copy.reachesFallback = this.reachesFallback;
        copy.index = this.index;
        copy.limitExpression = this.limitExpression;
        copy.aotReachable = this.aotReachable;
        copy.unroll = this.unroll;
        copy.uncachedSpecialization = this.uncachedSpecialization;
        return copy;
    }

    public void setExcludeForUncached(Boolean value) {
        this.excludeForUncached = value;
    }

    public boolean isExcludeForUncached() {
        return this.excludeForUncached;
    }

    public List<SpecializationGroup.TypeGuard> getImplicitTypeGuards() {
        TypeSystemData typeSystem = this.getNode().getTypeSystem();
        if (typeSystem.getImplicitCasts().isEmpty()) {
            return List.of();
        }
        int signatureIndex = 0;
        ArrayList<SpecializationGroup.TypeGuard> implicitTypeChecks = new ArrayList<SpecializationGroup.TypeGuard>();
        for (Parameter p : this.getDynamicParameters()) {
            if (typeSystem.hasImplicitSourceTypes(p.getType())) {
                implicitTypeChecks.add(new SpecializationGroup.TypeGuard(typeSystem, p.getType(), signatureIndex));
            }
            ++signatureIndex;
        }
        return implicitTypeChecks;
    }

    public boolean isNodeReceiverVariable(VariableElement var) {
        NodeExecutionData execution;
        Parameter p;
        if (this.getNode().isGenerateInline() && (p = this.findByVariable(var)) != null && p.getSpecification().isSignature() && (execution = p.getSpecification().getExecution()).getIndex() == 0) {
            return true;
        }
        String simpleString = var.getSimpleName().toString();
        return (simpleString.equals("this") || simpleString.equals("$node")) && ElementUtils.typeEquals(var.asType(), this.types.Node);
    }

    public boolean isNodeReceiverBoundInAnyExpression() {
        for (GuardExpression guard : this.getGuards()) {
            if (!this.isNodeReceiverBound(guard.getExpression())) continue;
            return true;
        }
        for (CacheExpression cache : this.getCaches()) {
            if (!this.isNodeReceiverBound(cache.getDefaultExpression())) continue;
            return true;
        }
        for (AssumptionExpression assumption : this.getAssumptionExpressions()) {
            if (!this.isNodeReceiverBound(assumption.getExpression())) continue;
            return true;
        }
        return this.isNodeReceiverBound(this.getLimitExpression());
    }

    public boolean isNodeReceiverBound(DSLExpression expression) {
        for (DSLExpression.Variable variable : expression.findBoundVariables()) {
            if (!this.isNodeReceiverVariable(variable.getResolvedVariable())) continue;
            return true;
        }
        return false;
    }

    public boolean isUncachedSpecialization() {
        if (this.getReplaces() != null) {
            for (SpecializationData replace : this.getReplaces()) {
                if (replace.getUncachedSpecialization() != this) continue;
                return true;
            }
        }
        return false;
    }

    public void setUnrollIndex(int unrollIndex) {
        this.unrollIndex = unrollIndex;
    }

    public int getUnrollIndex() {
        return this.unrollIndex;
    }

    public void setUnroll(int unroll) {
        this.unroll = unroll;
    }

    public boolean hasUnroll() {
        return this.unroll > 0;
    }

    public boolean isUnrolled() {
        return this.hasUnroll() && this.unrollIndex != -1;
    }

    public int getUnroll() {
        return this.unroll;
    }

    public boolean isCompilationFinalExpression(DSLExpression expression) {
        if (!(expression instanceof DSLExpression.Variable)) {
            return false;
        }
        if (expression.resolveConstant() != null) {
            return true;
        }
        DSLExpression current = expression;
        while (current != null) {
            Parameter boundParameter;
            if (!(current instanceof DSLExpression.Variable)) {
                return false;
            }
            DSLExpression.Variable variable = (DSLExpression.Variable)current;
            if (!variable.isCompilationFinalField() && (boundParameter = this.findByVariable(variable.getResolvedVariable())) == null) {
                return false;
            }
            current = variable.getReceiver();
        }
        return !this.isDynamicParameterBound(expression, true);
    }

    public boolean isPrepareForAOT() {
        return this.aotReachable;
    }

    public void setPrepareForAOT(boolean prepareForAOT) {
        this.aotReachable = prepareForAOT;
    }

    public void setUncachedSpecialization(SpecializationData removeCompanion) {
        this.uncachedSpecialization = removeCompanion;
    }

    public SpecializationData getUncachedSpecialization() {
        return this.uncachedSpecialization;
    }

    public boolean hasFrameParameter() {
        for (Parameter p : this.getSignatureParameters()) {
            if (!ElementUtils.typeEquals(p.getType(), this.types.VirtualFrame) && !ElementUtils.typeEquals(p.getType(), this.types.Frame)) continue;
            return true;
        }
        return false;
    }

    public boolean needsVirtualFrame() {
        return this.getFrame() != null && ElementUtils.typeEquals(this.getFrame().getType(), this.types.VirtualFrame);
    }

    public boolean needsTruffleBoundary() {
        for (CacheExpression cache : this.caches) {
            if (!cache.isAlwaysInitialized() || !cache.isRequiresBoundary()) continue;
            return true;
        }
        return false;
    }

    public boolean needsPushEncapsulatingNode() {
        for (CacheExpression cache : this.caches) {
            if (!cache.isAlwaysInitialized() || !cache.isRequiresBoundary() || !cache.isCachedLibrary() || !cache.getCachedLibrary().isPushEncapsulatingNode()) continue;
            return true;
        }
        return false;
    }

    public boolean isAnyLibraryBoundInGuard() {
        for (CacheExpression cache : this.getCaches()) {
            if (!cache.isCachedLibrary() || !this.isLibraryBoundInGuard(cache)) continue;
            return true;
        }
        return false;
    }

    public boolean isLibraryBoundInGuard(CacheExpression cachedLibrary) {
        if (!cachedLibrary.isCachedLibrary()) {
            return false;
        }
        for (GuardExpression guard : this.getGuards()) {
            if (guard.isLibraryAcceptsGuard()) continue;
            for (CacheExpression cacheExpression : this.getBoundCaches(guard.getExpression(), true)) {
                if (!cacheExpression.getParameter().equals(cachedLibrary.getParameter())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTrivialExpression(DSLExpression expression) {
        Set<ExecutableElement> boundMethod = expression.findBoundExecutableElements();
        ProcessorContext context = ProcessorContext.getInstance();
        for (ExecutableElement method : boundMethod) {
            String name = method.getSimpleName().toString();
            if (name.equals("getClass") && ElementUtils.typeEquals(method.getEnclosingElement().asType(), context.getType(Object.class))) continue;
            return false;
        }
        for (VariableElement variable : expression.findBoundVariableElements()) {
            if (variable.getSimpleName().toString().equals("null")) continue;
            Parameter parameter = this.findByVariable(variable);
            if (parameter == null) {
                return false;
            }
            if (parameter.getSpecification().isCached() || parameter.getSpecification().isSignature()) continue;
            return false;
        }
        return true;
    }

    public void setReachesFallback(boolean reachesFallback) {
        this.reachesFallback = reachesFallback;
    }

    public boolean isReportPolymorphism() {
        return this.reportPolymorphism;
    }

    public boolean isReportMegamorphism() {
        return this.reportMegamorphism;
    }

    public boolean isReachesFallback() {
        return this.reachesFallback;
    }

    public boolean isGuardBoundWithCache(GuardExpression guardExpression) {
        for (CacheExpression cache : this.getBoundCaches(guardExpression.getExpression(), false)) {
            if (cache.isAlwaysInitialized()) continue;
            return true;
        }
        return false;
    }

    public Set<CacheExpression> getBoundCaches(DSLExpression guardExpression, boolean transitiveCached) {
        return this.getBoundCachesImpl(new LinkedHashSet<DSLExpression>(), guardExpression, transitiveCached);
    }

    private Set<CacheExpression> getBoundCachesImpl(Set<DSLExpression> visitedExpressions, DSLExpression guardExpression, boolean transitiveCached) {
        List<CacheExpression> resolvedCaches = this.getCaches();
        if (resolvedCaches.isEmpty()) {
            return Collections.emptySet();
        }
        visitedExpressions.add(guardExpression);
        Set<VariableElement> boundVars = guardExpression.findBoundVariableElements();
        LinkedHashSet<CacheExpression> foundCaches = new LinkedHashSet<CacheExpression>();
        for (CacheExpression cache : resolvedCaches) {
            VariableElement cacheVar = cache.getParameter().getVariableElement();
            if (!boundVars.contains(cacheVar)) continue;
            if (cache.getDefaultExpression() != null && !visitedExpressions.contains(cache.getDefaultExpression()) && (transitiveCached || cache.isAlwaysInitialized())) {
                foundCaches.addAll(this.getBoundCachesImpl(visitedExpressions, cache.getDefaultExpression(), transitiveCached));
            }
            foundCaches.add(cache);
        }
        return foundCaches;
    }

    public void setKind(SpecializationKind kind) {
        this.kind = kind;
    }

    public Idempotence getIdempotence(DSLExpression expression) {
        if (this.isDynamicParameterBound(expression, true)) {
            return Idempotence.NON_IDEMPOTENT;
        }
        IdempotentenceVisitor visitor = new IdempotentenceVisitor();
        expression.accept(visitor);
        return visitor.current;
    }

    public Set<ExecutableElement> getBoundMethods(DSLExpression expression) {
        final LinkedHashSet<ExecutableElement> foundMethods = new LinkedHashSet<ExecutableElement>();
        expression.accept(new DSLExpression.AbstractDSLExpressionVisitor(this){
            final /* synthetic */ SpecializationData this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void visitCall(DSLExpression.Call n) {
                foundMethods.add(n.getResolvedMethod());
            }

            @Override
            public void visitVariable(DSLExpression.Variable n) {
                CacheExpression cache;
                Parameter p;
                VariableElement var = n.getResolvedVariable();
                if (n.getReceiver() == null && (p = this.this$0.findByVariable(var)) != null && (cache = this.this$0.findCache(p)) != null && cache.isAlwaysInitialized()) {
                    foundMethods.addAll(this.this$0.getBoundMethods(cache.getDefaultExpression()));
                }
            }
        });
        return foundMethods;
    }

    public boolean isDynamicParameterBound(DSLExpression expression, boolean transitive) {
        if (expression == null) {
            return false;
        }
        Set<VariableElement> boundVariables = expression.findBoundVariableElements();
        for (Parameter parameter : this.getDynamicParameters()) {
            if (!boundVariables.contains(parameter.getVariableElement())) continue;
            return true;
        }
        FindDynamicBindingVisitor visitor = new FindDynamicBindingVisitor();
        expression.accept(visitor);
        if (visitor.found) {
            return true;
        }
        if (transitive) {
            for (CacheExpression cache : this.getBoundCaches(expression, false)) {
                if (!cache.isAlwaysInitialized() || cache.isWeakReferenceGet() || !this.isDynamicParameterBound(cache.getDefaultExpression(), true)) continue;
                return true;
            }
        }
        return false;
    }

    public Parameter findByVariable(VariableElement variable) {
        for (Parameter parameter : this.getParameters()) {
            if (!ElementUtils.variableEquals(parameter.getVariableElement(), variable)) continue;
            return parameter;
        }
        return null;
    }

    public DSLExpression getLimitExpression() {
        return this.limitExpression;
    }

    public void setLimitExpression(DSLExpression limitExpression) {
        this.limitExpression = limitExpression;
    }

    public void setInsertBefore(SpecializationData insertBefore) {
        this.insertBefore = insertBefore;
    }

    public void setInsertBeforeName(String insertBeforeName) {
        this.insertBeforeName = insertBeforeName;
    }

    public SpecializationData getInsertBefore() {
        return this.insertBefore;
    }

    public String getInsertBeforeName() {
        return this.insertBeforeName;
    }

    public Set<String> getReplacesNames() {
        return this.replacesNames;
    }

    public void setReplacesNames(Set<String> replacesNames) {
        this.replacesNames = replacesNames;
    }

    public Set<SpecializationData> getReplaces() {
        return this.replaces;
    }

    public void setReplaces(Set<SpecializationData> replaces) {
        this.replaces = replaces;
    }

    public Set<SpecializationData> getReplacedBy() {
        return this.replacedBy;
    }

    public void setReplacedBy(Set<SpecializationData> replacedBy) {
        this.replacedBy = replacedBy;
    }

    public void setReachable(boolean reachable) {
        this.reachable = reachable;
    }

    public void setReplaced(boolean replaced) {
        this.replaced = replaced;
    }

    public boolean isReachable() {
        return this.reachable;
    }

    public boolean isReplaced() {
        return this.replaced;
    }

    @Override
    protected List<MessageContainer> findChildContainers() {
        ArrayList<MessageContainer> sinks = new ArrayList<MessageContainer>();
        if (this.exceptions != null) {
            sinks.addAll(this.exceptions);
        }
        if (this.guards != null) {
            sinks.addAll(this.guards);
        }
        if (this.caches != null) {
            sinks.addAll(this.caches);
        }
        if (this.assumptionExpressions != null) {
            sinks.addAll(this.assumptionExpressions);
        }
        sinks.addAll(this.getBoxingOverloads());
        return sinks;
    }

    public boolean needsState(ProcessorContext context) {
        if (this.needsRewrite(context)) {
            return true;
        }
        if (!this.getCaches().isEmpty()) {
            for (CacheExpression cache : this.getCaches()) {
                if (cache.isAlwaysInitialized()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean needsRewrite(ProcessorContext context) {
        if (!this.getExceptions().isEmpty()) {
            return true;
        }
        if (!this.getGuards().isEmpty()) {
            return true;
        }
        if (!this.getAssumptionExpressions().isEmpty()) {
            return true;
        }
        if (!this.getCaches().isEmpty()) {
            for (CacheExpression cache : this.getCaches()) {
                if (cache.isEagerInitialize() || cache.getInlinedNode() != null || cache.isAlwaysInitialized()) continue;
                return true;
            }
        }
        int signatureIndex = 0;
        for (Parameter parameter : this.getSignatureParameters()) {
            for (ExecutableTypeData executableType : this.node.getExecutableTypes()) {
                TypeMirror evaluatedParameterType;
                List<TypeMirror> evaluatedParameters = executableType.getEvaluatedParameters();
                if (signatureIndex >= evaluatedParameters.size() || !ElementUtils.needsCastTo(evaluatedParameterType = evaluatedParameters.get(signatureIndex), parameter.getType())) continue;
                return true;
            }
            NodeChildData child = parameter.getSpecification().getExecution().getChild();
            if (child != null) {
                ExecutableTypeData type = child.findExecutableType(parameter.getType());
                if (type == null) {
                    type = child.findAnyGenericExecutableType(context);
                }
                if (type.hasUnexpectedValue()) {
                    return true;
                }
                if (ElementUtils.needsCastTo(type.getReturnType(), parameter.getType())) {
                    return true;
                }
            }
            ++signatureIndex;
        }
        return false;
    }

    @Override
    public int compareTo(TemplateMethod other) {
        if (this == other) {
            return 0;
        }
        if (!(other instanceof SpecializationData)) {
            return super.compareTo(other);
        }
        SpecializationData m2 = (SpecializationData)other;
        int kindOrder = this.kind.compareTo(m2.kind);
        if (kindOrder != 0) {
            return kindOrder;
        }
        int compare = 0;
        int order1 = this.index;
        int order2 = m2.index;
        if (order1 != -1 && order2 != -1 && (compare = Integer.compare(order1, order2)) != 0) {
            return compare;
        }
        return super.compareTo(other);
    }

    public void setIndex(int order) {
        this.index = order;
    }

    public int getIndex() {
        return this.index;
    }

    public int getIntrospectionIndex() {
        if (this.getMethod() == null) {
            return -1;
        }
        return this.index;
    }

    public NodeData getNode() {
        return this.node;
    }

    public boolean isSpecialized() {
        return this.kind == SpecializationKind.SPECIALIZED;
    }

    public boolean isFallback() {
        return this.kind == SpecializationKind.FALLBACK;
    }

    public List<SpecializationThrowsData> getExceptions() {
        return this.exceptions;
    }

    public boolean hasUnexpectedResultRewrite() {
        return this.hasUnexpectedResultRewrite;
    }

    public List<GuardExpression> getGuards() {
        return this.guards;
    }

    public void setLocalActivationProbability(double activationProbability) {
        this.localActivationProbability = activationProbability;
    }

    public double getLocalActivationProbability() {
        return this.localActivationProbability;
    }

    public double getActivationProbability() {
        return this.getNode().getActivationProbability() * this.localActivationProbability;
    }

    @Override
    public String toString() {
        return String.format("%s [nodeId =%s, id = %s, method = %s, guards = %s, signature = %s]", this.getClass().getSimpleName(), this.getNode().getNodeId(), this.getId(), this.getMethod(), this.getGuards(), this.getDynamicTypes());
    }

    public boolean isFrameUsedByGuard() {
        Parameter frame = this.getFrame();
        if (frame != null) {
            for (GuardExpression guard : this.getGuards()) {
                if (!guard.getExpression().findBoundVariableElements().contains(frame.getVariableElement())) continue;
                return true;
            }
            for (CacheExpression cache : this.getCaches()) {
                if (cache.getDefaultExpression() == null || !cache.getDefaultExpression().findBoundVariableElements().contains(frame.getVariableElement())) continue;
                return true;
            }
        }
        return false;
    }

    public List<CacheExpression> getCaches() {
        return this.caches;
    }

    public void setCaches(List<CacheExpression> caches) {
        this.caches = caches;
    }

    public void setAssumptionExpressions(List<AssumptionExpression> assumptionExpressions) {
        this.assumptionExpressions = assumptionExpressions;
    }

    public List<AssumptionExpression> getAssumptionExpressions() {
        return this.assumptionExpressions;
    }

    public boolean hasMultipleInstances() {
        return this.getMaximumNumberOfInstances() > 1;
    }

    public boolean isGuardBindsExclusiveCache() {
        if (!this.getCaches().isEmpty() && !this.getGuards().isEmpty()) {
            for (GuardExpression guard : this.getGuards()) {
                if (guard.hasErrors() || !this.isDynamicParameterBound(guard.getExpression(), true) || !this.isExclusiveCacheParameterBound(guard)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isExclusiveCacheParameterBound(GuardExpression guard) {
        for (CacheExpression cache : this.getBoundCaches(guard.getExpression(), false)) {
            if (cache.isAlwaysInitialized() || !guard.isLibraryAcceptsGuard() && cache.isCachedLibrary() || guard.isWeakReferenceGuard() && cache.isWeakReference() || cache.getSharedGroup() != null) continue;
            return true;
        }
        return false;
    }

    public boolean isConstantLimit() {
        if (this.isGuardBindsExclusiveCache()) {
            DSLExpression expression = this.getLimitExpression();
            if (expression == null) {
                return true;
            }
            Object constant = expression.resolveConstant();
            return constant != null && constant instanceof Integer;
        }
        return true;
    }

    public int getMaximumNumberOfInstances() {
        if (this.isGuardBindsExclusiveCache()) {
            DSLExpression expression = this.getLimitExpression();
            if (expression == null) {
                return 3;
            }
            Object constant = expression.resolveConstant();
            if (constant != null && constant instanceof Integer) {
                return (Integer)constant;
            }
            return Integer.MAX_VALUE;
        }
        return 1;
    }

    public boolean isReachableAfter(SpecializationData prev) {
        if (!prev.isSpecialized()) {
            return true;
        }
        if (!prev.getExceptions().isEmpty()) {
            return true;
        }
        if (prev.isGuardBindsExclusiveCache()) {
            return true;
        }
        if (this.node.isGenerateUncached() && !this.isReplaced() && prev.isReplaced()) {
            return true;
        }
        for (CacheExpression cache : prev.getCaches()) {
            if (!cache.isCachedLibrary() || !this.getReplaces().contains(prev)) continue;
            return true;
        }
        Iterator<Parameter> currentSignature = this.getSignatureParameters().iterator();
        Iterator<Parameter> prevSignature = prev.getSignatureParameters().iterator();
        TypeSystemData typeSystem = prev.getNode().getTypeSystem();
        while (currentSignature.hasNext() && prevSignature.hasNext()) {
            TypeMirror prevType;
            TypeMirror currentType = currentSignature.next().getType();
            if (typeSystem.isImplicitSubtypeOf(currentType, prevType = prevSignature.next().getType())) continue;
            return true;
        }
        if (!prev.getAssumptionExpressions().isEmpty()) {
            return true;
        }
        Iterator<GuardExpression> prevGuards = prev.getGuards().iterator();
        Iterator<GuardExpression> currentGuards = this.getGuards().iterator();
        while (prevGuards.hasNext()) {
            GuardExpression currentGuard;
            GuardExpression prevGuard = prevGuards.next();
            if (prev.isGuardBoundWithCache(prevGuard)) {
                return true;
            }
            GuardExpression guardExpression = currentGuard = currentGuards.hasNext() ? currentGuards.next() : null;
            if (currentGuard != null && currentGuard.implies(prevGuard)) continue;
            return true;
        }
        return false;
    }

    public CacheExpression findCache(Parameter resolvedParameter) {
        for (CacheExpression cache : this.getCaches()) {
            if (!cache.getParameter().equals(resolvedParameter)) continue;
            return cache;
        }
        return null;
    }

    public boolean isBoxingOverloadable(SpecializationData other) {
        if (!ElementUtils.isPrimitive(other.getReturnType().getType()) && !ElementUtils.isVoid(other.getReturnType().getType())) {
            return false;
        }
        List<Parameter> signature = this.getSignatureParameters();
        List<Parameter> otherSignature = other.getSignatureParameters();
        if (signature.size() != otherSignature.size()) {
            return false;
        }
        for (int i = 0; i < signature.size(); ++i) {
            Parameter parameter = signature.get(i);
            Parameter otherParameter = otherSignature.get(i);
            if (ElementUtils.typeEquals(parameter.getType(), otherParameter.getType())) continue;
            return false;
        }
        if (!Objects.equals(this.getLimitExpression(), other.getLimitExpression())) {
            return false;
        }
        if (!this.hasSameGuards(other)) {
            return false;
        }
        if (!this.hasSameCaches(other)) {
            return false;
        }
        return this.hasSameAssumptions(other);
    }

    public boolean hasSameGuards(SpecializationData other) {
        if (this.guards.size() != other.guards.size()) {
            return false;
        }
        for (int i = 0; i < this.guards.size(); ++i) {
            GuardExpression guard = this.guards.get(i);
            GuardExpression otherGuard = other.guards.get(i);
            if (guard.getExpression().equals(otherGuard.getExpression())) continue;
            return false;
        }
        return true;
    }

    public boolean hasSameCaches(SpecializationData other) {
        if (this.caches.size() != other.caches.size()) {
            return false;
        }
        for (int i = 0; i < this.caches.size(); ++i) {
            CacheExpression otherCache;
            CacheExpression cache = this.caches.get(i);
            if (cache.isSameCache(otherCache = other.caches.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean hasSameAssumptions(SpecializationData other) {
        if (this.assumptionExpressions.size() != other.assumptionExpressions.size()) {
            return false;
        }
        for (int i = 0; i < this.assumptionExpressions.size(); ++i) {
            AssumptionExpression assumption = this.assumptionExpressions.get(i);
            AssumptionExpression otherAssumptions = other.assumptionExpressions.get(i);
            if (assumption.getExpression().equals(otherAssumptions.getExpression())) continue;
            return false;
        }
        return true;
    }

    public List<SpecializationData> getBoxingOverloads() {
        return this.boxingOverloads;
    }

    public SpecializationData lookupBoxingOverload(ExecutableTypeData type) {
        if (!type.hasUnexpectedValue()) {
            return null;
        }
        for (SpecializationData specialization : this.getBoxingOverloads()) {
            if (!ElementUtils.typeEquals(specialization.getReturnType().getType(), type.getReturnType())) continue;
            return specialization;
        }
        return null;
    }

    public TypeMirror lookupBoxingOverloadReturnType(ExecutableTypeData type) {
        SpecializationData specializationData = this.lookupBoxingOverload(type);
        if (specializationData == null) {
            return this.getReturnType().getType();
        }
        return specializationData.getReturnType().getType();
    }

    public static enum SpecializationKind {
        SPECIALIZED,
        FALLBACK;

    }

    public static enum Idempotence {
        IDEMPOTENT,
        NON_IDEMPOTENT,
        UNKNOWN;

    }

    private final class IdempotentenceVisitor
    extends DSLExpression.AbstractDSLExpressionVisitor {
        Idempotence current = Idempotence.IDEMPOTENT;

        private IdempotentenceVisitor() {
        }

        @Override
        public void visitCall(DSLExpression.Call n) {
            if (this.current == Idempotence.NON_IDEMPOTENT) {
                return;
            }
            Idempotence idempotent = ElementUtils.getIdempotent(n.getResolvedMethod());
            if (idempotent == Idempotence.UNKNOWN || idempotent == Idempotence.NON_IDEMPOTENT) {
                this.current = idempotent;
            }
        }

        @Override
        public void visitVariable(DSLExpression.Variable n) {
            if (this.current == Idempotence.NON_IDEMPOTENT) {
                return;
            }
            VariableElement var = n.getResolvedVariable();
            if (n.getReceiver() == null) {
                CacheExpression cache;
                Parameter p = SpecializationData.this.findByVariable(var);
                if (p != null && (cache = SpecializationData.this.findCache(p)) != null && cache.isAlwaysInitialized()) {
                    Idempotence cacheIdempotent = SpecializationData.this.getIdempotence(cache.getDefaultExpression());
                    switch (cacheIdempotent.ordinal()) {
                        case 0: {
                            break;
                        }
                        case 1: 
                        case 2: {
                            this.current = cacheIdempotent;
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
            } else if (!var.getModifiers().contains((Object)Modifier.FINAL)) {
                this.current = Idempotence.NON_IDEMPOTENT;
            }
        }
    }

    static final class FindDynamicBindingVisitor
    extends DSLExpression.AbstractDSLExpressionVisitor {
        boolean found;
        final String[] resultValues;

        FindDynamicBindingVisitor() {
            this.resultValues = new String[]{"get", ((TypeElement)ProcessorContext.getInstance().getTypes().TruffleLanguage_ContextReference.asElement()).getQualifiedName().toString(), "get", ((TypeElement)ProcessorContext.getInstance().getTypes().TruffleLanguage_LanguageReference.asElement()).getQualifiedName().toString(), "get", ProcessorContext.getInstance().getTypeElement(Reference.class).getQualifiedName().toString()};
        }

        @Override
        public void visitCall(DSLExpression.Call binary) {
            ExecutableElement method = binary.getResolvedMethod();
            String methodName = method.getSimpleName().toString();
            Element enclosingElement = method.getEnclosingElement();
            if (enclosingElement == null || !enclosingElement.getKind().isClass()) {
                return;
            }
            String className = ((TypeElement)enclosingElement).getQualifiedName().toString();
            for (int i = 0; i < this.resultValues.length; i += 2) {
                String searchMethod = this.resultValues[i];
                String searchClass = this.resultValues[i + 1];
                if (!searchMethod.equals(methodName) || !className.equals(searchClass)) continue;
                this.found = true;
                break;
            }
        }
    }
}

