/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java.compiler;

import com.oracle.truffle.dsl.processor.java.compiler.AbstractCompiler;
import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

public class JavaCCompiler
extends AbstractCompiler {
    private static volatile Reflection reflection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initializeReflectionClasses(Object classLoaderSupplier) throws ReflectiveOperationException {
        if (reflection != null) return;
        Class<JavaCCompiler> clazz = JavaCCompiler.class;
        synchronized (JavaCCompiler.class) {
            if (reflection != null) return;
            reflection = new Reflection(classLoaderSupplier.getClass().getClassLoader());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean isValidElement(Element currentElement) {
        try {
            Class<?> elementClass = Class.forName("com.sun.tools.javac.code.Symbol");
            return elementClass.isAssignableFrom(currentElement.getClass());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public List<? extends Element> getAllMembersInDeclarationOrder(ProcessingEnvironment environment, TypeElement type) {
        return environment.getElementUtils().getAllMembers(type);
    }

    @Override
    public List<? extends Element> getEnclosedElementsInDeclarationOrder(TypeElement type) {
        return type.getEnclosedElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean emitDeprecationWarningImpl(ProcessingEnvironment environment, Element element) {
        try {
            Object javacContext = JavaCCompiler.method(environment, "getContext");
            Object elementTreePath = JavaCCompiler.getTreePathForElement(environment, element);
            if (elementTreePath == null) {
                return false;
            }
            Object log = JavaCCompiler.getLog(javacContext);
            Object check = JavaCCompiler.getCheck(javacContext);
            Object file = JavaCCompiler.field(JavaCCompiler.method(elementTreePath, "getCompilationUnit"), "sourcefile");
            Object prev = JavaCCompiler.useSource(log, file);
            try {
                JavaCCompiler.reportProblem(check, elementTreePath, element);
            }
            finally {
                JavaCCompiler.useSource(log, prev);
            }
            return true;
        }
        catch (ReflectiveOperationException reflectiveException) {
            return false;
        }
    }

    private static Object getTrees(ProcessingEnvironment environment, Element element) throws ReflectiveOperationException {
        JavaCCompiler.initializeReflectionClasses(element);
        return JavaCCompiler.staticMethod(JavaCCompiler.reflection.clsTrees, "instance", new Class[]{ProcessingEnvironment.class}, environment);
    }

    private static Object getTreePathForElement(ProcessingEnvironment environment, Element element) throws ReflectiveOperationException {
        Object trees = JavaCCompiler.getTrees(environment, element);
        return JavaCCompiler.reflection.metTreesGetPath.invoke(trees, element);
    }

    private static Object getLog(Object javacContext) throws ReflectiveOperationException {
        ClassLoader cl = javacContext.getClass().getClassLoader();
        Class<?> logClass = Class.forName("com.sun.tools.javac.util.Log", false, cl);
        Class<?> contextClass = Class.forName("com.sun.tools.javac.util.Context", false, cl);
        return JavaCCompiler.staticMethod(logClass, "instance", new Class[]{contextClass}, javacContext);
    }

    private static Object getCheck(Object javacContext) throws ReflectiveOperationException {
        ClassLoader cl = javacContext.getClass().getClassLoader();
        Class<?> checkClass = Class.forName("com.sun.tools.javac.comp.Check");
        Class<?> contextClass = Class.forName("com.sun.tools.javac.util.Context", false, cl);
        return JavaCCompiler.staticMethod(checkClass, "instance", new Class[]{contextClass}, javacContext);
    }

    private static Object useSource(Object log, Object currentFile) throws ReflectiveOperationException {
        return JavaCCompiler.method(log, "useSource", new Class[]{JavaFileObject.class}, currentFile);
    }

    private static void reportProblem(Object check, Object treePath, Element element) throws ReflectiveOperationException {
        ClassLoader cl = check.getClass().getClassLoader();
        Class<?> diagnosticPositionClass = Class.forName("com.sun.tools.javac.util.JCDiagnostic$DiagnosticPosition", false, cl);
        Class<?> symbolClass = Class.forName("com.sun.tools.javac.code.Symbol", false, cl);
        Object elementTree = JavaCCompiler.method(treePath, "getLeaf");
        JavaCCompiler.method(check, "warnDeprecated", new Class[]{diagnosticPositionClass, symbolClass}, elementTree, element);
    }

    @Override
    public File getEnclosingSourceFile(ProcessingEnvironment processingEnv, Element element) {
        try {
            Object treePath = JavaCCompiler.getTreePathForElement(processingEnv, element);
            Object compilationUnit = JavaCCompiler.reflection.metTreePathGetCompilationUnit.invoke(treePath, new Object[0]);
            JavaFileObject obj = (JavaFileObject)JavaCCompiler.reflection.metCompilationUnitTreeGetSourceFile.invoke(compilationUnit, new Object[0]);
            return new File(obj.toUri());
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError("should not happen", e);
        }
    }

    private static class Reflection {
        final Class<?> clsTrees;
        final Method metTreesGetPath;
        final Method metTreePathGetCompilationUnit;
        final Method metCompilationUnitTreeGetSourceFile;

        Reflection(ClassLoader cl) throws ReflectiveOperationException {
            this.clsTrees = Class.forName("com.sun.source.util.Trees", false, cl);
            this.metTreesGetPath = this.clsTrees.getMethod("getPath", Element.class);
            Class<?> clsTreePath = Class.forName("com.sun.source.util.TreePath", false, cl);
            this.metTreePathGetCompilationUnit = clsTreePath.getMethod("getCompilationUnit", new Class[0]);
            Class<?> clsCompilationUnitTree = Class.forName("com.sun.source.tree.CompilationUnitTree", false, cl);
            this.metCompilationUnitTreeGetSourceFile = clsCompilationUnitTree.getDeclaredMethod("getSourceFile", new Class[0]);
        }
    }
}

