/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.bytecode.model;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.bytecode.model.BytecodeDSLModel;
import com.oracle.truffle.dsl.processor.bytecode.model.OperationModel;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import com.oracle.truffle.dsl.processor.model.Template;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class CustomOperationModel
extends Template {
    public final BytecodeDSLModel bytecode;
    public final OperationModel operation;
    public final List<TypeMirror> implicitTags = new ArrayList<TypeMirror>();
    public Boolean forceCached;

    public CustomOperationModel(ProcessorContext context, BytecodeDSLModel bytecode, TypeElement templateType, AnnotationMirror mirror, OperationModel operation) {
        super(context, templateType, mirror);
        this.bytecode = bytecode;
        this.operation = operation;
        operation.customModel = this;
    }

    public List<TypeMirror> getImplicitTags() {
        return this.implicitTags;
    }

    public boolean isEpilogExceptional() {
        return ElementUtils.typeEquals(this.getTemplateTypeAnnotation().getAnnotationType(), this.types.EpilogExceptional);
    }

    public MessageContainer getModelForMessages() {
        if (ElementUtils.typeEquals(this.getTemplateTypeAnnotation().getAnnotationType(), this.types.OperationProxy)) {
            return this.bytecode;
        }
        return this;
    }

    public void setForceCached() {
        this.forceCached = true;
    }

    public boolean forcesCached() {
        return this.forceCached != null && this.forceCached != false;
    }

    @Override
    protected List<MessageContainer> findChildContainers() {
        if (this.operation.instruction != null && this.operation.instruction.nodeData != null) {
            return List.of(this.operation.instruction.nodeData);
        }
        return List.of();
    }
}

