/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.bytecode.generator;

import com.oracle.truffle.dsl.processor.java.model.CodeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

public final class EqualityCodeTree {
    private final CodeTree tree;
    private final String source;

    private EqualityCodeTree(CodeTree tree) {
        this.tree = tree;
        CodeElement.StringBuilderCodeWriter codeWriter = new CodeElement.StringBuilderCodeWriter();
        codeWriter.visitTree(tree, null, null);
        this.source = codeWriter.getString();
    }

    public CodeTree getTree() {
        return this.tree;
    }

    public int hashCode() {
        return Objects.hash(this.source);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EqualityCodeTree other = (EqualityCodeTree)obj;
        return Objects.equals(this.source, other.source);
    }

    public static <T> Map<EqualityCodeTree, List<T>> group(CodeTreeBuilder parent, Collection<T> values, BiConsumer<T, CodeTreeBuilder> grouper) {
        LinkedHashMap<EqualityCodeTree, List<T>> grouping = new LinkedHashMap<EqualityCodeTree, List<T>>();
        for (T value : values) {
            CodeTreeBuilder b = parent.create();
            grouper.accept(value, b);
            grouping.computeIfAbsent(new EqualityCodeTree(b.build()), k -> new ArrayList()).add(value);
        }
        return grouping;
    }
}

