/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.dsl.processor.AbstractRegistrationProcessor;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

@SupportedAnnotationTypes(value={"com.oracle.truffle.api.InternalResource.Id"})
public class OptionalResourceRegistrationProcessor
extends AbstractRegistrationProcessor {
    @Override
    DeclaredType getProviderClass() {
        TruffleTypes types = ProcessorContext.getInstance().getTypes();
        return types.InternalResourceProvider;
    }

    @Override
    Iterable<AnnotationMirror> getProviderAnnotations(TypeElement annotatedElement) {
        return List.of();
    }

    @Override
    boolean accepts(Element annotatedElement, AnnotationMirror registrationMirror) {
        return ElementUtils.getAnnotationValue(Boolean.class, registrationMirror, "optional");
    }

    @Override
    boolean validateRegistration(Element annotatedElement, AnnotationMirror registrationMirror) {
        ProcessorContext context = ProcessorContext.getInstance();
        TruffleTypes types = context.getTypes();
        TypeElement internalResourceElement = (TypeElement)annotatedElement;
        if (!this.processingEnv.getTypeUtils().isAssignable(annotatedElement.asType(), types.InternalResource)) {
            String idSimpleName = ElementUtils.getSimpleName(types.InternalResource_Id);
            String internalResourceClzName = OptionalResourceRegistrationProcessor.getScopedName((TypeElement)types.InternalResource.asElement());
            this.emitError(String.format("The annotation @%s can be applied only to %s instances. To resolve this, remove the @%s annotation or implement %s.", idSimpleName, internalResourceClzName, idSimpleName, internalResourceClzName), annotatedElement, registrationMirror, null);
            return false;
        }
        if (ElementUtils.getAnnotationValue(String.class, registrationMirror, "componentId").isEmpty()) {
            String idSimpleName = ElementUtils.getSimpleName(types.InternalResource_Id);
            this.emitError(String.format("The '@%s.componentId' for an optional internal resource must be set to language or instrument identifier for which the resource is registered. To resolve this, add 'componentId = \"<component-id>\"' or make the internal resource required.", idSimpleName), annotatedElement, registrationMirror, null);
            return false;
        }
        Set<Modifier> modifiers = internalResourceElement.getModifiers();
        if (internalResourceElement.getEnclosingElement().getKind() != ElementKind.PACKAGE && !modifiers.contains((Object)Modifier.STATIC)) {
            this.emitError(String.format("The class %s must be a static inner-class or a top-level class. To resolve this, make the %s static or top-level class.", OptionalResourceRegistrationProcessor.getScopedName(internalResourceElement), internalResourceElement.getSimpleName()), annotatedElement, registrationMirror, null);
            return false;
        }
        if (internalResourceElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            PackageElement targetPackage = ElementUtils.findPackageElement(annotatedElement);
            this.emitError(String.format("The class %s must be public or package protected in the %s package. To resolve this, make the %s package protected or move it to the %s package.", OptionalResourceRegistrationProcessor.getScopedName(internalResourceElement), targetPackage.getQualifiedName(), OptionalResourceRegistrationProcessor.getScopedName(internalResourceElement), targetPackage.getQualifiedName()), annotatedElement, registrationMirror, null);
            return false;
        }
        boolean foundConstructor = false;
        for (ExecutableElement constructor : ElementFilter.constructorsIn(internalResourceElement.getEnclosedElements())) {
            if (constructor.getModifiers().contains((Object)Modifier.PRIVATE) || !constructor.getParameters().isEmpty()) continue;
            foundConstructor = true;
            break;
        }
        if (!foundConstructor) {
            this.emitError(String.format("The class %s must have a no argument public or package protected constructor. To resolve this, add %s() constructor.", OptionalResourceRegistrationProcessor.getScopedName(internalResourceElement), ElementUtils.getSimpleName(internalResourceElement)), annotatedElement, registrationMirror, null);
            return false;
        }
        return true;
    }

    @Override
    void implementMethod(TypeElement annotatedElement, CodeExecutableElement methodToImplement) {
        ProcessorContext context = ProcessorContext.getInstance();
        TruffleTypes types = context.getTypes();
        AnnotationMirror registration = ElementUtils.findAnnotationMirror(annotatedElement.getAnnotationMirrors(), (TypeMirror)types.InternalResource_Id);
        CodeTreeBuilder builder = methodToImplement.createBuilder();
        switch (methodToImplement.getSimpleName().toString()) {
            case "getComponentId": {
                builder.startReturn().doubleQuote(ElementUtils.getAnnotationValue(String.class, registration, "componentId")).end();
                break;
            }
            case "getResourceId": {
                builder.startReturn().doubleQuote(ElementUtils.getAnnotationValue(String.class, registration, "value")).end();
                break;
            }
            case "createInternalResource": {
                DeclaredType internalResource = (DeclaredType)annotatedElement.asType();
                builder.startReturn().startNew(internalResource).end(2);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported method: " + String.valueOf(methodToImplement.getSimpleName()));
            }
        }
    }
}

