/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.verify;

import com.oracle.truffle.dsl.processor.ExpectError;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.oracle.truffle.api.CompilerDirectives.TruffleBoundary", "com.oracle.truffle.api.nodes.Node.Child", "com.oracle.truffle.api.nodes.Node.Children"})
public class VerifyTruffleProcessor
extends AbstractProcessor {
    private Element scope;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    public static boolean isEnclosedIn(Element e, Element scopeElement) {
        List<Element> elementHierarchy = ElementUtils.getElementHierarchy(e);
        return elementHierarchy.contains(scopeElement);
    }

    void errorMessage(Element element, String format, Object ... args) {
        this.message(Diagnostic.Kind.ERROR, element, format, args);
    }

    void message(Diagnostic.Kind kind, Element element, String format, Object ... args) {
        if (this.scope != null && !VerifyTruffleProcessor.isEnclosedIn(element, this.scope)) {
            List<Element> elementHierarchy = ElementUtils.getElementHierarchy(element);
            Collections.reverse(elementHierarchy);
            StringBuilder str = new StringBuilder();
            for (Element e : elementHierarchy) {
                if (e.getKind() == ElementKind.PACKAGE) continue;
                str.append(str.length() == 0 ? "" : ".");
                str.append(e);
            }
            this.processingEnv.getMessager().printMessage(kind, String.format(String.valueOf(str) + ": " + format, args), this.scope);
        } else {
            this.processingEnv.getMessager().printMessage(kind, String.format(format, args), element);
        }
    }

    private void reportException(Diagnostic.Kind kind, Element element, Throwable t) {
        StringWriter buf = new StringWriter();
        t.printStackTrace(new PrintWriter(buf));
        this.message(kind, element, "Exception thrown during processing: %s", buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        try (ProcessorContext context = ProcessorContext.enter(this.processingEnv);){
            TruffleTypes types = context.getTypes();
            TypeElement virtualFrameType = ElementUtils.castTypeElement(types.VirtualFrame);
            TypeElement frameType = ElementUtils.castTypeElement(types.Frame);
            Iterator<? extends Element> iterator = roundEnv.getElementsAnnotatedWith(ElementUtils.castTypeElement(types.CompilerDirectives_TruffleBoundary)).iterator();
            while (iterator.hasNext()) {
                Element element;
                this.scope = element = iterator.next();
                try {
                    if (element.getKind() != ElementKind.CONSTRUCTOR && element.getKind() != ElementKind.METHOD) continue;
                    ExecutableElement method = (ExecutableElement)element;
                    for (VariableElement variableElement : method.getParameters()) {
                        Element paramType = this.processingEnv.getTypeUtils().asElement(variableElement.asType());
                        if (paramType == null || !paramType.equals(virtualFrameType) && !paramType.equals(frameType)) continue;
                        Name truffleBoundarySimpleName = types.CompilerDirectives_TruffleBoundary.asElement().getSimpleName();
                        this.errorMessage(element, "Method %s cannot be annotated with @%s and have a parameter of type %s.%nTo resolve this, either change the parameter to a %s, remove the parameter or remove the @%s.", method.getSimpleName(), truffleBoundarySimpleName, paramType.getSimpleName(), types.MaterializedFrame.asElement().getSimpleName(), truffleBoundarySimpleName);
                    }
                }
                catch (Throwable t) {
                    this.reportException(VerifyTruffleProcessor.isBug367599(t) ? Diagnostic.Kind.NOTE : Diagnostic.Kind.ERROR, element, t);
                }
                finally {
                    this.scope = null;
                }
            }
            TypeElement nodeType = ElementUtils.castTypeElement(types.Node);
            TypeElement nodeInterfaceType = ElementUtils.castTypeElement(types.NodeInterface);
            for (Element element : roundEnv.getElementsAnnotatedWith(ElementUtils.castTypeElement(types.Node_Child))) {
                if (element.getModifiers().contains((Object)Modifier.FINAL)) {
                    this.emitError("@Child field cannot be final", element);
                    continue;
                }
                if (!this.processingEnv.getTypeUtils().isSubtype(element.asType(), nodeInterfaceType.asType())) {
                    this.emitError("@Child field must implement NodeInterface", element);
                    continue;
                }
                if (!this.processingEnv.getTypeUtils().isSubtype(element.getEnclosingElement().asType(), nodeType.asType())) {
                    this.emitError("@Child field is allowed only in Node sub-class", element);
                    continue;
                }
                if (ElementUtils.findAnnotationMirror(element, (TypeMirror)types.Executed) != null) continue;
                this.assertNoErrorExpected(element);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ElementUtils.castTypeElement(types.Node_Children))) {
                boolean bl = false;
                TypeMirror annotatedFieldType = element.asType();
                if (annotatedFieldType.getKind() == TypeKind.ARRAY) {
                    TypeMirror compomentType = ((ArrayType)annotatedFieldType).getComponentType();
                    if (!this.processingEnv.getTypeUtils().isSubtype(compomentType, nodeInterfaceType.asType())) {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    this.emitError("@Children field must be an array of NodeInterface sub-types", element);
                    continue;
                }
                if (!this.processingEnv.getTypeUtils().isSubtype(element.getEnclosingElement().asType(), nodeType.asType())) {
                    this.emitError("@Children field is allowed only in Node sub-class", element);
                    continue;
                }
                if (ElementUtils.findAnnotationMirror(element, (TypeMirror)types.Executed) != null) continue;
                this.assertNoErrorExpected(element);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ElementUtils.castTypeElement(types.DenyReplace))) {
                try {
                    TypeElement typeElement;
                    if (element.getKind() != ElementKind.CLASS || (typeElement = (TypeElement)element).getModifiers().contains((Object)Modifier.FINAL)) continue;
                    this.emitError(String.format("@%s may only be used for final classes.", ElementUtils.getSimpleName(types.DenyReplace)), typeElement);
                }
                catch (Throwable throwable) {
                    this.reportException(VerifyTruffleProcessor.isBug367599(throwable) ? Diagnostic.Kind.NOTE : Diagnostic.Kind.ERROR, element, throwable);
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    void assertNoErrorExpected(Element element) {
        ExpectError.assertNoErrorExpected(element);
    }

    void emitError(String message, Element element) {
        if (ExpectError.isExpectedError(element, message)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    public static boolean isBug367599(Throwable t) {
        if (t instanceof FilerException) {
            for (StackTraceElement ste : t.getStackTrace()) {
                if (!ste.toString().contains("org.eclipse.jdt.internal.apt.pluggable.core.filer.IdeFilerImpl.create")) continue;
                return true;
            }
        }
        if (t.getCause() != null) {
            return VerifyTruffleProcessor.isBug367599(t.getCause());
        }
        return false;
    }
}

