/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java.transform;

import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeElementScanner;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeImport;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeKind;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeMirror;
import com.oracle.truffle.dsl.processor.java.transform.AbstractCodeWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.AbstractAnnotationValueVisitor8;
import javax.lang.model.util.ElementFilter;

public final class OrganizedImports {
    private final Map<String, String> classImportUsage = new HashMap<String, String>();
    private final Map<String, Boolean> noImportSymbols = new HashMap<String, Boolean>();
    private final Map<String, Set<String>> autoImportCache = new HashMap<String, Set<String>>();
    private final CodeTypeElement topLevelClass;

    private OrganizedImports(CodeTypeElement topLevelClass) {
        this.topLevelClass = topLevelClass;
    }

    public static OrganizedImports organize(CodeTypeElement topLevelClass) {
        OrganizedImports organized = new OrganizedImports(topLevelClass);
        organized.organizeImpl();
        return organized;
    }

    private void organizeImpl() {
        ImportTypeReferenceVisitor reference = new ImportTypeReferenceVisitor();
        if (this.topLevelClass != null) {
            this.topLevelClass.accept(reference, null);
        }
    }

    public String createTypeReference(Element enclosedElement, TypeMirror type, boolean raw) {
        switch (type.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case SHORT: 
            case INT: 
            case LONG: 
            case VOID: {
                return ElementUtils.getSimpleName(type);
            }
            case DECLARED: {
                return this.createDeclaredTypeName(enclosedElement, (DeclaredType)type, raw);
            }
            case ARRAY: {
                return this.createTypeReference(enclosedElement, ((ArrayType)type).getComponentType(), raw) + "[]";
            }
            case WILDCARD: {
                return this.createWildcardName(enclosedElement, (WildcardType)type);
            }
            case TYPEVAR: {
                TypeVariable var = (TypeVariable)type;
                return var.asElement().getSimpleName().toString();
            }
        }
        throw new RuntimeException("Unknown type specified " + String.valueOf((Object)type.getKind()) + " mirror: " + String.valueOf(type));
    }

    public String createStaticFieldReference(Element enclosedElement, TypeMirror type, String fieldName) {
        return this.createStaticReference(enclosedElement, type, fieldName);
    }

    public String createStaticMethodReference(Element enclosedElement, TypeMirror type, String methodName) {
        return this.createStaticReference(enclosedElement, type, methodName);
    }

    private String createStaticReference(Element enclosedElement, TypeMirror type, String name) {
        return this.createTypeReference(enclosedElement, type, true) + "." + name;
    }

    private String createWildcardName(Element enclosedElement, WildcardType type) {
        StringBuilder b = new StringBuilder();
        if (type.getExtendsBound() != null) {
            b.append("? extends ").append(this.createTypeReference(enclosedElement, type.getExtendsBound(), false));
        } else if (type.getSuperBound() != null) {
            b.append("? super ").append(this.createTypeReference(enclosedElement, type.getExtendsBound(), false));
        } else {
            b.append("?");
        }
        return b.toString();
    }

    private String createDeclaredTypeName(Element enclosedElement, DeclaredType type, boolean raw) {
        String name = ElementUtils.fixECJBinaryNameIssue(type.asElement().getSimpleName().toString());
        if (ElementUtils.isDeprecated(type.asElement())) {
            name = ElementUtils.getQualifiedName(type);
        } else if (this.classImportUsage.containsKey(name)) {
            String qualifiedImport = this.classImportUsage.get(name);
            String qualifiedName = ElementUtils.getEnclosedQualifiedName(type);
            if (qualifiedImport == null || !qualifiedName.equals(qualifiedImport)) {
                name = ElementUtils.getQualifiedName(type);
            }
        }
        if (raw) {
            return name;
        }
        List<? extends TypeMirror> typeArguments = type.getTypeArguments();
        List<? extends TypeParameterElement> parameters = ((TypeElement)type.asElement()).getTypeParameters();
        if (parameters.isEmpty()) {
            return name;
        }
        StringBuilder b = new StringBuilder(name);
        b.append("<");
        for (int i = 0; i < parameters.size(); ++i) {
            TypeMirror genericType = i < typeArguments.size() ? typeArguments.get(i) : null;
            TypeMirror parameterGenericType = parameters.get(i).asType();
            if (genericType != null && !ElementUtils.typeEquals(genericType, parameterGenericType)) {
                b.append(this.createTypeReference(enclosedElement, genericType, false));
            } else {
                b.append("?");
            }
            if (i >= parameters.size() - 1) continue;
            b.append(", ");
        }
        b.append(">");
        return b.toString();
    }

    public Set<CodeImport> generateImports() {
        HashSet<CodeImport> imports = new HashSet<CodeImport>();
        imports.addAll(this.generateImports(this.classImportUsage));
        return imports;
    }

    private boolean needsImport(Element enclosed, TypeMirror importType) {
        String qualifiedName;
        PackageElement importPackageElement = ElementUtils.getPackageElement(importType);
        TypeElement enclosedType = ElementUtils.findNearestEnclosingType(enclosed).orElse(null);
        if (importPackageElement == null) {
            return false;
        }
        if (importPackageElement.getQualifiedName().contentEquals("java.lang")) {
            return false;
        }
        PackageElement topLevelPackage = ElementUtils.findPackageElement(this.topLevelClass);
        if (ElementUtils.nameEquals(importPackageElement.getQualifiedName(), topLevelPackage.getQualifiedName()) && (OrganizedImports.anyEqualEnclosingTypes(enclosed, ElementUtils.castTypeElement(importType)) || OrganizedImports.importFromEnclosingScope(enclosedType, ElementUtils.castTypeElement(importType)))) {
            return false;
        }
        if (importType instanceof CodeTypeMirror.DeclaredCodeTypeMirror && importPackageElement.getQualifiedName().contentEquals("")) {
            return false;
        }
        if (ElementUtils.isDeprecated(importType)) {
            return false;
        }
        String enclosedElementId = ElementUtils.getUniqueIdentifier(enclosedType.asType());
        Set<String> autoImportedTypes = this.autoImportCache.get(enclosedElementId);
        if (autoImportedTypes == null) {
            autoImportedTypes = new HashSet<String>();
            this.autoImportCache.put(enclosedElementId, autoImportedTypes);
            this.collectImplicitImports(autoImportedTypes, enclosedElementId, enclosedType);
        }
        return !autoImportedTypes.contains(qualifiedName = ElementUtils.getQualifiedName(importType));
    }

    private void collectImplicitImports(Set<String> autoImportedTypes, String enclosedElementId, TypeElement enclosedType) {
        List<Element> elements = ElementUtils.getElementHierarchy(enclosedType);
        for (Element element : elements) {
            if (!element.getKind().isClass() && !element.getKind().isInterface()) continue;
            OrganizedImports.collectSuperTypeImports((TypeElement)element, autoImportedTypes);
            OrganizedImports.collectInnerTypeImports((TypeElement)element, autoImportedTypes);
        }
        this.autoImportCache.put(enclosedElementId, autoImportedTypes);
    }

    private static boolean anyEqualEnclosingTypes(Element enclosed, Element importElement) {
        Element enclosingElement = enclosed.getEnclosingElement();
        Element importEnclosingElement = importElement.getEnclosingElement();
        if (enclosingElement == null || importEnclosingElement == null) {
            return false;
        }
        if (!enclosingElement.getKind().isClass() || !importEnclosingElement.getKind().isClass()) {
            return false;
        }
        if (ElementUtils.elementEquals(enclosingElement, importEnclosingElement)) {
            return true;
        }
        return OrganizedImports.anyEqualEnclosingTypes(enclosingElement, importElement) || OrganizedImports.anyEqualEnclosingTypes(importElement, enclosingElement);
    }

    private static boolean importFromEnclosingScope(TypeElement enclosed, TypeElement importElement) {
        Element importEnclosingElement = importElement.getEnclosingElement();
        for (Element current = enclosed; current != null; current = current.getEnclosingElement()) {
            if (!ElementUtils.elementEquals(importElement, current) && !ElementUtils.elementEquals(importEnclosingElement, current)) continue;
            return true;
        }
        return false;
    }

    private Set<CodeImport> generateImports(Map<String, String> symbols) {
        TreeSet<CodeImport> importObjects = new TreeSet<CodeImport>();
        for (String symbol : symbols.keySet()) {
            String importQualifiedName = symbols.get(symbol);
            Boolean needsImport = this.noImportSymbols.get(symbol);
            if (importQualifiedName == null || !needsImport.booleanValue()) continue;
            String useSymbol = symbol;
            int firstClassIndex = useSymbol.indexOf(46);
            if (firstClassIndex != -1) {
                useSymbol = useSymbol.substring(0, firstClassIndex);
            }
            importObjects.add(new CodeImport(importQualifiedName, useSymbol, false));
        }
        return importObjects;
    }

    private static void collectInnerTypeImports(TypeElement e, Set<String> autoImportedTypes) {
        autoImportedTypes.add(ElementUtils.getQualifiedName(e));
        for (TypeElement innerClass : ElementFilter.typesIn(e.getEnclosedElements())) {
            autoImportedTypes.add(ElementUtils.getQualifiedName(innerClass));
        }
    }

    private static void collectSuperTypeImports(TypeElement e, Set<String> autoImportedTypes) {
        List<TypeElement> superTypes = ElementUtils.getSuperTypes(e);
        for (TypeElement superType : superTypes) {
            List<TypeElement> declaredTypes = ElementUtils.getDeclaredTypes(superType);
            for (TypeElement declaredType : declaredTypes) {
                if (superTypes.contains(declaredType)) continue;
                autoImportedTypes.add(ElementUtils.getQualifiedName(declaredType));
            }
        }
    }

    private final class ImportTypeReferenceVisitor
    extends TypeReferenceVisitor {
        private ImportTypeReferenceVisitor() {
        }

        @Override
        public void visitStaticFieldReference(Element enclosedType, TypeMirror type, String elementName) {
            this.visitTypeReference(enclosedType, type);
        }

        @Override
        public void visitStaticMethodReference(Element enclosedType, TypeMirror type, String elementName) {
            this.visitTypeReference(enclosedType, type);
        }

        @Override
        public void visitTypeReference(Element enclosedType, TypeMirror type) {
            if (type != null) {
                switch (type.getKind()) {
                    case BOOLEAN: 
                    case BYTE: 
                    case CHAR: 
                    case DOUBLE: 
                    case FLOAT: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case VOID: {
                        return;
                    }
                    case DECLARED: {
                        DeclaredType declared = (DeclaredType)type;
                        String declaredName = ElementUtils.getDeclaredName(declared, false);
                        String enclosedQualifiedName = ElementUtils.getEnclosedQualifiedName(declared);
                        this.registerSymbol(OrganizedImports.this.classImportUsage, enclosedQualifiedName, declaredName, type);
                        if (!OrganizedImports.this.needsImport(enclosedType, type)) {
                            OrganizedImports.this.noImportSymbols.putIfAbsent(declaredName, Boolean.FALSE);
                        } else {
                            OrganizedImports.this.noImportSymbols.put(declaredName, Boolean.TRUE);
                        }
                        for (TypeMirror typeMirror : ((DeclaredType)type).getTypeArguments()) {
                            this.visitTypeReference(enclosedType, typeMirror);
                        }
                        return;
                    }
                    case ARRAY: {
                        this.visitTypeReference(enclosedType, ((ArrayType)type).getComponentType());
                        return;
                    }
                    case WILDCARD: {
                        WildcardType wildcard = (WildcardType)type;
                        if (wildcard.getExtendsBound() != null) {
                            this.visitTypeReference(enclosedType, wildcard.getExtendsBound());
                        } else if (wildcard.getSuperBound() != null) {
                            this.visitTypeReference(enclosedType, wildcard.getSuperBound());
                        }
                        return;
                    }
                    case TYPEVAR: {
                        return;
                    }
                }
                throw new RuntimeException("Unknown type specified " + String.valueOf((Object)type.getKind()) + " mirror: " + String.valueOf(type));
            }
        }

        private boolean isImportDeprecated(TypeMirror type) {
            Optional<TypeElement> optional = Optional.ofNullable(ElementUtils.castTypeElement(type));
            while (optional.isPresent()) {
                TypeElement element = optional.get();
                if (ElementUtils.isDeprecated(element)) {
                    return true;
                }
                optional = ElementUtils.findParentEnclosingType(element);
            }
            return false;
        }

        private void registerSymbol(Map<String, String> symbolUsage, String elementQualifiedName, String elementName, TypeMirror type) {
            if (symbolUsage.containsKey(elementName)) {
                String otherQualifiedName = symbolUsage.get(elementName);
                if (otherQualifiedName == null) {
                    return;
                }
                if (!otherQualifiedName.equals(elementQualifiedName)) {
                    symbolUsage.put(elementName, null);
                }
            } else if (this.isImportDeprecated(type)) {
                symbolUsage.put(elementName, null);
            } else {
                symbolUsage.put(elementName, elementQualifiedName);
            }
        }
    }

    private static abstract class TypeReferenceVisitor
    extends CodeElementScanner<Void, Void> {
        private TypeReferenceVisitor() {
        }

        @Override
        public void visitTree(CodeTree e, Void p, Element enclosing) {
            if (e.getCodeKind() == CodeTreeKind.STATIC_FIELD_REFERENCE) {
                this.visitStaticFieldReference(enclosing, e.getType(), e.getString());
            } else if (e.getCodeKind() == CodeTreeKind.STATIC_METHOD_REFERENCE) {
                this.visitStaticMethodReference(enclosing, e.getType(), e.getString());
            } else if (e.getType() != null) {
                this.visitTypeReference(enclosing, e.getType());
            }
            super.visitTree(e, p, enclosing);
        }

        @Override
        public Void visitExecutable(CodeExecutableElement e, Void p) {
            this.visitAnnotations(e, e.getAnnotationMirrors());
            if (e.getReturnType() != null) {
                this.visitTypeReference(e, e.getReturnType());
            }
            for (TypeMirror type : e.getThrownTypes()) {
                this.visitTypeReference(e, type);
            }
            return (Void)super.visitExecutable(e, p);
        }

        @Override
        public Void visitType(CodeTypeElement e, Void p) {
            Element enclosing = e;
            if (!e.isTopLevelClass()) {
                enclosing = e.getEnclosingElement();
            }
            this.visitAnnotations(enclosing, e.getAnnotationMirrors());
            if (e.getDocTree() != null) {
                this.visitTree(e.getDocTree(), null, enclosing);
            }
            this.visitTypeReference(e, e.getSuperclass());
            for (TypeMirror type : e.getImplements()) {
                this.visitTypeReference(e, type);
            }
            return (Void)super.visitType(e, p);
        }

        private void visitAnnotations(Element enclosingElement, List<? extends AnnotationMirror> mirrors) {
            for (AnnotationMirror annotationMirror : mirrors) {
                this.visitAnnotation(enclosingElement, annotationMirror);
            }
        }

        public void visitAnnotation(Element enclosingElement, AnnotationMirror e) {
            block4: {
                block3: {
                    List<AnnotationMirror> repeatables = AbstractCodeWriter.unpackRepeatable(e);
                    if (repeatables == null) break block3;
                    for (AnnotationMirror repeatable : repeatables) {
                        this.visitAnnotation(enclosingElement, repeatable);
                    }
                    break block4;
                }
                this.visitTypeReference(enclosingElement, e.getAnnotationType());
                if (e.getElementValues().isEmpty()) break block4;
                Map<? extends ExecutableElement, ? extends AnnotationValue> values = e.getElementValues();
                Set<? extends ExecutableElement> methodsSet = values.keySet();
                ArrayList<ExecutableElement> methodsList = new ArrayList<ExecutableElement>();
                for (ExecutableElement executableElement : methodsSet) {
                    if (values.get(executableElement) == null) continue;
                    methodsList.add(executableElement);
                }
                for (int i = 0; i < methodsList.size(); ++i) {
                    AnnotationValue annotationValue = values.get(methodsList.get(i));
                    this.visitAnnotationValue(enclosingElement, annotationValue);
                }
            }
        }

        public void visitAnnotationValue(Element enclosingElement, AnnotationValue e) {
            e.accept(new AnnotationValueReferenceVisitor(enclosingElement), null);
        }

        @Override
        public Void visitVariable(VariableElement f, Void p) {
            this.visitAnnotations(f, f.getAnnotationMirrors());
            this.visitTypeReference(f, f.asType());
            return (Void)super.visitVariable(f, p);
        }

        @Override
        public void visitImport(CodeImport e, Void p) {
        }

        public abstract void visitTypeReference(Element var1, TypeMirror var2);

        public abstract void visitStaticMethodReference(Element var1, TypeMirror var2, String var3);

        public abstract void visitStaticFieldReference(Element var1, TypeMirror var2, String var3);

        private class AnnotationValueReferenceVisitor
        extends AbstractAnnotationValueVisitor8<Void, Void> {
            private final Element enclosingElement;

            AnnotationValueReferenceVisitor(Element enclosedElement) {
                this.enclosingElement = enclosedElement;
            }

            @Override
            public Void visitBoolean(boolean b, Void p) {
                return null;
            }

            @Override
            public Void visitByte(byte b, Void p) {
                return null;
            }

            @Override
            public Void visitChar(char c, Void p) {
                return null;
            }

            @Override
            public Void visitDouble(double d, Void p) {
                return null;
            }

            @Override
            public Void visitFloat(float f, Void p) {
                return null;
            }

            @Override
            public Void visitInt(int i, Void p) {
                return null;
            }

            @Override
            public Void visitLong(long i, Void p) {
                return null;
            }

            @Override
            public Void visitShort(short s, Void p) {
                return null;
            }

            @Override
            public Void visitString(String s, Void p) {
                return null;
            }

            @Override
            public Void visitType(TypeMirror t, Void p) {
                TypeReferenceVisitor.this.visitTypeReference(this.enclosingElement, t);
                return null;
            }

            @Override
            public Void visitEnumConstant(VariableElement c, Void p) {
                TypeReferenceVisitor.this.visitTypeReference(this.enclosingElement, c.asType());
                return null;
            }

            @Override
            public Void visitAnnotation(AnnotationMirror a, Void p) {
                TypeReferenceVisitor.this.visitAnnotation(this.enclosingElement, a);
                return null;
            }

            @Override
            public Void visitArray(List<? extends AnnotationValue> vals, Void p) {
                for (int i = 0; i < vals.size(); ++i) {
                    TypeReferenceVisitor.this.visitAnnotationValue(this.enclosingElement, vals.get(i));
                }
                return null;
            }
        }
    }
}

