/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.generator;

import com.oracle.truffle.dsl.processor.generator.BitSet;
import com.oracle.truffle.dsl.processor.generator.FlatNodeGenFactory;
import com.oracle.truffle.dsl.processor.generator.StateQuery;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

class MultiBitSet {
    private final List<BitSet> sets;

    MultiBitSet(List<BitSet> sets) {
        this.sets = sets;
    }

    public List<BitSet> getSets() {
        return this.sets;
    }

    public int getCapacity() {
        int length = 0;
        for (BitSet a : this.sets) {
            length += a.getBitCount();
        }
        return length;
    }

    public CodeTree createContainsAll(FlatNodeGenFactory.FrameState frameState, StateQuery elements) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        String sep = "";
        for (BitSet set : this.sets) {
            StateQuery selected = set.filter(elements);
            if (selected.isEmpty()) continue;
            CodeTree containsAll = set.createIs(frameState, selected, selected);
            builder.string(sep);
            builder.tree(containsAll);
            sep = " && ";
        }
        return builder.build();
    }

    public CodeTree createContains(FlatNodeGenFactory.FrameState frameState, StateQuery elements) {
        return MultiBitSet.createContainsImpl(this.sets, frameState, elements);
    }

    protected static CodeTree createContainsImpl(List<? extends BitSet> sets, FlatNodeGenFactory.FrameState frameState, StateQuery elements) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        ArrayList<CodeTree> conditions = new ArrayList<CodeTree>();
        for (BitSet bitSet : sets) {
            StateQuery included = bitSet.filter(elements);
            if (included.isEmpty()) continue;
            conditions.add(bitSet.createContains(frameState, included));
        }
        if (conditions.size() > 1) {
            builder.string("(");
        }
        String sep = "";
        for (CodeTree tree : conditions) {
            builder.string(sep);
            builder.tree(tree);
            sep = " || ";
        }
        if (conditions.size() > 1) {
            builder.string(")");
        }
        return builder.build();
    }

    public CodeTree persistTransaction(FlatNodeGenFactory.FrameState frameState, StateTransaction transaction) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        for (BitSet set : transaction.modified) {
            if (set.hasLocal(frameState)) {
                builder.tree(set.createSet(frameState, null, null, true));
                continue;
            }
            throw new AssertionError((Object)"Cannot persist transaction state local without a local variable in the frame state.");
        }
        return builder.build();
    }

    public CodeTree createSet(FlatNodeGenFactory.FrameState frameState, StateTransaction transaction, StateQuery query, boolean value, boolean persist) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        for (BitSet set : this.sets) {
            StateQuery included = set.getStates().filter(query);
            if (included.isEmpty()) continue;
            if (transaction != null) {
                if (!set.hasLocal(frameState) || persist) {
                    throw new AssertionError((Object)"Must be loaded for transactional write.");
                }
                transaction.modified.add(set);
            }
            builder.tree(set.createSet(frameState, included, value, persist));
        }
        return builder.build();
    }

    public CodeTree createSetInteger(FlatNodeGenFactory.FrameState frameState, StateTransaction transaction, StateQuery element, CodeTree value) {
        for (BitSet set : this.sets) {
            if (!set.contains(element)) continue;
            if (transaction != null) {
                if (!set.hasLocal(frameState)) {
                    throw new AssertionError((Object)"Cannot use transactions without the state being loaded.");
                }
                transaction.modified.add(set);
            }
            return set.createSetInteger(frameState, element, value);
        }
        throw new AssertionError((Object)"element not contained");
    }

    public CodeTree createContainsOnly(FlatNodeGenFactory.FrameState frameState, int offset, int length, StateQuery selectedElements, StateQuery allElements) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        String sep = "";
        for (BitSet set : this.sets) {
            CodeTree containsOnly;
            StateQuery selected = set.filter(selectedElements);
            StateQuery filteredAll = set.filter(allElements);
            if (filteredAll.isEmpty() || (containsOnly = set.createContainsOnly(frameState, offset, length, selected, filteredAll)) == null) continue;
            builder.string(sep);
            builder.tree(containsOnly);
            sep = " && ";
        }
        return builder.build();
    }

    public CodeTree createIs(FlatNodeGenFactory.FrameState frameState, StateQuery selectedElements, StateQuery maskedElements) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        String sep = "";
        for (BitSet set : this.sets) {
            StateQuery masked = set.filter(maskedElements);
            if (masked.isEmpty()) continue;
            StateQuery selected = set.filter(selectedElements);
            builder.string(sep);
            builder.tree(set.createIs(frameState, selected, masked));
            sep = " && ";
        }
        return builder.build();
    }

    public CodeTree createIsNotAny(FlatNodeGenFactory.FrameState frameState, StateQuery elements) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.string("(");
        String sep = "";
        for (BitSet set : this.sets) {
            StateQuery filteredElements = set.filter(elements);
            if (filteredElements.isEmpty()) continue;
            builder.string(sep);
            builder.tree(set.createIsNotAny(frameState, filteredElements));
            sep = " || ";
        }
        builder.string(")");
        return builder.build();
    }

    public CodeTree createExtractInteger(FlatNodeGenFactory.FrameState frameState, StateQuery element) {
        for (BitSet set : this.sets) {
            if (!set.contains(element)) continue;
            return set.createExtractInteger(frameState, element);
        }
        throw new AssertionError((Object)"element not contained");
    }

    public CodeTree createNotContains(FlatNodeGenFactory.FrameState frameState, StateQuery elements) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        String sep = "";
        for (BitSet set : this.sets) {
            StateQuery setElements = set.filter(elements);
            if (setElements.isEmpty()) continue;
            builder.string(sep);
            builder.tree(set.createNotContains(frameState, setElements));
            sep = " && ";
        }
        return builder.build();
    }

    static final class StateTransaction {
        private final LinkedHashSet<BitSet> modified = new LinkedHashSet();

        StateTransaction() {
        }

        void markModified(BitSet bitSet) {
            this.modified.add(bitSet);
        }
    }
}

