/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.bytecode.parser;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.bytecode.model.BytecodeDSLModel;
import com.oracle.truffle.dsl.processor.bytecode.model.ConstantOperandModel;
import com.oracle.truffle.dsl.processor.bytecode.model.CustomOperationModel;
import com.oracle.truffle.dsl.processor.bytecode.model.DynamicOperandModel;
import com.oracle.truffle.dsl.processor.bytecode.model.InstructionModel;
import com.oracle.truffle.dsl.processor.bytecode.model.OperationModel;
import com.oracle.truffle.dsl.processor.bytecode.model.ShortCircuitInstructionModel;
import com.oracle.truffle.dsl.processor.bytecode.model.Signature;
import com.oracle.truffle.dsl.processor.bytecode.parser.BytecodeDSLParser;
import com.oracle.truffle.dsl.processor.bytecode.parser.SpecializationSignatureParser;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationValue;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import com.oracle.truffle.dsl.processor.java.model.GeneratedPackageElement;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import com.oracle.truffle.dsl.processor.model.NodeData;
import com.oracle.truffle.dsl.processor.model.TypeSystemData;
import com.oracle.truffle.dsl.processor.parser.AbstractParser;
import com.oracle.truffle.dsl.processor.parser.NodeParser;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;

public final class CustomOperationParser
extends AbstractParser<CustomOperationModel> {
    private final ProcessorContext context;
    private final BytecodeDSLModel parent;
    private final DeclaredType annotationType;
    private final boolean forProxyValidation;
    private boolean uncachedProxyValidation;

    private CustomOperationParser(ProcessorContext context, BytecodeDSLModel parent, DeclaredType annotationType, boolean forProxyValidation) {
        this.context = context;
        this.parent = parent;
        this.annotationType = annotationType;
        this.forProxyValidation = forProxyValidation;
    }

    public static CustomOperationParser forProxyValidation() {
        ProcessorContext context = ProcessorContext.getInstance();
        CodeTypeElement dummyBytecodeClass = new CodeTypeElement(Set.of(), ElementKind.CLASS, null, "DummyBytecodeClass");
        dummyBytecodeClass.setSuperClass(context.getTypes().Node);
        dummyBytecodeClass.setEnclosingElement(new GeneratedPackageElement("dummy"));
        return new CustomOperationParser(context, new BytecodeDSLModel(context, dummyBytecodeClass, null, null, null), context.getTypes().OperationProxy_Proxyable, true);
    }

    public static CustomOperationParser forCodeGeneration(BytecodeDSLModel parent, DeclaredType annotationType) {
        ProcessorContext context = parent.getContext();
        if (CustomOperationParser.isHandled(context, annotationType)) {
            return new CustomOperationParser(context, parent, annotationType, false);
        }
        throw new IllegalArgumentException(String.format("%s does not handle the %s annotation.", CustomOperationParser.class.getName(), annotationType));
    }

    private static boolean isHandled(ProcessorContext context, TypeMirror annotationType) {
        Types typeUtils = context.getEnvironment().getTypeUtils();
        TruffleTypes truffleTypes = context.getTypes();
        for (DeclaredType handled : new DeclaredType[]{truffleTypes.Operation, truffleTypes.OperationProxy_Proxyable, truffleTypes.ShortCircuitOperation}) {
            if (!typeUtils.isSameType(annotationType, handled)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected CustomOperationModel parse(Element element, List<AnnotationMirror> annotationMirrors) {
        if (!ElementUtils.typeEquals(this.annotationType, this.context.getTypes().OperationProxy_Proxyable)) {
            throw new AssertionError();
        }
        TypeElement typeElement = (TypeElement)element;
        if (annotationMirrors.size() != 1) {
            throw new IllegalArgumentException(String.format("Expected element %s to have one %s annotation, but %d found.", typeElement.getSimpleName(), this.annotationType, annotationMirrors.size()));
        }
        AnnotationMirror mirror = annotationMirrors.get(0);
        return this.parseCustomRegularOperation(mirror, typeElement, null);
    }

    CustomOperationModel parseCustomRegularOperation(AnnotationMirror mirror, TypeElement typeElement, String explicitName) {
        OperationModel.ConstantOperandsModel constantOperands;
        if (this.forProxyValidation) {
            this.uncachedProxyValidation = ElementUtils.getAnnotationValue(Boolean.class, mirror, "allowUncached");
        }
        if (this.isShortCircuit()) {
            throw new AssertionError();
        }
        String name = this.getCustomOperationName(typeElement, explicitName);
        String javadoc = ElementUtils.getAnnotationValue(String.class, mirror, "javadoc");
        boolean isInstrumentation = ElementUtils.typeEquals(mirror.getAnnotationType(), this.types.Instrumentation);
        OperationModel.OperationKind kind = isInstrumentation ? OperationModel.OperationKind.CUSTOM_INSTRUMENTATION : OperationModel.OperationKind.CUSTOM;
        CustomOperationModel customOperation = this.parent.customRegularOperation(kind, name, javadoc, typeElement, mirror);
        if (customOperation == null) {
            return null;
        }
        AnnotationValue forceCachedValue = ElementUtils.getAnnotationValue(mirror, "forceCached", false);
        if (forceCachedValue != null) {
            boolean forceCached = ElementUtils.resolveAnnotationValue(Boolean.class, forceCachedValue);
            if (forceCached) {
                if (this.parent.enableUncachedInterpreter) {
                    customOperation.setForceCached();
                } else {
                    customOperation.getModelForMessages().addError(mirror, forceCachedValue, "The uncached interpreter is not enabled, so forceCached has no effect. Remove the forceCached attribute to resolve this error.", new Object[0]);
                }
            } else {
                customOperation.getModelForMessages().addError(mirror, forceCachedValue, "Setting forceCached to false has no effect. Remove the forceCached attribute or set it to true to resolve this error.", new Object[0]);
            }
        }
        OperationModel operation = customOperation.operation;
        this.validateCustomOperation(customOperation, typeElement, mirror, name);
        operation.constantOperands = constantOperands = this.getConstantOperands(customOperation, typeElement, mirror);
        if (customOperation.hasErrors()) {
            return customOperation;
        }
        CodeTypeElement generatedNode = this.createNodeForCustomInstruction(typeElement);
        List<ExecutableElement> specializations = this.findSpecializations(generatedNode);
        if (specializations.size() == 0) {
            customOperation.addError("Operation class %s contains no specializations.", generatedNode.getSimpleName());
            return customOperation;
        }
        List<SpecializationSignatureParser.SpecializationSignature> signatures = CustomOperationParser.parseSignatures(specializations, customOperation, constantOperands);
        if (customOperation.hasErrors()) {
            return customOperation;
        }
        Signature signature = SpecializationSignatureParser.createPolymorphicSignature(signatures, specializations, customOperation);
        if (customOperation.hasErrors()) {
            return customOperation;
        }
        if (signature == null) {
            throw new AssertionError((Object)"Signature could not be computed, but no error was reported");
        }
        this.produceConstantOperandWarnings(customOperation, signature, mirror);
        List<String> constantOperandBeforeNames = CustomOperationParser.mergeConstantOperandNames(customOperation, constantOperands.before(), signatures, 0);
        List<String> constantOperandAfterNames = CustomOperationParser.mergeConstantOperandNames(customOperation, constantOperands.after(), signatures, signature.constantOperandsBeforeCount + signature.dynamicOperandCount);
        List<List<String>> dynamicOperandNames = CustomOperationParser.collectDynamicOperandNames(signatures, signature);
        if (operation.kind == OperationModel.OperationKind.CUSTOM_INSTRUMENTATION) {
            this.validateInstrumentationSignature(customOperation, signature);
        } else if (ElementUtils.typeEquals(mirror.getAnnotationType(), this.types.Prolog)) {
            this.validatePrologSignature(customOperation, signature);
        } else if (ElementUtils.typeEquals(mirror.getAnnotationType(), this.types.EpilogReturn)) {
            this.validateEpilogReturnSignature(customOperation, signature);
        } else if (ElementUtils.typeEquals(mirror.getAnnotationType(), this.types.EpilogExceptional)) {
            this.validateEpilogExceptionalSignature(customOperation, signature, specializations, signatures);
        } else {
            List<TypeMirror> tags = ElementUtils.getAnnotationValueList(TypeMirror.class, mirror, "tags");
            MessageContainer modelForErrors = customOperation.getModelForMessages();
            if (!tags.isEmpty()) {
                AnnotationValue tagsValue = ElementUtils.getAnnotationValue(mirror, "tags");
                customOperation.implicitTags.addAll(tags);
                if (!this.parent.enableTagInstrumentation) {
                    modelForErrors.addError(mirror, tagsValue, "Tag instrumentation is not enabled. The tags attribute can only be used if tag instrumentation is enabled for the parent root node. Enable tag instrumentation using @%s(... enableTagInstrumentation = true) to resolve this or remove the tags attribute.", ElementUtils.getSimpleName(this.types.GenerateBytecode));
                } else {
                    for (TypeMirror tag : tags) {
                        if (customOperation.bytecode.isTagProvided(tag)) continue;
                        modelForErrors.addError(mirror, tagsValue, "Invalid tag '%s' specified. The tag is not provided by language '%s'.", ElementUtils.getSimpleName(tag), ElementUtils.getQualifiedName(this.parent.languageClass));
                        break;
                    }
                }
            }
        }
        AnnotationMirror variadicReturn = ElementUtils.findAnnotationMirror(typeElement.getAnnotationMirrors(), (TypeMirror)this.types.Variadic);
        if (variadicReturn != null) {
            Integer startOffset;
            if (kind != OperationModel.OperationKind.CUSTOM) {
                customOperation.addError(variadicReturn, null, "@%s can only be used on on @%s annotated classes.", ElementUtils.getSimpleName(this.types.Variadic), ElementUtils.getSimpleName(this.types.Operation));
            }
            if ((startOffset = ElementUtils.getAnnotationValue(Integer.class, variadicReturn, "startOffset", false)) != null) {
                customOperation.addError(variadicReturn, ElementUtils.getAnnotationValue(variadicReturn, "startOffset"), "@%s.startOffset is not supported for variadic return specifications. It is supported for variadic operands only.", ElementUtils.getSimpleName(this.types.Variadic));
            }
            if (!ElementUtils.typeEquals(signature.returnType, this.context.getType(Object[].class))) {
                customOperation.addError(variadicReturn, null, "@%s annotated operations must return Object[] for all specializations.", ElementUtils.getSimpleName(this.types.Variadic));
            }
            operation.variadicReturn = true;
        }
        if (customOperation.hasErrors()) {
            return customOperation;
        }
        operation.isVariadic = signature.isVariadic || this.isShortCircuit();
        operation.variadicOffset = signature.variadicOffset;
        operation.isVoid = signature.isVoid;
        DynamicOperandModel[] dynamicOperands = new DynamicOperandModel[signature.dynamicOperandCount];
        for (int i = 0; i < dynamicOperands.length; ++i) {
            dynamicOperands[i] = new DynamicOperandModel(dynamicOperandNames.get(i), false, signature.isVariadicParameter(i));
        }
        operation.dynamicOperands = dynamicOperands;
        operation.constantOperandBeforeNames = constantOperandBeforeNames;
        operation.constantOperandAfterNames = constantOperandAfterNames;
        operation.operationBeginArguments = this.createOperationConstantArguments(constantOperands.before(), constantOperandBeforeNames);
        operation.operationEndArguments = this.createOperationConstantArguments(constantOperands.after(), constantOperandAfterNames);
        operation.setInstruction(this.createCustomInstruction(customOperation, generatedNode, signature, name));
        return customOperation;
    }

    private static List<List<String>> collectDynamicOperandNames(List<SpecializationSignatureParser.SpecializationSignature> signatures, Signature signature) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (int i = 0; i < signature.dynamicOperandCount; ++i) {
            result.add(CustomOperationParser.getDynamicOperandNames(signatures, signature.constantOperandsBeforeCount + i));
        }
        return result;
    }

    private static List<String> mergeConstantOperandNames(CustomOperationModel customOperation, List<ConstantOperandModel> constantOperands, List<SpecializationSignatureParser.SpecializationSignature> signatures, int operandOffset) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < constantOperands.size(); ++i) {
            ConstantOperandModel constantOperand = constantOperands.get(i);
            List<String> operandNames = CustomOperationParser.getConstantOperandNames(signatures, constantOperand, operandOffset + i);
            if (operandNames.size() > 1) {
                customOperation.addWarning(constantOperand.mirror(), null, "Specializations use multiple different names for this operand (%s). It is recommended to use the same name in each specialization or to explicitly provide a name for the operand.", operandNames);
            }
            result.add(operandNames.getFirst());
        }
        return result;
    }

    private void produceConstantOperandWarnings(CustomOperationModel customOperation, Signature polymorphicSignature, AnnotationMirror mirror) {
        OperationModel.ConstantOperandsModel constantOperands = customOperation.operation.constantOperands;
        for (ConstantOperandModel constantOperand : constantOperands.before()) {
            this.warnIfSpecifyAtEndUnnecessary(polymorphicSignature, constantOperand, customOperation, mirror);
        }
        for (ConstantOperandModel constantOperand : constantOperands.after()) {
            this.warnIfSpecifyAtEndUnnecessary(polymorphicSignature, constantOperand, customOperation, mirror);
        }
    }

    private static List<String> getDynamicOperandNames(List<SpecializationSignatureParser.SpecializationSignature> signatures, int operandIndex) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (SpecializationSignatureParser.SpecializationSignature signature : signatures) {
            result.add(signature.operandNames().get(operandIndex));
        }
        return new ArrayList<String>(result);
    }

    private static List<String> getConstantOperandNames(List<SpecializationSignatureParser.SpecializationSignature> signatures, ConstantOperandModel constantOperand, int operandIndex) {
        if (!constantOperand.name().isEmpty()) {
            return List.of(constantOperand.name());
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (SpecializationSignatureParser.SpecializationSignature signature : signatures) {
            result.add(signature.operandNames().get(operandIndex));
        }
        return new ArrayList<String>(result);
    }

    private void warnIfSpecifyAtEndUnnecessary(Signature polymorphicSignature, ConstantOperandModel constantOperand, CustomOperationModel customOperation, AnnotationMirror mirror) {
        if (ElementUtils.typeEquals(mirror.getAnnotationType(), this.types.Prolog)) {
            return;
        }
        if (polymorphicSignature.dynamicOperandCount == 0 && constantOperand.specifyAtEnd() != null) {
            customOperation.addWarning(constantOperand.mirror(), ElementUtils.getAnnotationValue(constantOperand.mirror(), "specifyAtEnd"), "The specifyAtEnd attribute is unnecessary. This operation does not take any dynamic operands, so all operands will be provided to a single emit%s method.", customOperation.operation.name);
        }
    }

    private void validateInstrumentationSignature(CustomOperationModel customOperation, Signature signature) {
        if (signature.dynamicOperandCount > 1) {
            customOperation.addError(String.format("An @%s operation cannot have more than one dynamic operand. Instrumentations must have transparent stack effects. Remove the additional operands to resolve this.", ElementUtils.getSimpleName(this.types.Instrumentation)), new Object[0]);
        } else if (signature.isVariadic) {
            customOperation.addError(String.format("An @%s operation cannot use @%s for its dynamic operand. Instrumentations must have transparent stack effects. Remove the variadic annotation to resolve this.", ElementUtils.getSimpleName(this.types.Instrumentation), ElementUtils.getSimpleName(this.types.Variadic)), new Object[0]);
        } else if (!signature.isVoid && signature.dynamicOperandCount != 1) {
            customOperation.addError(String.format("An @%s operation cannot have a return value without also specifying a single dynamic operand. Instrumentations must have transparent stack effects. Use void as the return type or specify a single dynamic operand value to resolve this.", ElementUtils.getSimpleName(this.types.Instrumentation)), new Object[0]);
        }
    }

    private void validatePrologSignature(CustomOperationModel customOperation, Signature signature) {
        if (signature.dynamicOperandCount > 0) {
            customOperation.addError(String.format("A @%s operation cannot have any dynamic operands. Remove the operands to resolve this.", ElementUtils.getSimpleName(this.types.Prolog)), new Object[0]);
        } else if (!signature.isVoid) {
            customOperation.addError(String.format("A @%s operation cannot have a return value. Use void as the return type.", ElementUtils.getSimpleName(this.types.Prolog)), new Object[0]);
        }
    }

    private void validateEpilogReturnSignature(CustomOperationModel customOperation, Signature signature) {
        if (signature.dynamicOperandCount != 1) {
            customOperation.addError(String.format("An @%s operation must have exactly one dynamic operand for the returned value. Update all specializations to take one operand to resolve this.", ElementUtils.getSimpleName(this.types.EpilogReturn)), new Object[0]);
        } else if (signature.isVoid) {
            customOperation.addError(String.format("An @%s operation must have a return value. The result is returned from the root node instead of the original return value. Update all specializations to return a value to resolve this.", ElementUtils.getSimpleName(this.types.EpilogReturn)), new Object[0]);
        }
    }

    private void validateEpilogExceptionalSignature(CustomOperationModel customOperation, Signature signature, List<ExecutableElement> specializations, List<SpecializationSignatureParser.SpecializationSignature> signatures) {
        if (signature.dynamicOperandCount != 1) {
            customOperation.addError(String.format("An @%s operation must have exactly one dynamic operand for the exception. Update all specializations to take one operand to resolve this.", ElementUtils.getSimpleName(this.types.EpilogExceptional)), new Object[0]);
            return;
        }
        for (int i = 0; i < signatures.size(); ++i) {
            Signature individualSignature = signatures.get(i).signature();
            TypeMirror argType = individualSignature.operandTypes.get(0);
            if (ElementUtils.isAssignable(argType, this.types.AbstractTruffleException)) continue;
            customOperation.addError(String.format("The operand type for %s must be %s or a subclass.", specializations.get(i).getSimpleName(), ElementUtils.getSimpleName(this.types.AbstractTruffleException)), new Object[0]);
        }
        if (customOperation.hasErrors()) {
            return;
        }
        if (!signature.isVoid) {
            customOperation.addError(String.format("An @%s operation cannot have a return value. Use void as the return type.", ElementUtils.getSimpleName(this.types.EpilogExceptional)), new Object[0]);
        }
    }

    private OperationModel.OperationArgument[] createOperationConstantArguments(List<ConstantOperandModel> operands, List<String> operandNames) {
        assert (operands.size() == operandNames.size());
        OperationModel.OperationArgument[] arguments = new OperationModel.OperationArgument[operandNames.size()];
        for (int i = 0; i < operandNames.size(); ++i) {
            OperationModel.OperationArgument.Encoding encoding;
            TypeMirror builderType;
            ConstantOperandModel constantOperand = operands.get(i);
            String argumentName = operandNames.get(i);
            if (ElementUtils.typeEqualsAny(constantOperand.type(), this.types.LocalAccessor, this.types.MaterializedLocalAccessor)) {
                builderType = this.types.BytecodeLocal;
                encoding = OperationModel.OperationArgument.Encoding.LOCAL;
            } else if (ElementUtils.typeEquals(constantOperand.type(), this.types.LocalRangeAccessor)) {
                builderType = new CodeTypeMirror.ArrayCodeTypeMirror(this.types.BytecodeLocal);
                encoding = OperationModel.OperationArgument.Encoding.LOCAL_ARRAY;
            } else {
                builderType = constantOperand.type();
                encoding = OperationModel.OperationArgument.Encoding.OBJECT;
            }
            arguments[i] = new OperationModel.OperationArgument(builderType, constantOperand.type(), encoding, CustomOperationParser.sanitizeConstantArgumentName(argumentName), constantOperand.doc());
        }
        return arguments;
    }

    private static String sanitizeConstantArgumentName(String name) {
        return name + "Value";
    }

    CustomOperationModel parseCustomShortCircuitOperation(AnnotationMirror mirror, String name, ShortCircuitInstructionModel.Operator operator, TypeElement booleanConverterTypeElement) {
        String javadoc = ElementUtils.getAnnotationValue(String.class, mirror, "javadoc");
        CustomOperationModel customOperation = this.parent.customShortCircuitOperation(name, javadoc, mirror);
        if (customOperation == null) {
            return null;
        }
        OperationModel operation = customOperation.operation;
        operation.isVariadic = true;
        operation.isVoid = false;
        operation.setDynamicOperands(new DynamicOperandModel(List.of("value"), false, false));
        InstructionModel booleanConverterInstruction = null;
        if (booleanConverterTypeElement != null) {
            booleanConverterInstruction = this.getOrCreateBooleanConverterInstruction(booleanConverterTypeElement, mirror);
        }
        InstructionModel instruction = this.parent.shortCircuitInstruction("sc." + name, new ShortCircuitInstructionModel(operator, booleanConverterInstruction));
        operation.setInstruction(instruction);
        instruction.addImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX, "branch_target");
        instruction.addImmediate(InstructionModel.ImmediateKind.BRANCH_PROFILE, "branch_profile");
        return customOperation;
    }

    private InstructionModel getOrCreateBooleanConverterInstruction(TypeElement typeElement, AnnotationMirror mirror) {
        CustomOperationModel result = this.parent.getCustomOperationForType(typeElement);
        if (result == null) {
            result = CustomOperationParser.forCodeGeneration(this.parent, this.types.Operation).parseCustomRegularOperation(mirror, typeElement, null);
        }
        if (result == null || result.hasErrors()) {
            this.parent.addError(mirror, ElementUtils.getAnnotationValue(mirror, "booleanConverter"), "Encountered errors using %s as a boolean converter. These errors must be resolved before the DSL can proceed.", ElementUtils.getSimpleName(typeElement));
            return null;
        }
        List<ExecutableElement> specializations = this.findSpecializations(typeElement);
        assert (specializations.size() != 0);
        boolean returnsBoolean = true;
        for (ExecutableElement spec : specializations) {
            if (spec.getReturnType().getKind() == TypeKind.BOOLEAN) continue;
            returnsBoolean = false;
            break;
        }
        Signature sig = result.operation.instruction.signature;
        if (!returnsBoolean || sig.dynamicOperandCount != 1 || sig.isVariadic) {
            this.parent.addError(mirror, ElementUtils.getAnnotationValue(mirror, "booleanConverter"), "Specializations for boolean converter %s must only take one dynamic operand and return boolean.", ElementUtils.getSimpleName(typeElement));
            return null;
        }
        return result.operation.instruction;
    }

    private String getCustomOperationName(TypeElement typeElement, String explicitName) {
        if (explicitName != null && !explicitName.isEmpty()) {
            return explicitName;
        }
        String name = typeElement.getSimpleName().toString();
        if (this.isProxy() && name.endsWith("Node")) {
            name = name.substring(0, name.length() - 4);
        }
        return name;
    }

    private void validateCustomOperation(CustomOperationModel customOperation, TypeElement typeElement, AnnotationMirror mirror, String name) {
        boolean isNode;
        if (name.contains("_")) {
            customOperation.addError("Operation class name cannot contain underscores.", new Object[0]);
        }
        if (isNode = ElementUtils.isAssignable(typeElement.asType(), this.types.NodeInterface)) {
            AnnotationMirror generateCached;
            if (this.isProxy() && (generateCached = NodeParser.findGenerateAnnotation(typeElement.asType(), this.types.GenerateCached)) != null && !ElementUtils.getAnnotationValue(Boolean.class, generateCached, "value").booleanValue()) {
                customOperation.addError("Class %s does not generate a cached node, so it cannot be used as an OperationProxy. Enable cached node generation using @GenerateCached(true) or delegate to this node using a regular Operation.", typeElement.getQualifiedName());
                return;
            }
        } else {
            if (!typeElement.getModifiers().contains((Object)Modifier.FINAL)) {
                customOperation.addError("Operation class must be declared final. Inheritance in operation specifications is not supported.", new Object[0]);
            }
            if (typeElement.getEnclosingElement().getKind() != ElementKind.PACKAGE && !typeElement.getModifiers().contains((Object)Modifier.STATIC)) {
                customOperation.addError("Operation class must not be an inner class (non-static nested class). Declare the class as static.", new Object[0]);
            }
            if (typeElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
                customOperation.addError("Operation class must not be declared private. Remove the private modifier to make it visible.", new Object[0]);
            }
            if (!ElementUtils.isObject(typeElement.getSuperclass()) || !typeElement.getInterfaces().isEmpty()) {
                customOperation.addError("Operation class must not extend any classes or implement any interfaces. Inheritance in operation specifications is not supported.", new Object[0]);
            }
            for (Element element : typeElement.getEnclosedElements()) {
                if (element.getModifiers().contains((Object)Modifier.PRIVATE) || element.getModifiers().contains((Object)Modifier.STATIC) || element.getKind() == ElementKind.CONSTRUCTOR && ((ExecutableElement)element).getParameters().size() == 0 || element.getKind() == ElementKind.METHOD && this.isSpecialization((ExecutableElement)element)) continue;
                customOperation.addError(element, "Operation class must not contain non-static members.", new Object[0]);
            }
        }
        for (ExecutableElement executableElement : this.findSpecializations(typeElement)) {
            if (!executableElement.getModifiers().contains((Object)Modifier.STATIC)) {
                customOperation.addError(executableElement, "Operation specializations must be static. Rewrite this specialization as a static method to resolve this error. A static specialization cannot reference the \"this\" instance or any instance state; instead, use \"@%s Node\" to bind the receiver and define state using @%s parameters.", ElementUtils.getSimpleName(this.types.Bind), ElementUtils.getSimpleName(this.types.Cached));
            }
            if (executableElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
                customOperation.addError(executableElement, "Operation specialization cannot be private.", new Object[0]);
                continue;
            }
            if (this.forProxyValidation || ElementUtils.isVisible(this.parent.getTemplateType(), executableElement)) continue;
            this.parent.addError(mirror, null, "Operation %s's specialization \"%s\" must be visible from this node.", typeElement.getSimpleName(), executableElement.getSimpleName());
        }
    }

    private OperationModel.ConstantOperandsModel getConstantOperands(CustomOperationModel customOperation, TypeElement typeElement, AnnotationMirror mirror) {
        List<AnnotationMirror> constantOperands = ElementUtils.getRepeatedAnnotation(typeElement.getAnnotationMirrors(), this.types.ConstantOperand);
        if (constantOperands.isEmpty()) {
            return OperationModel.ConstantOperandsModel.NONE;
        }
        if (ElementUtils.typeEqualsAny((TypeMirror)mirror.getAnnotationType(), this.types.EpilogReturn, this.types.EpilogExceptional)) {
            customOperation.addError("An @%s operation cannot declare constant operands.", ElementUtils.getSimpleName(mirror.getAnnotationType()));
            return null;
        }
        ArrayList<ConstantOperandModel> before = new ArrayList<ConstantOperandModel>();
        ArrayList<ConstantOperandModel> after = new ArrayList<ConstantOperandModel>();
        for (AnnotationMirror constantOperandMirror : constantOperands) {
            TypeMirror type = this.parseConstantOperandType(constantOperandMirror);
            String operandName = ElementUtils.getAnnotationValue(String.class, constantOperandMirror, "name");
            String javadoc = ElementUtils.getAnnotationValue(String.class, constantOperandMirror, "javadoc");
            Boolean specifyAtEnd = ElementUtils.getAnnotationValue(Boolean.class, constantOperandMirror, "specifyAtEnd", false);
            int dimensions = ElementUtils.getAnnotationValue(Integer.class, constantOperandMirror, "dimensions");
            ConstantOperandModel constantOperand = new ConstantOperandModel(type, operandName, javadoc, specifyAtEnd, dimensions, constantOperandMirror);
            if (ElementUtils.isAssignable(type, this.types.Node) && !ElementUtils.isAssignable(type, this.types.RootNode)) {
                customOperation.addError(constantOperandMirror, ElementUtils.getAnnotationValue(constantOperandMirror, "type"), "Nodes cannot be used as constant operands.", new Object[0]);
            } else if (ElementUtils.typeEquals(type, this.types.MaterializedLocalAccessor) && !this.parent.enableMaterializedLocalAccesses) {
                customOperation.addError(constantOperandMirror, ElementUtils.getAnnotationValue(constantOperandMirror, "type"), "MaterializedLocalAccessor cannot be used because materialized local accesses are disabled. They can be enabled using the enableMaterializedLocalAccesses field of @GenerateBytecode.", new Object[0]);
            }
            if (!CustomOperationParser.isValidOperandName(operandName)) {
                customOperation.addError(constantOperandMirror, ElementUtils.getAnnotationValue(constantOperandMirror, "name"), "Invalid constant operand name \"%s\". Operand name must be a valid Java identifier.", operandName);
            }
            if (dimensions != 0) {
                customOperation.addError(constantOperandMirror, ElementUtils.getAnnotationValue(constantOperandMirror, "dimensions"), "Constant operands with non-zero dimensions are not supported.", new Object[0]);
            }
            if (specifyAtEnd == null || !specifyAtEnd.booleanValue()) {
                before.add(constantOperand);
                continue;
            }
            after.add(constantOperand);
        }
        return new OperationModel.ConstantOperandsModel(before, after);
    }

    private TypeMirror parseConstantOperandType(AnnotationMirror constantOperandMirror) {
        TypeMirror result = ElementUtils.getAnnotationValue(TypeMirror.class, constantOperandMirror, "type");
        return ElementUtils.rawTypeToWildcardedType(this.context, result);
    }

    private static boolean isValidOperandName(String name) {
        if (name.isEmpty()) {
            return true;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private CodeTypeElement createNodeForCustomInstruction(TypeElement typeElement) {
        CodeTypeElement nodeType;
        boolean isNode = ElementUtils.isAssignable(typeElement.asType(), this.types.NodeInterface);
        if (isNode) {
            nodeType = this.cloneTypeHierarchy(typeElement, ct -> {
                ct.getAnnotationMirrors().removeIf(m -> ElementUtils.typeEqualsAny((TypeMirror)m.getAnnotationType(), this.types.NodeChild, this.types.NodeChildren, this.types.GenerateUncached, this.types.GenerateCached, this.types.GenerateInline, this.types.GenerateNodeFactory));
                ct.getEnclosedElements().removeIf(e -> !e.getModifiers().contains((Object)Modifier.STATIC) || e.getModifiers().contains((Object)Modifier.PRIVATE));
            });
        } else {
            nodeType = CodeTypeElement.cloneShallow(typeElement);
            nodeType.setSuperClass(this.types.Node);
        }
        nodeType.getAnnotationMirrors().removeIf(m -> ElementUtils.typeEqualsAny((TypeMirror)m.getAnnotationType(), this.types.ExpectErrorTypes));
        return nodeType;
    }

    private void addCustomInstructionNodeMembers(CustomOperationModel customOperation, CodeTypeElement generatedNode, Signature signature) {
        if (this.shouldGenerateUncached(customOperation)) {
            generatedNode.addAnnotationMirror(new CodeAnnotationMirror(this.types.GenerateUncached));
        }
        generatedNode.addAll(this.createExecuteMethods(customOperation, signature));
        CodeAnnotationMirror nodeChildrenAnnotation = new CodeAnnotationMirror(this.types.NodeChildren);
        nodeChildrenAnnotation.setElementValue("value", (AnnotationValue)new CodeAnnotationValue(this.createNodeChildAnnotations(customOperation, signature).stream().map(CodeAnnotationValue::new).collect(Collectors.toList())));
        generatedNode.addAnnotationMirror(nodeChildrenAnnotation);
        if (this.parent.enableSpecializationIntrospection) {
            generatedNode.addAnnotationMirror(new CodeAnnotationMirror(this.types.Introspectable));
        }
    }

    private boolean isShortCircuit() {
        return ElementUtils.typeEquals(this.annotationType, this.context.getTypes().ShortCircuitOperation);
    }

    private boolean isProxy() {
        return ElementUtils.typeEquals(this.annotationType, this.context.getTypes().OperationProxy_Proxyable);
    }

    private boolean isOperation() {
        return ElementUtils.typeEquals(this.annotationType, this.context.getTypes().Operation);
    }

    private List<AnnotationMirror> createNodeChildAnnotations(CustomOperationModel customOperation, Signature signature) {
        int i;
        ArrayList<AnnotationMirror> result = new ArrayList<AnnotationMirror>();
        OperationModel operation = customOperation.operation;
        OperationModel.ConstantOperandsModel constantOperands = operation.constantOperands;
        for (i = 0; i < operation.numConstantOperandsBefore(); ++i) {
            result.add(this.createNodeChildAnnotation(operation.getConstantOperandBeforeName(i), constantOperands.before().get(i).type(), new TypeMirror[0]));
        }
        for (i = 0; i < signature.dynamicOperandCount; ++i) {
            result.add(this.createNodeChildAnnotation("child" + i, signature.getGenericType(i), new TypeMirror[0]));
        }
        for (i = 0; i < operation.numConstantOperandsAfter(); ++i) {
            result.add(this.createNodeChildAnnotation(operation.getConstantOperandAfterName(i), constantOperands.after().get(i).type(), new TypeMirror[0]));
        }
        return result;
    }

    private CodeAnnotationMirror createNodeChildAnnotation(String name, TypeMirror regularReturn, TypeMirror ... unexpectedReturns) {
        CodeAnnotationMirror mir = new CodeAnnotationMirror(this.types.NodeChild);
        mir.setElementValue("value", (AnnotationValue)new CodeAnnotationValue(name));
        mir.setElementValue("type", (AnnotationValue)new CodeAnnotationValue(this.createNodeChildType(regularReturn, unexpectedReturns).asType()));
        return mir;
    }

    private CodeTypeElement createNodeChildType(TypeMirror regularReturn, TypeMirror ... unexpectedReturns) {
        CodeTypeElement c = new CodeTypeElement(Set.of(Modifier.PUBLIC, Modifier.ABSTRACT), ElementKind.CLASS, new GeneratedPackageElement(""), "C");
        c.setSuperClass(this.types.Node);
        c.add(this.createNodeChildExecute("execute", regularReturn, false));
        for (TypeMirror ty : unexpectedReturns) {
            c.add(this.createNodeChildExecute("execute" + ElementUtils.firstLetterUpperCase(ElementUtils.getSimpleName(ty)), ty, true));
        }
        return c;
    }

    private CodeExecutableElement createNodeChildExecute(String name, TypeMirror returnType, boolean withUnexpected) {
        CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PUBLIC, Modifier.ABSTRACT), returnType, name, new CodeVariableElement[0]);
        ex.addParameter(new CodeVariableElement(this.types.VirtualFrame, "frame"));
        if (withUnexpected) {
            ex.addThrownType(this.types.UnexpectedResultException);
        }
        return ex;
    }

    private List<CodeExecutableElement> createExecuteMethods(CustomOperationModel customOperation, Signature signature) {
        ArrayList<CodeExecutableElement> result = new ArrayList<CodeExecutableElement>();
        result.add(this.createExecuteMethod(customOperation, signature, "executeObject", signature.returnType, false, false));
        if (this.parent.enableUncachedInterpreter) {
            result.add(this.createExecuteMethod(customOperation, signature, "executeUncached", signature.returnType, false, true));
        }
        return result;
    }

    private CodeExecutableElement createExecuteMethod(CustomOperationModel customOperation, Signature signature, String name, TypeMirror type, boolean withUnexpected, boolean uncached) {
        CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PUBLIC, Modifier.ABSTRACT), type, name, new CodeVariableElement[0]);
        if (withUnexpected) {
            ex.addThrownType(this.types.UnexpectedResultException);
        }
        ex.addParameter(new CodeVariableElement(this.types.VirtualFrame, "frame"));
        if (uncached) {
            int i;
            OperationModel operation = customOperation.operation;
            OperationModel.ConstantOperandsModel constantOperands = operation.constantOperands;
            for (i = 0; i < operation.numConstantOperandsBefore(); ++i) {
                ex.addParameter(new CodeVariableElement(constantOperands.before().get(i).type(), operation.getConstantOperandBeforeName(i)));
            }
            for (i = 0; i < signature.dynamicOperandCount; ++i) {
                ex.addParameter(new CodeVariableElement(signature.getGenericType(i), "child" + i + "Value"));
            }
            for (i = 0; i < operation.numConstantOperandsAfter(); ++i) {
                ex.addParameter(new CodeVariableElement(constantOperands.after().get(i).type(), operation.getConstantOperandAfterName(i)));
            }
        }
        return ex;
    }

    private InstructionModel createCustomInstruction(CustomOperationModel customOperation, CodeTypeElement generatedNode, Signature signature, String operationName) {
        int i;
        String instructionName = "c." + operationName;
        InstructionModel instr = customOperation.isEpilogExceptional() ? new InstructionModel(InstructionModel.InstructionKind.CUSTOM, instructionName, signature, null) : this.parent.instruction(InstructionModel.InstructionKind.CUSTOM, instructionName, signature);
        instr.nodeType = generatedNode;
        instr.nodeData = this.parseGeneratedNode(customOperation, generatedNode, signature);
        if (customOperation.operation.variadicReturn) {
            instr.nonNull = true;
        }
        OperationModel operation = customOperation.operation;
        for (i = 0; i < operation.numConstantOperandsBefore(); ++i) {
            instr.addImmediate(InstructionModel.ImmediateKind.CONSTANT, operation.getConstantOperandBeforeName(i));
        }
        for (i = 0; i < operation.numConstantOperandsAfter(); ++i) {
            instr.addImmediate(InstructionModel.ImmediateKind.CONSTANT, operation.getConstantOperandAfterName(i));
        }
        if (!instr.canUseNodeSingleton()) {
            instr.addImmediate(InstructionModel.ImmediateKind.NODE_PROFILE, "node");
        }
        return instr;
    }

    private NodeData parseGeneratedNode(CustomOperationModel customOperation, CodeTypeElement generatedNode, Signature signature) {
        NodeData result;
        if (this.forProxyValidation) {
            return null;
        }
        this.addCustomInstructionNodeMembers(customOperation, generatedNode, signature);
        try {
            NodeParser parser = NodeParser.createOperationParser(this.parent.getTemplateType());
            result = (NodeData)parser.parse((Element)generatedNode, false);
        }
        catch (Throwable ex) {
            StringWriter wr = new StringWriter();
            ex.printStackTrace(new PrintWriter(wr));
            customOperation.addError("Error generating instruction for Operation node %s: \n%s", this.parent.getName(), wr.toString());
            return null;
        }
        if (result == null) {
            customOperation.addError("Error generating instruction for Operation node %s. This is likely a bug in the Bytecode DSL.", this.parent.getName());
            return null;
        }
        if (result.getTypeSystem() == null) {
            customOperation.addError("Error parsing type system for operation. Fix problems in the referenced type system class first.", new Object[0]);
            return null;
        }
        this.checkUnnecessaryForceCached(customOperation, result);
        TypeSystemData parentTypeSystem = this.parent.typeSystem;
        if (parentTypeSystem != null && !parentTypeSystem.isDefault()) {
            if (result.getTypeSystem().isDefault()) {
                result.setTypeSystem(parentTypeSystem);
            } else if (this.isOperation() && ElementUtils.typeEquals(result.getTypeSystem().getTemplateType().asType(), this.parent.typeSystem.getTemplateType().asType())) {
                customOperation.addSuppressableWarning("truffle-unused", "Type system referenced by this operation is the same as the type system referenced by the parent bytecode root node. Remove the operation type system reference to resolve this warning.", new Object[0]);
            }
        }
        result.redirectMessagesOnGeneratedElements(this.parent);
        return result;
    }

    public static List<SpecializationSignatureParser.SpecializationSignature> parseSignatures(List<ExecutableElement> specializations, MessageContainer customOperation, OperationModel.ConstantOperandsModel constantOperands) {
        ArrayList<SpecializationSignatureParser.SpecializationSignature> signatures = new ArrayList<SpecializationSignatureParser.SpecializationSignature>(specializations.size());
        SpecializationSignatureParser parser = new SpecializationSignatureParser(ProcessorContext.getInstance());
        for (ExecutableElement specialization : specializations) {
            signatures.add(parser.parse(specialization, customOperation, constantOperands));
        }
        return signatures;
    }

    static TruffleTypes types() {
        return ProcessorContext.types();
    }

    private List<ExecutableElement> findSpecializations(TypeElement te) {
        if (ElementUtils.isObject(te.asType())) {
            return new ArrayList<ExecutableElement>();
        }
        List<ExecutableElement> result = this.findSpecializations(ElementUtils.getTypeElement((DeclaredType)te.getSuperclass()));
        for (ExecutableElement ex : ElementFilter.methodsIn(te.getEnclosedElements())) {
            if (!this.isSpecialization(ex)) continue;
            result.add(ex);
        }
        return result;
    }

    private boolean isSpecialization(ExecutableElement ex) {
        return ElementUtils.findAnnotationMirror((Element)ex, (TypeMirror)this.types.Specialization) != null || ElementUtils.findAnnotationMirror((Element)ex, (TypeMirror)this.types.Fallback) != null;
    }

    private boolean shouldGenerateUncached(CustomOperationModel customOperation) {
        if (this.forProxyValidation) {
            return this.uncachedProxyValidation;
        }
        return this.parent.enableUncachedInterpreter && !customOperation.forcesCached();
    }

    private void checkUnnecessaryForceCached(CustomOperationModel customOperation, NodeData result) {
        if (!this.parent.enableUncachedInterpreter || !customOperation.forcesCached()) {
            return;
        }
        if (!result.isUncachable()) {
            return;
        }
        if (this.isProxy() && !this.proxyableAllowsUncached(customOperation.getTemplateTypeAnnotation())) {
            return;
        }
        AnnotationMirror mirror = customOperation.getTemplateTypeAnnotation();
        AnnotationValue forceCached = ElementUtils.getAnnotationValue(mirror, "forceCached");
        customOperation.getModelForMessages().addSuppressableWarning("truffle-force-cached", mirror, forceCached, "This operation supports uncached execution, so forcing cached is not necessary. Remove the forceCached attribute to resolve this warning.", new Object[0]);
    }

    private boolean proxyableAllowsUncached(AnnotationMirror operationProxyMirror) {
        if (!ElementUtils.typeEquals(operationProxyMirror.getAnnotationType(), this.types.OperationProxy)) {
            throw new AssertionError();
        }
        AnnotationValue proxiedTypeValue = ElementUtils.getAnnotationValue(operationProxyMirror, "value");
        TypeMirror proxiedType = BytecodeDSLParser.getTypeMirror(this.context, proxiedTypeValue);
        TypeElement proxiedElement = (TypeElement)((DeclaredType)proxiedType).asElement();
        AnnotationMirror proxyableMirror = ElementUtils.findAnnotationMirror((Element)proxiedElement, (TypeMirror)this.types.OperationProxy_Proxyable);
        return ElementUtils.getAnnotationValue(Boolean.class, proxyableMirror, "allowUncached");
    }

    @Override
    public DeclaredType getAnnotationType() {
        return this.annotationType;
    }

    private CodeTypeElement cloneTypeHierarchy(TypeElement element, Consumer<CodeTypeElement> mapper) {
        CodeTypeElement result = CodeTypeElement.cloneShallow(element);
        if (!ElementUtils.isObject(element.getSuperclass())) {
            result.setSuperClass(this.cloneTypeHierarchy(this.context.getTypeElement((DeclaredType)element.getSuperclass()), mapper).asType());
        }
        mapper.accept(result);
        return result;
    }
}

