/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.dsl.processor.AbstractRegistrationProcessor;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import java.util.Collections;
import java.util.Set;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

@SupportedAnnotationTypes(value={"com.oracle.truffle.api.instrumentation.TruffleInstrument.Registration"})
public final class InstrumentRegistrationProcessor
extends AbstractRegistrationProcessor {
    private static final Set<String> IGNORED_ATTRIBUTES = Set.of("services");

    @Override
    boolean validateRegistration(Element annotatedElement, AnnotationMirror registrationMirror) {
        boolean processingTruffleInstrument;
        if (annotatedElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.emitError("Registered instrument class must be at least package protected.", annotatedElement);
            return false;
        }
        if (annotatedElement.getEnclosingElement().getKind() != ElementKind.PACKAGE && !annotatedElement.getModifiers().contains((Object)Modifier.STATIC)) {
            this.emitError("Registered instrument inner-class must be static.", annotatedElement);
            return false;
        }
        ProcessorContext context = ProcessorContext.getInstance();
        TruffleTypes types = context.getTypes();
        DeclaredType truffleInstrument = types.TruffleInstrument;
        DeclaredType truffleInstrumentProvider = types.TruffleInstrumentProvider;
        if (this.processingEnv.getTypeUtils().isAssignable(annotatedElement.asType(), truffleInstrument)) {
            processingTruffleInstrument = true;
        } else if (this.processingEnv.getTypeUtils().isAssignable(annotatedElement.asType(), truffleInstrumentProvider)) {
            processingTruffleInstrument = false;
        } else {
            this.emitError("Registered instrument class must subclass TruffleInstrument.", annotatedElement);
            return false;
        }
        if (!this.validateInternalResources(annotatedElement, registrationMirror, context)) {
            return false;
        }
        InstrumentRegistrationProcessor.assertNoErrorExpected(annotatedElement);
        return processingTruffleInstrument;
    }

    @Override
    DeclaredType getProviderClass() {
        TruffleTypes types = ProcessorContext.getInstance().getTypes();
        return types.TruffleInstrumentProvider;
    }

    @Override
    Iterable<AnnotationMirror> getProviderAnnotations(TypeElement annotatedElement) {
        TruffleTypes types = ProcessorContext.getInstance().getTypes();
        DeclaredType registrationType = types.TruffleInstrument_Registration;
        CodeAnnotationMirror registration = InstrumentRegistrationProcessor.copyAnnotations(ElementUtils.findAnnotationMirror(annotatedElement.getAnnotationMirrors(), (TypeMirror)registrationType), t -> !IGNORED_ATTRIBUTES.contains(t.getSimpleName().toString()));
        return Collections.singleton(registration);
    }

    @Override
    void implementMethod(TypeElement annotatedElement, CodeExecutableElement methodToImplement) {
        CodeTreeBuilder builder = methodToImplement.createBuilder();
        ProcessorContext context = ProcessorContext.getInstance();
        TruffleTypes types = context.getTypes();
        switch (methodToImplement.getSimpleName().toString()) {
            case "create": {
                builder.startReturn().startNew(annotatedElement.asType()).end().end();
                break;
            }
            case "getInstrumentClassName": {
                Elements elements = context.getEnvironment().getElementUtils();
                builder.startReturn().doubleQuote(elements.getBinaryName(annotatedElement).toString()).end();
                break;
            }
            case "getServicesClassNames": {
                AnnotationMirror registration = ElementUtils.findAnnotationMirror(annotatedElement.getAnnotationMirrors(), (TypeMirror)types.TruffleInstrument_Registration);
                InstrumentRegistrationProcessor.generateGetServicesClassNames(registration, builder, context);
                break;
            }
            case "getInternalResourceIds": {
                AnnotationMirror registration = ElementUtils.findAnnotationMirror(annotatedElement.getAnnotationMirrors(), (TypeMirror)types.TruffleInstrument_Registration);
                InstrumentRegistrationProcessor.generateGetInternalResourceIds(registration, builder, context);
                break;
            }
            case "createInternalResource": {
                AnnotationMirror registration = ElementUtils.findAnnotationMirror(annotatedElement.getAnnotationMirrors(), (TypeMirror)types.TruffleInstrument_Registration);
                InstrumentRegistrationProcessor.generateCreateInternalResource(registration, methodToImplement.getParameters().get(0), builder, context);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported method: " + String.valueOf(methodToImplement.getSimpleName()));
            }
        }
    }
}

