/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.bytecode.generator;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

interface ElementHelpers {
    public static TypeMirror type(Class<?> t) {
        return ProcessorContext.getInstance().getType(t);
    }

    public static TypeElement element(Class<?> t) {
        TypeElement type = ElementUtils.castTypeElement(ProcessorContext.getInstance().getDeclaredType(t));
        if (type == null) {
            throw new NullPointerException("Cannot cast to type element " + String.valueOf(t));
        }
        return type;
    }

    public static ArrayType arrayOf(TypeMirror t) {
        return new CodeTypeMirror.ArrayCodeTypeMirror(t);
    }

    public static TypeElement element(TypeMirror t) {
        TypeElement type = ElementUtils.castTypeElement(t);
        if (type == null) {
            throw new NullPointerException("Cannot cast to type element " + String.valueOf(t));
        }
        return type;
    }

    public static TypeMirror[] types(Class<?> ... types) {
        TypeMirror[] array = new TypeMirror[types.length];
        for (int i = 0; i < types.length; ++i) {
            array[i] = ElementHelpers.type(types[i]);
        }
        return array;
    }

    public static TypeMirror wildcard(TypeMirror extendsBounds, TypeMirror superbounds) {
        return new CodeTypeMirror.WildcardTypeMirror(extendsBounds, superbounds);
    }

    public static DeclaredType generic(TypeMirror type, TypeMirror genericType1) {
        return new CodeTypeMirror.DeclaredCodeTypeMirror(ElementHelpers.element(type), List.of(genericType1));
    }

    public static DeclaredType generic(TypeMirror type, TypeMirror ... genericTypes) {
        return new CodeTypeMirror.DeclaredCodeTypeMirror(ElementHelpers.element(type), List.of(genericTypes));
    }

    public static DeclaredType generic(Class<?> type, TypeMirror genericType1) {
        return new CodeTypeMirror.DeclaredCodeTypeMirror(ElementHelpers.element(type), List.of(genericType1));
    }

    public static DeclaredType generic(Class<?> type, TypeMirror ... genericType1) {
        return new CodeTypeMirror.DeclaredCodeTypeMirror(ElementHelpers.element(type), List.of(genericType1));
    }

    public static DeclaredType generic(Class<?> type, Class<?> ... genericTypes) {
        return new CodeTypeMirror.DeclaredCodeTypeMirror(ElementHelpers.element(type), List.of(ElementHelpers.types(genericTypes)));
    }

    public static CodeVariableElement addField(CodeElement<? super Element> e, Set<Modifier> modifiers, TypeMirror type, String name) {
        CodeVariableElement var = new CodeVariableElement(modifiers, type, name);
        e.getEnclosedElements().add(var);
        return var;
    }

    public static CodeVariableElement addField(CodeElement<? super Element> e, Set<Modifier> modifiers, Class<?> type, String name) {
        return ElementHelpers.addField(e, modifiers, ElementHelpers.type(type), name);
    }

    public static CodeVariableElement addField(CodeElement<? super Element> e, Set<Modifier> modifiers, Class<?> type, String name, String initString) {
        CodeVariableElement var = ElementHelpers.createInitializedVariable(modifiers, type, name, initString);
        e.add(var);
        return var;
    }

    public static CodeVariableElement createInitializedVariable(Set<Modifier> modifiers, Class<?> type, String name, String initString) {
        CodeTree init = CodeTreeBuilder.singleString(initString);
        CodeVariableElement var = new CodeVariableElement(modifiers, ProcessorContext.getInstance().getType(type), name);
        var.createInitBuilder().tree(init);
        return var;
    }
}

