/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.generator;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.generator.FlatNodeGenFactory;
import com.oracle.truffle.dsl.processor.generator.GeneratorUtils;
import com.oracle.truffle.dsl.processor.generator.NodeCodeGenerator;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationValue;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeNames;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import com.oracle.truffle.dsl.processor.model.InlineFieldData;
import com.oracle.truffle.dsl.processor.model.NodeData;
import com.oracle.truffle.dsl.processor.model.NodeExecutionData;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class NodeFactoryFactory {
    private final ProcessorContext context;
    private final NodeData node;
    private final CodeTypeElement createdFactoryElement;
    private final TruffleTypes types;

    NodeFactoryFactory(ProcessorContext context, NodeData node, CodeTypeElement createdClass) {
        this.context = context;
        this.node = node;
        this.createdFactoryElement = createdClass;
        this.types = context.getTypes();
    }

    public static String factoryClassName(Element type) {
        return type.getSimpleName().toString() + "Factory";
    }

    public CodeTypeElement create() {
        Modifier visibility = this.node.getVisibility();
        DeclaredType nodeFactory = ElementUtils.getDeclaredType(ElementUtils.fromTypeMirror(this.context.getTypes().NodeFactory), this.node.getNodeType());
        CodeTypeElement clazz = GeneratorUtils.createClass(this.node, null, ElementUtils.modifiers(new Modifier[0]), NodeFactoryFactory.factoryClassName(this.node.getTemplateType()), null);
        if (visibility != null) {
            clazz.getModifiers().add(visibility);
        }
        clazz.getModifiers().add(Modifier.FINAL);
        if (this.createdFactoryElement != null) {
            clazz.getImplements().add(nodeFactory);
            clazz.add(this.createNodeFactoryConstructor());
            clazz.add(this.createCreateGetNodeClass());
            clazz.add(this.createCreateGetExecutionSignature());
            clazz.add(this.createCreateGetNodeSignatures());
            if (this.node.isGenerateCached()) {
                clazz.add(this.createCreateNodeMethod());
            }
            if (this.node.isGenerateUncached()) {
                clazz.addOptional(this.createGetUncached());
            }
            clazz.add(this.createGetInstanceMethod(visibility));
            clazz.add(this.createInstanceConstant(clazz.asType()));
            List<ExecutableElement> constructors = GeneratorUtils.findUserConstructors(this.createdFactoryElement.asType());
            List<CodeExecutableElement> factoryMethods = NodeFactoryFactory.createFactoryMethods(this.node, constructors);
            for (CodeExecutableElement method : factoryMethods) {
                clazz.add(method);
            }
        }
        return clazz;
    }

    private Element createNodeFactoryConstructor() {
        CodeExecutableElement method = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PRIVATE), null, NodeFactoryFactory.factoryClassName(this.node.getTemplateType()), new CodeVariableElement[0]);
        return method;
    }

    private CodeExecutableElement createCreateGetNodeClass() {
        DeclaredType returnValue = ElementUtils.getDeclaredType(ElementUtils.fromTypeMirror(this.context.getType(Class.class)), this.node.getNodeType());
        CodeExecutableElement method = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC), returnValue, "getNodeClass", new CodeVariableElement[0]);
        method.createBuilder().startReturn().typeLiteral(this.node.getNodeType()).end();
        return method;
    }

    private CodeExecutableElement createCreateGetNodeSignatures() {
        TypeMirror returnType = ElementUtils.findMethod(this.types.NodeFactory, "getNodeSignatures").getReturnType();
        CodeExecutableElement method = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC), returnType, "getNodeSignatures", new CodeVariableElement[0]);
        CodeTreeBuilder builder = method.createBuilder();
        builder.startReturn();
        builder.startGroup();
        builder.startStaticCall(this.context.getType(List.class), "of");
        List<ExecutableElement> constructors = GeneratorUtils.findUserConstructors(this.createdFactoryElement.asType());
        for (ExecutableElement constructor : constructors) {
            builder.startGroup();
            builder.startStaticCall(this.context.getType(List.class), "of");
            for (VariableElement variableElement : constructor.getParameters()) {
                builder.typeLiteral(variableElement.asType());
            }
            builder.end();
            builder.end();
        }
        builder.end();
        builder.end();
        builder.end();
        return method;
    }

    private CodeExecutableElement createCreateGetExecutionSignature() {
        ExecutableElement overriddenMethod = ElementUtils.findMethod(this.types.NodeFactory, "getExecutionSignature");
        CodeExecutableElement method = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC), overriddenMethod.getReturnType(), "getExecutionSignature", new CodeVariableElement[0]);
        CodeTreeBuilder builder = method.createBuilder();
        builder.startReturn();
        builder.startStaticCall(this.context.getType(List.class), "of");
        for (NodeExecutionData execution : this.node.getChildExecutions()) {
            TypeMirror nodeType = execution.getNodeType();
            if (nodeType != null) {
                builder.typeLiteral(nodeType);
                continue;
            }
            builder.typeLiteral(this.types.Node);
        }
        builder.end();
        builder.end();
        return method;
    }

    private CodeExecutableElement createGetUncached() {
        if (!this.node.isGenerateUncached()) {
            return null;
        }
        CodeExecutableElement method = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC), this.node.getNodeType(), "getUncachedInstance", new CodeVariableElement[0]);
        String className = this.createdFactoryElement.getSimpleName().toString();
        CodeTreeBuilder builder = method.createBuilder();
        builder.startReturn();
        if (this.node.isGenerateFactory()) {
            builder.string(className).string(".").string("UNCACHED");
        } else {
            builder.string("UNCACHED");
        }
        builder.end();
        return method;
    }

    private CodeExecutableElement createCreateNodeMethod() {
        CodeExecutableElement method = GeneratorUtils.override(this.types.NodeFactory, "createNode", new String[]{"arguments"});
        method.setReturnType(this.node.getNodeType());
        method.getModifiers().remove((Object)Modifier.ABSTRACT);
        CodeTreeBuilder builder = method.createBuilder();
        List<ExecutableElement> signatures = GeneratorUtils.findUserConstructors(this.createdFactoryElement.asType());
        boolean ifStarted = false;
        for (ExecutableElement element : signatures) {
            ifStarted = builder.startIf(ifStarted);
            builder.string("arguments.length == " + element.getParameters().size());
            int index = 0;
            for (VariableElement variableElement : element.getParameters()) {
                if (ElementUtils.isObject(variableElement.asType())) {
                    ++index;
                    continue;
                }
                builder.string(" && ");
                if (!variableElement.asType().getKind().isPrimitive()) {
                    builder.string("(arguments[" + index + "] == null || ");
                }
                builder.string("arguments[" + index + "] instanceof ");
                builder.type(ElementUtils.eraseGenericTypes(ElementUtils.boxType(this.context, variableElement.asType())));
                if (!variableElement.asType().getKind().isPrimitive()) {
                    builder.string(")");
                }
                ++index;
            }
            builder.end();
            builder.startBlock();
            builder.startReturn().startCall("create");
            index = 0;
            for (VariableElement variableElement : element.getParameters()) {
                builder.startGroup();
                if (!ElementUtils.isObject(variableElement.asType())) {
                    builder.string("(").type(variableElement.asType()).string(") ");
                    if (ElementUtils.hasGenericTypes(variableElement.asType())) {
                        GeneratorUtils.mergeSuppressWarnings(method, "unchecked");
                    }
                }
                builder.string("arguments[").string(String.valueOf(index)).string("]");
                builder.end();
                ++index;
            }
            builder.end().end();
            builder.end();
        }
        builder.startElseBlock();
        builder.startThrow().startNew(this.context.getType(IllegalArgumentException.class));
        builder.doubleQuote("Invalid create signature.");
        builder.end().end();
        builder.end();
        return method;
    }

    private ExecutableElement createGetInstanceMethod(Modifier visibility) {
        TypeElement nodeFactoryType = ElementUtils.fromTypeMirror(this.types.NodeFactory);
        DeclaredType returnType = ElementUtils.getDeclaredType(nodeFactoryType, this.node.getNodeType());
        CodeExecutableElement method = new CodeExecutableElement(ElementUtils.modifiers(new Modifier[0]), returnType, "getInstance", new CodeVariableElement[0]);
        if (visibility != null) {
            method.getModifiers().add(visibility);
        }
        method.getModifiers().add(Modifier.STATIC);
        method.createBuilder().startReturn().string(NodeFactoryFactory.instanceVarName(this.node)).end();
        return method;
    }

    private static String instanceVarName(NodeData node) {
        if (node.getDeclaringNode() != null) {
            return ElementUtils.createConstantName(NodeFactoryFactory.factoryClassName(node.getTemplateType())) + "_INSTANCE";
        }
        return "INSTANCE";
    }

    private CodeVariableElement createInstanceConstant(TypeMirror factoryType) {
        String varName = NodeFactoryFactory.instanceVarName(this.node);
        CodeVariableElement var = new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), factoryType, varName);
        var.createInitBuilder().startNew(NodeFactoryFactory.factoryClassName(this.node.getTemplateType())).end();
        return var;
    }

    public static List<CodeExecutableElement> createFactoryMethods(NodeData node, List<ExecutableElement> constructors) {
        ArrayList<CodeExecutableElement> methods = new ArrayList<CodeExecutableElement>();
        for (ExecutableElement constructor : constructors) {
            if (node.isGenerateCached()) {
                methods.add(NodeFactoryFactory.createCreateMethod(node, constructor));
            }
            if (constructor instanceof CodeExecutableElement) {
                ElementUtils.setVisibility(constructor.getModifiers(), Modifier.PRIVATE);
            }
            if (node.isGenerateUncached()) {
                methods.add(NodeFactoryFactory.createGetUncached(node, constructor));
            }
            if (!node.isGenerateInline() || node.hasErrors() && ElementUtils.findStaticMethod(node.getTemplateType(), "inline") != null) continue;
            methods.add(NodeFactoryFactory.createInlineMethod(node, constructor));
        }
        return methods;
    }

    public static CodeExecutableElement createInlineMethod(NodeData node, ExecutableElement constructorPrototype) {
        CodeExecutableElement method;
        if (constructorPrototype == null) {
            method = new CodeExecutableElement(node.getNodeType(), "inline");
        } else {
            method = CodeExecutableElement.clone(constructorPrototype);
            method.setSimpleName(CodeNames.of("inline"));
            method.getModifiers().clear();
            method.setReturnType(node.getNodeType());
        }
        method.getModifiers().add(Modifier.PUBLIC);
        method.getModifiers().add(Modifier.STATIC);
        method.getAnnotationMirrors().add(new CodeAnnotationMirror(ProcessorContext.getInstance().getTypes().NeverDefault));
        CodeTreeBuilder body = method.createBuilder();
        TypeMirror nodeType = NodeCodeGenerator.nodeType(node);
        body.startReturn();
        if (node.hasErrors()) {
            body.startNew(nodeType);
            for (VariableElement var : method.getParameters()) {
                body.defaultValue(var.asType());
            }
            body.end();
        } else {
            body.startNew(ElementUtils.getSimpleName(nodeType) + ".Inlined");
            TruffleTypes types = ProcessorContext.getInstance().getTypes();
            CodeVariableElement inlineTarget = new CodeVariableElement(types.InlineSupport_InlineTarget, "target");
            body.string(inlineTarget.getName());
            method.addParameter(inlineTarget);
            ArrayList<CodeAnnotationValue> requiredFields = new ArrayList<CodeAnnotationValue>();
            ExecutableElement value = ElementUtils.findMethod(types.InlineSupport_RequiredField, "value");
            ExecutableElement bits = ElementUtils.findMethod(types.InlineSupport_RequiredField, "bits");
            ExecutableElement type = ElementUtils.findMethod(types.InlineSupport_RequiredField, "type");
            ExecutableElement dimensions = ElementUtils.findMethod(types.InlineSupport_RequiredField, "dimensions");
            CodeTreeBuilder docBuilder = method.createDocBuilder();
            docBuilder.startJavadoc();
            docBuilder.string("Required Fields: ");
            docBuilder.string("<ul>");
            docBuilder.newLine();
            for (InlineFieldData field : FlatNodeGenFactory.createInlinedFields(node)) {
                CodeAnnotationMirror requiredField = new CodeAnnotationMirror(types.InlineSupport_RequiredField);
                requiredField.setElementValue(value, (AnnotationValue)new CodeAnnotationValue(field.getFieldType()));
                if (field.hasBits()) {
                    requiredField.setElementValue(bits, (AnnotationValue)new CodeAnnotationValue(field.getBits()));
                }
                if (!field.isPrimitive() && field.getType() != null) {
                    requiredField.setElementValue(type, (AnnotationValue)new CodeAnnotationValue(field.getType()));
                }
                if (field.getDimensions() != 0) {
                    requiredField.setElementValue(dimensions, (AnnotationValue)new CodeAnnotationValue(field.getDimensions()));
                }
                Element sourceElement = field.getSourceElement();
                docBuilder.string("<li>");
                if (sourceElement != null) {
                    if (sourceElement.getEnclosingElement() == null) {
                        docBuilder.string("{@link ");
                        docBuilder.string("Inlined#");
                        docBuilder.string(sourceElement.getSimpleName().toString());
                        docBuilder.string("}");
                    } else {
                        docBuilder.javadocLink(sourceElement, null);
                    }
                } else {
                    docBuilder.string("Unknown source");
                }
                docBuilder.newLine();
                requiredFields.add(new CodeAnnotationValue(requiredField));
            }
            docBuilder.string("</ul>");
            docBuilder.end();
            ExecutableElement fieldsValue = ElementUtils.findMethod(types.InlineSupport_RequiredFields, "value");
            CodeAnnotationMirror requiredFieldsMirror = new CodeAnnotationMirror(types.InlineSupport_RequiredFields);
            requiredFieldsMirror.setElementValue(fieldsValue, (AnnotationValue)new CodeAnnotationValue(requiredFields));
            inlineTarget.getAnnotationMirrors().add(requiredFieldsMirror);
            body.end();
        }
        body.end();
        return method;
    }

    private static CodeExecutableElement createGetUncached(NodeData node, ExecutableElement constructor) {
        CodeExecutableElement method = CodeExecutableElement.clone(constructor);
        method.setSimpleName(CodeNames.of("getUncached"));
        method.getModifiers().clear();
        method.getModifiers().add(Modifier.PUBLIC);
        method.getModifiers().add(Modifier.STATIC);
        method.setReturnType(node.getNodeType());
        method.getAnnotationMirrors().add(new CodeAnnotationMirror(ProcessorContext.getInstance().getTypes().NeverDefault));
        CodeTreeBuilder body = method.createBuilder();
        body.startReturn();
        TypeMirror type = NodeCodeGenerator.nodeType(node);
        if (node.hasErrors()) {
            body.startNew(type);
            for (VariableElement var : method.getParameters()) {
                body.defaultValue(var.asType());
            }
            body.end();
        } else {
            TypeElement typeElement = ElementUtils.castTypeElement(type);
            body.string(typeElement.getSimpleName().toString(), ".UNCACHED");
        }
        body.end();
        method.getParameters().clear();
        return method;
    }

    private static CodeExecutableElement createCreateMethod(NodeData node, ExecutableElement constructor) {
        CodeExecutableElement method = CodeExecutableElement.clone(constructor);
        method.setSimpleName(CodeNames.of("create"));
        method.getModifiers().clear();
        method.getModifiers().add(Modifier.PUBLIC);
        method.getModifiers().add(Modifier.STATIC);
        method.setReturnType(node.getNodeType());
        method.getAnnotationMirrors().add(new CodeAnnotationMirror(ProcessorContext.getInstance().getTypes().NeverDefault));
        CodeTreeBuilder body = method.createBuilder();
        body.startReturn();
        if (node.getSpecializations().isEmpty()) {
            body.nullLiteral();
        } else {
            body.startNew(NodeCodeGenerator.nodeType(node));
            for (VariableElement var : method.getParameters()) {
                body.string(var.getSimpleName().toString());
            }
            body.end();
        }
        body.end();
        return method;
    }
}

