/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.bytecode.model;

import com.oracle.truffle.dsl.processor.bytecode.model.BytecodeDSLModel;
import com.oracle.truffle.dsl.processor.bytecode.model.ConstantOperandModel;
import com.oracle.truffle.dsl.processor.bytecode.model.CustomOperationModel;
import com.oracle.truffle.dsl.processor.bytecode.model.DynamicOperandModel;
import com.oracle.truffle.dsl.processor.bytecode.model.InstructionModel;
import com.oracle.truffle.dsl.processor.bytecode.model.PrettyPrintable;
import com.oracle.truffle.dsl.processor.bytecode.parser.CustomOperationParser;
import com.oracle.truffle.dsl.processor.bytecode.parser.SpecializationSignatureParser;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import com.oracle.truffle.dsl.processor.model.SpecializationData;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

public class OperationModel
implements PrettyPrintable {
    private static final OperationArgument[] EMPTY_ARGUMENTS = new OperationArgument[0];
    public final BytecodeDSLModel parent;
    public final int id;
    public final OperationKind kind;
    public final String name;
    public final String javadoc;
    public boolean isTransparent;
    public boolean isVoid;
    public boolean isVariadic;
    public boolean isInternal;
    public InstructionModel instruction;
    public CustomOperationModel customModel;
    public ConstantOperandsModel constantOperands = null;
    public DynamicOperandModel[] dynamicOperands = new DynamicOperandModel[0];
    public List<String> constantOperandBeforeNames;
    public List<String> constantOperandAfterNames;
    public OperationArgument[] operationBeginArguments = EMPTY_ARGUMENTS;
    public OperationArgument[] operationEndArguments = EMPTY_ARGUMENTS;
    public boolean operationBeginArgumentVarArgs = false;
    public int instrumentationIndex;

    public OperationModel(BytecodeDSLModel parent, int id, OperationKind kind, String name, String javadoc) {
        this.parent = parent;
        this.id = id;
        this.kind = kind;
        this.name = name;
        this.javadoc = javadoc;
    }

    public int numConstantOperandsBefore() {
        if (this.constantOperands == null) {
            return 0;
        }
        return this.constantOperands.before.size();
    }

    public int numDynamicOperands() {
        return this.dynamicOperands.length;
    }

    public int numConstantOperandsAfter() {
        if (this.constantOperands == null) {
            return 0;
        }
        return this.constantOperands.after.size();
    }

    public boolean hasChildren() {
        return this.isVariadic || this.numDynamicOperands() > 0;
    }

    public void setInstrumentationIndex(int instrumentationIndex) {
        this.instrumentationIndex = instrumentationIndex;
    }

    public SpecializationSignatureParser.SpecializationSignature getSpecializationSignature(SpecializationData specialization) {
        return this.getSpecializationSignature(List.of(specialization));
    }

    public SpecializationSignatureParser.SpecializationSignature getSpecializationSignature(List<SpecializationData> specializations) {
        List<ExecutableElement> methods = specializations.stream().map(s -> s.getMethod()).toList();
        SpecializationSignatureParser.SpecializationSignature includedSpecializationSignatures = CustomOperationParser.parseSignatures(methods, specializations.get(0).getNode(), this.constantOperands).get(0);
        return includedSpecializationSignatures;
    }

    public OperationModel setTransparent(boolean isTransparent) {
        this.isTransparent = isTransparent;
        return this;
    }

    public OperationModel setVariadic(boolean isVariadic) {
        this.isVariadic = isVariadic;
        return this;
    }

    public boolean isTransparent() {
        return this.isTransparent;
    }

    public OperationModel setVoid(boolean isVoid) {
        this.isVoid = isVoid;
        return this;
    }

    public String getConstantOperandBeforeName(int i) {
        return this.constantOperandBeforeNames.get(i);
    }

    public String getConstantOperandAfterName(int i) {
        return this.constantOperandAfterNames.get(i);
    }

    public OperationModel setDynamicOperands(DynamicOperandModel ... dynamicOperands) {
        this.dynamicOperands = dynamicOperands;
        return this;
    }

    public OperationModel setInstruction(InstructionModel instruction) {
        this.instruction = instruction;
        if (instruction.operation != null) {
            throw new AssertionError((Object)"operation already set");
        }
        instruction.operation = this;
        return this;
    }

    public OperationModel setOperationBeginArgumentVarArgs(boolean varArgs) {
        this.operationBeginArgumentVarArgs = varArgs;
        return this;
    }

    public OperationModel setOperationBeginArguments(OperationArgument ... operationBeginArguments) {
        if (this.operationBeginArguments != null) assert (this.operationBeginArguments.length == operationBeginArguments.length);
        this.operationBeginArguments = operationBeginArguments;
        return this;
    }

    public OperationModel setOperationEndArguments(OperationArgument ... operationEndArguments) {
        if (this.operationEndArguments != null) assert (this.operationEndArguments.length == operationEndArguments.length);
        this.operationEndArguments = operationEndArguments;
        return this;
    }

    public String getOperationBeginArgumentName(int i) {
        return this.operationBeginArguments[i].name;
    }

    public String getOperationEndArgumentName(int i) {
        return this.operationEndArguments[i].name;
    }

    public OperationModel setInternal() {
        this.isInternal = true;
        return this;
    }

    @Override
    public void pp(PrettyPrintable.PrettyPrinter printer) {
        printer.print("Operation %s", this.name);
        printer.field("kind", (Object)this.kind);
    }

    public boolean isSourceOnly() {
        return this.kind == OperationKind.SOURCE || this.kind == OperationKind.SOURCE_SECTION;
    }

    public boolean isCustom() {
        return this.kind == OperationKind.CUSTOM || this.kind == OperationKind.CUSTOM_SHORT_CIRCUIT || this.kind == OperationKind.CUSTOM_INSTRUMENTATION;
    }

    public boolean requiresRootOperation() {
        return this.kind != OperationKind.SOURCE && this.kind != OperationKind.SOURCE_SECTION;
    }

    public boolean requiresStackBalancing() {
        return this.kind != OperationKind.TAG;
    }

    public String getConstantName() {
        return this.name.toUpperCase();
    }

    public record ConstantOperandsModel(List<ConstantOperandModel> before, List<ConstantOperandModel> after) {
        public static final ConstantOperandsModel NONE = new ConstantOperandsModel(List.of(), List.of());

        public boolean hasConstantOperands() {
            return this != NONE;
        }
    }

    public record OperationArgument(TypeMirror builderType, TypeMirror constantType, Encoding kind, String name, String doc) {
        OperationArgument(TypeMirror builderType, Encoding kind, String name, String doc) {
            this(builderType, builderType, kind, name, doc);
        }

        public CodeVariableElement toVariableElement() {
            return new CodeVariableElement(this.builderType, this.name);
        }

        public String toJavadocParam() {
            String docPart = this.doc.isEmpty() ? "" : String.format(" %s.", this.doc);
            return String.format("@param %s%s", this.name, docPart);
        }

        public static enum Encoding {
            LANGUAGE,
            SHORT,
            INTEGER,
            OBJECT,
            LOCAL,
            LOCAL_ARRAY,
            TAGS,
            LABEL,
            FINALLY_GENERATOR;

        }
    }

    public static enum OperationKind {
        ROOT,
        BLOCK,
        IF_THEN,
        IF_THEN_ELSE,
        CONDITIONAL,
        WHILE,
        TRY_CATCH,
        TRY_FINALLY,
        TRY_CATCH_OTHERWISE,
        FINALLY_HANDLER,
        SOURCE,
        SOURCE_SECTION,
        TAG,
        LABEL,
        BRANCH,
        RETURN,
        YIELD,
        LOAD_CONSTANT,
        LOAD_NULL,
        LOAD_ARGUMENT,
        LOAD_EXCEPTION,
        LOAD_LOCAL,
        LOAD_LOCAL_MATERIALIZED,
        STORE_LOCAL,
        STORE_LOCAL_MATERIALIZED,
        CUSTOM,
        CUSTOM_SHORT_CIRCUIT,
        CUSTOM_INSTRUMENTATION;

    }
}

