/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.bytecode.generator;

import com.oracle.truffle.dsl.processor.AnnotationProcessor;
import com.oracle.truffle.dsl.processor.ExpectError;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.bytecode.generator.BytecodeRootNodeElement;
import com.oracle.truffle.dsl.processor.bytecode.generator.BytecodeRootNodeErrorElement;
import com.oracle.truffle.dsl.processor.bytecode.generator.ElementHelpers;
import com.oracle.truffle.dsl.processor.bytecode.model.BytecodeDSLModel;
import com.oracle.truffle.dsl.processor.bytecode.model.BytecodeDSLModels;
import com.oracle.truffle.dsl.processor.generator.CodeTypeElementFactory;
import com.oracle.truffle.dsl.processor.generator.GeneratorUtils;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeNames;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeParameterElement;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import java.io.DataInput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class BytecodeDSLCodeGenerator
extends CodeTypeElementFactory<BytecodeDSLModels> {
    @Override
    public List<CodeTypeElement> create(ProcessorContext context, AnnotationProcessor<?> processor, BytecodeDSLModels modelList) {
        ArrayList<CodeTypeElement> results = new ArrayList<CodeTypeElement>();
        if (this.hasExpectErrors(modelList.getTemplateType())) {
            return results;
        }
        for (BytecodeDSLModel bytecodeDSLModel : modelList.getModels()) {
            if (modelList.hasErrors()) {
                results.add(new BytecodeRootNodeErrorElement(bytecodeDSLModel));
                continue;
            }
            results.add(new BytecodeRootNodeElement(bytecodeDSLModel));
        }
        if (results.size() == 1) {
            return results;
        }
        CodeTypeElement abstractBuilderType = (CodeTypeElement)ElementUtils.castTypeElement(modelList.getModels().getFirst().abstractBuilderType);
        for (BytecodeDSLModel model : modelList.getModels()) {
            if (abstractBuilderType != ElementUtils.castTypeElement(model.abstractBuilderType)) {
                throw new AssertionError((Object)"Invalid builder type.");
            }
        }
        Iterator iterator = results.stream().map(result -> (CodeTypeElement)ElementUtils.findTypeElement(result, "Builder")).iterator();
        CodeTypeElement firstBuilder = (CodeTypeElement)iterator.next();
        HashSet<String> expectedPublicMethodNames = new HashSet<String>();
        for (ExecutableElement method : ElementFilter.methodsIn(firstBuilder.getEnclosedElements())) {
            if (!method.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            HashSet<Modifier> modifiers = new HashSet<Modifier>(method.getModifiers());
            modifiers.add(Modifier.ABSTRACT);
            CodeExecutableElement abstractMethod = new CodeExecutableElement((Set<Modifier>)modifiers, method.getReturnType(), method.getSimpleName().toString(), new CodeVariableElement[0]);
            method.getParameters().forEach(param -> abstractMethod.addParameter((VariableElement)param));
            abstractMethod.setVarArgs(method.isVarArgs());
            abstractBuilderType.add(abstractMethod);
            expectedPublicMethodNames.add(method.getSimpleName().toString());
        }
        while (iterator.hasNext()) {
            TypeElement builder = (TypeElement)iterator.next();
            HashSet<String> publicMethodNames = new HashSet<String>();
            for (ExecutableElement method : ElementFilter.methodsIn(builder.getEnclosedElements())) {
                if (!method.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                publicMethodNames.add(method.getSimpleName().toString());
            }
            if (modelList.hasErrors()) continue;
            HashSet<String> missing = new HashSet<String>();
            HashSet<String> remaining = publicMethodNames;
            for (String method : expectedPublicMethodNames) {
                if (remaining.remove(method)) continue;
                missing.add(method);
            }
            if (missing.isEmpty() && remaining.isEmpty()) continue;
            Object errorMessage = String.format("Incompatible public interface of builder %s:", builder.getQualifiedName());
            if (!missing.isEmpty()) {
                errorMessage = (String)errorMessage + " missing method(s) ";
                errorMessage = (String)errorMessage + ((Object)missing).toString();
            }
            if (!remaining.isEmpty()) {
                errorMessage = (String)errorMessage + " additional method(s) ";
                errorMessage = (String)errorMessage + ((Object)remaining).toString();
            }
            throw new AssertionError(errorMessage);
        }
        abstractBuilderType.addAll(this.createReflectiveHelpers(modelList, abstractBuilderType.asType()));
        results.add(abstractBuilderType);
        return results;
    }

    public static CodeTypeElement createAbstractBuilderType(TypeElement templateType) {
        String abstractBuilderName = String.valueOf(templateType.getSimpleName()) + "Builder";
        CodeTypeElement abstractBuilderType = new CodeTypeElement(Set.of(Modifier.PUBLIC, Modifier.ABSTRACT), ElementKind.CLASS, ElementUtils.findPackageElement(templateType), abstractBuilderName);
        abstractBuilderType.setSuperClass(ProcessorContext.types().BytecodeBuilder);
        CodeExecutableElement constructor = GeneratorUtils.createConstructorUsingFields(Set.of(Modifier.PROTECTED), abstractBuilderType);
        constructor.getParameters().clear();
        constructor.addParameter(new CodeVariableElement(ProcessorContext.getInstance().getType(Object.class), "token"));
        constructor.createBuilder().statement("super(token)");
        abstractBuilderType.add(constructor);
        return abstractBuilderType;
    }

    private boolean hasExpectErrors(Element element) {
        if (!ExpectError.getExpectedErrors(element).isEmpty()) {
            return true;
        }
        for (Element element2 : element.getEnclosedElements()) {
            if (!this.hasExpectErrors(element2)) continue;
            return true;
        }
        if (element instanceof ExecutableElement) {
            ExecutableElement ex = (ExecutableElement)element;
            for (VariableElement variableElement : ex.getParameters()) {
                if (!this.hasExpectErrors(variableElement)) continue;
                return true;
            }
        }
        return false;
    }

    private List<CodeExecutableElement> createReflectiveHelpers(BytecodeDSLModels modelList, TypeMirror abstractBuilderType) {
        ArrayList<CodeExecutableElement> result = new ArrayList<CodeExecutableElement>();
        ProcessorContext ctx = ProcessorContext.getInstance();
        TypeMirror templateType = modelList.getTemplateType().asType();
        DeclaredType languageClass = modelList.getModels().getFirst().languageClass;
        CodeTypeParameterElement tExtendsBasicInterpreter = new CodeTypeParameterElement(CodeNames.of("T"), templateType);
        result.add(BytecodeDSLCodeGenerator.createReflectiveHelper("newConfigBuilder", templateType, this.types.BytecodeConfig_Builder, null, new CodeVariableElement[0]));
        result.add(BytecodeDSLCodeGenerator.createReflectiveHelper("create", templateType, ElementHelpers.generic((TypeMirror)this.types.BytecodeRootNodes, tExtendsBasicInterpreter.asType()), tExtendsBasicInterpreter, new CodeVariableElement(languageClass, "language"), new CodeVariableElement(this.types.BytecodeConfig, "config"), new CodeVariableElement(ElementHelpers.generic((TypeMirror)this.types.BytecodeParser, ElementHelpers.wildcard(abstractBuilderType, null)), "builder")));
        result.add(BytecodeDSLCodeGenerator.createReflectiveHelper("deserialize", templateType, ElementHelpers.generic((TypeMirror)this.types.BytecodeRootNodes, tExtendsBasicInterpreter.asType()), tExtendsBasicInterpreter, new CodeVariableElement(languageClass, "language"), new CodeVariableElement(this.types.BytecodeConfig, "config"), new CodeVariableElement(ElementHelpers.generic((TypeMirror)ctx.getDeclaredType(Supplier.class), (TypeMirror)ctx.getDeclaredType(DataInput.class)), "input"), new CodeVariableElement(this.types.BytecodeDeserializer, "callback")));
        return result;
    }

    private static CodeExecutableElement createReflectiveHelper(String name, TypeMirror templateType, DeclaredType returnType, CodeTypeParameterElement typeParameter, CodeVariableElement ... params) {
        String helperName = "invoke" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        CodeExecutableElement ex = new CodeExecutableElement(Set.of(Modifier.PUBLIC, Modifier.STATIC), returnType, helperName, new CodeVariableElement[0]);
        if (!returnType.getTypeArguments().isEmpty()) {
            GeneratorUtils.mergeSuppressWarnings(ex, "unchecked");
        }
        if (typeParameter != null) {
            ex.getTypeParameters().add(typeParameter);
        }
        ex.addParameter(new CodeVariableElement(ElementHelpers.generic(Class.class, ElementHelpers.wildcard(templateType, null)), "interpreterClass"));
        for (CodeVariableElement param : params) {
            ex.addParameter(param);
        }
        CodeTreeBuilder b = ex.createBuilder();
        ProcessorContext ctx = ProcessorContext.getInstance();
        b.startTryBlock();
        b.startDeclaration(ctx.getDeclaredType(Method.class), "method");
        b.startCall("interpreterClass.getMethod");
        b.doubleQuote(name);
        for (CodeVariableElement param : params) {
            b.typeLiteral(param.asType());
        }
        b.end();
        b.end();
        b.startReturn().cast(returnType);
        b.startCall("method.invoke");
        b.string("null");
        for (CodeVariableElement param : params) {
            b.variable(param);
        }
        b.end();
        b.end();
        b.end().startCatchBlock(ctx.getDeclaredType(InvocationTargetException.class), "e");
        b.startIf().string("e.getCause() instanceof RuntimeException err").end().startBlock();
        b.startThrow().string("err").end();
        b.end().startElseBlock();
        b.startThrow().startNew(ctx.getDeclaredType(AssertionError.class)).string("e.getCause()").end(2);
        b.end();
        b.end().startCatchBlock(ctx.getDeclaredType(Exception.class), "e");
        b.startThrow().startNew(ctx.getDeclaredType(AssertionError.class)).string("e").end(2);
        b.end();
        return ex;
    }
}

