/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.model;

import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import com.oracle.truffle.dsl.processor.model.MethodSpec;
import com.oracle.truffle.dsl.processor.model.NodeExecutionData;
import com.oracle.truffle.dsl.processor.model.Parameter;
import com.oracle.truffle.dsl.processor.model.Template;
import com.oracle.truffle.dsl.processor.util.FilteredIterable;
import com.oracle.truffle.dsl.processor.util.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class TemplateMethod
extends MessageContainer
implements Comparable<TemplateMethod> {
    public static final String FRAME_NAME = "frameValue";
    public static final int NO_NATURAL_ORDER = -1;
    private String id;
    private final Template template;
    private final int naturalOrder;
    private final MethodSpec specification;
    private final ExecutableElement method;
    private final AnnotationMirror markerAnnotation;
    private Parameter returnType;
    private final List<Parameter> parameters;
    private final List<Parameter> signatureParmeters;
    private final Map<String, Parameter> parameterCache = new HashMap<String, Parameter>();

    public TemplateMethod(String id, int naturalOrder, Template template, MethodSpec specification, ExecutableElement method, AnnotationMirror markerAnnotation, Parameter returnType, List<Parameter> parameters) {
        this.template = template;
        this.specification = specification;
        this.naturalOrder = naturalOrder;
        this.method = method;
        this.markerAnnotation = markerAnnotation;
        this.returnType = returnType;
        this.parameters = new ArrayList<Parameter>(parameters);
        this.signatureParmeters = new ArrayList<Parameter>(parameters.size());
        for (Parameter param : parameters) {
            this.parameterCache.put(param.getLocalName(), param);
            if (!param.getSpecification().isSignature()) continue;
            this.signatureParmeters.add(param);
        }
        if (returnType != null) {
            this.parameterCache.put(returnType.getLocalName(), returnType);
        }
        this.id = id;
    }

    public final Parameter getFrame() {
        return this.findParameter(FRAME_NAME);
    }

    public void addParameter(Parameter p) {
        this.parameters.add(p);
        this.parameterCache.put(p.getLocalName(), p);
        if (p.getSpecification().isSignature()) {
            this.signatureParmeters.add(p);
        }
    }

    public String createReferenceName() {
        if (this.getMethod() == null) {
            return "-";
        }
        return ElementUtils.createReferenceName(this.getMethod());
    }

    public int getNaturalOrder() {
        return this.naturalOrder;
    }

    public TemplateMethod(TemplateMethod method) {
        this(method.id, method.naturalOrder, method.template, method.specification, method.method, method.markerAnnotation, method.returnType, method.parameters);
        if (!method.getMessages().isEmpty()) {
            this.getMessagesForModification().addAll(method.getMessages());
        }
    }

    public TemplateMethod(TemplateMethod method, ExecutableElement executable) {
        this(method.id, method.naturalOrder, method.template, method.specification, executable, method.markerAnnotation, method.returnType, method.parameters);
        if (!method.getMessages().isEmpty()) {
            this.getMessagesForModification().addAll(method.getMessages());
        }
    }

    @Override
    public Element getMessageElement() {
        return this.method;
    }

    @Override
    public AnnotationMirror getMessageAnnotation() {
        return this.markerAnnotation;
    }

    @Override
    protected List<MessageContainer> findChildContainers() {
        return Collections.emptyList();
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Template getTemplate() {
        return this.template;
    }

    public MethodSpec getSpecification() {
        return this.specification;
    }

    public Parameter getReturnType() {
        return this.returnType;
    }

    public Iterable<Parameter> getDynamicParameters() {
        return new FilteredIterable<Parameter>(this.getParameters(), new Predicate<Parameter>(){

            @Override
            public boolean evaluate(Parameter value) {
                return !value.getSpecification().isLocal() && !value.getSpecification().isCached();
            }
        });
    }

    public List<Parameter> getSignatureParameters() {
        return this.signatureParmeters;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Parameter findParameterOrDie(NodeExecutionData execution) {
        Parameter p = this.findParameter(execution);
        if (p == null) {
            throw new AssertionError((Object)"Could not find parameter for execution");
        }
        return p;
    }

    public Parameter findParameter(NodeExecutionData execution) {
        for (Parameter parameter : this.signatureParmeters) {
            if (parameter.getSpecification().getExecution() != execution) continue;
            return parameter;
        }
        return null;
    }

    public Parameter findParameter(String valueName) {
        return this.parameterCache.get(valueName);
    }

    public List<Parameter> getReturnTypeAndParameters() {
        ArrayList<Parameter> allParameters = new ArrayList<Parameter>(this.getParameters().size() + 1);
        if (this.getReturnType() != null) {
            allParameters.add(this.getReturnType());
        }
        allParameters.addAll(this.getParameters());
        return Collections.unmodifiableList(allParameters);
    }

    public ExecutableElement getMethod() {
        return this.method;
    }

    public String getMethodName() {
        if (this.getMethod() != null) {
            return this.getMethod().getSimpleName().toString();
        }
        return "$synthetic";
    }

    public AnnotationMirror getMarkerAnnotation() {
        return this.markerAnnotation;
    }

    public String toString() {
        return String.format("%s [id = %s, method = %s]", this.getClass().getSimpleName(), this.getId(), this.getMethod());
    }

    public int getSignatureSize() {
        int signatureSize = 0;
        for (Parameter parameter : this.getSignatureParameters()) {
            ++signatureSize;
        }
        return signatureSize;
    }

    public TypeSignature getTypeSignature() {
        TypeSignature signature = new TypeSignature();
        signature.types.add(this.getReturnType().getType());
        for (Parameter parameter : this.getSignatureParameters()) {
            TypeMirror typeData = parameter.getType();
            if (typeData == null) continue;
            signature.types.add(typeData);
        }
        return signature;
    }

    @Override
    public int compareTo(TemplateMethod o) {
        if (this == o) {
            return 0;
        }
        int compare = this.compareBySignature(o);
        if (compare == 0) {
            compare = this.getId().compareTo(o.getId());
        }
        if (compare == 0) {
            TypeElement enclosingType1 = ElementUtils.findNearestEnclosingType(this.getMethod()).orElseThrow(AssertionError::new);
            TypeElement enclosingType2 = ElementUtils.findNearestEnclosingType(o.getMethod()).orElseThrow(AssertionError::new);
            compare = enclosingType1.getQualifiedName().toString().compareTo(enclosingType2.getQualifiedName().toString());
        }
        return compare;
    }

    public int compareBySignature(TemplateMethod compareMethod) {
        TypeMirror t2;
        TypeMirror t1;
        List<TypeMirror> signature1 = this.getDynamicTypes();
        List<TypeMirror> signature2 = compareMethod.getDynamicTypes();
        int result = 0;
        for (int i = 0; i < Math.max(signature1.size(), signature2.size()) && (result = ElementUtils.compareType(t1 = i < signature1.size() ? signature1.get(i) : null, t2 = i < signature2.size() ? signature2.get(i) : null)) == 0; ++i) {
        }
        return result;
    }

    public List<TypeMirror> getDynamicTypes() {
        ArrayList<TypeMirror> foundTypes = new ArrayList<TypeMirror>();
        for (Parameter param : this.getDynamicParameters()) {
            foundTypes.add(param.getType());
        }
        return foundTypes;
    }

    public static class TypeSignature
    implements Iterable<TypeMirror> {
        private final List<TypeMirror> types = new ArrayList<TypeMirror>();

        public int hashCode() {
            return this.types.hashCode();
        }

        public int size() {
            return this.types.size();
        }

        public TypeMirror get(int index) {
            return this.types.get(index);
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeSignature) {
                return ((TypeSignature)obj).types.equals(this.types);
            }
            return super.equals(obj);
        }

        @Override
        public Iterator<TypeMirror> iterator() {
            return this.types.iterator();
        }

        public String toString() {
            return this.types.toString();
        }
    }
}

