/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.model;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.expression.DSLExpression;
import com.oracle.truffle.dsl.processor.model.ExecutableTypeData;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import com.oracle.truffle.dsl.processor.model.NodeData;
import com.oracle.truffle.dsl.processor.model.NodeExecutionData;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeMirror;

public class NodeChildData
extends MessageContainer {
    private final Element sourceElement;
    private final AnnotationMirror sourceAnnotationMirror;
    private final String name;
    private final TypeMirror type;
    private final TypeMirror originalType;
    private final Element accessElement;
    private final Cardinality cardinality;
    private final AnnotationValue executeWithValue;
    private final String implicitCreate;
    private DSLExpression implicitCreateExpression;
    private final String uncached;
    private DSLExpression uncachedExpression;
    private List<NodeExecutionData> executeWith = Collections.emptyList();
    private NodeData childNode;

    public NodeChildData(Element sourceElement, AnnotationMirror sourceMirror, String name, TypeMirror nodeType, TypeMirror originalNodeType, Element accessElement, Cardinality cardinality, AnnotationValue executeWithValue, String implicitCreate, String uncached) {
        this.sourceElement = sourceElement;
        this.sourceAnnotationMirror = sourceMirror;
        this.name = name;
        this.type = nodeType;
        this.originalType = originalNodeType;
        this.accessElement = accessElement;
        this.cardinality = cardinality;
        this.executeWithValue = executeWithValue;
        this.implicitCreate = implicitCreate;
        this.uncached = uncached;
    }

    public boolean needsGeneratedField() {
        return this.accessElement == null || this.accessElement.getKind() != ElementKind.FIELD;
    }

    public AnnotationValue getExecuteWithValue() {
        return this.executeWithValue;
    }

    public List<NodeExecutionData> getExecuteWith() {
        return this.executeWith;
    }

    public boolean isImplicit() {
        return this.implicitCreate != null;
    }

    public String getImplicitCreate() {
        return this.implicitCreate;
    }

    public DSLExpression getImplicitCreateExpression() {
        assert (this.isImplicit());
        return this.implicitCreateExpression;
    }

    public void setImplicitCreateExpression(DSLExpression implicitCreateExpression) {
        assert (this.isImplicit());
        this.implicitCreateExpression = implicitCreateExpression;
    }

    public boolean isAllowUncached() {
        return this.uncached != null;
    }

    public String getUncached() {
        return this.uncached;
    }

    public DSLExpression getUncachedExpression() {
        assert (this.isAllowUncached());
        return this.uncachedExpression;
    }

    public void setUncachedExpression(DSLExpression uncachedExpression) {
        assert (this.isAllowUncached());
        this.uncachedExpression = uncachedExpression;
    }

    public void setExecuteWith(List<NodeExecutionData> executeWith) {
        this.executeWith = executeWith;
    }

    public ExecutableTypeData findExecutableType(TypeMirror targetType) {
        return this.childNode.findExecutableType(targetType, this.getExecuteWith().size());
    }

    public List<ExecutableTypeData> findGenericExecutableTypes() {
        return this.childNode.findGenericExecutableTypes(this.getExecuteWith().size());
    }

    public ExecutableTypeData findAnyGenericExecutableType(ProcessorContext context) {
        return this.childNode.findAnyGenericExecutableType(context, this.getExecuteWith().size());
    }

    public TypeMirror getOriginalType() {
        return this.originalType;
    }

    @Override
    public Element getMessageElement() {
        return this.sourceElement;
    }

    @Override
    public AnnotationMirror getMessageAnnotation() {
        return this.sourceAnnotationMirror;
    }

    public void setNode(NodeData nodeData) {
        this.childNode = nodeData;
        if (nodeData != null) {
            this.getMessagesForModification().addAll(nodeData.collectMessages());
        }
    }

    public Element getAccessElement() {
        return this.accessElement;
    }

    public TypeMirror getNodeType() {
        return this.type;
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    public NodeData getNodeData() {
        return this.childNode;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "NodeFieldData[name=" + this.getName() + ", kind=" + this.cardinality + ", node=" + this.getNodeData() + "]";
    }

    public static enum Cardinality {
        ONE,
        MANY;


        public boolean isMany() {
            return this == MANY;
        }

        public boolean isOne() {
            return this == ONE;
        }
    }
}

