/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.model;

import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.model.ParameterSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.type.TypeMirror;

public class MethodSpec {
    private final ParameterSpec returnType;
    private final List<ParameterSpec> optional = new ArrayList<ParameterSpec>();
    private final List<ParameterSpec> required = new ArrayList<ParameterSpec>();
    private final List<ParameterSpec> annotations = new ArrayList<ParameterSpec>();
    private boolean ignoreAdditionalParameters;
    private boolean ignoreAdditionalSpecifications;
    private boolean variableRequiredParameters;
    private List<TypeDef> typeDefinitions;

    public MethodSpec(ParameterSpec returnType) {
        this.returnType = returnType;
    }

    public void setVariableRequiredParameters(boolean variableRequiredParameters) {
        this.variableRequiredParameters = variableRequiredParameters;
    }

    public boolean isVariableRequiredParameters() {
        return this.variableRequiredParameters;
    }

    public void setIgnoreAdditionalParameters(boolean ignoreAdditionalParameter) {
        this.ignoreAdditionalParameters = ignoreAdditionalParameter;
    }

    public boolean isIgnoreAdditionalParameters() {
        return this.ignoreAdditionalParameters;
    }

    public void addOptional(ParameterSpec spec) {
        this.optional.add(spec);
    }

    public ParameterSpec addRequired(ParameterSpec spec) {
        this.required.add(spec);
        return spec;
    }

    public List<ParameterSpec> getAnnotations() {
        return this.annotations;
    }

    public ParameterSpec getReturnType() {
        return this.returnType;
    }

    public List<ParameterSpec> getRequired() {
        return this.required;
    }

    public List<ParameterSpec> getOptional() {
        return this.optional;
    }

    public List<ParameterSpec> getAll() {
        ArrayList<ParameterSpec> specs = new ArrayList<ParameterSpec>();
        specs.add(this.getReturnType());
        specs.addAll(this.getOptional());
        specs.addAll(this.getRequired());
        return specs;
    }

    public void applyTypeDefinitions(String prefix) {
        this.typeDefinitions = this.createTypeDefinitions(prefix);
    }

    private List<TypeDef> createTypeDefinitions(String prefix) {
        ArrayList<TypeDef> typeDefs = new ArrayList<TypeDef>();
        int defIndex = 0;
        for (ParameterSpec spec : this.getAll()) {
            Collection<TypeMirror> allowedTypes = spec.getAllowedTypes();
            Collection<TypeMirror> types = spec.getAllowedTypes();
            if (types == null || allowedTypes.size() <= 1) continue;
            TypeDef foundDef = null;
            for (TypeDef def : typeDefs) {
                if (!allowedTypes.equals(def.getTypes())) continue;
                foundDef = def;
                break;
            }
            if (foundDef == null) {
                foundDef = new TypeDef(types, prefix + defIndex);
                typeDefs.add(foundDef);
                ++defIndex;
            }
            spec.setTypeDefinition(foundDef);
        }
        return typeDefs;
    }

    public String toSignatureString(String methodName) {
        StringBuilder b = new StringBuilder();
        b.append("    ");
        b.append(MethodSpec.createTypeSignature(this.returnType, true));
        b.append(" ");
        b.append(methodName);
        b.append("(");
        String sep = "";
        for (ParameterSpec optionalSpec : this.getOptional()) {
            b.append(sep);
            b.append("[");
            b.append(MethodSpec.createTypeSignature(optionalSpec, false));
            b.append("]");
            sep = ", ";
        }
        for (int i = 0; i < this.getRequired().size(); ++i) {
            ParameterSpec requiredSpec = this.getRequired().get(i);
            b.append(sep);
            if (this.isVariableRequiredParameters() && i == this.getRequired().size() - 1) {
                b.append("{");
            }
            b.append(MethodSpec.createTypeSignature(requiredSpec, false));
            if (this.isVariableRequiredParameters() && i == this.getRequired().size() - 1) {
                b.append("}");
            }
            sep = ", ";
        }
        b.append(")");
        if (this.typeDefinitions != null && !this.typeDefinitions.isEmpty()) {
            b.append(System.lineSeparator());
            b.append(System.lineSeparator());
            String lineSep = "";
            for (TypeDef def : this.typeDefinitions) {
                b.append(lineSep);
                b.append("    <").append(def.getName()).append(">");
                b.append(" = {");
                String separator = "";
                for (TypeMirror type : def.getTypes()) {
                    b.append(separator).append(ElementUtils.getSimpleName(type));
                    separator = ", ";
                }
                b.append("}");
                lineSep = System.lineSeparator();
            }
        }
        return b.toString();
    }

    private static String createTypeSignature(ParameterSpec spec, boolean typeOnly) {
        StringBuilder builder = new StringBuilder();
        TypeDef foundTypeDef = spec.getTypeDefinition();
        if (foundTypeDef != null) {
            builder.append("<" + foundTypeDef.getName() + ">");
        } else if (spec.getAllowedTypes().size() >= 1) {
            builder.append(ElementUtils.getSimpleName(spec.getAllowedTypes().iterator().next()));
        } else {
            builder.append("void");
        }
        if (!typeOnly) {
            builder.append(" ");
            builder.append(spec.getName());
        }
        return builder.toString();
    }

    public String toString() {
        return this.toSignatureString("methodName");
    }

    public void setIgnoreAdditionalSpecifications(boolean ignoreAdditoinalSpecifications) {
        this.ignoreAdditionalSpecifications = ignoreAdditoinalSpecifications;
    }

    public boolean isIgnoreAdditionalSpecifications() {
        return this.ignoreAdditionalSpecifications;
    }

    static final class TypeDef {
        private final Collection<TypeMirror> types;
        private final String name;

        private TypeDef(Collection<TypeMirror> types, String name) {
            this.types = types;
            this.name = name;
        }

        public Collection<TypeMirror> getTypes() {
            return this.types;
        }

        public String getName() {
            return this.name;
        }
    }
}

