/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java.model;

import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.compiler.CompilerFactory;
import com.oracle.truffle.dsl.processor.java.model.CodeCompilationUnit;
import com.oracle.truffle.dsl.processor.java.model.CodeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeImport;
import com.oracle.truffle.dsl.processor.java.model.CodeNames;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeMirror;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class CodeTypeElement
extends CodeElement<Element>
implements TypeElement {
    private final List<? extends CodeImport> imports = this.parentableList(this, new ArrayList());
    private final PackageElement packageElement;
    private Name simpleName;
    private final Name packageName;
    private Name qualifiedName;
    private final List<TypeMirror> implementsInterfaces = new ArrayList<TypeMirror>();
    private final List<TypeParameterElement> typeParameters = this.parentableList(this, new ArrayList());
    private ElementKind kind;
    private TypeMirror superClass;
    private final CodeTypeMirror.DeclaredCodeTypeMirror mirror = new CodeTypeMirror.DeclaredCodeTypeMirror(this);

    public CodeTypeElement(Set<Modifier> modifiers, ElementKind kind, PackageElement packageElement, String simpleName) {
        super(modifiers);
        this.kind = kind;
        this.packageElement = packageElement;
        this.simpleName = CodeNames.of(simpleName);
        this.packageName = this.packageElement != null ? packageElement.getQualifiedName() : CodeNames.of("default");
        this.qualifiedName = this.createQualifiedName();
    }

    public void setSimpleName(Name simpleName) {
        this.simpleName = simpleName;
        this.qualifiedName = this.createQualifiedName();
    }

    @Override
    public TypeMirror asType() {
        return this.mirror;
    }

    public void setKind(ElementKind kind) {
        this.kind = kind;
    }

    @Override
    public ElementKind getKind() {
        return this.kind;
    }

    public boolean containsField(String name) {
        for (VariableElement field : this.getFields()) {
            if (!field.getSimpleName().toString().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public NestingKind getNestingKind() {
        return this.isTopLevelClass() ? NestingKind.TOP_LEVEL : NestingKind.LOCAL;
    }

    @Override
    public Element getEnclosingElement() {
        if (this.isTopLevelClass()) {
            return this.packageElement;
        }
        return super.getEnclosingElement();
    }

    @Override
    public TypeMirror getSuperclass() {
        return this.superClass;
    }

    public List<TypeMirror> getInterfaces() {
        return this.implementsInterfaces;
    }

    public List<TypeParameterElement> getTypeParameters() {
        return this.typeParameters;
    }

    public boolean isTopLevelClass() {
        return super.getEnclosingElement() instanceof CodeCompilationUnit || super.getEnclosingElement() == null;
    }

    private Name createQualifiedName() {
        TypeElement enclosingType = this.getEnclosingClass();
        Object name = enclosingType == null ? (this.packageName == null || this.packageName.length() == 0 ? this.simpleName.toString() : this.packageName + "." + this.simpleName) : enclosingType.getQualifiedName() + "." + this.simpleName;
        return CodeNames.of((String)name);
    }

    @Override
    public void setEnclosingElement(Element element) {
        super.setEnclosingElement(element);
        this.qualifiedName = this.createQualifiedName();
    }

    public Name getPackageName() {
        return this.packageName;
    }

    @Override
    public Name getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public Name getSimpleName() {
        return this.simpleName;
    }

    public void setSuperClass(TypeMirror superType) {
        this.superClass = superType;
    }

    public List<? extends CodeImport> getImports() {
        return this.imports;
    }

    public List<TypeMirror> getImplements() {
        return this.implementsInterfaces;
    }

    @Override
    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TypeElement) {
            return this.getQualifiedName().equals(((TypeElement)obj).getQualifiedName());
        }
        return false;
    }

    public List<VariableElement> getFields() {
        return ElementFilter.fieldsIn(this.getEnclosedElements());
    }

    public List<ExecutableElement> getMethods() {
        return ElementFilter.methodsIn(this.getEnclosedElements());
    }

    public List<TypeElement> getInnerClasses() {
        return ElementFilter.typesIn(this.getEnclosedElements());
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> v, P p) {
        return v.visitType(this, p);
    }

    public static CodeTypeElement cloneShallow(TypeElement typeElement) {
        CodeTypeElement copy = new CodeTypeElement(new HashSet<Modifier>(typeElement.getModifiers()), typeElement.getKind(), ElementUtils.findPackageElement(typeElement), typeElement.getSimpleName().toString());
        copy.setEnclosingElement(typeElement.getEnclosingElement());
        copy.setSuperClass(typeElement.getSuperclass());
        copy.getTypeParameters().addAll(typeElement.getTypeParameters());
        copy.getImplements().addAll(typeElement.getInterfaces());
        copy.getAnnotationMirrors().addAll(typeElement.getAnnotationMirrors());
        copy.getEnclosedElements().addAll(CompilerFactory.getCompiler(typeElement).getEnclosedElementsInDeclarationOrder(typeElement));
        return copy;
    }
}

