/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.parser;

import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import com.oracle.truffle.dsl.processor.model.MethodSpec;
import com.oracle.truffle.dsl.processor.model.Parameter;
import com.oracle.truffle.dsl.processor.model.ParameterSpec;
import com.oracle.truffle.dsl.processor.model.Template;
import com.oracle.truffle.dsl.processor.model.TemplateMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public final class MethodSpecParser {
    private boolean emitErrors = true;
    private boolean useVarArgs = false;
    private final Template template;

    public MethodSpecParser(Template template) {
        this.template = template;
    }

    public Template getTemplate() {
        return this.template;
    }

    public boolean isEmitErrors() {
        return this.emitErrors;
    }

    public boolean isUseVarArgs() {
        return this.useVarArgs;
    }

    public void setEmitErrors(boolean emitErrors) {
        this.emitErrors = emitErrors;
    }

    public void setUseVarArgs(boolean useVarArgs) {
        this.useVarArgs = useVarArgs;
    }

    public TemplateMethod parse(MethodSpec methodSpecification, ExecutableElement method, AnnotationMirror annotation, int naturalOrder) {
        if (methodSpecification == null) {
            return null;
        }
        methodSpecification.applyTypeDefinitions("types");
        String id = method.getSimpleName().toString();
        TypeMirror returnType = method.getReturnType();
        return this.parseImpl(methodSpecification, naturalOrder, id, method, annotation, returnType, method.getParameters());
    }

    public TemplateMethod parseImpl(MethodSpec methodSpecification, int naturalOrder, String id, ExecutableElement method, AnnotationMirror annotation, TypeMirror returnType, List<? extends VariableElement> parameterTypes) {
        ParameterSpec returnTypeSpec = methodSpecification.getReturnType();
        Parameter returnTypeMirror = MethodSpecParser.matchParameter(returnTypeSpec, new CodeVariableElement(returnType, "returnType"), -1, -1);
        if (returnTypeMirror == null) {
            if (this.isEmitErrors() && method != null) {
                TemplateMethod invalidMethod = new TemplateMethod(id, naturalOrder, this.template, methodSpecification, method, annotation, returnTypeMirror, Collections.emptyList());
                String expectedReturnType = returnTypeSpec.toSignatureString(true);
                String actualReturnType = ElementUtils.getSimpleName(returnType);
                String message = String.format("The provided return type \"%s\" does not match expected return type \"%s\".%nExpected signature: %n %s", actualReturnType, expectedReturnType, methodSpecification.toSignatureString(method.getSimpleName().toString()));
                invalidMethod.addError(message, new Object[0]);
                return invalidMethod;
            }
            return null;
        }
        List<Parameter> parameters = MethodSpecParser.parseParameters(methodSpecification, parameterTypes, this.isUseVarArgs() && method != null ? method.isVarArgs() : false);
        if (parameters == null) {
            if (this.isEmitErrors() && method != null) {
                TemplateMethod invalidMethod = new TemplateMethod(id, naturalOrder, this.template, methodSpecification, method, annotation, returnTypeMirror, Collections.emptyList());
                String message = String.format("Method signature %s does not match to the expected signature: %n%s", MethodSpecParser.createActualSignature(method), methodSpecification.toSignatureString(method.getSimpleName().toString()));
                invalidMethod.addError(message, new Object[0]);
                return invalidMethod;
            }
            return null;
        }
        return new TemplateMethod(id, naturalOrder, this.template, methodSpecification, method, annotation, returnTypeMirror, parameters);
    }

    private static String createActualSignature(ExecutableElement method) {
        StringBuilder b = new StringBuilder("(");
        String sep = "";
        if (method != null) {
            for (VariableElement variableElement : method.getParameters()) {
                b.append(sep);
                b.append(ElementUtils.getSimpleName(variableElement.asType()));
                sep = ", ";
            }
        }
        b.append(")");
        return b.toString();
    }

    private static List<Parameter> parseParameters(MethodSpec spec, List<? extends VariableElement> parameterTypes, boolean varArgs) {
        List<? extends VariableElement> potentialOptionals;
        List<Parameter> parsedOptionals;
        int offset;
        List<Parameter> parsedRequired = null;
        for (offset = 0; offset <= parameterTypes.size(); ++offset) {
            ArrayList<VariableElement> parameters = new ArrayList<VariableElement>();
            parameters.addAll(parameterTypes.subList(offset, parameterTypes.size()));
            parsedRequired = MethodSpecParser.parseParametersRequired(spec, parameters, varArgs);
            if (parsedRequired != null) break;
        }
        if (parsedRequired == null) {
            return null;
        }
        if (parsedRequired.isEmpty() && offset == 0) {
            offset = parameterTypes.size();
        }
        if ((parsedOptionals = MethodSpecParser.parseParametersOptional(spec, potentialOptionals = parameterTypes.subList(0, offset))) == null) {
            return null;
        }
        ArrayList<Parameter> finalParameters = new ArrayList<Parameter>();
        finalParameters.addAll(parsedOptionals);
        finalParameters.addAll(parsedRequired);
        return finalParameters;
    }

    private static List<Parameter> parseParametersOptional(MethodSpec spec, List<? extends VariableElement> types) {
        ArrayList<Parameter> parsedParams = new ArrayList<Parameter>();
        int typeStartIndex = 0;
        List<ParameterSpec> specifications = spec.getOptional();
        block0: for (int specIndex = 0; specIndex < specifications.size(); ++specIndex) {
            ParameterSpec specification = specifications.get(specIndex);
            for (int typeIndex = typeStartIndex; typeIndex < types.size(); ++typeIndex) {
                VariableElement variable = types.get(typeIndex);
                Parameter optionalParam = MethodSpecParser.matchParameter(specification, variable, -1, -1);
                if (optionalParam == null) continue;
                parsedParams.add(optionalParam);
                typeStartIndex = typeIndex + 1;
                continue block0;
            }
        }
        if (typeStartIndex < types.size()) {
            return null;
        }
        return parsedParams;
    }

    private static List<Parameter> parseParametersRequired(MethodSpec spec, List<VariableElement> types, boolean typeVarArgs) {
        Parameter matchedParamter;
        VariableElement variable;
        ParameterSpec specification;
        ArrayList<Parameter> parsedParams = new ArrayList<Parameter>();
        List<ParameterSpec> specifications = spec.getRequired();
        boolean specVarArgs = spec.isVariableRequiredParameters();
        int typeIndex = 0;
        int specificationIndex = 0;
        while ((specification = MethodSpecParser.nextSpecification(specifications, specificationIndex, specVarArgs)) != null) {
            int specVarArgsIndex;
            VariableElement actualType = MethodSpecParser.nextActualType(types, typeIndex, typeVarArgs);
            if (actualType == null) {
                if (spec.isIgnoreAdditionalSpecifications()) break;
                return null;
            }
            int typeVarArgsIndex = typeVarArgs ? typeIndex - types.size() + 1 : -1;
            int n = specVarArgsIndex = specVarArgs ? specificationIndex - specifications.size() + 1 : -1;
            if (typeVarArgsIndex >= 0 && specVarArgsIndex >= 0) break;
            Parameter resolvedParameter = MethodSpecParser.matchParameter(specification, actualType, specVarArgsIndex, typeVarArgsIndex);
            if (resolvedParameter == null) {
                return null;
            }
            for (ParameterSpec annotationSpec : spec.getAnnotations()) {
                if (!annotationSpec.matches(actualType)) continue;
                return null;
            }
            parsedParams.add(resolvedParameter);
            ++typeIndex;
            ++specificationIndex;
        }
        while ((variable = MethodSpecParser.nextActualType(types, typeIndex, typeVarArgs)) != null && (matchedParamter = MethodSpecParser.matchAnnotatedParameter(spec, variable)) != null) {
            parsedParams.add(matchedParamter);
            ++typeIndex;
        }
        if (typeIndex < types.size()) {
            if (spec.isIgnoreAdditionalParameters()) {
                return parsedParams;
            }
            return null;
        }
        return parsedParams;
    }

    private static Parameter matchAnnotatedParameter(MethodSpec spec, VariableElement variable) {
        for (ParameterSpec parameterSpec : spec.getAnnotations()) {
            Parameter matchedParameter;
            if (!parameterSpec.matches(variable) || (matchedParameter = MethodSpecParser.matchParameter(parameterSpec, variable, -1, -1)) == null) continue;
            matchedParameter.setLocalName(variable.getSimpleName().toString());
            return matchedParameter;
        }
        return null;
    }

    private static ParameterSpec nextSpecification(List<ParameterSpec> specifications, int specIndex, boolean varArgs) {
        if (varArgs && specIndex >= specifications.size() - 1 && !specifications.isEmpty()) {
            return specifications.get(specifications.size() - 1);
        }
        if (specIndex < specifications.size()) {
            return specifications.get(specIndex);
        }
        return null;
    }

    private static VariableElement nextActualType(List<VariableElement> types, int typeIndex, boolean varArgs) {
        if (varArgs && typeIndex >= types.size() - 1 && !types.isEmpty()) {
            VariableElement actualType = types.get(types.size() - 1);
            if (actualType.asType().getKind() == TypeKind.ARRAY) {
                actualType = new CodeVariableElement(((ArrayType)actualType.asType()).getComponentType(), actualType.getSimpleName().toString());
            }
            return actualType;
        }
        if (typeIndex < types.size()) {
            return types.get(typeIndex);
        }
        return null;
    }

    private static Parameter matchParameter(ParameterSpec specification, VariableElement variable, int specificationIndex, int varArgsIndex) {
        TypeMirror resolvedType = variable.asType();
        if (ElementUtils.hasError(resolvedType)) {
            return null;
        }
        if (!specification.matches(variable)) {
            return null;
        }
        return new Parameter(specification, variable, specificationIndex, varArgsIndex);
    }
}

