/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.dsl.processor.CodeWriter;
import com.oracle.truffle.dsl.processor.ExpectError;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.generator.GeneratorUtils;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.compiler.CompilerFactory;
import com.oracle.truffle.dsl.processor.java.compiler.JDTCompiler;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.transform.FixWarningsVisitor;
import com.oracle.truffle.dsl.processor.java.transform.GenerateOverrideVisitor;
import com.oracle.truffle.dsl.processor.model.Template;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

abstract class AbstractRegistrationProcessor
extends AbstractProcessor {
    private final Map<String, Element> registrations = new HashMap<String, Element>();

    AbstractRegistrationProcessor() {
    }

    @Override
    public final SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ProcessorContext.enter(this.processingEnv);
        try {
            ProcessorContext context = ProcessorContext.getInstance();
            String providerServiceBinName = this.processingEnv.getElementUtils().getBinaryName(context.getTypeElement(this.getProviderClass())).toString();
            if (roundEnv.processingOver()) {
                AbstractRegistrationProcessor.generateServicesRegistration(providerServiceBinName, this.registrations);
                this.registrations.clear();
                boolean bl = true;
                return bl;
            }
            String[] supportedAnnotations = this.getClass().getAnnotation(SupportedAnnotationTypes.class).value();
            TypeElement supportedAnnotation = this.processingEnv.getElementUtils().getTypeElement(supportedAnnotations[0]);
            if (supportedAnnotation == null) {
                throw new IllegalStateException("Cannot resolve " + supportedAnnotations[0]);
            }
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(supportedAnnotation);
            if (!annotatedElements.isEmpty()) {
                for (Element element : annotatedElements) {
                    AnnotationMirror mirror = ElementUtils.findAnnotationMirror(element, supportedAnnotation.asType());
                    if (mirror == null || element.getKind() != ElementKind.CLASS || !this.validateRegistration(element, mirror)) continue;
                    TypeElement annotatedElement = (TypeElement)element;
                    String providerImplBinName = this.generateProvider(annotatedElement);
                    this.registrations.put(providerImplBinName, annotatedElement);
                    if (!AbstractRegistrationProcessor.shouldGenerateProviderFiles(annotatedElement)) continue;
                    AbstractRegistrationProcessor.generateProviderFile(this.processingEnv, providerImplBinName, providerServiceBinName, annotatedElement);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ProcessorContext.leave();
        }
    }

    abstract boolean validateRegistration(Element var1, AnnotationMirror var2);

    abstract DeclaredType getProviderClass();

    abstract Iterable<AnnotationMirror> getProviderAnnotations(TypeElement var1);

    abstract void implementMethod(TypeElement var1, CodeExecutableElement var2);

    final void assertNoErrorExpected(Element e) {
        ExpectError.assertNoErrorExpected(this.processingEnv, e);
    }

    final void emitError(String msg, Element e) {
        if (ExpectError.isExpectedError(this.processingEnv, e, msg)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e);
    }

    final void emitError(String msg, Element e, AnnotationMirror mirror, AnnotationValue value) {
        if (ExpectError.isExpectedError(this.processingEnv, e, msg)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e, mirror, value);
    }

    final void emitWarning(String msg, Element e) {
        if (ExpectError.isExpectedError(this.processingEnv, e, msg)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg, e);
    }

    final void emitWarning(String msg, Element e, AnnotationMirror mirror, AnnotationValue value) {
        if (ExpectError.isExpectedError(this.processingEnv, e, msg)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg, e, mirror, value);
    }

    static AnnotationMirror copyAnnotations(AnnotationMirror mirror, Predicate<ExecutableElement> filter) {
        CodeAnnotationMirror res = new CodeAnnotationMirror(mirror.getAnnotationType());
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : mirror.getElementValues().entrySet()) {
            ExecutableElement executable = e.getKey();
            AnnotationValue value = e.getValue();
            if (!filter.test(executable)) continue;
            res.setElementValue(executable, value);
        }
        return res;
    }

    private String generateProvider(TypeElement annotatedElement) {
        ProcessorContext context = ProcessorContext.getInstance();
        Template model = new Template(context, annotatedElement, null){};
        TypeElement providerElement = context.getTypeElement(this.getProviderClass());
        CodeTypeElement providerClass = GeneratorUtils.createClass(model, null, EnumSet.of(Modifier.PUBLIC), AbstractRegistrationProcessor.createProviderSimpleName(annotatedElement), null);
        providerClass.getModifiers().add(Modifier.FINAL);
        providerClass.getImplements().add(providerElement.asType());
        for (Element element : ElementFilter.methodsIn(providerElement.getEnclosedElements())) {
            CodeExecutableElement implementedMethod = CodeExecutableElement.clone((ExecutableElement)element);
            implementedMethod.getModifiers().remove((Object)Modifier.ABSTRACT);
            this.implementMethod(annotatedElement, implementedMethod);
            providerClass.add(implementedMethod);
        }
        for (AnnotationMirror annotationMirror : this.getProviderAnnotations(annotatedElement)) {
            providerClass.addAnnotationMirror(annotationMirror);
        }
        DeclaredType overrideType = (DeclaredType)context.getType(Override.class);
        providerClass.accept(new GenerateOverrideVisitor(overrideType), null);
        providerClass.accept(new FixWarningsVisitor(annotatedElement, overrideType), null);
        providerClass.accept(new CodeWriter(context.getEnvironment(), annotatedElement), null);
        return providerClass.getQualifiedName().toString();
    }

    private static String createProviderSimpleName(TypeElement annotatedElement) {
        StringBuilder nameBuilder = new StringBuilder();
        List<Element> hierarchy = ElementUtils.getElementHierarchy(annotatedElement);
        ListIterator<Element> it = hierarchy.listIterator(hierarchy.size());
        while (it.hasPrevious()) {
            Element enc = it.previous();
            if (!enc.getKind().isClass() && !enc.getKind().isInterface()) continue;
            nameBuilder.append(enc.getSimpleName());
        }
        nameBuilder.append("Provider");
        return nameBuilder.toString();
    }

    static void generateProviderFile(ProcessingEnvironment env, String providerClassName, String serviceClassName, Element ... originatingElements) {
        assert (originatingElements.length > 0);
        String filename = "META-INF/truffle-registrations/" + providerClassName;
        try {
            FileObject file = env.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", filename, originatingElements);
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(file.openOutputStream(), "UTF-8"));
            writer.println(serviceClassName);
            writer.close();
        }
        catch (IOException e) {
            AbstractRegistrationProcessor.handleIOError(e, env, originatingElements[0]);
        }
    }

    private static boolean isBug367599(Throwable t) {
        if (t instanceof FilerException) {
            for (StackTraceElement ste : t.getStackTrace()) {
                if (!ste.toString().contains("org.eclipse.jdt.internal.apt.pluggable.core.filer.IdeFilerImpl.create")) continue;
                return true;
            }
        }
        return t.getCause() != null && AbstractRegistrationProcessor.isBug367599(t.getCause());
    }

    static void generateServicesRegistration(String providerBinName, Map<String, Element> providerRegistrations) {
        ProcessorContext context = ProcessorContext.getInstance();
        ProcessingEnvironment env = context.getEnvironment();
        Elements elements = env.getElementUtils();
        String filename = "META-INF/services/" + providerBinName;
        ArrayList<String> providerClassNames = new ArrayList<String>(providerRegistrations.size());
        for (String providerFqn : providerRegistrations.keySet()) {
            TypeElement te = ElementUtils.getTypeElement(env, providerFqn);
            if (te == null) {
                providerClassNames.add(providerFqn);
                continue;
            }
            providerClassNames.add(elements.getBinaryName(te).toString());
        }
        Collections.sort(providerClassNames);
        if (!providerClassNames.isEmpty()) {
            try {
                FileObject file = env.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", filename, providerRegistrations.values().toArray(new Element[providerRegistrations.size()]));
                try (PrintWriter out = new PrintWriter(new OutputStreamWriter(file.openOutputStream(), "UTF-8"));){
                    for (String providerClassName : providerClassNames) {
                        out.println(providerClassName);
                    }
                }
            }
            catch (IOException e) {
                AbstractRegistrationProcessor.handleIOError(e, env, providerRegistrations.values().iterator().next());
            }
        }
    }

    private static void handleIOError(IOException e, ProcessingEnvironment env, Element element) {
        if (e instanceof FilerException && (e.getMessage().startsWith("Source file already created") || e.getMessage().startsWith("Resource already created"))) {
            return;
        }
        env.getMessager().printMessage(AbstractRegistrationProcessor.isBug367599(e) ? Diagnostic.Kind.NOTE : Diagnostic.Kind.ERROR, e.getMessage(), element);
    }

    static boolean shouldGenerateProviderFiles(Element currentElement) {
        return CompilerFactory.getCompiler(currentElement) instanceof JDTCompiler;
    }

    static class SortedProperties
    extends Properties {
        SortedProperties() {
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            return Collections.enumeration(new TreeSet<Object>(super.keySet()));
        }
    }
}

