/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.dsl.processor.AbstractRegistrationProcessor;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@SupportedAnnotationTypes(value={"com.oracle.truffle.api.TruffleLanguage.Registration"})
public final class LanguageRegistrationProcessor
extends AbstractRegistrationProcessor {
    private static final Set<String> RESERVED_IDS = new HashSet<String>(Arrays.asList("host", "graal", "truffle", "language", "instrument", "graalvm", "context", "polyglot", "compiler", "vm", "file", "engine", "log", "image-build-time"));

    @Override
    boolean validateRegistration(Element annotatedElement, AnnotationMirror registrationMirror) {
        boolean bl;
        boolean processingTruffleLanguage;
        if (annotatedElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.emitError("Registered language class must be at least package protected", annotatedElement);
            return false;
        }
        if (annotatedElement.getEnclosingElement().getKind() != ElementKind.PACKAGE && !annotatedElement.getModifiers().contains((Object)Modifier.STATIC)) {
            this.emitError("Registered language inner-class must be static", annotatedElement);
            return false;
        }
        TruffleTypes types = ProcessorContext.getInstance().getTypes();
        TypeMirror truffleLang = this.processingEnv.getTypeUtils().erasure(types.TruffleLanguage);
        DeclaredType truffleLangProvider = types.TruffleLanguage_Provider;
        if (this.processingEnv.getTypeUtils().isAssignable(annotatedElement.asType(), truffleLang)) {
            processingTruffleLanguage = true;
        } else if (this.processingEnv.getTypeUtils().isAssignable(annotatedElement.asType(), truffleLangProvider)) {
            processingTruffleLanguage = false;
        } else {
            this.emitError("Registered language class must subclass TruffleLanguage", annotatedElement);
            return false;
        }
        boolean foundConstructor = false;
        for (ExecutableElement executableElement : ElementFilter.constructorsIn(annotatedElement.getEnclosedElements())) {
            if (executableElement.getModifiers().contains((Object)Modifier.PRIVATE) || !executableElement.getParameters().isEmpty()) continue;
            foundConstructor = true;
            break;
        }
        Element singletonElement = null;
        for (Element element : annotatedElement.getEnclosedElements()) {
            if (!element.getModifiers().contains((Object)Modifier.PUBLIC) || element.getKind() != ElementKind.FIELD || !element.getModifiers().contains((Object)Modifier.FINAL) || !"INSTANCE".equals(element.getSimpleName().toString()) || !this.processingEnv.getTypeUtils().isAssignable(element.asType(), truffleLang)) continue;
            singletonElement = element;
            break;
        }
        boolean bl2 = true;
        if (processingTruffleLanguage && singletonElement != null) {
            this.emitWarning("Using a singleton field is deprecated. Please provide a public no-argument constructor instead.", singletonElement);
            bl = false;
        } else if (!foundConstructor) {
            this.emitError("A TruffleLanguage subclass must have at least package protected no argument constructor.", annotatedElement);
            return false;
        }
        HashSet<String> hashSet = new HashSet<String>();
        List<String> characterMimeTypes = ElementUtils.getAnnotationValueList(String.class, registrationMirror, "characterMimeTypes");
        if (!this.validateMimeTypes(hashSet, annotatedElement, registrationMirror, ElementUtils.getAnnotationValue(registrationMirror, "characterMimeTypes"), characterMimeTypes)) {
            return false;
        }
        List<String> byteMimeTypes = ElementUtils.getAnnotationValueList(String.class, registrationMirror, "byteMimeTypes");
        if (!this.validateMimeTypes(hashSet, annotatedElement, registrationMirror, ElementUtils.getAnnotationValue(registrationMirror, "byteMimeTypes"), byteMimeTypes)) {
            return false;
        }
        String defaultMimeType = ElementUtils.getAnnotationValue(String.class, registrationMirror, "defaultMimeType");
        if (hashSet.size() > 1 && (defaultMimeType == null || defaultMimeType.equals(""))) {
            this.emitError("No defaultMimeType attribute specified. The defaultMimeType attribute needs to be specified if more than one MIME type was specified.", annotatedElement, registrationMirror, ElementUtils.getAnnotationValue(registrationMirror, "defaultMimeType"));
            return false;
        }
        if (defaultMimeType != null && !defaultMimeType.equals("") && !hashSet.contains(defaultMimeType)) {
            this.emitError("The defaultMimeType is not contained in the list of supported characterMimeTypes or byteMimeTypes. Add the specified default MIME type to character or byte MIME types to resolve this.", annotatedElement, registrationMirror, ElementUtils.getAnnotationValue(registrationMirror, "defaultMimeType"));
            return false;
        }
        String id = ElementUtils.getAnnotationValue(String.class, registrationMirror, "id");
        if (id.isEmpty()) {
            this.emitError("The attribute id is mandatory.", annotatedElement, registrationMirror, null);
            return false;
        }
        if (RESERVED_IDS.contains(id)) {
            this.emitError(String.format("Id '%s' is reserved for other use and must not be used as id.", id), annotatedElement, registrationMirror, ElementUtils.getAnnotationValue(registrationMirror, "id"));
            return false;
        }
        if (!this.validateFileTypeDetectors(annotatedElement, registrationMirror)) {
            return false;
        }
        if (bl) {
            this.assertNoErrorExpected(annotatedElement);
        }
        return processingTruffleLanguage;
    }

    @Override
    DeclaredType getProviderClass() {
        TruffleTypes types = ProcessorContext.getInstance().getTypes();
        return types.TruffleLanguage_Provider;
    }

    @Override
    Iterable<AnnotationMirror> getProviderAnnotations(TypeElement annotatedElement) {
        ArrayList<AnnotationMirror> result = new ArrayList<AnnotationMirror>(2);
        TruffleTypes types = ProcessorContext.getInstance().getTypes();
        DeclaredType registrationType = types.TruffleLanguage_Registration;
        AnnotationMirror registration = LanguageRegistrationProcessor.copyAnnotations(ElementUtils.findAnnotationMirror(annotatedElement.getAnnotationMirrors(), (TypeMirror)registrationType), new Predicate<ExecutableElement>(){

            @Override
            public boolean test(ExecutableElement t) {
                return !"services".contentEquals(t.getSimpleName()) && !"fileTypeDetectors".contentEquals(t.getSimpleName());
            }
        });
        result.add(registration);
        AnnotationMirror providedTags = ElementUtils.findAnnotationMirror(annotatedElement.getAnnotationMirrors(), (TypeMirror)types.ProvidedTags);
        if (providedTags != null) {
            result.add(providedTags);
        }
        return result;
    }

    @Override
    void implementMethod(TypeElement annotatedElement, CodeExecutableElement methodToImplement) {
        ProcessorContext context = ProcessorContext.getInstance();
        TruffleTypes types = context.getTypes();
        CodeTreeBuilder builder = methodToImplement.createBuilder();
        switch (methodToImplement.getSimpleName().toString()) {
            case "create": {
                DeclaredType languageType = (DeclaredType)annotatedElement.asType();
                List<? extends TypeParameterElement> typeParams = annotatedElement.getTypeParameters();
                if (!typeParams.isEmpty()) {
                    builder.startReturn().string("new " + annotatedElement.getQualifiedName() + "<>()").end();
                    break;
                }
                builder.startReturn().startNew(languageType).end(2);
                break;
            }
            case "createFileTypeDetectors": {
                AnnotationMirror registration = ElementUtils.findAnnotationMirror(annotatedElement.getAnnotationMirrors(), (TypeMirror)types.TruffleLanguage_Registration);
                List<TypeMirror> detectors = ElementUtils.getAnnotationValueList(TypeMirror.class, registration, "fileTypeDetectors");
                if (detectors.isEmpty()) {
                    builder.startReturn().startStaticCall(context.getType(Collections.class), "emptyList").end().end();
                    break;
                }
                builder.startReturn();
                builder.startStaticCall(context.getType(Arrays.class), "asList");
                for (TypeMirror detector : detectors) {
                    builder.startGroup().startNew(detector).end(2);
                }
                builder.end(2);
                break;
            }
            case "getLanguageClassName": {
                Elements elements = context.getEnvironment().getElementUtils();
                builder.startReturn().doubleQuote(elements.getBinaryName(annotatedElement).toString()).end();
                break;
            }
            case "getServicesClassNames": {
                AnnotationMirror registration = ElementUtils.findAnnotationMirror(annotatedElement.getAnnotationMirrors(), (TypeMirror)types.TruffleLanguage_Registration);
                List<TypeMirror> services = ElementUtils.getAnnotationValueList(TypeMirror.class, registration, "services");
                if (services.isEmpty()) {
                    builder.startReturn().startStaticCall(context.getType(Collections.class), "emptySet").end().end();
                    break;
                }
                builder.startReturn();
                builder.startStaticCall(context.getType(Arrays.class), "asList");
                for (TypeMirror service : services) {
                    Elements elements = context.getEnvironment().getElementUtils();
                    Types typeUtils = context.getEnvironment().getTypeUtils();
                    builder.startGroup().doubleQuote(elements.getBinaryName((TypeElement)((DeclaredType)typeUtils.erasure(service)).asElement()).toString()).end();
                }
                builder.end(2);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported method: " + methodToImplement.getSimpleName());
            }
        }
    }

    private boolean validateMimeTypes(Set<String> collectedMimeTypes, Element e, AnnotationMirror mirror, AnnotationValue value, List<String> loadedMimeTypes) {
        for (String mimeType : loadedMimeTypes) {
            if (!this.validateMimeType(e, mirror, value, mimeType)) {
                return false;
            }
            if (collectedMimeTypes.contains(mimeType)) {
                this.emitError(String.format("Duplicate MIME type specified '%s'. MIME types must be unique.", mimeType), e, mirror, value);
                return false;
            }
            collectedMimeTypes.add(mimeType);
        }
        return true;
    }

    private boolean validateMimeType(Element type, AnnotationMirror mirror, AnnotationValue value, String mimeType) {
        int index = mimeType.indexOf(47);
        if (index == -1 || index == 0 || index == mimeType.length() - 1) {
            this.emitError(String.format("Invalid MIME type '%s' provided. MIME types consist of a type and a subtype separated by '/'.", mimeType), type, mirror, value);
            return false;
        }
        if (mimeType.indexOf(47, index + 1) != -1) {
            this.emitError(String.format("Invalid MIME type '%s' provided. MIME types consist of a type and a subtype separated by '/'.", mimeType), type, mirror, value);
            return false;
        }
        return true;
    }

    private boolean validateFileTypeDetectors(Element annotatedElement, AnnotationMirror mirror) {
        AnnotationValue value = ElementUtils.getAnnotationValue(mirror, "fileTypeDetectors", true);
        for (TypeMirror fileTypeDetectorType : ElementUtils.getAnnotationValueList(TypeMirror.class, mirror, "fileTypeDetectors")) {
            TypeElement fileTypeDetectorElement = ElementUtils.fromTypeMirror(fileTypeDetectorType);
            if (!fileTypeDetectorElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
                this.emitError("Registered FileTypeDetector class must be public.", annotatedElement, mirror, value);
                return false;
            }
            if (fileTypeDetectorElement.getEnclosingElement().getKind() != ElementKind.PACKAGE && !fileTypeDetectorElement.getModifiers().contains((Object)Modifier.STATIC)) {
                this.emitError("Registered FileTypeDetector inner-class must be static.", annotatedElement, mirror, value);
                return false;
            }
            boolean foundConstructor = false;
            for (ExecutableElement constructor : ElementFilter.constructorsIn(fileTypeDetectorElement.getEnclosedElements())) {
                if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC) || !constructor.getParameters().isEmpty()) continue;
                foundConstructor = true;
                break;
            }
            if (foundConstructor) continue;
            this.emitError("A FileTypeDetector subclass must have a public no argument constructor.", annotatedElement, mirror, value);
            return false;
        }
        return true;
    }
}

