/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.DecodingErrorHandler;
import com.oracle.truffle.api.strings.Encodings;
import com.oracle.truffle.api.strings.Stride;
import com.oracle.truffle.api.strings.StringAttributes;
import com.oracle.truffle.api.strings.TSCodeRange;
import com.oracle.truffle.api.strings.TStringConstants;
import com.oracle.truffle.api.strings.TStringGuards;
import com.oracle.truffle.api.strings.TStringUnsafe;
import java.lang.ref.Reference;
import sun.misc.Unsafe;

final class TStringOps {
    TStringOps() {
    }

    static int readFromByteArray(byte[] array, int stride, int i) {
        return TStringOps.readValue(array, 0, array.length >> stride, stride, i);
    }

    static void writeToByteArray(byte[] array, int stride, int i, int value) {
        TStringOps.writeValue(array, 0, array.length >> stride, stride, i, value);
    }

    static int readValue(AbstractTruffleString a, Object arrayA, int stride, int i) {
        return TStringOps.readValue(arrayA, a.offset(), a.length(), stride, i);
    }

    static int readS0(AbstractTruffleString a, Object arrayA, int i) {
        return TStringOps.readS0(arrayA, a.offset(), a.length(), i);
    }

    static char readS1(AbstractTruffleString a, Object arrayA, int i) {
        return TStringOps.readS1(arrayA, a.offset(), a.length(), i);
    }

    static int readS2(AbstractTruffleString a, Object arrayA, int i) {
        return TStringOps.readS2(arrayA, a.offset(), a.length(), i);
    }

    static int readS0(Object array, int offset, int length, int i) {
        return TStringOps.readValue(array, offset, length, 0, i);
    }

    static char readS1(Object array, int offset, int length, int i) {
        return (char)TStringOps.readValue(array, offset, length, 1, i);
    }

    static int readS2(Object array, int offset, int length, int i) {
        return TStringOps.readValue(array, offset, length, 2, i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long readS3(Object array, int offset, int length) {
        try {
            long stubOffset;
            byte[] stubArray;
            if (TStringOps.isNativePointer(array)) {
                stubArray = null;
                stubOffset = (long)offset + TStringOps.nativePointer(array);
            } else {
                stubArray = (byte[])array;
                stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegion(stubArray, offset, length, 3);
            long l = TStringUnsafe.getLong(stubArray, stubOffset);
            return l;
        }
        finally {
            Reference.reachabilityFence(array);
        }
    }

    static void writeS0(Object array, int offset, int length, int i, byte value) {
        TStringOps.writeValue(array, offset, length, 0, i, TStringOps.uInt(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int readValue(Object array, int offset, int length, int stride, int i) {
        try {
            long stubOffset;
            byte[] stubArray;
            if (TStringOps.isNativePointer(array)) {
                stubArray = null;
                stubOffset = (long)offset + TStringOps.nativePointer(array);
            } else {
                stubArray = (byte[])array;
                stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegionIndex(stubArray, offset, length, stride, i);
            int n = TStringOps.readValue(stubArray, stubOffset, stride, i);
            return n;
        }
        finally {
            Reference.reachabilityFence(array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeValue(Object array, int offset, int length, int stride, int i, int value) {
        try {
            long stubOffset;
            byte[] stubArray;
            if (TStringOps.isNativePointer(array)) {
                stubArray = null;
                stubOffset = (long)offset + TStringOps.nativePointer(array);
            } else {
                stubArray = (byte[])array;
                stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegionIndex(stubArray, offset, length, stride, i);
            TStringOps.writeValue(stubArray, stubOffset, stride, i, value);
        }
        finally {
            Reference.reachabilityFence(array);
        }
    }

    private static int readValueS0(byte[] array, long offset, int i) {
        return TStringOps.readValue(array, offset, 0, i);
    }

    private static int readValueS1(byte[] array, long offset, int i) {
        return TStringOps.readValue(array, offset, 1, i);
    }

    private static int readValueS2(byte[] array, long offset, int i) {
        return TStringOps.readValue(array, offset, 2, i);
    }

    private static int readValue(byte[] array, long offset, int stride, int i) {
        switch (stride) {
            case 0: {
                return TStringOps.uInt(TStringUnsafe.getByte(array, offset + (long)i));
            }
            case 1: {
                return TStringUnsafe.getChar(array, offset + ((long)i << 1));
            }
        }
        return TStringUnsafe.getInt(array, offset + ((long)i << 2));
    }

    private static void writeValue(byte[] array, long offset, int stride, int i, int value) {
        switch (stride) {
            case 0: {
                TStringUnsafe.putByte(array, offset + (long)i, (byte)value);
                return;
            }
            case 1: {
                TStringUnsafe.putChar(array, offset + ((long)i << 1), (char)value);
                return;
            }
        }
        TStringUnsafe.putInt(array, offset + ((long)i << 2), value);
    }

    static int indexOfAnyByte(Node location, AbstractTruffleString a, Object arrayA, int fromIndex, int toIndex, byte[] values) {
        assert (a.stride() == 0);
        return TStringOps.indexOfAnyByteIntl(location, arrayA, a.offset(), toIndex, fromIndex, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int indexOfAnyByteIntl(Node location, Object array, int offset, int length, int fromIndex, byte[] values) {
        try {
            long stubOffset;
            byte[] stubArray;
            boolean isNative = TStringOps.isNativePointer(array);
            if (isNative) {
                stubArray = null;
                stubOffset = (long)offset + TStringOps.nativePointer(array);
            } else {
                stubArray = (byte[])array;
                stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegionIndex(stubArray, offset, length, 0, fromIndex);
            switch (values.length) {
                case 1: {
                    int n = TStringOps.runIndexOfAny1(location, stubArray, stubOffset, length, 0, isNative, fromIndex, TStringOps.uInt(values[0]));
                    return n;
                }
                case 2: {
                    int n = TStringOps.runIndexOfAny2(location, stubArray, stubOffset, length, 0, isNative, fromIndex, TStringOps.uInt(values[0]), TStringOps.uInt(values[1]));
                    return n;
                }
                case 3: {
                    int n = TStringOps.runIndexOfAny3(location, stubArray, stubOffset, length, 0, isNative, fromIndex, TStringOps.uInt(values[0]), TStringOps.uInt(values[1]), TStringOps.uInt(values[2]));
                    return n;
                }
                case 4: {
                    int n = TStringOps.runIndexOfAny4(location, stubArray, stubOffset, length, 0, isNative, fromIndex, TStringOps.uInt(values[0]), TStringOps.uInt(values[1]), TStringOps.uInt(values[2]), TStringOps.uInt(values[3]));
                    return n;
                }
            }
            int n = TStringOps.runIndexOfAnyByte(location, stubArray, stubOffset, length, fromIndex, values);
            return n;
        }
        finally {
            Reference.reachabilityFence(array);
        }
    }

    static int indexOfAnyChar(Node location, AbstractTruffleString a, Object arrayA, int stride, int fromIndex, int toIndex, char[] values) {
        assert (stride == 0 || stride == 1);
        return TStringOps.indexOfAnyCharIntl(location, arrayA, a.offset(), toIndex, stride, fromIndex, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int indexOfAnyCharIntl(Node location, Object array, int offset, int length, int stride, int fromIndex, char[] values) {
        try {
            long stubOffset;
            byte[] stubArray;
            boolean isNative = TStringOps.isNativePointer(array);
            if (isNative) {
                stubArray = null;
                stubOffset = (long)offset + TStringOps.nativePointer(array);
            } else {
                stubArray = (byte[])array;
                stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegionIndex(stubArray, offset, length, stride, fromIndex);
            if (stride == 0) {
                switch (values.length) {
                    case 1: {
                        int n = TStringOps.runIndexOfAny1(location, stubArray, stubOffset, length, 0, isNative, fromIndex, values[0]);
                        return n;
                    }
                    case 2: {
                        int n = TStringOps.runIndexOfAny2(location, stubArray, stubOffset, length, 0, isNative, fromIndex, values[0], values[1]);
                        return n;
                    }
                    case 3: {
                        int n = TStringOps.runIndexOfAny3(location, stubArray, stubOffset, length, 0, isNative, fromIndex, values[0], values[1], values[2]);
                        return n;
                    }
                    case 4: {
                        int n = TStringOps.runIndexOfAny4(location, stubArray, stubOffset, length, 0, isNative, fromIndex, values[0], values[1], values[2], values[3]);
                        return n;
                    }
                }
            } else {
                assert (stride == 1);
                switch (values.length) {
                    case 1: {
                        int n = TStringOps.runIndexOfAny1(location, stubArray, stubOffset, length, 1, isNative, fromIndex, values[0]);
                        return n;
                    }
                    case 2: {
                        int n = TStringOps.runIndexOfAny2(location, stubArray, stubOffset, length, 1, isNative, fromIndex, values[0], values[1]);
                        return n;
                    }
                    case 3: {
                        int n = TStringOps.runIndexOfAny3(location, stubArray, stubOffset, length, 1, isNative, fromIndex, values[0], values[1], values[2]);
                        return n;
                    }
                    case 4: {
                        int n = TStringOps.runIndexOfAny4(location, stubArray, stubOffset, length, 1, isNative, fromIndex, values[0], values[1], values[2], values[3]);
                        return n;
                    }
                }
            }
            int n = TStringOps.runIndexOfAnyChar(location, stubArray, stubOffset, length, stride, fromIndex, values);
            return n;
        }
        finally {
            Reference.reachabilityFence(array);
        }
    }

    static int indexOfAnyInt(Node location, AbstractTruffleString a, Object arrayA, int stride, int fromIndex, int toIndex, int[] values) {
        return TStringOps.indexOfAnyIntIntl(location, arrayA, a.offset(), toIndex, stride, fromIndex, values);
    }

    static int indexOfAnyInt(Node location, Object arrayA, int offsetA, int stride, int fromIndex, int toIndex, int[] values) {
        return TStringOps.indexOfAnyIntIntl(location, arrayA, offsetA, toIndex, stride, fromIndex, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int indexOfAnyIntIntl(Node location, Object array, int offset, int length, int stride, int fromIndex, int[] values) {
        try {
            long stubOffset;
            byte[] stubArray;
            boolean isNative = TStringOps.isNativePointer(array);
            if (isNative) {
                stubArray = null;
                stubOffset = (long)offset + TStringOps.nativePointer(array);
            } else {
                stubArray = (byte[])array;
                stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegionIndex(stubArray, offset, length, stride, fromIndex);
            if (stride == 0) {
                switch (values.length) {
                    case 1: {
                        int n = TStringOps.runIndexOfAny1(location, stubArray, stubOffset, length, 0, isNative, fromIndex, values[0]);
                        return n;
                    }
                    case 2: {
                        int n = TStringOps.runIndexOfAny2(location, stubArray, stubOffset, length, 0, isNative, fromIndex, values[0], values[1]);
                        return n;
                    }
                    case 3: {
                        int n = TStringOps.runIndexOfAny3(location, stubArray, stubOffset, length, 0, isNative, fromIndex, values[0], values[1], values[2]);
                        return n;
                    }
                    case 4: {
                        int n = TStringOps.runIndexOfAny4(location, stubArray, stubOffset, length, 0, isNative, fromIndex, values[0], values[1], values[2], values[3]);
                        return n;
                    }
                }
            } else if (stride == 1) {
                switch (values.length) {
                    case 1: {
                        int n = TStringOps.runIndexOfAny1(location, stubArray, stubOffset, length, 1, isNative, fromIndex, values[0]);
                        return n;
                    }
                    case 2: {
                        int n = TStringOps.runIndexOfAny2(location, stubArray, stubOffset, length, 1, isNative, fromIndex, values[0], values[1]);
                        return n;
                    }
                    case 3: {
                        int n = TStringOps.runIndexOfAny3(location, stubArray, stubOffset, length, 1, isNative, fromIndex, values[0], values[1], values[2]);
                        return n;
                    }
                    case 4: {
                        int n = TStringOps.runIndexOfAny4(location, stubArray, stubOffset, length, 1, isNative, fromIndex, values[0], values[1], values[2], values[3]);
                        return n;
                    }
                }
            } else {
                assert (stride == 2);
                switch (values.length) {
                    case 1: {
                        int n = TStringOps.runIndexOfAny1(location, stubArray, stubOffset, length, 2, isNative, fromIndex, values[0]);
                        return n;
                    }
                    case 2: {
                        int n = TStringOps.runIndexOfAny2(location, stubArray, stubOffset, length, 2, isNative, fromIndex, values[0], values[1]);
                        return n;
                    }
                    case 3: {
                        int n = TStringOps.runIndexOfAny3(location, stubArray, stubOffset, length, 2, isNative, fromIndex, values[0], values[1], values[2]);
                        return n;
                    }
                    case 4: {
                        int n = TStringOps.runIndexOfAny4(location, stubArray, stubOffset, length, 2, isNative, fromIndex, values[0], values[1], values[2], values[3]);
                        return n;
                    }
                }
            }
            int n = TStringOps.runIndexOfAnyInt(location, stubArray, stubOffset, length, stride, fromIndex, values);
            return n;
        }
        finally {
            Reference.reachabilityFence(array);
        }
    }

    static int indexOfAnyIntRange(Node location, Object arrayA, int offsetA, int stride, int fromIndex, int toIndex, int[] ranges) {
        return TStringOps.indexOfAnyIntRangeIntl(location, arrayA, offsetA, toIndex, stride, fromIndex, ranges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int indexOfAnyIntRangeIntl(Node location, Object array, int offset, int length, int stride, int fromIndex, int[] ranges) {
        try {
            long stubOffset;
            byte[] stubArray;
            boolean isNative = TStringOps.isNativePointer(array);
            if (isNative) {
                stubArray = null;
                stubOffset = (long)offset + TStringOps.nativePointer(array);
            } else {
                stubArray = (byte[])array;
                stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegionIndex(stubArray, offset, length, stride, fromIndex);
            if (stride == 0) {
                if (ranges.length == 2) {
                    int n = TStringOps.runIndexOfRange1(location, stubArray, stubOffset, length, 0, isNative, fromIndex, ranges[0], ranges[1]);
                    return n;
                }
                if (ranges.length == 4) {
                    int n = TStringOps.runIndexOfRange2(location, stubArray, stubOffset, length, 0, isNative, fromIndex, ranges[0], ranges[1], ranges[2], ranges[3]);
                    return n;
                }
            } else if (stride == 1) {
                if (ranges.length == 2) {
                    int n = TStringOps.runIndexOfRange1(location, stubArray, stubOffset, length, 1, isNative, fromIndex, ranges[0], ranges[1]);
                    return n;
                }
                if (ranges.length == 4) {
                    int n = TStringOps.runIndexOfRange2(location, stubArray, stubOffset, length, 1, isNative, fromIndex, ranges[0], ranges[1], ranges[2], ranges[3]);
                    return n;
                }
            } else {
                assert (stride == 2);
                if (ranges.length == 2) {
                    int n = TStringOps.runIndexOfRange1(location, stubArray, stubOffset, length, 2, isNative, fromIndex, ranges[0], ranges[1]);
                    return n;
                }
                if (ranges.length == 4) {
                    int n = TStringOps.runIndexOfRange2(location, stubArray, stubOffset, length, 2, isNative, fromIndex, ranges[0], ranges[1], ranges[2], ranges[3]);
                    return n;
                }
            }
            int n = TStringOps.runIndexOfAnyIntRange(location, stubArray, stubOffset, length, stride, fromIndex, ranges);
            return n;
        }
        finally {
            Reference.reachabilityFence(array);
        }
    }

    static int indexOfTable(Node location, Object arrayA, int offsetA, int stride, int fromIndex, int toIndex, byte[] tables) {
        return TStringOps.indexOfTableIntl(location, arrayA, offsetA, toIndex, stride, fromIndex, tables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int indexOfTableIntl(Node location, Object array, int offset, int length, int stride, int fromIndex, byte[] tables) {
        try {
            long stubOffset;
            byte[] stubArray;
            assert (tables.length == 32);
            boolean isNative = TStringOps.isNativePointer(array);
            if (isNative) {
                stubArray = null;
                stubOffset = (long)offset + TStringOps.nativePointer(array);
            } else {
                stubArray = (byte[])array;
                stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegionIndex(stubArray, offset, length, stride, fromIndex);
            if (stride == 0) {
                int n = TStringOps.runIndexOfTable(location, stubArray, stubOffset, length, 0, isNative, fromIndex, tables);
                return n;
            }
            if (stride == 1) {
                int n = TStringOps.runIndexOfTable(location, stubArray, stubOffset, length, 1, isNative, fromIndex, tables);
                return n;
            }
            assert (stride == 2);
            int n = TStringOps.runIndexOfTable(location, stubArray, stubOffset, length, 2, isNative, fromIndex, tables);
            return n;
        }
        finally {
            Reference.reachabilityFence(array);
        }
    }

    static int indexOfCodePointWithStride(Node location, AbstractTruffleString a, Object arrayA, int strideA, int fromIndex, int toIndex, int codepoint) {
        return TStringOps.indexOfCodePointWithStrideIntl(location, arrayA, a.offset(), toIndex, strideA, fromIndex, codepoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int indexOfCodePointWithStrideIntl(Node location, Object array, int offset, int length, int stride, int fromIndex, int v1) {
        try {
            long stubOffset;
            byte[] stubArray;
            boolean isNative = TStringOps.isNativePointer(array);
            if (isNative) {
                stubArray = null;
                stubOffset = (long)offset + TStringOps.nativePointer(array);
            } else {
                stubArray = (byte[])array;
                stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegionIndex(stubArray, offset, length, stride, fromIndex);
            switch (stride) {
                case 0: {
                    int n = TStringOps.runIndexOfAny1(location, stubArray, stubOffset, length, 0, isNative, fromIndex, v1);
                    return n;
                }
                case 1: {
                    int n = TStringOps.runIndexOfAny1(location, stubArray, stubOffset, length, 1, isNative, fromIndex, v1);
                    return n;
                }
            }
            assert (stride == 2);
            int n = TStringOps.runIndexOfAny1(location, stubArray, stubOffset, length, 2, isNative, fromIndex, v1);
            return n;
        }
        finally {
            Reference.reachabilityFence(array);
        }
    }

    static int indexOfCodePointWithOrMaskWithStride(Node location, AbstractTruffleString a, Object arrayA, int strideA, int fromIndex, int toIndex, int codepoint, int maskA) {
        return TStringOps.indexOfCodePointWithMaskWithStrideIntl(location, arrayA, a.offset(), toIndex, strideA, fromIndex, codepoint, maskA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int indexOfCodePointWithMaskWithStrideIntl(Node location, Object array, int offset, int length, int stride, int fromIndex, int v1, int mask1) {
        try {
            long stubOffset;
            byte[] stubArray;
            boolean isNative = TStringOps.isNativePointer(array);
            if (isNative) {
                stubArray = null;
                stubOffset = (long)offset + TStringOps.nativePointer(array);
            } else {
                stubArray = (byte[])array;
                stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegionIndex(stubArray, offset, length, stride, fromIndex);
            switch (stride) {
                case 0: {
                    int n = (v1 ^ mask1) <= 255 ? TStringOps.runIndexOfWithOrMaskWithStride(location, stubArray, stubOffset, length, 0, isNative, fromIndex, v1, mask1) : -1;
                    return n;
                }
                case 1: {
                    int n = (v1 ^ mask1) <= 65535 ? TStringOps.runIndexOfWithOrMaskWithStride(location, stubArray, stubOffset, length, 1, isNative, fromIndex, v1, mask1) : -1;
                    return n;
                }
            }
            assert (stride == 2);
            int n = TStringOps.runIndexOfWithOrMaskWithStride(location, stubArray, stubOffset, length, 2, isNative, fromIndex, v1, mask1);
            return n;
        }
        finally {
            Reference.reachabilityFence(array);
        }
    }

    static int indexOf2ConsecutiveWithStride(Node location, AbstractTruffleString a, Object arrayA, int strideA, int fromIndex, int toIndex, int v1, int v2) {
        return TStringOps.indexOf2ConsecutiveWithStrideIntl(location, arrayA, a.offset(), toIndex, strideA, fromIndex, v1, v2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int indexOf2ConsecutiveWithStrideIntl(Node location, Object array, int offset, int length, int stride, int fromIndex, int v1, int v2) {
        try {
            long stubOffset;
            byte[] stubArray;
            boolean isNative = TStringOps.isNativePointer(array);
            if (isNative) {
                stubArray = null;
                stubOffset = (long)offset + TStringOps.nativePointer(array);
            } else {
                stubArray = (byte[])array;
                stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegionIndex(stubArray, offset, length, stride, fromIndex);
            switch (stride) {
                case 0: {
                    int n = (v1 | v2) <= 255 ? TStringOps.runIndexOf2ConsecutiveWithStride(location, stubArray, stubOffset, length, 0, isNative, fromIndex, v1, v2) : -1;
                    return n;
                }
                case 1: {
                    int n = (v1 | v2) <= 65535 ? TStringOps.runIndexOf2ConsecutiveWithStride(location, stubArray, stubOffset, length, 1, isNative, fromIndex, v1, v2) : -1;
                    return n;
                }
            }
            assert (stride == 2);
            int n = TStringOps.runIndexOf2ConsecutiveWithStride(location, stubArray, stubOffset, length, 2, isNative, fromIndex, v1, v2);
            return n;
        }
        finally {
            Reference.reachabilityFence(array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int indexOf2ConsecutiveWithOrMaskWithStrideIntl(Node location, Object array, int offset, int length, int stride, int fromIndex, int v1, int v2, int mask1, int mask2) {
        try {
            long stubOffset;
            byte[] stubArray;
            boolean isNative = TStringOps.isNativePointer(array);
            if (isNative) {
                stubArray = null;
                stubOffset = (long)offset + TStringOps.nativePointer(array);
            } else {
                stubArray = (byte[])array;
                stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegionIndex(stubArray, offset, length, stride, fromIndex);
            switch (stride) {
                case 0: {
                    int n = (v1 ^ mask1 | v2 ^ mask2) <= 255 ? TStringOps.runIndexOf2ConsecutiveWithOrMaskWithStride(location, stubArray, stubOffset, length, 0, isNative, fromIndex, v1, v2, mask1, mask2) : -1;
                    return n;
                }
                case 1: {
                    int n = (v1 ^ mask1 | v2 ^ mask2) <= 65535 ? TStringOps.runIndexOf2ConsecutiveWithOrMaskWithStride(location, stubArray, stubOffset, length, 1, isNative, fromIndex, v1, v2, mask1, mask2) : -1;
                    return n;
                }
            }
            assert (stride == 2);
            int n = TStringOps.runIndexOf2ConsecutiveWithOrMaskWithStride(location, stubArray, stubOffset, length, 2, isNative, fromIndex, v1, v2, mask1, mask2);
            return n;
        }
        finally {
            Reference.reachabilityFence(array);
        }
    }

    static int indexOfStringWithOrMaskWithStride(Node location, AbstractTruffleString a, Object arrayA, int strideA, AbstractTruffleString b, Object arrayB, int strideB, int fromIndex, int toIndex, byte[] maskB) {
        return TStringOps.indexOfStringWithOrMaskWithStride(location, arrayA, a.offset(), a.length(), strideA, arrayB, b.offset(), b.length(), strideB, fromIndex, toIndex, maskB);
    }

    static int indexOfStringWithOrMaskWithStride(Node location, Object arrayA, int offsetA, int lengthA, int strideA, Object arrayB, int offsetB, int lengthB, int strideB, int fromIndex, int toIndex, byte[] maskB) {
        int mask1;
        int offsetMask = 0;
        assert (lengthB > 1);
        assert (lengthA >= lengthB);
        int max = toIndex - (lengthB - 2);
        int index = fromIndex;
        int b0 = TStringOps.readValue(arrayB, offsetB, lengthB, strideB, 0);
        int b1 = TStringOps.readValue(arrayB, offsetB, lengthB, strideB, 1);
        int mask0 = maskB == null ? 0 : TStringOps.readValue(maskB, offsetMask, lengthB, strideB, 0);
        int n = mask1 = maskB == null ? 0 : TStringOps.readValue(maskB, offsetMask, lengthB, strideB, 1);
        while (index < max - 1) {
            index = maskB == null ? TStringOps.indexOf2ConsecutiveWithStrideIntl(location, arrayA, offsetA, max, strideA, index, b0, b1) : TStringOps.indexOf2ConsecutiveWithOrMaskWithStrideIntl(location, arrayA, offsetA, max, strideA, index, b0, b1, mask0, mask1);
            if (index < 0) {
                return -1;
            }
            if (lengthB == 2 || TStringOps.regionEqualsWithOrMaskWithStrideIntl(location, arrayA, offsetA, lengthA, strideA, index, arrayB, offsetB, lengthB, strideB, 0, maskB, lengthB)) {
                return index;
            }
            TStringConstants.truffleSafePointPoll(location, ++index);
        }
        return -1;
    }

    static int lastIndexOfCodePointWithOrMaskWithStride(Node location, AbstractTruffleString a, Object arrayA, int stride, int fromIndex, int toIndex, int codepoint, int mask) {
        return TStringOps.lastIndexOfCodePointWithOrMaskWithStrideIntl(location, arrayA, a.offset(), stride, fromIndex, toIndex, codepoint, mask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int lastIndexOfCodePointWithOrMaskWithStrideIntl(Node location, Object array, int offset, int stride, int fromIndex, int toIndex, int codepoint, int mask) {
        try {
            long stubOffset;
            byte[] stubArray;
            boolean isNative = TStringOps.isNativePointer(array);
            if (isNative) {
                stubArray = null;
                stubOffset = (long)offset + TStringOps.nativePointer(array);
            } else {
                stubArray = (byte[])array;
                stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegionIndex(stubArray, offset, fromIndex, stride, toIndex);
            switch (stride) {
                case 0: {
                    int n = TStringOps.runLastIndexOfWithOrMaskWithStride(location, stubArray, stubOffset, 0, fromIndex, toIndex, codepoint, mask);
                    return n;
                }
                case 1: {
                    int n = TStringOps.runLastIndexOfWithOrMaskWithStride(location, stubArray, stubOffset, 1, fromIndex, toIndex, codepoint, mask);
                    return n;
                }
            }
            assert (stride == 2);
            int n = TStringOps.runLastIndexOfWithOrMaskWithStride(location, stubArray, stubOffset, 2, fromIndex, toIndex, codepoint, mask);
            return n;
        }
        finally {
            Reference.reachabilityFence(array);
        }
    }

    static int lastIndexOf2ConsecutiveWithOrMaskWithStride(Node location, AbstractTruffleString a, Object arrayA, int stride, int fromIndex, int toIndex, int v1, int v2, int mask1, int mask2) {
        return TStringOps.lastIndexOf2ConsecutiveWithOrMaskWithStrideIntl(location, arrayA, a.offset(), stride, fromIndex, toIndex, v1, v2, mask1, mask2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int lastIndexOf2ConsecutiveWithOrMaskWithStrideIntl(Node location, Object array, int offset, int stride, int fromIndex, int toIndex, int v1, int v2, int mask1, int mask2) {
        try {
            long stubOffset;
            byte[] stubArray;
            boolean isNative = TStringOps.isNativePointer(array);
            if (isNative) {
                stubArray = null;
                stubOffset = (long)offset + TStringOps.nativePointer(array);
            } else {
                stubArray = (byte[])array;
                stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegionIndex(stubArray, offset, fromIndex, stride, toIndex);
            switch (stride) {
                case 0: {
                    int n = TStringOps.runLastIndexOf2ConsecutiveWithOrMaskWithStride(location, stubArray, stubOffset, 0, fromIndex, toIndex, v1, v2, mask1, mask2);
                    return n;
                }
                case 1: {
                    int n = TStringOps.runLastIndexOf2ConsecutiveWithOrMaskWithStride(location, stubArray, stubOffset, 1, fromIndex, toIndex, v1, v2, mask1, mask2);
                    return n;
                }
            }
            assert (stride == 2);
            int n = TStringOps.runLastIndexOf2ConsecutiveWithOrMaskWithStride(location, stubArray, stubOffset, 2, fromIndex, toIndex, v1, v2, mask1, mask2);
            return n;
        }
        finally {
            Reference.reachabilityFence(array);
        }
    }

    static int lastIndexOfStringWithOrMaskWithStride(Node location, AbstractTruffleString a, Object arrayA, int strideA, AbstractTruffleString b, Object arrayB, int strideB, int fromIndex, int toIndex, byte[] maskB) {
        int offsetMask = 0;
        assert (b.length() > 1);
        assert (a.length() >= b.length());
        int index = fromIndex;
        int b0 = TStringOps.readValue(b, arrayB, strideB, b.length() - 2);
        int b1 = TStringOps.readValue(b, arrayB, strideB, b.length() - 1);
        int mask0 = maskB == null ? 0 : TStringOps.readValue(maskB, offsetMask, b.length(), strideB, b.length() - 2);
        int mask1 = maskB == null ? 0 : TStringOps.readValue(maskB, offsetMask, b.length(), strideB, b.length() - 1);
        int toIndex2Consecutive = toIndex + b.length() - 2;
        while (index > toIndex2Consecutive) {
            index = TStringOps.lastIndexOf2ConsecutiveWithOrMaskWithStrideIntl(location, arrayA, a.offset(), strideA, index, toIndex2Consecutive, b0, b1, mask0, mask1);
            if (index < 0) {
                return -1;
            }
            if (b.length() == 2 || TStringOps.regionEqualsWithOrMaskWithStride(location, a, arrayA, strideA, (index += 2) - b.length(), b, arrayB, strideB, 0, maskB, b.length())) {
                return index - b.length();
            }
            TStringConstants.truffleSafePointPoll(location, --index);
        }
        return -1;
    }

    static boolean regionEqualsWithOrMaskWithStride(Node location, AbstractTruffleString a, Object arrayA, int strideA, int fromIndexA, AbstractTruffleString b, Object arrayB, int strideB, int fromIndexB, byte[] maskB, int lengthCMP) {
        return TStringOps.regionEqualsWithOrMaskWithStrideIntl(location, arrayA, a.offset(), a.length(), strideA, fromIndexA, arrayB, b.offset(), b.length(), strideB, fromIndexB, maskB, lengthCMP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean regionEqualsWithOrMaskWithStrideIntl(Node location, Object arrayA, int offsetA, int lengthA, int strideA, int fromIndexA, Object arrayB, int offsetB, int lengthB, int strideB, int fromIndexB, byte[] maskB, int lengthCMP) {
        try {
            long stubOffsetB;
            byte[] stubArrayB;
            long stubOffsetA;
            byte[] stubArrayA;
            if (!TStringOps.rangeInBounds(fromIndexA, lengthCMP, lengthA) || !TStringOps.rangeInBounds(fromIndexB, lengthCMP, lengthB)) {
                boolean bl = false;
                return bl;
            }
            boolean isNativeA = TStringOps.isNativePointer(arrayA);
            if (isNativeA) {
                stubArrayA = null;
                stubOffsetA = (long)offsetA + TStringOps.nativePointer(arrayA) + (long)(fromIndexA << strideA);
            } else {
                stubArrayA = (byte[])arrayA;
                stubOffsetA = offsetA + Unsafe.ARRAY_BYTE_BASE_OFFSET + (fromIndexA << strideA);
            }
            boolean isNativeB = TStringOps.isNativePointer(arrayB);
            if (isNativeB) {
                stubArrayB = null;
                stubOffsetB = (long)offsetB + TStringOps.nativePointer(arrayB) + (long)(fromIndexB << strideB);
            } else {
                stubArrayB = (byte[])arrayB;
                stubOffsetB = offsetB + Unsafe.ARRAY_BYTE_BASE_OFFSET + (fromIndexB << strideB);
            }
            TStringOps.validateRegion(stubArrayA, offsetA, lengthCMP, strideA);
            TStringOps.validateRegion(stubArrayB, offsetB, lengthCMP, strideB);
            int stubStride = TStringOps.stubStride(strideA, strideB);
            if (maskB == null) {
                boolean bl = TStringOps.runRegionEqualsWithStride(location, stubArrayA, stubOffsetA, isNativeA, stubArrayB, stubOffsetB, isNativeB, lengthCMP, stubStride);
                return bl;
            }
            TStringOps.validateRegion(maskB, 0, lengthCMP, strideB);
            boolean bl = TStringOps.runRegionEqualsWithOrMaskWithStride(location, stubArrayA, stubOffsetA, isNativeA, stubArrayB, stubOffsetB, isNativeB, maskB, lengthCMP, stubStride);
            return bl;
        }
        finally {
            Reference.reachabilityFence(arrayA);
            Reference.reachabilityFence(arrayB);
        }
    }

    static int memcmpWithStride(Node location, AbstractTruffleString a, Object arrayA, int strideA, AbstractTruffleString b, Object arrayB, int strideB, int lengthCMP) {
        assert (lengthCMP <= a.length());
        assert (lengthCMP <= b.length());
        return TStringOps.memcmpWithStrideIntl(location, arrayA, a.offset(), strideA, arrayB, b.offset(), strideB, lengthCMP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int memcmpWithStrideIntl(Node location, Object arrayA, int offsetA, int strideA, Object arrayB, int offsetB, int strideB, int lengthCMP) {
        try {
            long stubOffsetB;
            byte[] stubArrayB;
            long stubOffsetA;
            byte[] stubArrayA;
            if (lengthCMP == 0) {
                int n = 0;
                return n;
            }
            boolean isNativeA = TStringOps.isNativePointer(arrayA);
            if (isNativeA) {
                stubArrayA = null;
                stubOffsetA = (long)offsetA + TStringOps.nativePointer(arrayA);
            } else {
                stubArrayA = (byte[])arrayA;
                stubOffsetA = offsetA + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            boolean isNativeB = TStringOps.isNativePointer(arrayB);
            if (isNativeB) {
                stubArrayB = null;
                stubOffsetB = (long)offsetB + TStringOps.nativePointer(arrayB);
            } else {
                stubArrayB = (byte[])arrayB;
                stubOffsetB = offsetB + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegion(stubArrayA, offsetA, lengthCMP, strideA);
            TStringOps.validateRegion(stubArrayB, offsetB, lengthCMP, strideB);
            int n = TStringOps.runMemCmp(location, stubArrayA, stubOffsetA, isNativeA, stubArrayB, stubOffsetB, isNativeB, lengthCMP, TStringOps.stubStride(strideA, strideB));
            return n;
        }
        finally {
            Reference.reachabilityFence(arrayA);
            Reference.reachabilityFence(arrayB);
        }
    }

    static int memcmpBytesWithStride(Node location, AbstractTruffleString a, Object arrayA, int strideA, AbstractTruffleString b, Object arrayB, int strideB, int lengthCMP) {
        assert (lengthCMP <= a.length());
        assert (lengthCMP <= b.length());
        return TStringOps.memcmpBytesWithStrideIntl(location, arrayA, a.offset(), strideA, arrayB, b.offset(), strideB, lengthCMP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int memcmpBytesWithStrideIntl(Node location, Object arrayA, int offsetA, int strideA, Object arrayB, int offsetB, int strideB, int lengthCMP) {
        try {
            int swappedResult;
            boolean swappedIsNativeB;
            boolean swappedIsNativeA;
            long swappedOffsetB;
            long swappedOffsetA;
            byte[] swappedArrayB;
            byte[] swappedArrayA;
            int swappedStrideB;
            int swappedStrideA;
            long stubOffsetB;
            byte[] stubArrayB;
            long stubOffsetA;
            byte[] stubArrayA;
            if (lengthCMP == 0) {
                int n = 0;
                return n;
            }
            boolean isNativeA = TStringOps.isNativePointer(arrayA);
            if (isNativeA) {
                stubArrayA = null;
                stubOffsetA = (long)offsetA + TStringOps.nativePointer(arrayA);
            } else {
                stubArrayA = (byte[])arrayA;
                stubOffsetA = offsetA + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            boolean isNativeB = TStringOps.isNativePointer(arrayB);
            if (isNativeB) {
                stubArrayB = null;
                stubOffsetB = (long)offsetB + TStringOps.nativePointer(arrayB);
            } else {
                stubArrayB = (byte[])arrayB;
                stubOffsetB = offsetB + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegion(stubArrayA, offsetA, lengthCMP, strideA);
            TStringOps.validateRegion(stubArrayB, offsetB, lengthCMP, strideB);
            if (strideA == strideB) {
                switch (strideA) {
                    case 0: {
                        int n = TStringOps.runMemCmp(location, stubArrayA, stubOffsetA, isNativeA, stubArrayB, stubOffsetB, isNativeB, lengthCMP, 0);
                        return n;
                    }
                    case 1: {
                        int n = TStringOps.runMemCmpBytes(location, stubArrayA, stubOffsetA, 1, isNativeA, stubArrayB, stubOffsetB, 1, isNativeB, lengthCMP);
                        return n;
                    }
                }
                assert (strideA == 2);
                int n = TStringOps.runMemCmpBytes(location, stubArrayA, stubOffsetA, 2, isNativeA, stubArrayB, stubOffsetB, 2, isNativeB, lengthCMP);
                return n;
            }
            if (strideA < strideB) {
                swappedStrideA = strideB;
                swappedStrideB = strideA;
                swappedArrayA = stubArrayB;
                swappedArrayB = stubArrayA;
                swappedOffsetA = stubOffsetB;
                swappedOffsetB = stubOffsetA;
                swappedIsNativeA = isNativeB;
                swappedIsNativeB = isNativeA;
                swappedResult = -1;
            } else {
                swappedStrideA = strideA;
                swappedStrideB = strideB;
                swappedArrayA = stubArrayA;
                swappedArrayB = stubArrayB;
                swappedOffsetA = stubOffsetA;
                swappedOffsetB = stubOffsetB;
                swappedIsNativeA = isNativeA;
                swappedIsNativeB = isNativeB;
                swappedResult = 1;
            }
            if (swappedStrideA == 1) {
                assert (swappedStrideB == 0);
                int n = swappedResult * TStringOps.runMemCmpBytes(location, swappedArrayA, swappedOffsetA, 1, swappedIsNativeA, swappedArrayB, swappedOffsetB, 0, swappedIsNativeB, lengthCMP);
                return n;
            }
            assert (swappedStrideA == 2);
            if (swappedStrideB == 0) {
                int n = swappedResult * TStringOps.runMemCmpBytes(location, swappedArrayA, swappedOffsetA, 2, swappedIsNativeA, swappedArrayB, swappedOffsetB, 0, swappedIsNativeB, lengthCMP);
                return n;
            }
            assert (swappedStrideB == 1);
            int n = swappedResult * TStringOps.runMemCmpBytes(location, swappedArrayA, swappedOffsetA, 2, swappedIsNativeA, swappedArrayB, swappedOffsetB, 1, swappedIsNativeB, lengthCMP);
            return n;
        }
        finally {
            Reference.reachabilityFence(arrayA);
            Reference.reachabilityFence(arrayB);
        }
    }

    static int hashCodeWithStride(Node location, AbstractTruffleString a, Object arrayA, int stride) {
        int offset = a.offset();
        int length = a.length();
        return TStringOps.hashCodeWithStrideIntl(location, arrayA, offset, length, stride);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int hashCodeWithStrideIntl(Node location, Object array, int offset, int length, int stride) {
        try {
            long stubOffset;
            byte[] stubArray;
            boolean isNative = TStringOps.isNativePointer(array);
            if (isNative) {
                stubArray = null;
                stubOffset = (long)offset + TStringOps.nativePointer(array);
            } else {
                stubArray = (byte[])array;
                stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegion(stubArray, offset, length, stride);
            switch (stride) {
                case 0: {
                    int n = TStringOps.runHashCode(location, stubArray, stubOffset, length, 0, isNative);
                    return n;
                }
                case 1: {
                    int n = TStringOps.runHashCode(location, stubArray, stubOffset, length, 1, isNative);
                    return n;
                }
            }
            assert (stride == 2);
            int n = TStringOps.runHashCode(location, stubArray, stubOffset, length, 2, isNative);
            return n;
        }
        finally {
            Reference.reachabilityFence(array);
        }
    }

    static Object arraycopyWithStrideCB(Node location, char[] arrayA, int offsetA, byte[] arrayB, int offsetB, int strideB, int lengthCPY) {
        TStringOps.validateRegion(arrayA, offsetA, lengthCPY);
        TStringOps.validateRegion(arrayB, offsetB, lengthCPY, strideB);
        int stubOffsetA = Unsafe.ARRAY_CHAR_BASE_OFFSET + offsetA;
        int stubOffsetB = Unsafe.ARRAY_BYTE_BASE_OFFSET + offsetB;
        TStringOps.runArrayCopy(location, arrayA, (long)stubOffsetA, arrayB, (long)stubOffsetB, lengthCPY, TStringOps.stubStride(1, strideB));
        return arrayB;
    }

    static Object arraycopyWithStrideIB(Node location, int[] arrayA, int offsetA, byte[] arrayB, int offsetB, int strideB, int lengthCPY) {
        TStringOps.validateRegion(arrayA, offsetA, lengthCPY);
        TStringOps.validateRegion(arrayB, offsetB, lengthCPY, strideB);
        int stubOffsetA = Unsafe.ARRAY_INT_BASE_OFFSET + offsetA;
        int stubOffsetB = Unsafe.ARRAY_BYTE_BASE_OFFSET + offsetB;
        TStringOps.runArrayCopy(location, arrayA, (long)stubOffsetA, arrayB, (long)stubOffsetB, lengthCPY, TStringOps.stubStride(2, strideB));
        return arrayB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object arraycopyWithStride(Node location, Object arrayA, int offsetA, int strideA, int fromIndexA, Object arrayB, int offsetB, int strideB, int fromIndexB, int lengthCPY) {
        try {
            long stubOffsetB;
            byte[] stubArrayB;
            long stubOffsetA;
            byte[] stubArrayA;
            boolean isNativeA = TStringOps.isNativePointer(arrayA);
            if (isNativeA) {
                stubArrayA = null;
                stubOffsetA = (long)offsetA + TStringOps.nativePointer(arrayA) + (long)(fromIndexA << strideA);
            } else {
                stubArrayA = (byte[])arrayA;
                stubOffsetA = offsetA + Unsafe.ARRAY_BYTE_BASE_OFFSET + (fromIndexA << strideA);
            }
            boolean isNativeB = TStringOps.isNativePointer(arrayB);
            if (isNativeB) {
                stubArrayB = null;
                stubOffsetB = (long)offsetB + TStringOps.nativePointer(arrayB) + (long)(fromIndexB << strideB);
            } else {
                stubArrayB = (byte[])arrayB;
                stubOffsetB = offsetB + Unsafe.ARRAY_BYTE_BASE_OFFSET + (fromIndexB << strideB);
            }
            TStringOps.validateRegion(stubArrayA, offsetA, lengthCPY, strideA);
            TStringOps.validateRegion(stubArrayB, offsetB, lengthCPY, strideB);
            TStringOps.runArrayCopy(location, stubArrayA, stubOffsetA, isNativeA, stubArrayB, stubOffsetB, isNativeB, lengthCPY, TStringOps.stubStride(strideA, strideB));
            byte[] byArray = stubArrayB;
            return byArray;
        }
        finally {
            Reference.reachabilityFence(arrayA);
            Reference.reachabilityFence(arrayB);
        }
    }

    static byte[] arraycopyOfWithStride(Node location, Object arrayA, int offsetA, int lengthA, int strideA, int lengthB, int strideB) {
        byte[] dst = new byte[lengthB << strideB];
        TStringOps.arraycopyWithStride(location, arrayA, offsetA, strideA, 0, dst, 0, strideB, 0, lengthA);
        return dst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object byteSwapS1(Node location, Object arrayA, int offsetA, Object arrayB, int offsetB, int lengthCPY) {
        try {
            long stubOffsetB;
            byte[] stubArrayB;
            long stubOffsetA;
            byte[] stubArrayA;
            boolean isNativeA = TStringOps.isNativePointer(arrayA);
            if (isNativeA) {
                stubArrayA = null;
                stubOffsetA = (long)offsetA + TStringOps.nativePointer(arrayA);
            } else {
                stubArrayA = (byte[])arrayA;
                stubOffsetA = offsetA + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            boolean isNativeB = TStringOps.isNativePointer(arrayB);
            if (isNativeB) {
                stubArrayB = null;
                stubOffsetB = (long)offsetB + TStringOps.nativePointer(arrayB);
            } else {
                stubArrayB = (byte[])arrayB;
                stubOffsetB = offsetB + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegion(stubArrayA, offsetA, lengthCPY, 1);
            TStringOps.validateRegion(stubArrayB, offsetB, lengthCPY, 1);
            TStringOps.runByteSwapS1(location, stubArrayA, stubOffsetA, isNativeA, stubArrayB, stubOffsetB, isNativeB, lengthCPY);
            byte[] byArray = stubArrayB;
            return byArray;
        }
        finally {
            Reference.reachabilityFence(arrayA);
            Reference.reachabilityFence(arrayB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object byteSwapS2(Node location, Object arrayA, int offsetA, Object arrayB, int offsetB, int lengthCPY) {
        try {
            long stubOffsetB;
            byte[] stubArrayB;
            long stubOffsetA;
            byte[] stubArrayA;
            boolean isNativeA = TStringOps.isNativePointer(arrayA);
            if (isNativeA) {
                stubArrayA = null;
                stubOffsetA = (long)offsetA + TStringOps.nativePointer(arrayA);
            } else {
                stubArrayA = (byte[])arrayA;
                stubOffsetA = offsetA + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            boolean isNativeB = TStringOps.isNativePointer(arrayB);
            if (isNativeB) {
                stubArrayB = null;
                stubOffsetB = (long)offsetB + TStringOps.nativePointer(arrayB);
            } else {
                stubArrayB = (byte[])arrayB;
                stubOffsetB = offsetB + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegion(stubArrayA, offsetA, lengthCPY, 2);
            TStringOps.validateRegion(stubArrayB, offsetB, lengthCPY, 2);
            TStringOps.runByteSwapS2(location, stubArrayA, stubOffsetA, isNativeA, stubArrayB, stubOffsetB, isNativeB, lengthCPY);
            byte[] byArray = stubArrayB;
            return byArray;
        }
        finally {
            Reference.reachabilityFence(arrayA);
            Reference.reachabilityFence(arrayB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int calcStringAttributesLatin1(Node location, Object array, int offset, int length) {
        try {
            long stubOffset;
            byte[] stubArray;
            boolean isNative = TStringOps.isNativePointer(array);
            if (isNative) {
                stubArray = null;
                stubOffset = (long)offset + TStringOps.nativePointer(array);
            } else {
                stubArray = (byte[])array;
                stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegion(stubArray, offset, length, 0);
            int n = TStringOps.runCalcStringAttributesLatin1(location, stubArray, stubOffset, length, isNative);
            return n;
        }
        finally {
            Reference.reachabilityFence(array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int calcStringAttributesBMP(Node location, Object array, int offset, int length) {
        try {
            long stubOffset;
            byte[] stubArray;
            boolean isNative = TStringOps.isNativePointer(array);
            if (isNative) {
                stubArray = null;
                stubOffset = (long)offset + TStringOps.nativePointer(array);
            } else {
                stubArray = (byte[])array;
                stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegion(stubArray, offset, length, 1);
            int n = TStringOps.runCalcStringAttributesBMP(location, stubArray, stubOffset, length, isNative);
            return n;
        }
        finally {
            Reference.reachabilityFence(array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long calcStringAttributesUTF8(Node location, Object array, int offset, int length, boolean assumeValid, boolean isAtEnd, InlinedConditionProfile brokenProfile) {
        try {
            long stubOffset;
            byte[] stubArray;
            boolean isNative = TStringOps.isNativePointer(array);
            if (isNative) {
                stubArray = null;
                stubOffset = (long)offset + TStringOps.nativePointer(array);
            } else {
                stubArray = (byte[])array;
                stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegion(stubArray, offset, length, 0);
            if (assumeValid && !Encodings.isUTF8ContinuationByte(TStringOps.readS0(array, offset, length, 0)) && (isAtEnd || !Encodings.isUTF8ContinuationByte(TStringOps.readS0(array, offset, length + 1, length)))) {
                long l = TStringOps.runCalcStringAttributesUTF8(location, stubArray, stubOffset, length, isNative, true);
                return l;
            }
            long attrs = TStringOps.runCalcStringAttributesUTF8(location, stubArray, stubOffset, length, isNative, false);
            if (brokenProfile.profile(location, TStringGuards.isBrokenMultiByte(StringAttributes.getCodeRange(attrs)))) {
                int codePointLength = 0;
                for (int i = 0; i < length; i += Encodings.utf8GetCodePointLength(array, offset, length, i, DecodingErrorHandler.DEFAULT)) {
                    TStringConstants.truffleSafePointPoll(location, ++codePointLength);
                }
                long l = StringAttributes.create(codePointLength, StringAttributes.getCodeRange(attrs));
                return l;
            }
            long l = attrs;
            return l;
        }
        finally {
            Reference.reachabilityFence(array);
        }
    }

    static long calcStringAttributesUTF16C(Node location, char[] array, int offset, int length) {
        TStringOps.validateRegion(array, offset, length);
        int stubOffset = Unsafe.ARRAY_CHAR_BASE_OFFSET + offset;
        return TStringOps.runCalcStringAttributesUTF16C(location, array, stubOffset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long calcStringAttributesUTF16(Node location, Object array, int offset, int length, boolean assumeValid) {
        try {
            long stubOffset;
            byte[] stubArray;
            boolean isNative = TStringOps.isNativePointer(array);
            if (isNative) {
                stubArray = null;
                stubOffset = (long)offset + TStringOps.nativePointer(array);
            } else {
                stubArray = (byte[])array;
                stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegion(stubArray, offset, length, 1);
            long attrs = assumeValid ? TStringOps.runCalcStringAttributesUTF16(location, stubArray, stubOffset, length, isNative, true) : TStringOps.runCalcStringAttributesUTF16(location, stubArray, stubOffset, length, isNative, false);
            if (assumeValid && length > 0) {
                if (Encodings.isUTF16LowSurrogate(TStringOps.readS1(array, offset, length, 0))) {
                    attrs = StringAttributes.create(StringAttributes.getCodePointLength(attrs), TSCodeRange.getBrokenMultiByte());
                }
                if (Encodings.isUTF16HighSurrogate(TStringOps.readS1(array, offset, length, length - 1))) {
                    attrs = StringAttributes.create(StringAttributes.getCodePointLength(attrs) + 1, TSCodeRange.getBrokenMultiByte());
                }
            }
            long l = attrs;
            return l;
        }
        finally {
            Reference.reachabilityFence(array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long calcStringAttributesUTF16FE(Node location, Object array, int offset, int length) {
        try {
            long stubOffset;
            byte[] stubArray;
            boolean isNative = TStringOps.isNativePointer(array);
            if (isNative) {
                stubArray = null;
                stubOffset = (long)offset + TStringOps.nativePointer(array);
            } else {
                stubArray = (byte[])array;
                stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegion(stubArray, offset, length, 1);
            long l = TStringOps.runCalcStringAttributesUTF16FE(location, stubArray, stubOffset, length, isNative);
            return l;
        }
        finally {
            Reference.reachabilityFence(array);
        }
    }

    static int calcStringAttributesUTF32I(Node location, int[] array, int offset, int length) {
        TStringOps.validateRegion(array, offset, length);
        int stubOffset = Unsafe.ARRAY_INT_BASE_OFFSET + offset;
        return TStringOps.runCalcStringAttributesUTF32I(location, array, stubOffset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int calcStringAttributesUTF32(Node location, Object array, int offset, int length) {
        try {
            long stubOffset;
            byte[] stubArray;
            boolean isNative = TStringOps.isNativePointer(array);
            if (isNative) {
                stubArray = null;
                stubOffset = (long)offset + TStringOps.nativePointer(array);
            } else {
                stubArray = (byte[])array;
                stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegion(stubArray, offset, length, 2);
            int n = TStringOps.runCalcStringAttributesUTF32(location, stubArray, stubOffset, length, isNative);
            return n;
        }
        finally {
            Reference.reachabilityFence(array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int calcStringAttributesUTF32FE(Node location, Object array, int offset, int length) {
        try {
            long stubOffset;
            byte[] stubArray;
            boolean isNative = TStringOps.isNativePointer(array);
            if (isNative) {
                stubArray = null;
                stubOffset = (long)offset + TStringOps.nativePointer(array);
            } else {
                stubArray = (byte[])array;
                stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegion(stubArray, offset, length, 2);
            int n = TStringOps.runCalcStringAttributesUTF32FE(location, stubArray, stubOffset, length, isNative);
            return n;
        }
        finally {
            Reference.reachabilityFence(array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int codePointIndexToByteIndexUTF8Valid(Node location, Object array, int offset, int length, int index) {
        try {
            long stubOffset;
            byte[] stubArray;
            boolean isNative = TStringOps.isNativePointer(array);
            if (isNative) {
                stubArray = null;
                stubOffset = (long)offset + TStringOps.nativePointer(array);
            } else {
                stubArray = (byte[])array;
                stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegion(stubArray, offset, length, 0);
            int n = TStringOps.runCodePointIndexToByteIndexUTF8Valid(location, stubArray, stubOffset, length, index, isNative);
            return n;
        }
        finally {
            Reference.reachabilityFence(array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int codePointIndexToByteIndexUTF16Valid(Node location, Object array, int offset, int length, int index) {
        try {
            long stubOffset;
            byte[] stubArray;
            boolean isNative = TStringOps.isNativePointer(array);
            if (isNative) {
                stubArray = null;
                stubOffset = (long)offset + TStringOps.nativePointer(array);
            } else {
                stubArray = (byte[])array;
                stubOffset = offset + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            TStringOps.validateRegion(stubArray, offset, length, 1);
            int n = TStringOps.runCodePointIndexToByteIndexUTF16Valid(location, stubArray, stubOffset, length, index, isNative);
            return n;
        }
        finally {
            Reference.reachabilityFence(array);
        }
    }

    private static int runIndexOfAnyByte(Node location, byte[] array, long offset, int length, int fromIndex, byte ... needle) {
        for (int i = fromIndex; i < length; ++i) {
            int value = TStringOps.readValue(array, offset, 0, i);
            for (int j = 0; j < needle.length; ++j) {
                if (value == TStringOps.uInt(needle[j])) {
                    return i;
                }
                TStringConstants.truffleSafePointPoll(location, j + 1);
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return -1;
    }

    private static int runIndexOfAnyChar(Node location, byte[] array, long offset, int length, int stride, int fromIndex, char ... needle) {
        for (int i = fromIndex; i < length; ++i) {
            int value = TStringOps.readValue(array, offset, stride, i);
            for (int j = 0; j < needle.length; ++j) {
                if (value == needle[j]) {
                    return i;
                }
                TStringConstants.truffleSafePointPoll(location, j + 1);
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return -1;
    }

    private static int runIndexOfAnyInt(Node location, byte[] array, long offset, int length, int stride, int fromIndex, int ... needle) {
        for (int i = fromIndex; i < length; ++i) {
            int value = TStringOps.readValue(array, offset, stride, i);
            for (int j = 0; j < needle.length; ++j) {
                if (value == needle[j]) {
                    return i;
                }
                TStringConstants.truffleSafePointPoll(location, j + 1);
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return -1;
    }

    private static int runIndexOfAnyIntRange(Node location, byte[] array, long offset, int length, int stride, int fromIndex, int ... ranges) {
        for (int i = fromIndex; i < length; ++i) {
            for (int j = 0; j < ranges.length; j += 2) {
                if (TStringOps.inRange(ranges[j], ranges[j + 1], TStringOps.readValue(array, offset, stride, i))) {
                    return i;
                }
                TStringConstants.truffleSafePointPoll(location, j + 1);
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return -1;
    }

    private static boolean inRange(int lo, int hi, int v) {
        return Integer.compareUnsigned(lo, v) <= 0 && Integer.compareUnsigned(v, hi) <= 0;
    }

    private static int runIndexOfAny1(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int v0) {
        for (int i = fromIndex; i < length; ++i) {
            if (TStringOps.readValue(array, offset, stride, i) == v0) {
                return i;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return -1;
    }

    private static int runIndexOfAny2(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int v0, int v1) {
        for (int i = fromIndex; i < length; ++i) {
            int value = TStringOps.readValue(array, offset, stride, i);
            if (value == v0 || value == v1) {
                return i;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return -1;
    }

    private static int runIndexOfAny3(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int v0, int v1, int v2) {
        for (int i = fromIndex; i < length; ++i) {
            int value = TStringOps.readValue(array, offset, stride, i);
            if (value == v0 || value == v1 || value == v2) {
                return i;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return -1;
    }

    private static int runIndexOfAny4(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int v0, int v1, int v2, int v3) {
        for (int i = fromIndex; i < length; ++i) {
            int value = TStringOps.readValue(array, offset, stride, i);
            if (value == v0 || value == v1 || value == v2 || value == v3) {
                return i;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return -1;
    }

    private static int runIndexOfRange1(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int v0, int v1) {
        for (int i = fromIndex; i < length; ++i) {
            if (TStringOps.inRange(v0, v1, TStringOps.readValue(array, offset, stride, i))) {
                return i;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return -1;
    }

    private static int runIndexOfRange2(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int v0, int v1, int v2, int v3) {
        for (int i = fromIndex; i < length; ++i) {
            int value = TStringOps.readValue(array, offset, stride, i);
            if (TStringOps.inRange(v0, v1, value) || TStringOps.inRange(v2, v3, value)) {
                return i;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return -1;
    }

    private static int runIndexOfTable(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, byte[] tables) {
        for (int i = fromIndex; i < length; ++i) {
            int value = TStringOps.readValue(array, offset, stride, i);
            if (value <= 255 && TStringOps.performTableLookup(tables, value)) {
                return i;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return -1;
    }

    private static boolean performTableLookup(byte[] tables, int value) {
        int tableLo;
        int tableHi = TStringOps.uInt(tables[value >>> 4 & 0xF]);
        return (tableHi & (tableLo = TStringOps.uInt(tables[16 + (value & 0xF)]))) != 0;
    }

    private static int runIndexOfWithOrMaskWithStride(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int needle, int mask) {
        for (int i = fromIndex; i < length; ++i) {
            if ((TStringOps.readValue(array, offset, stride, i) | mask) == needle) {
                return i;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return -1;
    }

    private static int runLastIndexOfWithOrMaskWithStride(Node location, byte[] array, long offset, int stride, int fromIndex, int toIndex, int needle, int mask) {
        for (int i = fromIndex - 1; i >= toIndex; --i) {
            if ((TStringOps.readValue(array, offset, stride, i) | mask) == needle) {
                return i;
            }
            TStringConstants.truffleSafePointPoll(location, i);
        }
        return -1;
    }

    private static int runIndexOf2ConsecutiveWithStride(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int c1, int c2) {
        for (int i = fromIndex + 1; i < length; ++i) {
            if (TStringOps.readValue(array, offset, stride, i - 1) == c1 && TStringOps.readValue(array, offset, stride, i) == c2) {
                return i - 1;
            }
            TStringConstants.truffleSafePointPoll(location, i);
        }
        return -1;
    }

    private static int runIndexOf2ConsecutiveWithOrMaskWithStride(Node location, byte[] array, long offset, int length, int stride, boolean isNative, int fromIndex, int c1, int c2, int mask1, int mask2) {
        for (int i = fromIndex + 1; i < length; ++i) {
            if ((TStringOps.readValue(array, offset, stride, i - 1) | mask1) == c1 && (TStringOps.readValue(array, offset, stride, i) | mask2) == c2) {
                return i - 1;
            }
            TStringConstants.truffleSafePointPoll(location, i);
        }
        return -1;
    }

    private static int runLastIndexOf2ConsecutiveWithOrMaskWithStride(Node location, byte[] array, long offset, int stride, int fromIndex, int toIndex, int c1, int c2, int mask1, int mask2) {
        for (int i = fromIndex - 1; i > toIndex; --i) {
            if ((TStringOps.readValue(array, offset, stride, i - 1) | mask1) == c1 && (TStringOps.readValue(array, offset, stride, i) | mask2) == c2) {
                return i - 1;
            }
            TStringConstants.truffleSafePointPoll(location, i);
        }
        return -1;
    }

    private static boolean runRegionEqualsWithStride(Node location, byte[] arrayA, long offsetA, boolean isNativeA, byte[] arrayB, long offsetB, boolean isNativeB, int length, int stubStride) {
        int strideA = TStringOps.stubStrideToStrideA(stubStride);
        int strideB = TStringOps.stubStrideToStrideB(stubStride);
        for (int i = 0; i < length; ++i) {
            if (TStringOps.readValue(arrayA, offsetA, strideA, i) != TStringOps.readValue(arrayB, offsetB, strideB, i)) {
                return false;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return true;
    }

    private static boolean runRegionEqualsWithOrMaskWithStride(Node location, byte[] arrayA, long offsetA, boolean isNativeA, byte[] arrayB, long offsetB, boolean isNativeB, byte[] arrayMask, int lengthCMP, int stubStride) {
        int strideA = TStringOps.stubStrideToStrideA(stubStride);
        int strideB = TStringOps.stubStrideToStrideB(stubStride);
        for (int i = 0; i < lengthCMP; ++i) {
            if ((TStringOps.readValue(arrayA, offsetA, strideA, i) | TStringOps.readFromByteArray(arrayMask, strideB, i)) != TStringOps.readValue(arrayB, offsetB, strideB, i)) {
                return false;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return true;
    }

    private static int runMemCmp(Node location, byte[] arrayA, long offsetA, boolean isNativeA, byte[] arrayB, long offsetB, boolean isNativeB, int lengthCMP, int stubStride) {
        int strideA = TStringOps.stubStrideToStrideA(stubStride);
        int strideB = TStringOps.stubStrideToStrideB(stubStride);
        for (int i = 0; i < lengthCMP; ++i) {
            int cmp = TStringOps.readValue(arrayA, offsetA, strideA, i) - TStringOps.readValue(arrayB, offsetB, strideB, i);
            if (cmp != 0) {
                return cmp;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return 0;
    }

    private static int runMemCmpBytes(Node location, byte[] arrayA, long offsetA, int strideA, boolean isNativeA, byte[] arrayB, long offsetB, int strideB, boolean isNativeB, int lengthCMP) {
        assert (strideA >= strideB);
        for (int i = 0; i < lengthCMP; ++i) {
            int valueA = TStringOps.readValue(arrayA, offsetA, strideA, i);
            int valueB = TStringOps.readValue(arrayB, offsetB, strideB, i);
            for (int j = 0; j < 4; ++j) {
                int cmp;
                if (TStringGuards.littleEndian()) {
                    cmp = (valueA & 0xFF) - (valueB & 0xFF);
                    valueA >>= 8;
                    valueB >>= 8;
                } else {
                    cmp = (valueA >> 24 & 0xFF) - (valueB >> 24 & 0xFF);
                    valueA <<= 8;
                    valueB <<= 8;
                }
                if (cmp == 0) continue;
                return cmp;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return 0;
    }

    private static int runHashCode(Node location, byte[] array, long offset, int length, int stride, boolean isNative) {
        int hash = 0;
        for (int i = 0; i < length; ++i) {
            hash = 31 * hash + TStringOps.readValue(array, offset, stride, i);
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return hash;
    }

    private static void runArrayCopy(Node location, char[] stubArrayA, long stubOffsetA, byte[] stubArrayB, long stubOffsetB, int lengthCPY, int stubStride) {
        int strideB = TStringOps.stubStrideToStrideB(stubStride);
        int offsetA = (int)(stubOffsetA - (long)Unsafe.ARRAY_CHAR_BASE_OFFSET >> 1);
        for (int i = 0; i < lengthCPY; ++i) {
            TStringOps.writeValue(stubArrayB, stubOffsetB, strideB, i, stubArrayA[offsetA + i]);
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
    }

    private static void runArrayCopy(Node location, int[] stubArrayA, long stubOffsetA, byte[] stubArrayB, long stubOffsetB, int lengthCPY, int stubStride) {
        int strideB = TStringOps.stubStrideToStrideB(stubStride);
        int offsetA = (int)(stubOffsetA - (long)Unsafe.ARRAY_INT_BASE_OFFSET >> 2);
        for (int i = 0; i < lengthCPY; ++i) {
            TStringOps.writeValue(stubArrayB, stubOffsetB, strideB, i, stubArrayA[offsetA + i]);
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
    }

    private static void runArrayCopy(Node location, byte[] stubArrayA, long stubOffsetA, boolean isNativeA, byte[] stubArrayB, long stubOffsetB, boolean isNativeB, int lengthCPY, int stubStride) {
        int strideA = TStringOps.stubStrideToStrideA(stubStride);
        int strideB = TStringOps.stubStrideToStrideB(stubStride);
        for (int i = 0; i < lengthCPY; ++i) {
            TStringOps.writeValue(stubArrayB, stubOffsetB, strideB, i, TStringOps.readValue(stubArrayA, stubOffsetA, strideA, i));
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
    }

    private static void runByteSwapS1(Node location, byte[] stubArrayA, long stubOffsetA, boolean isNativeA, byte[] stubArrayB, long stubOffsetB, boolean isNativeB, int length) {
        for (int i = 0; i < length; ++i) {
            TStringOps.writeValue(stubArrayB, stubOffsetB, 1, i, Character.reverseBytes((char)TStringOps.readValue(stubArrayA, stubOffsetA, 1, i)));
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
    }

    private static void runByteSwapS2(Node location, byte[] stubArrayA, long stubOffsetA, boolean isNativeA, byte[] stubArrayB, long stubOffsetB, boolean isNativeB, int length) {
        for (int i = 0; i < length; ++i) {
            TStringOps.writeValue(stubArrayB, stubOffsetB, 2, i, Integer.reverseBytes(TStringOps.readValue(stubArrayA, stubOffsetA, 2, i)));
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
    }

    private static int runCalcStringAttributesLatin1(Node location, byte[] array, long offset, int length, boolean isNative) {
        for (int i = 0; i < length; ++i) {
            if (TStringOps.readValueS0(array, offset, i) > 127) {
                return TSCodeRange.get8Bit();
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return TSCodeRange.get7Bit();
    }

    private static int runCalcStringAttributesBMP(Node location, byte[] array, long offset, int length, boolean isNative) {
        int i;
        int codeRange = TSCodeRange.get7Bit();
        for (i = 0; i < length; ++i) {
            if (TStringOps.readValueS1(array, offset, i) > 127) {
                codeRange = TSCodeRange.get8Bit();
                break;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        if (!TSCodeRange.is8Bit(codeRange)) {
            return TSCodeRange.get7Bit();
        }
        while (i < length) {
            if (TStringOps.readValueS1(array, offset, i) > 255) {
                return TSCodeRange.get16Bit();
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
            ++i;
        }
        return TSCodeRange.get8Bit();
    }

    private static int runCalcStringAttributesUTF32I(Node location, int[] array, long offset, int length) {
        return TStringOps.runCalcStringAttributesUTF32AnyArray(location, array, offset, length);
    }

    private static int runCalcStringAttributesUTF32(Node location, byte[] array, long offset, int length, boolean isNative) {
        return TStringOps.runCalcStringAttributesUTF32AnyArray(location, array, offset, length);
    }

    private static int readValueS2I(Object array, long offset, int i) {
        if (array instanceof int[]) {
            return ((int[])array)[(int)(offset - (long)Unsafe.ARRAY_INT_BASE_OFFSET >> 2) + i];
        }
        return TStringOps.readValueS2((byte[])array, offset, i);
    }

    private static int runCalcStringAttributesUTF32AnyArray(Node location, Object array, long offset, int length) {
        int value;
        int i;
        int codeRange = TSCodeRange.get7Bit();
        for (i = 0; i < length; ++i) {
            if (Integer.toUnsignedLong(TStringOps.readValueS2I(array, offset, i)) > 127L) {
                codeRange = TSCodeRange.get8Bit();
                break;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        if (!TSCodeRange.is8Bit(codeRange)) {
            return TSCodeRange.get7Bit();
        }
        while (i < length) {
            if (Integer.toUnsignedLong(TStringOps.readValueS2I(array, offset, i)) > 255L) {
                codeRange = TSCodeRange.get16Bit();
                break;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
            ++i;
        }
        if (!TSCodeRange.is16Bit(codeRange)) {
            return TSCodeRange.get8Bit();
        }
        while (i < length) {
            value = TStringOps.readValueS2I(array, offset, i);
            if (Integer.toUnsignedLong(value) > 65535L) {
                codeRange = TSCodeRange.getValidFixedWidth();
                break;
            }
            if (Encodings.isUTF16Surrogate(value)) {
                return TSCodeRange.getBrokenFixedWidth();
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
            ++i;
        }
        if (!TSCodeRange.isValid(codeRange)) {
            return TSCodeRange.get16Bit();
        }
        while (i < length) {
            value = TStringOps.readValueS2I(array, offset, i);
            if (!Encodings.isValidUnicodeCodepoint(value)) {
                return TSCodeRange.getBrokenFixedWidth();
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
            ++i;
        }
        return TSCodeRange.getValidFixedWidth();
    }

    private static int runCalcStringAttributesUTF32FE(Node location, byte[] array, long offset, int length, boolean isNative) {
        for (int i = 0; i < length; ++i) {
            int value = Integer.reverseBytes(TStringOps.readValueS2(array, offset, i));
            if (!Encodings.isValidUnicodeCodepoint(value)) {
                return TSCodeRange.getBrokenMultiByte();
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return TSCodeRange.getValidMultiByte();
    }

    private static long runCalcStringAttributesUTF8(Node location, byte[] array, long offset, int length, boolean isNative, boolean assumeValid) {
        int i;
        int codeRange = TSCodeRange.get7Bit();
        for (i = 0; i < length; ++i) {
            if (TStringOps.readValueS0(array, offset, i) > 127) {
                codeRange = TSCodeRange.getValidMultiByte();
                break;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        if (!TSCodeRange.isValidMultiByte(codeRange)) {
            return StringAttributes.create(length, TSCodeRange.get7Bit());
        }
        int nCodePoints = i;
        if (assumeValid) {
            while (i < length) {
                if (!Encodings.isUTF8ContinuationByte(TStringOps.readValueS0(array, offset, i))) {
                    ++nCodePoints;
                }
                TStringConstants.truffleSafePointPoll(location, i + 1);
                ++i;
            }
            return StringAttributes.create(nCodePoints, TSCodeRange.getValidMultiByte());
        }
        int state = 0;
        while (i < length) {
            int b = TStringOps.readValueS0(array, offset, i);
            if (!Encodings.isUTF8ContinuationByte(b)) {
                ++nCodePoints;
            }
            byte type = Encodings.UTF_8_STATE_MACHINE[b];
            state = Encodings.UTF_8_STATE_MACHINE[256 + state + type];
            TStringConstants.truffleSafePointPoll(location, i + 1);
            ++i;
        }
        if (state != 0) {
            codeRange = TSCodeRange.getBrokenMultiByte();
        }
        return StringAttributes.create(nCodePoints, codeRange);
    }

    private static long runCalcStringAttributesUTF16C(Node location, char[] array, long offset, int length) {
        return TStringOps.runCalcStringAttributesUTF16AnyArray(location, array, offset, length, false);
    }

    private static long runCalcStringAttributesUTF16(Node location, byte[] array, long offset, int length, boolean isNative, boolean assumeValid) {
        return TStringOps.runCalcStringAttributesUTF16AnyArray(location, array, offset, length, assumeValid);
    }

    private static char readValueS1C(Object array, long offset, int i) {
        if (array instanceof char[]) {
            return ((char[])array)[(int)(offset - (long)Unsafe.ARRAY_CHAR_BASE_OFFSET >> 1) + i];
        }
        return (char)TStringOps.readValueS1((byte[])array, offset, i);
    }

    private static long runCalcStringAttributesUTF16AnyArray(Node location, Object array, long offset, int length, boolean assumeValid) {
        int i;
        int codeRange = TSCodeRange.get7Bit();
        for (i = 0; i < length; ++i) {
            if (TStringOps.readValueS1C(array, offset, i) > '\u007f') {
                codeRange = TSCodeRange.get8Bit();
                break;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        if (!TSCodeRange.is8Bit(codeRange)) {
            return StringAttributes.create(length, TSCodeRange.get7Bit());
        }
        while (i < length) {
            if (TStringOps.readValueS1C(array, offset, i) > '\u00ff') {
                codeRange = TSCodeRange.get16Bit();
                break;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
            ++i;
        }
        if (!TSCodeRange.is16Bit(codeRange)) {
            return StringAttributes.create(length, TSCodeRange.get8Bit());
        }
        while (i < length) {
            char c = TStringOps.readValueS1C(array, offset, i);
            if (assumeValid ? Encodings.isUTF16HighSurrogate(c) : Encodings.isUTF16Surrogate(c)) {
                codeRange = TSCodeRange.getValidMultiByte();
                break;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
            ++i;
        }
        if (!TSCodeRange.isValidMultiByte(codeRange)) {
            return StringAttributes.create(length, TSCodeRange.get16Bit());
        }
        int nCodePoints = length;
        if (assumeValid) {
            while (i < length) {
                if (Encodings.isUTF16HighSurrogate(TStringOps.readValueS1C(array, offset, i))) {
                    --nCodePoints;
                }
                TStringConstants.truffleSafePointPoll(location, i + 1);
                ++i;
            }
            return StringAttributes.create(nCodePoints, TSCodeRange.getValidMultiByte());
        }
        while (i < length) {
            char c = TStringOps.readValueS1C(array, offset, i);
            if (Encodings.isUTF16Surrogate(c)) {
                if (Encodings.isUTF16LowSurrogate(c) || i + 1 >= length || !Encodings.isUTF16LowSurrogate(TStringOps.readValueS1C(array, offset, i + 1))) {
                    codeRange = TSCodeRange.getBrokenMultiByte();
                } else {
                    ++i;
                    --nCodePoints;
                }
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
            ++i;
        }
        return StringAttributes.create(nCodePoints, codeRange);
    }

    private static long runCalcStringAttributesUTF16FE(Node location, byte[] array, long offset, int length, boolean isNative) {
        int codeRange = TSCodeRange.getValidMultiByte();
        int nCodePoints = length;
        for (int i = 0; i < length; ++i) {
            char c = Character.reverseBytes((char)TStringOps.readValueS1(array, offset, i));
            if (Encodings.isUTF16Surrogate(c)) {
                if (Encodings.isUTF16LowSurrogate(c) || i + 1 >= length || !Encodings.isUTF16LowSurrogate(Character.reverseBytes((char)TStringOps.readValueS1(array, offset, i + 1)))) {
                    codeRange = TSCodeRange.getBrokenMultiByte();
                } else {
                    ++i;
                    --nCodePoints;
                }
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return StringAttributes.create(nCodePoints, codeRange);
    }

    private static int runCodePointIndexToByteIndexUTF8Valid(Node location, byte[] array, long offset, int length, int index, boolean isNative) {
        int cpi = index;
        for (int i = 0; i < length; ++i) {
            if (!Encodings.isUTF8ContinuationByte(TStringOps.readValueS0(array, offset, i)) && --cpi < 0) {
                return i;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return cpi == 0 ? length : -1;
    }

    private static int runCodePointIndexToByteIndexUTF16Valid(Node location, byte[] array, long offset, int length, int index, boolean isNative) {
        int cpi = index;
        for (int i = 0; i < length; ++i) {
            if (!Encodings.isUTF16LowSurrogate(TStringOps.readValueS1(array, offset, i)) && --cpi < 0) {
                return i;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return cpi == 0 ? length : -1;
    }

    static long byteLength(Object array) {
        CompilerAsserts.neverPartOfCompilation();
        if (array instanceof byte[]) {
            return ((byte[])array).length;
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    private static boolean rangeInBounds(int rangeStart, int rangeLength, int arrayLength) {
        return Integer.toUnsignedLong(rangeStart) + Integer.toUnsignedLong(rangeLength) <= (long)arrayLength;
    }

    private static boolean isNativePointer(Object arrayB) {
        return arrayB instanceof AbstractTruffleString.NativePointer;
    }

    private static long nativePointer(Object array) {
        return ((AbstractTruffleString.NativePointer)array).pointer;
    }

    private static int stubStride(int strideA, int strideB) {
        assert (Stride.isStride(strideA));
        assert (Stride.isStride(strideB));
        return strideA * 3 + strideB;
    }

    private static int stubStrideToStrideA(int stubStride) {
        assert (0 <= stubStride && stubStride < 9) : stubStride;
        return stubStride / 3;
    }

    private static int stubStrideToStrideB(int stubStride) {
        assert (0 <= stubStride && stubStride < 9) : stubStride;
        return stubStride % 3;
    }

    private static int uInt(byte value) {
        return Byte.toUnsignedInt(value);
    }

    static void validateRegion(byte[] stubArray, int offset, int length, int stride) {
        if (!TStringOps.validRegion(stubArray, offset, length, stride)) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    private static void validateRegion(char[] array, int offset, int length) {
        int charOffset = offset >> 1;
        if (Integer.toUnsignedLong(charOffset) + Integer.toUnsignedLong(length) > (long)array.length) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    private static void validateRegion(int[] array, int offset, int length) {
        int intOffset = offset >> 2;
        if (Integer.toUnsignedLong(intOffset) + Integer.toUnsignedLong(length) > (long)array.length) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    private static void validateRegionIndex(byte[] stubArray, int offset, int length, int stride, int i) {
        if (!TStringOps.validRegionIndex(stubArray, offset, length, stride, i)) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    private static boolean validRegion(byte[] stubArray, int offset, int length, int stride) {
        return TStringOps.validOffsetOrLength(stubArray, offset, length, stride);
    }

    private static boolean validRegionIndex(byte[] stubArray, int offset, int length, int stride, int i) {
        return TStringOps.validOffsetOrLength(stubArray, offset, length, stride) && TStringOps.validIndex(length, i);
    }

    private static boolean validOffsetOrLength(byte[] stubArray, int offset, int length, int stride) {
        if (stubArray == null) {
            return offset >= 0 && length >= 0;
        }
        return Integer.toUnsignedLong(offset) + (Integer.toUnsignedLong(length) << stride) <= (long)stubArray.length;
    }

    private static boolean validIndex(int length, int i) {
        return Integer.compareUnsigned(i, length) < 0;
    }
}

