/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLocals;
import com.oracle.truffle.polyglot.PolyglotSourceCache;
import com.oracle.truffle.polyglot.PolyglotValueDispatch;
import com.oracle.truffle.polyglot.WeakAssumedValue;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.graalvm.collections.Pair;
import org.graalvm.polyglot.Source;

final class PolyglotLanguageInstance
implements PolyglotImpl.VMObject {
    final PolyglotLanguage language;
    final TruffleLanguage<Object> spi;
    private final PolyglotSourceCache sourceCache;
    private final Map<Class<?>, PolyglotValueDispatch> valueCache;
    private final Map<Class<?>, CallTarget> callTargetCache;
    final Map<Object, Object> hostToGuestCodeCache = new ConcurrentHashMap<Object, Object>();
    private volatile OptionValuesImpl firstOptionValues;
    private volatile boolean multiContextInitialized;
    final Map<Class<?>, ClassLoader> staticObjectClassLoaders = new ConcurrentHashMap();
    final ConcurrentHashMap<Pair<Class<?>, Class<?>>, Object> generatorCache = new ConcurrentHashMap();
    final WeakAssumedValue<PolyglotLanguageContext> singleLanguageContext = new WeakAssumedValue("single language context");
    List<PolyglotLocals.LanguageContextLocal<?>> contextLocals;
    List<PolyglotLocals.LanguageContextThreadLocal<?>> contextThreadLocals;
    PolyglotLocals.LocalLocation[] contextLocalLocations;
    PolyglotLocals.LocalLocation[] contextThreadLocalLocations;
    int claimedCount;

    PolyglotLanguageInstance(PolyglotLanguage language) {
        this.language = language;
        this.sourceCache = new PolyglotSourceCache();
        this.valueCache = new ConcurrentHashMap();
        this.callTargetCache = new ConcurrentHashMap();
        try {
            this.spi = language.cache.loadLanguage();
            EngineAccessor.LANGUAGE.initializeLanguage(this.spi, language.info, language, this);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error initializing language '%s' using class '%s'.", language.cache.getId(), language.cache.getClassName()), e);
        }
        PolyglotValueDispatch.createDefaultValues(this.getImpl(), this, this.valueCache);
    }

    CallTarget lookupCallTarget(Class<? extends RootNode> rootNodeClass) {
        return this.callTargetCache.get(rootNodeClass);
    }

    CallTarget installCallTarget(RootNode rootNode) {
        return this.callTargetCache.computeIfAbsent(rootNode.getClass(), r -> Truffle.getRuntime().createCallTarget(rootNode));
    }

    @Override
    public PolyglotEngineImpl getEngine() {
        return this.language.engine;
    }

    boolean areOptionsCompatible(OptionValuesImpl newOptionValues) {
        OptionValuesImpl firstOptions = this.firstOptionValues;
        if (this.firstOptionValues == null) {
            return true;
        }
        return EngineAccessor.LANGUAGE.areOptionsCompatible(this.spi, firstOptions, newOptionValues);
    }

    void claim(OptionValuesImpl optionValues) {
        assert (Thread.holdsLock(this.language.engine.lock));
        if (this.firstOptionValues == null) {
            this.firstOptionValues = optionValues;
        }
        ++this.claimedCount;
    }

    void patchFirstOptions(OptionValuesImpl optionValues) {
        this.firstOptionValues = optionValues;
    }

    void ensureMultiContextInitialized() {
        assert (Thread.holdsLock(this.language.engine.lock));
        if (!this.language.engine.singleContext.isValid() && this.language.cache.getPolicy() != TruffleLanguage.ContextPolicy.EXCLUSIVE && !this.multiContextInitialized) {
            this.multiContextInitialized = true;
            this.language.engine.initializeMultiContext();
            this.singleLanguageContext.invalidate();
            EngineAccessor.LANGUAGE.initializeMultiContext(this.spi);
        }
    }

    PolyglotSourceCache getSourceCache() {
        return this.sourceCache;
    }

    void listCachedSources(Collection<Source> sources) {
        this.sourceCache.listCachedSources(this, sources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PolyglotValueDispatch lookupValueCache(PolyglotContextImpl context, Object guestValue) {
        PolyglotValueDispatch cache = this.valueCache.get(guestValue.getClass());
        if (cache == null) {
            Object prev = this.language.engine.enterIfNeeded(context, true);
            try {
                cache = this.lookupValueCacheImpl(guestValue);
            }
            finally {
                this.language.engine.leaveIfNeeded(prev, context);
            }
        }
        return cache;
    }

    private synchronized PolyglotValueDispatch lookupValueCacheImpl(final Object guestValue) {
        PolyglotValueDispatch cache = this.valueCache.computeIfAbsent(guestValue.getClass(), new Function<Class<?>, PolyglotValueDispatch>(){

            @Override
            public PolyglotValueDispatch apply(Class<?> t) {
                return PolyglotValueDispatch.createInteropValue(PolyglotLanguageInstance.this, (TruffleObject)guestValue, guestValue.getClass());
            }
        });
        return cache;
    }
}

