/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.HostAdapterFactory;
import com.oracle.truffle.polyglot.HostClassCache;
import com.oracle.truffle.polyglot.HostClassDesc;
import com.oracle.truffle.polyglot.HostException;
import com.oracle.truffle.polyglot.HostExecuteNode;
import com.oracle.truffle.polyglot.HostFieldDesc;
import com.oracle.truffle.polyglot.HostFunction;
import com.oracle.truffle.polyglot.HostInteropErrors;
import com.oracle.truffle.polyglot.HostInteropReflect;
import com.oracle.truffle.polyglot.HostLanguage;
import com.oracle.truffle.polyglot.HostMethodDesc;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotProxy;
import com.oracle.truffle.polyglot.TargetMappingNode;
import com.oracle.truffle.polyglot.ToHostNode;
import java.lang.reflect.Array;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ExportLibrary(value=InteropLibrary.class)
final class HostObject
implements TruffleObject {
    static final int LIMIT = 5;
    private static final ZoneId UTC = ZoneId.of("UTC");
    static final HostObject NULL = new HostObject(null, null, null);
    final Object obj;
    final PolyglotLanguageContext languageContext;
    private final Object extraInfo;

    private HostObject(Object obj, PolyglotLanguageContext languageContext, Object extraInfo) {
        this.obj = obj;
        this.languageContext = languageContext;
        this.extraInfo = extraInfo;
    }

    static HostObject forClass(Class<?> clazz, PolyglotLanguageContext languageContext) {
        assert (clazz != null);
        return new HostObject(clazz, languageContext, null);
    }

    static HostObject forStaticClass(Class<?> clazz, PolyglotLanguageContext languageContext) {
        assert (clazz != null);
        return new HostObject(clazz, languageContext, clazz);
    }

    static HostObject forObject(Object object, PolyglotLanguageContext languageContext) {
        assert (object != null && !(object instanceof Class));
        return new HostObject(object, languageContext, null);
    }

    static HostObject forException(Throwable object, PolyglotLanguageContext languageContext, HostException hostException) {
        Objects.requireNonNull(object);
        return new HostObject(object, languageContext, hostException);
    }

    static boolean isInstance(Object obj) {
        return obj instanceof HostObject || obj instanceof HostException;
    }

    static boolean isHostObjectInstance(Object obj) {
        return obj instanceof HostObject;
    }

    static Object withContext(Object obj, PolyglotLanguageContext context) {
        if (obj instanceof HostObject) {
            HostObject hostObject = (HostObject)obj;
            return new HostObject(hostObject.obj, context, hostObject.extraInfo);
        }
        if (obj instanceof HostException) {
            return new HostException(((HostException)obj).getOriginal(), context.context);
        }
        throw CompilerDirectives.shouldNotReachHere("Parameter must be HostObject or HostException.");
    }

    static boolean isJavaInstance(Class<?> targetType, Object javaObject) {
        if (HostObject.isInstance(javaObject)) {
            Object value = HostObject.valueOf(javaObject);
            return targetType.isInstance(value);
        }
        return false;
    }

    static Object valueOf(Object value) {
        if (value instanceof HostException) {
            return ((HostException)value).getOriginal();
        }
        HostObject obj = (HostObject)value;
        return obj.obj;
    }

    public int hashCode() {
        return System.identityHashCode(this.obj);
    }

    boolean isClass() {
        return this.obj instanceof Class;
    }

    boolean isArrayClass() {
        return this.isClass() && this.asClass().isArray();
    }

    boolean isDefaultClass() {
        return this.isClass() && !this.asClass().isArray();
    }

    @ExportMessage
    boolean hasMembers() {
        return !this.isNull();
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) throws UnsupportedMessageException {
        if (this.isNull()) {
            throw UnsupportedMessageException.create();
        }
        String[] fields = HostInteropReflect.findUniquePublicMemberNames(this.getEngine(), this.getLookupClass(), this.isStaticClass(), this.isClass(), includeInternal);
        return new KeysArray(fields);
    }

    @ExportMessage
    Object readMember(String name, @Cached.Shared(value="lookupField") @Cached LookupFieldNode lookupField, @Cached.Shared(value="readField") @Cached ReadFieldNode readField, @Cached.Shared(value="lookupMethod") @Cached LookupMethodNode lookupMethod, @Cached LookupInnerClassNode lookupInnerClass, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException, UnknownIdentifierException {
        if (this.isNull()) {
            error.enter();
            throw UnsupportedMessageException.create();
        }
        boolean isStatic = this.isStaticClass();
        Class<?> lookupClass = this.getLookupClass();
        HostFieldDesc foundField = lookupField.execute(this, lookupClass, name, isStatic);
        if (foundField != null) {
            return readField.execute(foundField, this);
        }
        HostMethodDesc foundMethod = lookupMethod.execute(this, lookupClass, name, isStatic);
        if (foundMethod != null) {
            return new HostFunction(foundMethod, this.obj, this.languageContext);
        }
        if (isStatic) {
            LookupInnerClassNode lookupInnerClassNode = lookupInnerClass;
            if ("class".equals(name)) {
                return HostObject.forClass(lookupClass, this.languageContext);
            }
            Class<?> innerclass = lookupInnerClassNode.execute(lookupClass, name);
            if (innerclass != null) {
                return HostObject.forStaticClass(innerclass, this.languageContext);
            }
        } else {
            if (this.isClass() && "static".equals(name)) {
                return HostObject.forStaticClass(this.asClass(), this.languageContext);
            }
            if ("super".equals(name) && HostAdapterFactory.isAdapterInstance(this.obj)) {
                return HostAdapterFactory.getSuperAdapter(this);
            }
        }
        error.enter();
        throw UnknownIdentifierException.create(name);
    }

    @ExportMessage
    boolean isMemberInsertable(String member) {
        return false;
    }

    @ExportMessage
    void writeMember(String member, Object value, @Cached.Shared(value="lookupField") @Cached LookupFieldNode lookupField, @Cached WriteFieldNode writeField, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
        if (this.isNull()) {
            error.enter();
            throw UnsupportedMessageException.create();
        }
        HostFieldDesc f = lookupField.execute(this, this.getLookupClass(), member, this.isStaticClass());
        if (f == null) {
            error.enter();
            throw UnknownIdentifierException.create(member);
        }
        try {
            writeField.execute(f, this, value);
        }
        catch (ClassCastException | NullPointerException e) {
            error.enter();
            throw UnsupportedTypeException.create(new Object[]{value}, HostObject.getMessage(e));
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static String getMessage(RuntimeException e) {
        return e.getMessage();
    }

    @ExportMessage
    Object invokeMember(String name, Object[] args, @Cached.Shared(value="lookupMethod") @Cached LookupMethodNode lookupMethod, @Cached.Shared(value="hostExecute") @Cached HostExecuteNode executeMethod, @Cached.Shared(value="lookupField") @Cached LookupFieldNode lookupField, @Cached.Shared(value="readField") @Cached ReadFieldNode readField, @CachedLibrary(limit="5") InteropLibrary fieldValues, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedTypeException, ArityException, UnsupportedMessageException, UnknownIdentifierException {
        Object fieldValue;
        if (this.isNull()) {
            error.enter();
            throw UnsupportedMessageException.create();
        }
        boolean isStatic = this.isStaticClass();
        Class<?> lookupClass = this.getLookupClass();
        HostMethodDesc foundMethod = lookupMethod.execute(this, lookupClass, name, isStatic);
        if (foundMethod != null) {
            return executeMethod.execute(foundMethod, this.obj, args, this.languageContext);
        }
        HostFieldDesc foundField = lookupField.execute(this, lookupClass, name, isStatic);
        if (foundField != null && fieldValues.isExecutable(fieldValue = readField.execute(foundField, this))) {
            return fieldValues.execute(fieldValue, args);
        }
        error.enter();
        throw UnknownIdentifierException.create(name);
    }

    @ExportMessage
    boolean isArrayElementInsertable(long index, @Cached.Shared(value="isList") @Cached IsListNode isList) {
        return isList.execute(this) && (long)this.getListSize() == index;
    }

    @ExportMessage
    boolean hasArrayElements(@Cached.Shared(value="isList") @Cached IsListNode isList, @Cached.Shared(value="isArray") @Cached IsArrayNode isArray) {
        return isList.execute(this) || isArray.execute(this);
    }

    @ExportMessage
    long getArraySize(@Cached.Shared(value="isArray") @Cached IsArrayNode isArray, @Cached.Shared(value="isList") @Cached IsListNode isList, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        if (isArray.execute(this)) {
            return Array.getLength(this.obj);
        }
        if (isList.execute(this)) {
            return this.getListSize();
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    int getListSize() {
        return ((List)this.obj).size();
    }

    @ExportMessage
    boolean isNull() {
        return this.obj == null;
    }

    @ExportMessage
    boolean isExecutable(@Cached.Shared(value="lookupFunctionalMethod") @Cached LookupFunctionalMethodNode lookupMethod) {
        return !this.isNull() && !this.isClass() && lookupMethod.execute(this, this.getLookupClass()) != null;
    }

    @ExportMessage
    Object execute(Object[] args, @Cached.Shared(value="hostExecute") @Cached HostExecuteNode doExecute, @Cached.Shared(value="lookupFunctionalMethod") @Cached LookupFunctionalMethodNode lookupMethod, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException, UnsupportedTypeException, ArityException {
        HostMethodDesc method;
        if (!this.isNull() && !this.isClass() && (method = lookupMethod.execute(this, this.getLookupClass())) != null) {
            return doExecute.execute(method, this.obj, args, this.languageContext);
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isNumber() {
        if (this.isNull()) {
            return false;
        }
        Class<?> c = this.obj.getClass();
        return c == Byte.class || c == Short.class || c == Integer.class || c == Long.class || c == Float.class || c == Double.class;
    }

    @ExportMessage
    boolean fitsInByte(@Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers) {
        if (this.isNumber()) {
            return numbers.fitsInByte(this.obj);
        }
        return false;
    }

    @ExportMessage
    boolean fitsInShort(@Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers) {
        if (this.isNumber()) {
            return numbers.fitsInShort(this.obj);
        }
        return false;
    }

    @ExportMessage
    boolean fitsInInt(@Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers) {
        if (this.isNumber()) {
            return numbers.fitsInInt(this.obj);
        }
        return false;
    }

    @ExportMessage
    boolean fitsInLong(@Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers) {
        if (this.isNumber()) {
            return numbers.fitsInLong(this.obj);
        }
        return false;
    }

    @ExportMessage
    boolean fitsInFloat(@Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers) {
        if (this.isNumber()) {
            return numbers.fitsInFloat(this.obj);
        }
        return false;
    }

    @ExportMessage
    boolean fitsInDouble(@Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers) {
        if (this.isNumber()) {
            return numbers.fitsInDouble(this.obj);
        }
        return false;
    }

    @ExportMessage
    byte asByte(@Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        if (this.isNumber()) {
            return numbers.asByte(this.obj);
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    short asShort(@Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        if (this.isNumber()) {
            return numbers.asShort(this.obj);
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    int asInt(@Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        if (this.isNumber()) {
            return numbers.asInt(this.obj);
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    long asLong(@Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        if (this.isNumber()) {
            return numbers.asLong(this.obj);
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    float asFloat(@Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        if (this.isNumber()) {
            return numbers.asFloat(this.obj);
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    double asDouble(@Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        if (this.isNumber()) {
            return numbers.asDouble(this.obj);
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isString() {
        if (this.isNull()) {
            return false;
        }
        Class<?> c = this.obj.getClass();
        return c == String.class || c == Character.class;
    }

    @ExportMessage
    String asString(@Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary strings, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        if (this.isString()) {
            return strings.asString(this.obj);
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isBoolean() {
        if (this.isNull()) {
            return false;
        }
        return this.obj.getClass() == Boolean.class;
    }

    @ExportMessage
    boolean asBoolean(@Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        if (this.isBoolean()) {
            return (Boolean)this.obj;
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isDate() {
        return this.obj instanceof LocalDate || this.obj instanceof LocalDateTime || this.obj instanceof Instant || this.obj instanceof ZonedDateTime || this.obj instanceof Date;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalDate asDate() throws UnsupportedMessageException {
        if (this.obj instanceof LocalDate) {
            return (LocalDate)this.obj;
        }
        if (this.obj instanceof LocalDateTime) {
            return ((LocalDateTime)this.obj).toLocalDate();
        }
        if (this.obj instanceof Instant) {
            return ((Instant)this.obj).atZone(UTC).toLocalDate();
        }
        if (this.obj instanceof ZonedDateTime) {
            return ((ZonedDateTime)this.obj).toLocalDate();
        }
        if (this.obj instanceof Date) {
            return ((Date)this.obj).toInstant().atZone(UTC).toLocalDate();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isTime() {
        return this.obj instanceof LocalTime || this.obj instanceof LocalDateTime || this.obj instanceof Instant || this.obj instanceof ZonedDateTime || this.obj instanceof Date;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalTime asTime() throws UnsupportedMessageException {
        if (this.obj instanceof LocalTime) {
            return (LocalTime)this.obj;
        }
        if (this.obj instanceof LocalDateTime) {
            return ((LocalDateTime)this.obj).toLocalTime();
        }
        if (this.obj instanceof ZonedDateTime) {
            return ((ZonedDateTime)this.obj).toLocalTime();
        }
        if (this.obj instanceof Instant) {
            return ((Instant)this.obj).atZone(UTC).toLocalTime();
        }
        if (this.obj instanceof Date) {
            return ((Date)this.obj).toInstant().atZone(UTC).toLocalTime();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isTimeZone() {
        return this.obj instanceof ZoneId || this.obj instanceof Instant || this.obj instanceof ZonedDateTime || this.obj instanceof Date;
    }

    @ExportMessage
    ZoneId asTimeZone() throws UnsupportedMessageException {
        if (this.obj instanceof ZoneId) {
            return (ZoneId)this.obj;
        }
        if (this.obj instanceof ZonedDateTime) {
            return ((ZonedDateTime)this.obj).getZone();
        }
        if (this.obj instanceof Instant) {
            return UTC;
        }
        if (this.obj instanceof Date) {
            return UTC;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Instant asInstant() throws UnsupportedMessageException {
        if (this.obj instanceof ZonedDateTime) {
            return ((ZonedDateTime)this.obj).toInstant();
        }
        if (this.obj instanceof Instant) {
            return (Instant)this.obj;
        }
        if (this.obj instanceof Date) {
            return ((Date)this.obj).toInstant();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isDuration() {
        return this.obj instanceof Duration;
    }

    @ExportMessage
    Duration asDuration() throws UnsupportedMessageException {
        if (this.isDuration()) {
            return (Duration)this.obj;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isException() {
        return this.obj instanceof Throwable;
    }

    @ExportMessage
    ExceptionType getExceptionType(@Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        if (this.isException()) {
            return this.obj instanceof InterruptedException ? ExceptionType.INTERRUPT : ExceptionType.RUNTIME_ERROR;
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isExceptionIncompleteSource(@Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        if (this.isException()) {
            return false;
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    int getExceptionExitStatus(@Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        error.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean hasExceptionMessage() {
        return this.isException() && ((Throwable)this.obj).getMessage() != null;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getExceptionMessage(@Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        String message;
        String string = message = this.isException() ? ((Throwable)this.obj).getMessage() : null;
        if (message != null) {
            return message;
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean hasExceptionCause() {
        return this.isException() && ((Throwable)this.obj).getCause() instanceof TruffleException;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getExceptionCause() throws UnsupportedMessageException {
        Throwable cause;
        if (this.isException() && (cause = ((Throwable)this.obj).getCause()) instanceof TruffleException) {
            return cause;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean hasExceptionStackTrace() {
        return this.isException() && TruffleStackTrace.fillIn((Throwable)this.obj) != null;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getExceptionStackTrace() throws UnsupportedMessageException {
        if (this.isException()) {
            return EngineAccessor.EXCEPTION.getExceptionStackTrace(this.obj);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    RuntimeException throwException(@Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        if (this.isException()) {
            HostException ex = (HostException)this.extraInfo;
            if (ex == null) {
                ex = new HostException((Throwable)this.obj);
            }
            throw ex;
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return HostLanguage.class;
    }

    @ExportMessage
    String toDisplayString(boolean allowSideEffects) {
        return HostObject.toStringImpl(this.languageContext, this.obj, 0, allowSideEffects);
    }

    @CompilerDirectives.TruffleBoundary
    static String toStringImpl(PolyglotLanguageContext context, Object javaObject, int level, boolean allowSideEffects) {
        try {
            if (javaObject == null) {
                return "null";
            }
            if (javaObject.getClass().isArray()) {
                return HostObject.arrayToString(context, javaObject, level, allowSideEffects);
            }
            if (javaObject instanceof Class) {
                return ((Class)javaObject).getTypeName();
            }
            if (allowSideEffects) {
                return Objects.toString(javaObject);
            }
            return javaObject.getClass().getTypeName() + "@" + Integer.toHexString(System.identityHashCode(javaObject));
        }
        catch (Throwable t) {
            throw PolyglotImpl.hostToGuestException(context, t);
        }
    }

    private static String arrayToString(PolyglotLanguageContext context, Object array, int level, boolean allowSideEffects) {
        if (array == null) {
            return "null";
        }
        if (level > 0) {
            return "[...]";
        }
        int iMax = Array.getLength(array) - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            Object arrayValue = Array.get(array, i);
            b.append(HostObject.toStringImpl(context, arrayValue, level + 1, allowSideEffects));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    @ExportMessage
    boolean hasMetaObject() {
        return !this.isNull();
    }

    @ExportMessage
    Object getMetaObject() throws UnsupportedMessageException {
        if (this.hasMetaObject()) {
            Object javaObject = this.obj;
            Class<?> javaType = javaObject.getClass();
            return HostObject.forClass(javaType, this.languageContext);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isMetaObject() {
        return this.isClass();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMetaQualifiedName() throws UnsupportedMessageException {
        if (this.isClass()) {
            return this.asClass().getTypeName();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMetaSimpleName() throws UnsupportedMessageException {
        if (this.isClass()) {
            return this.asClass().getSimpleName();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMetaInstance(Object other, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        if (this.isClass()) {
            Class<?> c = this.asClass();
            if (HostObject.isInstance(other)) {
                Object otherHostObj = HostObject.valueOf(other);
                if (otherHostObj == null) {
                    return false;
                }
                return c.isInstance(otherHostObj);
            }
            if (PolyglotProxy.isProxyGuestObject(other)) {
                PolyglotProxy otherHost = (PolyglotProxy)other;
                return c.isInstance(otherHost.proxy);
            }
            boolean canConvert = ToHostNode.canConvert(other, c, c, ToHostNode.allowsImplementation(this.languageContext, c), this.languageContext, 8, InteropLibrary.getFactory().getUncached(other), TargetMappingNode.getUncached());
            return canConvert;
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    boolean isStaticClass() {
        return this.extraInfo instanceof Class;
    }

    Class<?> getObjectClass() {
        return this.obj == null ? null : this.obj.getClass();
    }

    Class<?> asStaticClass() {
        assert (this.isStaticClass());
        return (Class)this.obj;
    }

    Class<?> asClass() {
        assert (this.isClass());
        return (Class)this.obj;
    }

    Class<?> getLookupClass() {
        if (this.obj == null) {
            return null;
        }
        if (this.isStaticClass()) {
            return this.asStaticClass();
        }
        return this.obj.getClass();
    }

    PolyglotEngineImpl getEngine() {
        PolyglotContextImpl context;
        PolyglotContextImpl polyglotContextImpl = context = this.languageContext != null ? this.languageContext.context : null;
        if (context == null) {
            context = PolyglotContextImpl.currentNotEntered();
        }
        return context.engine;
    }

    HostClassCache getHostClassCache() {
        return HostClassCache.forInstance(this);
    }

    @ExportMessage
    static int identityHashCode(HostObject receiver) {
        return System.identityHashCode(receiver.obj);
    }

    public boolean equals(Object o) {
        if (o instanceof HostObject) {
            HostObject other = (HostObject)o;
            return this.obj == other.obj && this.languageContext == other.languageContext;
        }
        return false;
    }

    public String toString() {
        if (this.obj == null) {
            return "null";
        }
        if (this.isClass()) {
            return "JavaClass[" + this.asClass().getTypeName() + "]";
        }
        return "JavaObject[" + this.obj + " (" + this.getObjectClass().getTypeName() + ")]";
    }

    @GenerateUncached
    static abstract class IsArrayNode
    extends Node {
        IsArrayNode() {
        }

        public abstract boolean execute(HostObject var1);

        @Specialization
        public boolean doDefault(HostObject receiver, @Cached(value="receiver.getHostClassCache().isArrayAccess()", allowUncached=true) boolean isArrayAccess) {
            assert (receiver.getHostClassCache().isArrayAccess() == isArrayAccess);
            return isArrayAccess && receiver.obj != null && receiver.obj.getClass().isArray();
        }
    }

    @GenerateUncached
    static abstract class IsListNode
    extends Node {
        IsListNode() {
        }

        public abstract boolean execute(HostObject var1);

        @Specialization
        public boolean doDefault(HostObject receiver, @Cached(value="receiver.getHostClassCache().isListAccess()", allowUncached=true) boolean isListAccess) {
            assert (receiver.getHostClassCache().isListAccess() == isListAccess);
            return isListAccess && receiver.obj instanceof List;
        }
    }

    @GenerateUncached
    static abstract class WriteFieldNode
    extends Node {
        static final int LIMIT = 3;

        WriteFieldNode() {
        }

        public abstract void execute(HostFieldDesc var1, HostObject var2, Object var3) throws UnsupportedTypeException, UnknownIdentifierException;

        @Specialization(guards={"field == cachedField"}, limit="LIMIT")
        static void doCached(HostFieldDesc field, HostObject object, Object rawValue, @Cached(value="field") HostFieldDesc cachedField, @Cached ToHostNode toHost, @Cached BranchProfile error) throws UnsupportedTypeException, UnknownIdentifierException {
            if (field.isFinal()) {
                error.enter();
                throw UnknownIdentifierException.create(field.getName());
            }
            try {
                Object value = toHost.execute(rawValue, cachedField.getType(), cachedField.getGenericType(), object.languageContext, true);
                cachedField.set(object.obj, value);
            }
            catch (PolyglotEngineException e) {
                error.enter();
                throw HostInteropErrors.unsupportedTypeException(rawValue, (Throwable)e.e);
            }
        }

        @Specialization(replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        static void doUncached(HostFieldDesc field, HostObject object, Object rawValue, @Cached ToHostNode toHost) throws UnsupportedTypeException, UnknownIdentifierException {
            if (field.isFinal()) {
                throw UnknownIdentifierException.create(field.getName());
            }
            try {
                Object val = toHost.execute(rawValue, field.getType(), field.getGenericType(), object.languageContext, true);
                field.set(object.obj, val);
            }
            catch (PolyglotEngineException e) {
                throw HostInteropErrors.unsupportedTypeException(rawValue, (Throwable)e.e);
            }
        }
    }

    @GenerateUncached
    static abstract class ReadFieldNode
    extends Node {
        static final int LIMIT = 3;

        ReadFieldNode() {
        }

        public abstract Object execute(HostFieldDesc var1, HostObject var2);

        @Specialization(guards={"field == cachedField"}, limit="LIMIT")
        static Object doCached(HostFieldDesc field, HostObject object, @Cached(value="field") HostFieldDesc cachedField, @Cached PolyglotLanguageContext.ToGuestValueNode toGuest) {
            Object val = cachedField.get(object.obj);
            return toGuest.execute(object.languageContext, val);
        }

        @Specialization(replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        static Object doUncached(HostFieldDesc field, HostObject object, @Cached PolyglotLanguageContext.ToGuestValueNode toGuest) {
            Object val = field.get(object.obj);
            return toGuest.execute(object.languageContext, val);
        }
    }

    @GenerateUncached
    static abstract class LookupMethodNode
    extends Node {
        static final int LIMIT = 3;

        LookupMethodNode() {
        }

        public abstract HostMethodDesc execute(HostObject var1, Class<?> var2, String var3, boolean var4);

        @Specialization(guards={"onlyStatic == cachedStatic", "clazz == cachedClazz", "cachedName.equals(name)"}, limit="LIMIT")
        HostMethodDesc doCached(HostObject receiver, Class<?> clazz, String name, boolean onlyStatic, @Cached(value="onlyStatic") boolean cachedStatic, @Cached(value="clazz") Class<?> cachedClazz, @Cached(value="name") String cachedName, @Cached(value="doUncached(receiver, clazz, name, onlyStatic)") HostMethodDesc cachedMethod) {
            assert (cachedMethod == this.doUncached(receiver, clazz, name, onlyStatic));
            return cachedMethod;
        }

        @Specialization(replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        HostMethodDesc doUncached(HostObject receiver, Class<?> clazz, String name, boolean onlyStatic) {
            return HostInteropReflect.findMethod(receiver.getEngine(), clazz, name, onlyStatic);
        }
    }

    @GenerateUncached
    static abstract class LookupInnerClassNode
    extends Node {
        static final int LIMIT = 3;

        LookupInnerClassNode() {
        }

        public abstract Class<?> execute(Class<?> var1, String var2);

        @Specialization(guards={"clazz == cachedClazz", "cachedName.equals(name)"}, limit="LIMIT")
        Class<?> doCached(Class<?> clazz, String name, @Cached(value="clazz") Class<?> cachedClazz, @Cached(value="name") String cachedName, @Cached(value="doUncached(clazz, name)") Class<?> cachedInnerClass) {
            assert (cachedInnerClass == this.doUncached(clazz, name));
            return cachedInnerClass;
        }

        @Specialization(replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        Class<?> doUncached(Class<?> clazz, String name) {
            return HostInteropReflect.findInnerClass(clazz, name);
        }
    }

    @GenerateUncached
    static abstract class LookupFunctionalMethodNode
    extends Node {
        static final int LIMIT = 3;

        LookupFunctionalMethodNode() {
        }

        public abstract HostMethodDesc execute(HostObject var1, Class<?> var2);

        @Specialization(guards={"clazz == cachedClazz"}, limit="LIMIT")
        HostMethodDesc doCached(HostObject object, Class<?> clazz, @Cached(value="clazz") Class<?> cachedClazz, @Cached(value="doUncached(object, clazz)") HostMethodDesc cachedMethod) {
            assert (cachedMethod == LookupFunctionalMethodNode.doUncached(object, clazz));
            return cachedMethod;
        }

        @Specialization(replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        static HostMethodDesc doUncached(HostObject object, Class<?> clazz) {
            return HostClassDesc.forClass(object.getEngine(), clazz).getFunctionalMethod();
        }
    }

    @GenerateUncached
    static abstract class LookupFieldNode
    extends Node {
        static final int LIMIT = 3;

        LookupFieldNode() {
        }

        public abstract HostFieldDesc execute(HostObject var1, Class<?> var2, String var3, boolean var4);

        @Specialization(guards={"onlyStatic == cachedStatic", "clazz == cachedClazz", "cachedName.equals(name)"}, limit="LIMIT")
        HostFieldDesc doCached(HostObject receiver, Class<?> clazz, String name, boolean onlyStatic, @Cached(value="onlyStatic") boolean cachedStatic, @Cached(value="clazz") Class<?> cachedClazz, @Cached(value="name") String cachedName, @Cached(value="doUncached(receiver, clazz, name, onlyStatic)") HostFieldDesc cachedField) {
            assert (cachedField == this.doUncached(receiver, clazz, name, onlyStatic));
            return cachedField;
        }

        @Specialization(replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        HostFieldDesc doUncached(HostObject receiver, Class<?> clazz, String name, boolean onlyStatic) {
            return HostInteropReflect.findField(receiver.getEngine(), clazz, name, onlyStatic);
        }
    }

    @GenerateUncached
    static abstract class LookupConstructorNode
    extends Node {
        static final int LIMIT = 3;

        LookupConstructorNode() {
        }

        public abstract HostMethodDesc execute(HostObject var1, Class<?> var2);

        @Specialization(guards={"clazz == cachedClazz"}, limit="LIMIT")
        HostMethodDesc doCached(HostObject receiver, Class<?> clazz, @Cached(value="clazz") Class<?> cachedClazz, @Cached(value="doUncached(receiver, clazz)") HostMethodDesc cachedMethod) {
            assert (cachedMethod == this.doUncached(receiver, clazz));
            return cachedMethod;
        }

        @Specialization(replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        HostMethodDesc doUncached(HostObject receiver, Class<?> clazz) {
            return HostClassDesc.forClass(receiver.getEngine(), clazz).lookupConstructor();
        }
    }

    @GenerateUncached
    static abstract class ArrayGet
    extends Node {
        ArrayGet() {
        }

        protected abstract Object execute(Object var1, int var2);

        @Specialization
        static boolean doBoolean(boolean[] array, int index) {
            return array[index];
        }

        @Specialization
        static byte doByte(byte[] array, int index) {
            return array[index];
        }

        @Specialization
        static short doShort(short[] array, int index) {
            return array[index];
        }

        @Specialization
        static char doChar(char[] array, int index) {
            return array[index];
        }

        @Specialization
        static int doInt(int[] array, int index) {
            return array[index];
        }

        @Specialization
        static long doLong(long[] array, int index) {
            return array[index];
        }

        @Specialization
        static float doFloat(float[] array, int index) {
            return array[index];
        }

        @Specialization
        static double doDouble(double[] array, int index) {
            return array[index];
        }

        @Specialization
        static Object doObject(Object[] array, int index) {
            return array[index];
        }
    }

    @GenerateUncached
    static abstract class ArraySet
    extends Node {
        ArraySet() {
        }

        protected abstract void execute(Object var1, int var2, Object var3);

        @Specialization
        static void doBoolean(boolean[] array, int index, boolean value) {
            array[index] = value;
        }

        @Specialization
        static void doByte(byte[] array, int index, byte value) {
            array[index] = value;
        }

        @Specialization
        static void doShort(short[] array, int index, short value) {
            array[index] = value;
        }

        @Specialization
        static void doChar(char[] array, int index, char value) {
            array[index] = value;
        }

        @Specialization
        static void doInt(int[] array, int index, int value) {
            array[index] = value;
        }

        @Specialization
        static void doLong(long[] array, int index, long value) {
            array[index] = value;
        }

        @Specialization
        static void doFloat(float[] array, int index, float value) {
            array[index] = value;
        }

        @Specialization
        static void doDouble(double[] array, int index, double value) {
            array[index] = value;
        }

        @Specialization
        static void doObject(Object[] array, int index, Object value) {
            array[index] = value;
        }
    }

    @ExportMessage
    static final class IsIdenticalOrUndefined {
        IsIdenticalOrUndefined() {
        }

        @Specialization
        static TriState doHostObject(HostObject receiver, HostObject other) {
            return receiver.obj == other.obj ? TriState.TRUE : TriState.FALSE;
        }

        @Fallback
        static TriState doOther(HostObject receiver, Object other) {
            return TriState.UNDEFINED;
        }
    }

    @ExportMessage
    static class Instantiate {
        Instantiate() {
        }

        @Specialization(guards={"!receiver.isClass()"})
        static Object doUnsupported(HostObject receiver, Object[] args) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"receiver.isArrayClass()"})
        static Object doArrayCached(HostObject receiver, Object[] args, @CachedLibrary(limit="1") InteropLibrary indexes, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException, UnsupportedTypeException, ArityException {
            if (args.length != 1) {
                error.enter();
                throw ArityException.create(1, args.length);
            }
            Object arg0 = args[0];
            if (!indexes.fitsInInt(arg0)) {
                error.enter();
                throw UnsupportedTypeException.create(args);
            }
            int length = indexes.asInt(arg0);
            Object array = Array.newInstance(receiver.asClass().getComponentType(), length);
            return HostObject.forObject(array, receiver.languageContext);
        }

        @Specialization(guards={"receiver.isDefaultClass()"})
        static Object doObjectCached(HostObject receiver, Object[] arguments, @Cached.Shared(value="lookupConstructor") @Cached LookupConstructorNode lookupConstructor, @Cached.Shared(value="hostExecute") @Cached HostExecuteNode executeMethod, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException, UnsupportedTypeException, ArityException {
            assert (!receiver.isArrayClass());
            HostMethodDesc constructor = lookupConstructor.execute(receiver, receiver.asClass());
            if (constructor != null) {
                return executeMethod.execute(constructor, null, arguments, receiver.languageContext);
            }
            error.enter();
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static class IsInstantiable {
        IsInstantiable() {
        }

        @Specialization(guards={"!receiver.isClass()"})
        static boolean doUnsupported(HostObject receiver) {
            return false;
        }

        @Specialization(guards={"receiver.isArrayClass()"})
        static boolean doArrayCached(HostObject receiver) {
            return true;
        }

        @Specialization(guards={"receiver.isDefaultClass()"})
        static boolean doObjectCached(HostObject receiver, @Cached.Shared(value="lookupConstructor") @Cached LookupConstructorNode lookupConstructor) {
            return lookupConstructor.execute(receiver, receiver.asClass()) != null;
        }
    }

    @ExportMessage
    static abstract class ReadArrayElement {
        ReadArrayElement() {
        }

        @Specialization(guards={"isArray.execute(receiver)"}, limit="1")
        protected static Object doArray(HostObject receiver, long index, @Cached ArrayGet arrayGet, @Cached.Shared(value="isArray") @Cached IsArrayNode isArray, @Cached.Shared(value="toGuest") @Cached PolyglotLanguageContext.ToGuestValueNode toGuest, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException {
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter();
                throw InvalidArrayIndexException.create(index);
            }
            Object obj = receiver.obj;
            Object val = null;
            try {
                val = arrayGet.execute(obj, (int)index);
            }
            catch (ArrayIndexOutOfBoundsException outOfBounds) {
                error.enter();
                throw InvalidArrayIndexException.create(index);
            }
            return toGuest.execute(receiver.languageContext, val);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isList.execute(receiver)"}, limit="1")
        protected static Object doList(HostObject receiver, long index, @Cached.Shared(value="isList") @Cached IsListNode isList, @Cached.Shared(value="toGuest") @Cached PolyglotLanguageContext.ToGuestValueNode toGuest, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException {
            try {
                if (index < 0L || Integer.MAX_VALUE < index) {
                    error.enter();
                    throw InvalidArrayIndexException.create(index);
                }
                return toGuest.execute(receiver.languageContext, ((List)receiver.obj).get((int)index));
            }
            catch (IndexOutOfBoundsException e) {
                error.enter();
                throw InvalidArrayIndexException.create(index);
            }
        }

        @Specialization(guards={"!isArray.execute(receiver)", "!isList.execute(receiver)"}, limit="1")
        protected static Object doNotArrayOrList(HostObject receiver, long index, @Cached.Shared(value="isArray") @Cached IsArrayNode isArray, @Cached.Shared(value="isList") @Cached IsListNode isList) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static class RemoveArrayElement {
        RemoveArrayElement() {
        }

        @Specialization(guards={"isList.execute(receiver)"}, limit="1")
        static void doList(HostObject receiver, long index, @Cached.Shared(value="isList") @Cached IsListNode isList, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException {
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter();
                throw InvalidArrayIndexException.create(index);
            }
            try {
                RemoveArrayElement.boundaryRemove(receiver, index);
            }
            catch (IndexOutOfBoundsException outOfBounds) {
                error.enter();
                throw InvalidArrayIndexException.create(index);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static Object boundaryRemove(HostObject receiver, long index) throws IndexOutOfBoundsException {
            return ((List)receiver.obj).remove((int)index);
        }

        @Specialization(guards={"!isList.execute(receiver)"}, limit="1")
        static void doOther(HostObject receiver, long index, @Cached.Shared(value="isList") @Cached IsListNode isList) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static class IsArrayElementRemovable {
        IsArrayElementRemovable() {
        }

        @Specialization(guards={"isList.execute(receiver)"}, limit="1")
        static boolean doList(HostObject receiver, long index, @Cached.Shared(value="isList") @Cached IsListNode isList) {
            return index >= 0L && index < (long)IsArrayElementRemovable.callSize(receiver);
        }

        @CompilerDirectives.TruffleBoundary
        private static int callSize(HostObject receiver) {
            return ((List)receiver.obj).size();
        }

        @Specialization(guards={"!isList.execute(receiver)"}, limit="1")
        static boolean doOther(HostObject receiver, long index, @Cached.Shared(value="isList") @Cached IsListNode isList) {
            return false;
        }
    }

    @ExportMessage
    static class WriteArrayElement {
        WriteArrayElement() {
        }

        @Specialization(guards={"isArray.execute(receiver)"}, limit="1")
        static void doArray(HostObject receiver, long index, Object value, @Cached.Shared(value="toHost") @Cached ToHostNode toHostNode, @Cached.Shared(value="isArray") @Cached IsArrayNode isArray, @Cached ArraySet arraySet, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException, UnsupportedTypeException {
            Object javaValue;
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter();
                throw InvalidArrayIndexException.create(index);
            }
            Object obj = receiver.obj;
            try {
                javaValue = toHostNode.execute(value, obj.getClass().getComponentType(), null, receiver.languageContext, true);
            }
            catch (PolyglotEngineException e) {
                error.enter();
                throw UnsupportedTypeException.create(new Object[]{value}, WriteArrayElement.getMessage(e));
            }
            try {
                arraySet.execute(obj, (int)index, javaValue);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                error.enter();
                throw InvalidArrayIndexException.create(index);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static String getMessage(PolyglotEngineException e) {
            return e.e.getMessage();
        }

        @Specialization(guards={"isList.execute(receiver)"}, limit="1")
        static void doList(HostObject receiver, long index, Object value, @Cached.Shared(value="isList") @Cached IsListNode isList, @Cached.Shared(value="toHost") @Cached ToHostNode toHostNode, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException, UnsupportedTypeException {
            Object javaValue;
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter();
                throw InvalidArrayIndexException.create(index);
            }
            try {
                javaValue = toHostNode.execute(value, Object.class, null, receiver.languageContext, true);
            }
            catch (PolyglotEngineException e) {
                error.enter();
                throw UnsupportedTypeException.create(new Object[]{value}, WriteArrayElement.getMessage(e));
            }
            try {
                List list = (List)receiver.obj;
                WriteArrayElement.setList(list, index, javaValue);
            }
            catch (IndexOutOfBoundsException e) {
                error.enter();
                throw InvalidArrayIndexException.create(index);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void setList(List<Object> list, long index, Object hostValue) {
            if (index == (long)list.size()) {
                list.add(hostValue);
            } else {
                list.set((int)index, hostValue);
            }
        }

        @Specialization(guards={"!isList.execute(receiver)", "!isArray.execute(receiver)"}, limit="1")
        static void doNotArrayOrList(HostObject receiver, long index, Object value, @Cached.Shared(value="isList") @Cached IsListNode isList, @Cached.Shared(value="isArray") @Cached IsArrayNode isArray) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isArrayElementReadable"), @ExportMessage(name="isArrayElementModifiable")})
    static class IsArrayElementExisting {
        IsArrayElementExisting() {
        }

        @Specialization(guards={"isArray.execute(receiver)"}, limit="1")
        static boolean doArray(HostObject receiver, long index, @Cached.Shared(value="isArray") @Cached IsArrayNode isArray) {
            long size = Array.getLength(receiver.obj);
            return index >= 0L && index < size;
        }

        @Specialization(guards={"isList.execute(receiver)"}, limit="1")
        static boolean doList(HostObject receiver, long index, @Cached.Shared(value="isList") @Cached IsListNode isList) {
            long size = receiver.getListSize();
            return index >= 0L && index < size;
        }

        @Specialization(guards={"!isList.execute(receiver)", "!isArray.execute(receiver)"}, limit="1")
        static boolean doNotArrayOrList(HostObject receiver, long index, @Cached.Shared(value="isList") @Cached IsListNode isList, @Cached.Shared(value="isArray") @Cached IsArrayNode isArray) {
            return false;
        }
    }

    @ExportMessage
    static class IsMemberInvocable {
        IsMemberInvocable() {
        }

        @Specialization(guards={"receiver.isStaticClass()", "receiver.isStaticClass() == cachedStatic", "receiver.getLookupClass() == cachedClazz", "cachedName.equals(name)"}, limit="LIMIT")
        static boolean doCached(HostObject receiver, String name, @Cached(value="receiver.isStaticClass()") boolean cachedStatic, @Cached(value="receiver.getLookupClass()") Class<?> cachedClazz, @Cached(value="name") String cachedName, @Cached(value="doUncached(receiver, name)") boolean cachedInvokable) {
            assert (cachedInvokable == IsMemberInvocable.doUncached(receiver, name));
            return cachedInvokable;
        }

        @Specialization(replaces={"doCached"})
        static boolean doUncached(HostObject receiver, String name) {
            if (receiver.isNull()) {
                return false;
            }
            return HostInteropReflect.isInvokable(receiver, receiver.getLookupClass(), name, receiver.isStaticClass());
        }
    }

    @ExportMessage
    static class IsMemberInternal {
        IsMemberInternal() {
        }

        @Specialization(guards={"receiver.isStaticClass()", "receiver.isStaticClass() == cachedStatic", "receiver.getLookupClass() == cachedClazz", "cachedName.equals(name)"}, limit="LIMIT")
        static boolean doCached(HostObject receiver, String name, @Cached(value="receiver.isStaticClass()") boolean cachedStatic, @Cached(value="receiver.getLookupClass()") Class<?> cachedClazz, @Cached(value="name") String cachedName, @Cached(value="doUncached(receiver, name)") boolean cachedInternal) {
            assert (cachedInternal == IsMemberInternal.doUncached(receiver, name));
            return cachedInternal;
        }

        @Specialization(replaces={"doCached"})
        static boolean doUncached(HostObject receiver, String name) {
            if (receiver.isNull()) {
                return false;
            }
            return HostInteropReflect.isInternal(receiver, receiver.getLookupClass(), name, receiver.isStaticClass());
        }
    }

    @ExportMessage
    static class IsMemberModifiable {
        IsMemberModifiable() {
        }

        @Specialization(guards={"receiver.isStaticClass()", "receiver.isStaticClass() == cachedStatic", "receiver.getLookupClass() == cachedClazz", "cachedName.equals(name)"}, limit="LIMIT")
        static boolean doCached(HostObject receiver, String name, @Cached(value="receiver.isStaticClass()") boolean cachedStatic, @Cached(value="receiver.getLookupClass()") Class<?> cachedClazz, @Cached(value="name") String cachedName, @Cached(value="doUncached(receiver, name)") boolean cachedModifiable) {
            assert (cachedModifiable == IsMemberModifiable.doUncached(receiver, name));
            return cachedModifiable;
        }

        @Specialization(replaces={"doCached"})
        static boolean doUncached(HostObject receiver, String name) {
            if (receiver.isNull()) {
                return false;
            }
            return HostInteropReflect.isModifiable(receiver, receiver.getLookupClass(), name, receiver.isStaticClass());
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class KeysArray
    implements TruffleObject {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final String[] keys;

        KeysArray(String[] keys) {
            this.keys = keys;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.keys.length;
        }

        @ExportMessage
        boolean isArrayElementReadable(long idx) {
            return 0L <= idx && idx < (long)this.keys.length;
        }

        @ExportMessage
        String readArrayElement(long idx, @Cached BranchProfile error) throws InvalidArrayIndexException {
            if (!this.isArrayElementReadable(idx)) {
                error.enter();
                throw InvalidArrayIndexException.create(idx);
            }
            return this.keys[(int)idx];
        }
    }

    @ExportMessage
    static class IsMemberReadable {
        IsMemberReadable() {
        }

        @Specialization(guards={"receiver.isStaticClass()", "receiver.isStaticClass() == cachedStatic", "receiver.getLookupClass() == cachedClazz", "cachedName.equals(name)"}, limit="LIMIT")
        static boolean doCached(HostObject receiver, String name, @Cached(value="receiver.isStaticClass()") boolean cachedStatic, @Cached(value="receiver.getLookupClass()") Class<?> cachedClazz, @Cached(value="name") String cachedName, @Cached(value="doUncached(receiver, name)") boolean cachedReadable) {
            assert (cachedReadable == IsMemberReadable.doUncached(receiver, name));
            return cachedReadable;
        }

        @Specialization(replaces={"doCached"})
        static boolean doUncached(HostObject receiver, String name) {
            if (receiver.isNull()) {
                return false;
            }
            return HostInteropReflect.isReadable(receiver, receiver.getLookupClass(), name, receiver.isStaticClass(), receiver.isClass());
        }
    }
}

