/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.SpecializationStatistics;
import com.oracle.truffle.api.utilities.TruffleWeakReference;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotThread;
import com.oracle.truffle.polyglot.SuppressFBWarnings;
import java.util.LinkedList;

final class PolyglotThreadInfo {
    static final PolyglotThreadInfo NULL = new PolyglotThreadInfo(null, null);
    private static final Object NULL_CLASS_LOADER = new Object();
    private final PolyglotContextImpl context;
    private final TruffleWeakReference<Thread> thread;
    private volatile int enteredCount;
    final LinkedList<PolyglotContextImpl> explicitContextStack = new LinkedList();
    volatile boolean cancelled;
    private Object originalContextClassLoader = NULL_CLASS_LOADER;
    private ClassLoaderEntry prevContextClassLoader;
    private SpecializationStatisticsEntry executionStatisticsEntry;
    private volatile Object[] contextThreadLocals;

    PolyglotThreadInfo(PolyglotContextImpl context, Thread thread) {
        this.context = context;
        this.thread = new TruffleWeakReference<Thread>(thread);
    }

    Thread getThread() {
        return (Thread)this.thread.get();
    }

    public Object[] getContextThreadLocals() {
        assert (Thread.holdsLock(this.context));
        return this.contextThreadLocals;
    }

    public void setContextThreadLocals(Object[] contextThreadLocals) {
        assert (Thread.holdsLock(this.context));
        this.contextThreadLocals = contextThreadLocals;
    }

    boolean isCurrent() {
        return this.getThread() == Thread.currentThread();
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"})
    void enter(PolyglotEngineImpl engine, PolyglotContextImpl profiledContext) {
        assert (Thread.currentThread() == this.getThread());
        ++this.enteredCount;
        if (CompilerDirectives.injectBranchProbability(1.0E-4, profiledContext.invalid)) {
            CompilerDirectives.transferToInterpreter();
            try {
                profiledContext.checkClosed();
            }
            catch (Throwable t) {
                --this.enteredCount;
                throw t;
            }
        }
        if (!engine.customHostClassLoader.isValid()) {
            this.setContextClassLoader();
        }
        try {
            EngineAccessor.INSTRUMENT.notifyEnter(engine.instrumentationHandler, profiledContext.creatorTruffleContext);
        }
        catch (Throwable t) {
            --this.enteredCount;
            throw t;
        }
        if (engine.specializationStatistics != null) {
            engine.specializationStatistics.enter();
        }
    }

    boolean isPolyglotThread(PolyglotContextImpl c) {
        if (this.getThread() instanceof PolyglotThread) {
            return ((PolyglotThread)this.getThread()).isOwner(c);
        }
        return false;
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"})
    void leave(PolyglotEngineImpl engine, PolyglotContextImpl profiledContext) {
        assert (Thread.currentThread() == this.getThread());
        try {
            EngineAccessor.INSTRUMENT.notifyLeave(engine.instrumentationHandler, profiledContext.creatorTruffleContext);
        }
        finally {
            --this.enteredCount;
            if (!engine.customHostClassLoader.isValid()) {
                this.restoreContextClassLoader();
            }
            if (engine.specializationStatistics != null) {
                this.leaveStatistics(engine.specializationStatistics);
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void enterStatistics(SpecializationStatistics statistics) {
        SpecializationStatistics prev = statistics.enter();
        if (prev != null || this.executionStatisticsEntry != null) {
            this.executionStatisticsEntry = new SpecializationStatisticsEntry(prev, this.executionStatisticsEntry);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void leaveStatistics(SpecializationStatistics statistics) {
        SpecializationStatisticsEntry entry = this.executionStatisticsEntry;
        if (entry == null) {
            statistics.leave(null);
        } else {
            statistics.leave(entry.statistics);
            this.executionStatisticsEntry = entry.next;
        }
    }

    boolean isLastActive() {
        return this.getThread() != null && this.enteredCount == 1 && !this.cancelled;
    }

    boolean isActiveNotCancelled() {
        return this.getThread() != null && this.enteredCount > 0 && !this.cancelled;
    }

    boolean isActive() {
        return this.getThread() != null && this.enteredCount > 0;
    }

    public String toString() {
        return super.toString() + "[thread=" + this.getThread() + ", enteredCount=" + this.enteredCount + ", cancelled=" + this.cancelled + "]";
    }

    @CompilerDirectives.TruffleBoundary
    private void setContextClassLoader() {
        ClassLoader hostClassLoader = this.context.config.hostClassLoader;
        if (hostClassLoader != null) {
            Thread t = this.getThread();
            ClassLoader original = t.getContextClassLoader();
            assert (this.originalContextClassLoader != NULL_CLASS_LOADER || this.prevContextClassLoader == null);
            if (this.originalContextClassLoader != NULL_CLASS_LOADER) {
                this.prevContextClassLoader = new ClassLoaderEntry((ClassLoader)this.originalContextClassLoader, this.prevContextClassLoader);
            }
            this.originalContextClassLoader = original;
            t.setContextClassLoader(hostClassLoader);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void restoreContextClassLoader() {
        if (this.originalContextClassLoader != NULL_CLASS_LOADER) {
            assert (this.context.config.hostClassLoader != null);
            Thread t = this.getThread();
            t.setContextClassLoader((ClassLoader)this.originalContextClassLoader);
            if (this.prevContextClassLoader != null) {
                this.originalContextClassLoader = this.prevContextClassLoader.classLoader;
                this.prevContextClassLoader = this.prevContextClassLoader.next;
            } else {
                this.originalContextClassLoader = NULL_CLASS_LOADER;
            }
        }
    }

    private static final class SpecializationStatisticsEntry {
        final SpecializationStatistics statistics;
        final SpecializationStatisticsEntry next;

        SpecializationStatisticsEntry(SpecializationStatistics statistics, SpecializationStatisticsEntry next) {
            this.statistics = statistics;
            this.next = next;
        }
    }

    private static final class ClassLoaderEntry {
        final ClassLoader classLoader;
        final ClassLoaderEntry next;

        ClassLoaderEntry(ClassLoader classLoader, ClassLoaderEntry next) {
            this.classLoader = classLoader;
            this.next = next;
        }
    }
}

