/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.polyglot.HostInteropErrors;
import com.oracle.truffle.polyglot.HostInteropReflect;
import com.oracle.truffle.polyglot.HostObject;
import com.oracle.truffle.polyglot.PolyglotClassCastException;
import com.oracle.truffle.polyglot.PolyglotFunction;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotList;
import com.oracle.truffle.polyglot.PolyglotMap;
import com.oracle.truffle.polyglot.TargetMappingNode;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Value;

@GenerateUncached
abstract class ToHostNode
extends Node {
    static final int LIMIT = 5;
    static final int STRICT = 0;
    static final int LOOSE = 1;
    static final int FUNCTION_PROXY = 2;
    static final int OBJECT_PROXY = 3;
    static final int HOST_PROXY = 4;
    static final int MAX = 4;
    static final int[] PRIORITIES = new int[]{0, 1, 2, 3, 4};

    ToHostNode() {
    }

    public abstract Object execute(Object var1, Class<?> var2, Type var3, PolyglotLanguageContext var4, boolean var5);

    @Specialization(guards={"targetType == cachedTargetType"}, limit="LIMIT")
    protected Object doCached(Object operand, Class<?> targetType, Type genericType, PolyglotLanguageContext languageContext, boolean useCustomTargetTypes, @CachedLibrary(value="operand") InteropLibrary interop, @Cached(value="targetType") Class<?> cachedTargetType, @Cached(value="isPrimitiveTarget(cachedTargetType)") boolean primitiveTarget, @Cached(value="allowsImplementation(languageContext, targetType)") boolean allowsImplementation, @Cached TargetMappingNode targetMapping) {
        return ToHostNode.convertImpl(operand, cachedTargetType, genericType, allowsImplementation, primitiveTarget, languageContext, interop, useCustomTargetTypes, targetMapping);
    }

    @CompilerDirectives.TruffleBoundary
    static boolean allowsImplementation(PolyglotLanguageContext languagecontext, Class<?> type) {
        if (languagecontext == null) {
            return false;
        }
        if (!type.isInterface()) {
            return false;
        }
        return languagecontext.getEngine().getHostClassCache().forClass(type).isAllowsImplementation();
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(replaces={"doCached"})
    protected static Object doGeneric(Object operand, Class<?> targetType, Type genericType, PolyglotLanguageContext languageContext, boolean useTargetMapping, @Cached(value="getUncached()") TargetMappingNode targetMapping, @CachedLibrary(limit="0") InteropLibrary interop) {
        return ToHostNode.convertImpl(operand, targetType, genericType, ToHostNode.allowsImplementation(languageContext, targetType), ToHostNode.isPrimitiveTarget(targetType), languageContext, interop, useTargetMapping, targetMapping);
    }

    static Object convertLossLess(Object value, Class<?> requestedType, InteropLibrary interop) {
        try {
            if (interop.isNumber(value)) {
                if (requestedType == Byte.TYPE || requestedType == Byte.class) {
                    return interop.asByte(value);
                }
                if (requestedType == Short.TYPE || requestedType == Short.class) {
                    return interop.asShort(value);
                }
                if (requestedType == Integer.TYPE || requestedType == Integer.class) {
                    return interop.asInt(value);
                }
                if (requestedType == Long.TYPE || requestedType == Long.class) {
                    return interop.asLong(value);
                }
                if (requestedType == Float.TYPE || requestedType == Float.class) {
                    return Float.valueOf(interop.asFloat(value));
                }
                if (requestedType == Double.TYPE || requestedType == Double.class) {
                    return interop.asDouble(value);
                }
                if (requestedType == Number.class) {
                    return ToHostNode.convertToNumber(value, interop);
                }
            } else if (interop.isBoolean(value)) {
                if (requestedType == Boolean.TYPE || requestedType == Boolean.class) {
                    return interop.asBoolean(value);
                }
            } else if (interop.isString(value)) {
                if (requestedType == Character.TYPE || requestedType == Character.class) {
                    String str = interop.asString(value);
                    if (str.length() == 1) {
                        return Character.valueOf(str.charAt(0));
                    }
                } else if (requestedType == String.class || requestedType == CharSequence.class) {
                    return interop.asString(value);
                }
            }
        }
        catch (UnsupportedMessageException unsupportedMessageException) {
            // empty catch block
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    private static String toString(Object value) {
        return value.toString();
    }

    static Object convertLossy(Object value, Class<?> targetType, InteropLibrary interop) {
        Object convertedValue = ToHostNode.convertLossLess(value, targetType, interop);
        if (convertedValue != null) {
            return convertedValue;
        }
        if ((targetType == Character.TYPE || targetType == Character.class) && interop.fitsInInt(value)) {
            try {
                int v = interop.asInt(value);
                if (v >= 0 && v < 65536) {
                    return Character.valueOf((char)v);
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Object convertImpl(Object value, Class<?> targetType, Type genericType, boolean allowsImplementation, boolean primitiveTargetType, PolyglotLanguageContext languageContext, InteropLibrary interop, boolean useCustomTargetTypes, TargetMappingNode targetMapping) {
        Object convertedValue;
        Object result;
        if (useCustomTargetTypes && (result = targetMapping.execute(value, targetType, languageContext, interop, false)) != TargetMappingNode.NO_RESULT) {
            return result;
        }
        if (primitiveTargetType && (convertedValue = ToHostNode.convertLossy(value, targetType, interop)) != null) {
            return convertedValue;
        }
        if (targetType == Value.class && languageContext != null) {
            convertedValue = value instanceof Value ? value : languageContext.asValue(value);
        } else if (value instanceof TruffleObject) {
            convertedValue = ToHostNode.asJavaObject((TruffleObject)value, targetType, genericType, allowsImplementation, languageContext);
        } else if (targetType.isAssignableFrom(value.getClass())) {
            convertedValue = value;
        } else {
            CompilerDirectives.transferToInterpreter();
            throw HostInteropErrors.cannotConvertPrimitive(languageContext, value, targetType);
        }
        return targetType.cast(convertedValue);
    }

    static boolean canConvertToPrimitive(Object value, Class<?> targetType, InteropLibrary interop) {
        if (HostObject.isJavaInstance(targetType, value)) {
            return true;
        }
        if (!ToHostNode.isPrimitiveTarget(targetType)) {
            return false;
        }
        Object convertedValue = ToHostNode.convertLossLess(value, targetType, interop);
        return convertedValue != null;
    }

    static boolean canConvert(Object value, Class<?> targetType, Type genericType, Boolean allowsImplementation, PolyglotLanguageContext languageContext, int priority, InteropLibrary interop, TargetMappingNode targetMapping) {
        if (targetMapping != null && targetMapping.execute(value, targetType, languageContext, interop, true) == Boolean.TRUE) {
            return true;
        }
        if (ToHostNode.canConvertToPrimitive(value, targetType, interop)) {
            return true;
        }
        if (priority <= 0) {
            return false;
        }
        if ((targetType == Character.TYPE || targetType == Character.class) && interop.fitsInInt(value)) {
            try {
                int v = interop.asInt(value);
                if (v >= 0 && v < 65536) {
                    return true;
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
        }
        if (targetType == Value.class && languageContext != null) {
            return true;
        }
        if (value instanceof TruffleObject) {
            if (interop.isNull(value)) {
                return !targetType.isPrimitive();
            }
            if (targetType == Object.class) {
                return true;
            }
            if (HostObject.isJavaInstance(targetType, value)) {
                return true;
            }
            if (targetType == List.class) {
                return interop.hasArrayElements(value);
            }
            if (targetType == Map.class) {
                return interop.hasMembers(value);
            }
            if (targetType.isArray()) {
                return interop.hasArrayElements(value);
            }
            if (targetType == LocalDate.class) {
                return interop.isDate(value);
            }
            if (targetType == LocalTime.class) {
                return interop.isTime(value);
            }
            if (targetType == LocalDateTime.class) {
                return interop.isDate(value) && interop.isTime(value);
            }
            if (targetType == ZonedDateTime.class || targetType == Date.class || targetType == Instant.class) {
                return interop.isInstant(value);
            }
            if (targetType == ZoneId.class) {
                return interop.isTimeZone(value);
            }
            if (targetType == Duration.class) {
                return interop.isDuration(value);
            }
            if (targetType == PolyglotException.class) {
                return interop.isException(value);
            }
            if (priority < 4 && HostObject.isInstance(value)) {
                return false;
            }
            if (priority >= 2 && HostInteropReflect.isFunctionalInterface(targetType) && (interop.isExecutable(value) || interop.isInstantiable(value)) && ToHostNode.checkAllowsImplementation(targetType, allowsImplementation, languageContext)) {
                return true;
            }
            return priority >= 3 && targetType.isInterface() && interop.hasMembers(value) && ToHostNode.checkAllowsImplementation(targetType, allowsImplementation, languageContext);
        }
        assert (!(value instanceof TruffleObject));
        return targetType.isInstance(value);
    }

    private static boolean checkAllowsImplementation(Class<?> targetType, Boolean allowsImplementation, PolyglotLanguageContext languageContext) {
        boolean implementations = allowsImplementation == null ? ToHostNode.allowsImplementation(languageContext, targetType) : allowsImplementation;
        return implementations;
    }

    static boolean isPrimitiveTarget(Class<?> clazz) {
        return clazz == Integer.TYPE || clazz == Integer.class || clazz == Boolean.TYPE || clazz == Boolean.class || clazz == Byte.TYPE || clazz == Byte.class || clazz == Short.TYPE || clazz == Short.class || clazz == Long.TYPE || clazz == Long.class || clazz == Float.TYPE || clazz == Float.class || clazz == Double.TYPE || clazz == Double.class || clazz == Character.TYPE || clazz == Character.class || clazz == Number.class || CharSequence.class.isAssignableFrom(clazz);
    }

    private static Object convertToObject(Object value, PolyglotLanguageContext languageContext, InteropLibrary interop) {
        try {
            if (interop.isNull(value)) {
                return null;
            }
            if (interop.isString(value)) {
                return interop.asString(value);
            }
            if (interop.isBoolean(value)) {
                return interop.asBoolean(value);
            }
            if (interop.isNumber(value)) {
                Object result = ToHostNode.convertToNumber(value, interop);
                if (result != null) {
                    return result;
                }
            } else {
                if (interop.hasMembers(value)) {
                    return ToHostNode.asJavaObject(value, Map.class, null, false, languageContext);
                }
                if (interop.hasArrayElements(value)) {
                    return ToHostNode.asJavaObject(value, List.class, null, false, languageContext);
                }
                if (interop.isExecutable(value) || interop.isInstantiable(value)) {
                    return ToHostNode.asJavaObject(value, Function.class, null, false, languageContext);
                }
            }
            return languageContext.asValue(value);
        }
        catch (UnsupportedMessageException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Object convertToNumber(Object value, InteropLibrary interop) {
        try {
            if (value instanceof Number) {
                return value;
            }
            if (interop.fitsInByte(value)) {
                return interop.asByte(value);
            }
            if (interop.fitsInShort(value)) {
                return interop.asShort(value);
            }
            if (interop.fitsInInt(value)) {
                return interop.asInt(value);
            }
            if (interop.fitsInLong(value)) {
                return interop.asLong(value);
            }
            if (interop.fitsInFloat(value)) {
                return Float.valueOf(interop.asFloat(value));
            }
            if (interop.fitsInDouble(value)) {
                return interop.asDouble(value);
            }
        }
        catch (UnsupportedMessageException unsupportedMessageException) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CompilerDirectives.TruffleBoundary
    private static <T> T asJavaObject(Object value, Class<T> targetType, Type genericType, boolean allowsImplementation, PolyglotLanguageContext languageContext) {
        Object obj;
        Objects.requireNonNull(value);
        InteropLibrary interop = InteropLibrary.getFactory().getUncached(value);
        if (interop.isNull(value)) {
            if (!targetType.isPrimitive()) return null;
            throw HostInteropErrors.nullCoercion(languageContext, value, targetType);
        }
        if (HostObject.isJavaInstance(targetType, value)) {
            obj = HostObject.valueOf(value);
        } else if (targetType == Object.class) {
            obj = ToHostNode.convertToObject(value, languageContext, interop);
        } else if (targetType == List.class) {
            if (!interop.hasArrayElements(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must have array elements.");
            boolean implementsFunction = ToHostNode.shouldImplementFunction(value, interop);
            TypeAndClass<?> elementType = ToHostNode.getGenericParameterType(genericType, 0);
            obj = PolyglotList.create(languageContext, value, implementsFunction, elementType.clazz, elementType.type);
        } else if (targetType == Map.class) {
            boolean hasKeys;
            Class keyClazz = ToHostNode.getGenericParameterType((Type)genericType, (int)0).clazz;
            TypeAndClass<?> valueType = ToHostNode.getGenericParameterType(genericType, 1);
            if (!ToHostNode.isSupportedMapKeyType(keyClazz)) {
                throw ToHostNode.newInvalidKeyTypeException(keyClazz);
            }
            boolean hasSize = Number.class.isAssignableFrom(keyClazz) && interop.hasArrayElements(value);
            boolean bl = hasKeys = (keyClazz == Object.class || keyClazz == String.class) && interop.hasMembers(value);
            if (!hasKeys && !hasSize) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must have members or array elements.");
            boolean implementsFunction = ToHostNode.shouldImplementFunction(value, interop);
            obj = PolyglotMap.create(languageContext, value, implementsFunction, keyClazz, valueType.clazz, valueType.type);
        } else if (targetType == Function.class) {
            TypeAndClass<?> returnType = ToHostNode.getGenericParameterType(genericType, 1);
            if (interop.isExecutable(value) || interop.isInstantiable(value)) {
                obj = PolyglotFunction.create(languageContext, value, returnType.clazz, returnType.type);
            } else {
                if (!interop.hasMembers(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must be executable or instantiable.");
                obj = HostInteropReflect.newProxyInstance(targetType, value, languageContext);
            }
        } else if (targetType.isArray()) {
            if (!interop.hasArrayElements(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must have array elements.");
            obj = ToHostNode.truffleObjectToArray(value, targetType, genericType, languageContext);
        } else {
            if (targetType == LocalDate.class) {
                if (!interop.isDate(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must have date and time information.");
                try {
                    obj = interop.asDate(value);
                }
                catch (UnsupportedMessageException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (targetType == LocalTime.class) {
                if (!interop.isTime(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must have date and time information.");
                try {
                    obj = interop.asTime(value);
                }
                catch (UnsupportedMessageException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (targetType == LocalDateTime.class) {
                LocalTime time;
                LocalDate date;
                if (!interop.isDate(value) || !interop.isTime(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must have date and time information.");
                try {
                    date = interop.asDate(value);
                    time = interop.asTime(value);
                }
                catch (UnsupportedMessageException e) {
                    throw new AssertionError((Object)e);
                }
                obj = ToHostNode.createDateTime(date, time);
            } else if (targetType == ZonedDateTime.class) {
                ZoneId timeZone;
                LocalTime time;
                LocalDate date;
                if (!interop.isDate(value) || !interop.isTime(value) || !interop.isTimeZone(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must have date, time and time-zone information.");
                try {
                    date = interop.asDate(value);
                    time = interop.asTime(value);
                    timeZone = interop.asTimeZone(value);
                }
                catch (UnsupportedMessageException e) {
                    throw new AssertionError((Object)e);
                }
                obj = ToHostNode.createZonedDateTime(date, time, timeZone);
            } else {
                if (targetType == ZoneId.class) {
                    if (!interop.isTimeZone(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must have time-zone information.");
                    try {
                        obj = interop.asTimeZone(value);
                    }
                    catch (UnsupportedMessageException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                if (targetType == Instant.class || targetType == Date.class) {
                    Instant instantValue;
                    if (!interop.isDate(value) || !interop.isTime(value) || !interop.isTimeZone(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must have date, time and time-zone information.");
                    try {
                        instantValue = interop.asInstant(value);
                    }
                    catch (UnsupportedMessageException e) {
                        throw new AssertionError((Object)e);
                    }
                    obj = targetType == Date.class ? Date.from(instantValue) : targetType.cast(instantValue);
                } else if (targetType == Duration.class) {
                    if (!interop.isDuration(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must have duration information.");
                    try {
                        obj = interop.asDuration(value);
                    }
                    catch (UnsupportedMessageException e) {
                        throw new AssertionError((Object)e);
                    }
                } else if (targetType == PolyglotException.class) {
                    if (!interop.isException(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must be an exception.");
                    obj = ToHostNode.asPolyglotException(value, interop, languageContext);
                } else {
                    if (!allowsImplementation || !targetType.isInterface()) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Unsupported target type.");
                    if (HostInteropReflect.isFunctionalInterface(targetType) && (interop.isExecutable(value) || interop.isInstantiable(value))) {
                        obj = HostInteropReflect.asJavaFunction(targetType, value, languageContext);
                    } else {
                        if (!interop.hasMembers(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must have members.");
                        obj = HostInteropReflect.newProxyInstance(targetType, value, languageContext);
                    }
                }
            }
        }
        assert (targetType.isInstance(obj));
        return targetType.cast(obj);
    }

    private static Object asPolyglotException(Object value, InteropLibrary interop, PolyglotLanguageContext languageContext) {
        try {
            interop.throwException(value);
            throw UnsupportedMessageException.create();
        }
        catch (UnsupportedMessageException e) {
            throw new AssertionError((Object)e);
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            return PolyglotImpl.wrapGuestException(languageContext, e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static ZonedDateTime createZonedDateTime(LocalDate date, LocalTime time, ZoneId timeZone) {
        return ZonedDateTime.of(date, time, timeZone);
    }

    @CompilerDirectives.TruffleBoundary
    private static LocalDateTime createDateTime(LocalDate date, LocalTime time) {
        return LocalDateTime.of(date, time);
    }

    private static boolean shouldImplementFunction(Object truffleObject, InteropLibrary interop) {
        boolean executable = interop.isExecutable(truffleObject);
        boolean instantiable = false;
        if (!executable) {
            instantiable = interop.isInstantiable(truffleObject);
        }
        boolean implementsFunction = executable || instantiable;
        return implementsFunction;
    }

    private static boolean isSupportedMapKeyType(Class<?> keyType) {
        return keyType == Object.class || keyType == String.class || keyType == Long.class || keyType == Integer.class || keyType == Number.class;
    }

    @CompilerDirectives.TruffleBoundary
    private static ClassCastException newInvalidKeyTypeException(Type targetType) {
        String message = "Unsupported Map key type: " + targetType;
        return new PolyglotClassCastException(message);
    }

    private static TypeAndClass<?> getGenericParameterType(Type genericType, int index) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parametrizedType = (ParameterizedType)genericType;
            Type[] typeArguments = parametrizedType.getActualTypeArguments();
            Class elementClass = Object.class;
            if (index < typeArguments.length) {
                Type elementType = typeArguments[index];
                if (elementType instanceof ParameterizedType) {
                    elementType = ((ParameterizedType)elementType).getRawType();
                }
                if (elementType instanceof Class) {
                    elementClass = (Class)elementType;
                }
                return new TypeAndClass(typeArguments[index], elementClass);
            }
        }
        return TypeAndClass.ANY;
    }

    private static Type getGenericArrayComponentType(Type genericType) {
        Type genericComponentType = null;
        if (genericType instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)genericType;
            genericComponentType = genericArrayType.getGenericComponentType();
        }
        return genericComponentType;
    }

    private static Object truffleObjectToArray(Object foreignObject, Class<?> arrayType, Type genericArrayType, PolyglotLanguageContext languageContext) {
        Class<?> componentType = arrayType.getComponentType();
        List<?> list = PolyglotList.create(languageContext, foreignObject, false, componentType, ToHostNode.getGenericArrayComponentType(genericArrayType));
        Object array = Array.newInstance(componentType, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Array.set(array, i, list.get(i));
        }
        return array;
    }

    static final class TypeAndClass<T> {
        static final TypeAndClass<Object> ANY = new TypeAndClass<Object>(null, Object.class);
        final Type type;
        final Class<T> clazz;

        TypeAndClass(Type type, Class<T> clazz) {
            this.type = type;
            this.clazz = clazz;
        }

        public String toString() {
            return "[" + this.clazz + ": " + Objects.toString(this.type) + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TypeAndClass)) {
                return false;
            }
            TypeAndClass other = (TypeAndClass)obj;
            return Objects.equals(this.clazz, other.clazz) && Objects.equals(this.type, other.type);
        }
    }
}

