/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.polyglot.DefaultScope;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import java.util.Map;
import org.graalvm.polyglot.Value;

@ExportLibrary(value=InteropLibrary.class)
final class PolyglotBindings
implements TruffleObject {
    private final PolyglotLanguageContext languageContext;
    private final Map<String, Value> bindings;

    PolyglotBindings(PolyglotLanguageContext languageContext, Map<String, Value> bindings) {
        this.languageContext = languageContext;
        this.bindings = bindings;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object readMember(String member) throws UnknownIdentifierException {
        Value value = this.bindings.get(member);
        if (value == null) {
            Value legacyValue = this.languageContext.context.findLegacyExportedSymbol(member);
            if (legacyValue != null) {
                return this.languageContext.getAPIAccess().getReceiver(legacyValue);
            }
            throw UnknownIdentifierException.create(member);
        }
        return this.languageContext.toGuestValue(value);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void writeMember(String member, Object value) {
        this.bindings.put(member, this.languageContext.asValue(value));
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void removeMember(String member) throws UnknownIdentifierException {
        Value ret = this.bindings.remove(member);
        if (ret == null) {
            throw UnknownIdentifierException.create(member);
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal) {
        return new DefaultScope.VariableNamesObject(this.bindings.keySet());
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isMemberReadable"), @ExportMessage(name="isMemberModifiable"), @ExportMessage(name="isMemberRemovable")})
    @CompilerDirectives.TruffleBoundary
    boolean isMemberExisting(String member) {
        boolean existing = this.bindings.containsKey(member);
        if (!existing) {
            return this.languageContext.context.findLegacyExportedSymbol(member) != null;
        }
        return existing;
    }

    @ExportMessage
    boolean isMemberInsertable(String member) {
        return !this.isMemberExisting(member);
    }
}

