/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.source.ByteSequenceWrapper;
import com.oracle.truffle.api.source.CharSequenceReader;
import com.oracle.truffle.api.source.CharSequenceWrapper;
import com.oracle.truffle.api.source.InternedSources;
import com.oracle.truffle.api.source.MissingMIMETypeException;
import com.oracle.truffle.api.source.MissingNameException;
import com.oracle.truffle.api.source.SourceAccessor;
import com.oracle.truffle.api.source.SourceImpl;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.source.SourceSectionLoaded;
import com.oracle.truffle.api.source.SourceSectionUnavailable;
import com.oracle.truffle.api.source.SourceSectionUnloaded;
import com.oracle.truffle.api.source.SubSourceImpl;
import com.oracle.truffle.api.source.TextMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.graalvm.polyglot.io.ByteSequence;

public abstract class Source {
    public static final CharSequence CONTENT_NONE = null;
    private static final CharSequence CONTENT_UNSET = new String();
    private static final String UNKNOWN_MIME_TYPE = "content/unknown";
    private static final Source EMPTY = new SourceImpl.Key(null, null, null, null, null, null, null, false, false, false, true).toSourceNotInterned();
    private static final String NO_FASTPATH_SUBSOURCE_CREATION_MESSAGE = "do not create sub sources from compiled code";
    private static final String URI_SCHEME = "truffle";
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    private static final int BUFFER_SIZE = 8192;
    static final Class<?> BYTE_SEQUENCE_CLASS = ByteSequence.create((byte[])new byte[0]).getClass();
    private static final InternedSources SOURCES = new InternedSources();
    private volatile TextMap textMap;
    private volatile URI computedURI;
    volatile org.graalvm.polyglot.Source polyglotSource;
    private static final int[] S = new int[]{41, 46, 67, 201, 162, 216, 124, 1, 61, 54, 84, 161, 236, 240, 6, 19, 98, 167, 5, 243, 192, 199, 115, 140, 152, 147, 43, 217, 188, 76, 130, 202, 30, 155, 87, 60, 253, 212, 224, 22, 103, 66, 111, 24, 138, 23, 229, 18, 190, 78, 196, 214, 218, 158, 222, 73, 160, 251, 245, 142, 187, 47, 238, 122, 169, 104, 121, 145, 21, 178, 7, 63, 148, 194, 16, 137, 11, 34, 95, 33, 128, 127, 93, 154, 90, 144, 50, 39, 53, 62, 204, 231, 191, 247, 151, 3, 255, 25, 48, 179, 72, 165, 181, 209, 215, 94, 146, 42, 172, 86, 170, 198, 79, 184, 56, 210, 150, 164, 125, 182, 118, 252, 107, 226, 156, 116, 4, 241, 69, 157, 112, 89, 100, 113, 135, 32, 134, 91, 207, 101, 230, 45, 168, 2, 27, 96, 37, 173, 174, 176, 185, 246, 28, 70, 97, 105, 52, 64, 126, 15, 85, 71, 163, 35, 221, 81, 175, 58, 195, 92, 249, 206, 186, 197, 234, 38, 44, 83, 13, 110, 133, 40, 132, 9, 211, 223, 205, 244, 65, 129, 77, 82, 106, 220, 55, 200, 108, 193, 171, 250, 36, 225, 123, 8, 12, 189, 177, 74, 120, 136, 149, 139, 227, 99, 232, 109, 233, 203, 213, 254, 59, 0, 29, 57, 242, 239, 183, 14, 102, 88, 208, 228, 166, 119, 114, 248, 235, 117, 75, 10, 49, 68, 80, 180, 143, 237, 31, 26, 219, 153, 141, 51, 159, 17, 131, 20};
    private static final boolean ALLOW_IO = SourceAccessor.ACCESSOR.engineSupport().isIOAllowed();

    abstract Object getSourceId();

    Source() {
    }

    public abstract String getLanguage();

    public abstract String getName();

    public abstract String getPath();

    public abstract boolean isInternal();

    public abstract boolean isCached();

    public abstract boolean isInteractive();

    public final boolean equals(Object obj) {
        if (!(obj instanceof Source)) {
            return false;
        }
        return this.getSourceId().equals(((Source)obj).getSourceId());
    }

    public final int hashCode() {
        return this.getSourceId().hashCode();
    }

    public Source subSource(int baseCharIndex, int length) {
        if (this.hasBytes()) {
            throw new UnsupportedOperationException("Operation is only enabled for character based sources.");
        }
        CompilerAsserts.neverPartOfCompilation(NO_FASTPATH_SUBSOURCE_CREATION_MESSAGE);
        return SubSourceImpl.create(this, baseCharIndex, length);
    }

    public abstract CharSequence getCharacters();

    public abstract boolean hasBytes();

    public abstract boolean hasCharacters();

    public abstract ByteSequence getBytes();

    public abstract URL getURL();

    abstract URI getOriginalURI();

    public final URI getURI() {
        URI uri = this.getOriginalURI();
        if (uri == null && (uri = this.computedURI) == null) {
            byte[] bytes = this.hasBytes() ? this.getBytes().toByteArray() : this.getCharacters().toString().getBytes();
            uri = this.computedURI = this.getNamedURI(this.getName(), bytes);
        }
        return uri;
    }

    public abstract String getMimeType();

    public final Reader getReader() {
        return new CharSequenceReader(this.getCharacters());
    }

    @Deprecated
    public final InputStream getInputStream() {
        return new ByteArrayInputStream(this.getCharacters().toString().getBytes());
    }

    public final int getLength() {
        if (this.hasCharacters()) {
            return this.getTextMap().length();
        }
        if (this.hasBytes()) {
            return this.getBytes().length();
        }
        throw new UnsupportedOperationException("Operation is only enabled for sources with character or byte content.");
    }

    public final CharSequence getCharacters(int lineNumber) {
        int offset = this.getTextMap().lineStartOffset(lineNumber);
        int length = this.getTextMap().lineLength(lineNumber);
        return this.getCharacters().subSequence(offset, offset + length);
    }

    public final int getLineCount() {
        return this.getTextMap().lineCount();
    }

    public final int getLineNumber(int offset) throws IllegalArgumentException {
        return this.getTextMap().offsetToLine(offset);
    }

    public final int getColumnNumber(int offset) throws IllegalArgumentException {
        return this.getTextMap().offsetToCol(offset);
    }

    public final int getLineStartOffset(int lineNumber) throws IllegalArgumentException {
        return this.getTextMap().lineStartOffset(lineNumber);
    }

    public final int getLineLength(int lineNumber) throws IllegalArgumentException {
        return this.getTextMap().lineLength(lineNumber);
    }

    public final SourceSection createUnavailableSection() {
        return new SourceSectionUnavailable(this);
    }

    public final SourceSection createSection(int startLine, int startColumn, int endLine, int endColumn) {
        if (this.hasBytes()) {
            throw new UnsupportedOperationException("Operation is only enabled for character based sources.");
        }
        if (startLine < 1) {
            throw new IllegalArgumentException("lineNumber < 1");
        }
        if (startLine > endLine) {
            throw new IllegalArgumentException("startLine " + startLine + " > endLine " + endLine);
        }
        if (startLine == endLine && startColumn > endColumn) {
            throw new IllegalArgumentException("startColumn " + startColumn + " > endColumn " + endColumn);
        }
        if (this.hasCharacters()) {
            if (startColumn < 1 || endColumn < 1) {
                throw new IllegalArgumentException("columnNumber < 1");
            }
            int charIndex = this.getTextMap().lineColumnToOffset(startLine, startColumn);
            int endIndex = this.getTextMap().lineColumnToOffset(endLine, endColumn);
            assert (charIndex <= endIndex) : charIndex + " > " + endIndex;
            int length = endIndex + 1 - charIndex;
            int sourceLength = this.getTextMap().length();
            if (length == 1 && charIndex + length > sourceLength) {
                length = 0;
            }
            if (charIndex + length > sourceLength) {
                throw new IllegalArgumentException("end position out of range");
            }
            SourceSectionLoaded section = new SourceSectionLoaded(this, charIndex, length);
            assert (Source.assertValid(section));
            return section;
        }
        if (startColumn == -1) {
            if (endColumn != -1) {
                throw new IllegalArgumentException("endColumn can not be specified when startColumn is not.");
            }
            return new SourceSectionUnloaded.Lines(this, startLine, endLine);
        }
        if (startColumn < 1 || endColumn < 1) {
            throw new IllegalArgumentException("columnNumber < 1");
        }
        return new SourceSectionUnloaded.LinesAndColumns(this, startLine, startColumn, endLine, endColumn);
    }

    public final SourceSection createSection(int lineNumber) {
        SourceSection section;
        if (this.hasBytes()) {
            throw new UnsupportedOperationException("Operation is only enabled for character based sources.");
        }
        if (lineNumber < 1) {
            throw new IllegalArgumentException("lineNumber < 1");
        }
        if (this.hasCharacters()) {
            int charIndex = this.getTextMap().lineStartOffset(lineNumber);
            int length = this.getTextMap().lineLength(lineNumber);
            section = new SourceSectionLoaded(this, charIndex, length);
            assert (Source.assertValid(section));
        } else {
            section = new SourceSectionUnloaded.Lines(this, lineNumber, lineNumber);
        }
        return section;
    }

    public final SourceSection createSection(int charIndex, int length) {
        SourceSection section;
        if (this.hasBytes()) {
            throw new UnsupportedOperationException("Operation is only enabled for character based sources.");
        }
        if (charIndex < 0) {
            throw new IllegalArgumentException("charIndex < 0");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (this.hasCharacters()) {
            section = new SourceSectionLoaded(this, charIndex, length);
            assert (Source.assertValid(section));
        } else {
            section = new SourceSectionUnloaded.Indexed(this, charIndex, length);
        }
        return section;
    }

    public final SourceSection createSection(int startLine, int startColumn, int length) {
        if (this.hasBytes() || !this.hasCharacters()) {
            throw new UnsupportedOperationException("Operation is only enabled for character based sources.");
        }
        if (startLine <= 0) {
            throw new IllegalArgumentException("startLine < 1");
        }
        if (startColumn <= 0) {
            throw new IllegalArgumentException("startColumn < 1");
        }
        if (this.hasCharacters() && length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        int lineStartOffset = this.getTextMap().lineStartOffset(startLine);
        int lineLength = this.getTextMap().lineLength(startLine);
        if (startColumn > lineLength + 1) {
            throw new IllegalArgumentException("column out of range");
        }
        int charIndex = lineStartOffset + startColumn - 1;
        if (charIndex + length > this.getCharacters().length()) {
            throw new IllegalArgumentException("charIndex out of range");
        }
        SourceSectionLoaded section = new SourceSectionLoaded(this, charIndex, length);
        assert (Source.assertValid(section));
        return section;
    }

    public String toString() {
        return "Source [language=" + this.getLanguage() + ", name=" + this.getName() + ", path=" + this.getPath() + ", internal=" + this.isInternal() + ", cached=" + this.isCached() + ", interactive=" + this.isInteractive() + ", hasBytes=" + this.hasBytes() + ", hasCharacters=" + this.hasCharacters() + ", URL=" + this.getURL() + ", URI=" + this.getURI() + ", mimeType=" + this.getMimeType() + "]";
    }

    private static boolean assertValid(SourceSection section) {
        if (!section.isValid()) {
            throw new IllegalArgumentException("Invalid source section bounds.");
        }
        return true;
    }

    abstract boolean isLegacy();

    abstract Source copy();

    final TextMap getTextMap() {
        if (this.hasBytes()) {
            throw new UnsupportedOperationException("Operation is only enabled for character based sources.");
        }
        TextMap res = this.textMap;
        if (res == null) {
            res = this.textMap = this.createTextMap();
        }
        assert (res != null);
        return res;
    }

    TextMap createTextMap() {
        CharSequence code = this.getCharacters();
        if (code == null) {
            throw new RuntimeException("can't read file " + this.getName());
        }
        return TextMap.fromCharSequence(code);
    }

    private URI getNamedURI(String name, byte[] bytes) {
        return this.getNamedURI(name, bytes, 0, bytes.length);
    }

    private URI getNamedURI(String name, byte[] bytes, int byteIndex, int length) {
        String digest = bytes != null ? Source.digest(bytes, byteIndex, length) : Integer.toString(System.identityHashCode(this), 16);
        if (name != null) {
            digest = digest + '/' + name;
        }
        try {
            return new URI(URI_SCHEME, digest, null);
        }
        catch (URISyntaxException ex) {
            throw new Error(ex);
        }
    }

    public static LiteralBuilder newBuilder(String language, CharSequence characters, String name) {
        Source source = EMPTY;
        source.getClass();
        return source.new LiteralBuilder(language, characters).name(name);
    }

    public static LiteralBuilder newBuilder(String language, ByteSequence bytes, String name) {
        Source source = EMPTY;
        source.getClass();
        return source.new LiteralBuilder(language, bytes).name(name);
    }

    public static SourceBuilder newBuilder(String language, TruffleFile file) {
        Source source = EMPTY;
        source.getClass();
        return source.new LiteralBuilder(language, file);
    }

    static SourceBuilder newBuilder(String language, File source) {
        Source source2 = EMPTY;
        source2.getClass();
        return source2.new LiteralBuilder(language, source);
    }

    public static SourceBuilder newBuilder(String language, URL url) {
        Source source = EMPTY;
        source.getClass();
        return source.new LiteralBuilder(language, url);
    }

    public static SourceBuilder newBuilder(String language, Reader source, String name) {
        Source source2 = EMPTY;
        source2.getClass();
        return source2.new LiteralBuilder(language, source).name(name);
    }

    public static LiteralBuilder newBuilder(Source source) {
        Source source2 = EMPTY;
        source2.getClass();
        return source2.new LiteralBuilder(source);
    }

    @Deprecated
    public static Builder<IOException, RuntimeException, RuntimeException> newBuilder(File file) {
        Source source = EMPTY;
        source.getClass();
        return source.new Builder<IOException, RuntimeException, RuntimeException>(file);
    }

    @Deprecated
    public static Builder<RuntimeException, MissingMIMETypeException, MissingNameException> newBuilder(String text) {
        return Source.newBuilder((CharSequence)text);
    }

    @Deprecated
    public static Builder<RuntimeException, MissingMIMETypeException, MissingNameException> newBuilder(CharSequence characters) {
        Source source = EMPTY;
        source.getClass();
        return source.new Builder<RuntimeException, MissingMIMETypeException, MissingNameException>(characters);
    }

    @Deprecated
    public static Builder<IOException, RuntimeException, RuntimeException> newBuilder(URL url) {
        Source source = EMPTY;
        source.getClass();
        return source.new Builder<IOException, RuntimeException, RuntimeException>(url);
    }

    @Deprecated
    public static Builder<IOException, MissingMIMETypeException, MissingNameException> newBuilder(Reader reader) {
        Source source = EMPTY;
        source.getClass();
        return source.new Builder<IOException, MissingMIMETypeException, MissingNameException>(reader);
    }

    public static String findLanguage(TruffleFile file) throws IOException {
        String mimeType = Source.findMimeType(file);
        return mimeType != null ? Source.findLanguage(mimeType) : null;
    }

    public static String findLanguage(URL url) throws IOException {
        String mimeType = Source.findMimeType(url);
        return mimeType != null ? Source.findLanguage(mimeType) : null;
    }

    public static String findMimeType(TruffleFile file) throws IOException {
        return file.getMimeType();
    }

    public static String findMimeType(URL url) throws IOException {
        return Source.findMimeType(url, url.openConnection(), null, SourceAccessor.getCurrentFileSystemContext());
    }

    public static String findLanguage(String mimeType) {
        return org.graalvm.polyglot.Source.findLanguage((String)mimeType);
    }

    private static IllegalArgumentException invalidMimeType() {
        return new IllegalArgumentException("Invalid MIME type provided. MIME types consist of a type and a subtype separated by '/'.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    static Source buildSource(String language, Object origin, String name, String path, String mimeType, Object content, URL url, URI uri, Charset encoding, boolean internal, boolean interactive, boolean cached, boolean legacy, Supplier<Object> fileSystemContext) throws IOException {
        URL useUrl;
        String usePath;
        String useMimeType;
        Object useContent;
        URI useUri;
        String useName;
        block24: {
            Charset useEncoding;
            Object useOrigin;
            block26: {
                Object file;
                block27: {
                    block25: {
                        useName = name;
                        useUri = uri;
                        useContent = content;
                        useMimeType = mimeType;
                        usePath = path;
                        useUrl = url;
                        useOrigin = origin;
                        useEncoding = encoding;
                        if (useOrigin instanceof File) {
                            file = (File)useOrigin;
                            TruffleFile truffleFile = SourceAccessor.getTruffleFile(((File)file).toPath().toString(), fileSystemContext.get());
                            useOrigin = truffleFile;
                        }
                        if (useOrigin != CONTENT_UNSET) break block25;
                        useContent = useContent == CONTENT_UNSET ? null : useContent;
                        break block24;
                    }
                    if (!(useOrigin instanceof TruffleFile)) break block26;
                    file = (TruffleFile)useOrigin;
                    if (!((TruffleFile)file).isAbsolute() && useContent == CONTENT_NONE) {
                        if (useUri == null) {
                            useUri = ((TruffleFile)file).toRelativeUri();
                        }
                    } else {
                        Object object = file = ((TruffleFile)file).exists(new LinkOption[0]) ? ((TruffleFile)file).getCanonicalFile(new LinkOption[0]) : file;
                        if (useUri == null) {
                            useUri = ((TruffleFile)file).toUri();
                        }
                    }
                    useName = useName == null ? ((TruffleFile)file).getName() : useName;
                    usePath = usePath == null ? ((TruffleFile)file).getPath() : usePath;
                    String string = useMimeType = useMimeType == null ? SourceAccessor.getMimeType((TruffleFile)file, Source.getValidMimeTypes(language)) : useMimeType;
                    if (!legacy) break block27;
                    useMimeType = useMimeType == null ? UNKNOWN_MIME_TYPE : useMimeType;
                    useEncoding = useEncoding == null ? Source.getEncoding((TruffleFile)file, useMimeType) : useEncoding;
                    useContent = useContent == CONTENT_UNSET ? Source.read((TruffleFile)file, useEncoding) : useContent;
                    break block24;
                }
                if (useContent == CONTENT_UNSET) {
                    if (Source.isCharacterBased(language, useMimeType)) {
                        useEncoding = useEncoding == null ? Source.getEncoding((TruffleFile)file, useMimeType) : useEncoding;
                        useContent = Source.read((TruffleFile)file, useEncoding);
                        break block24;
                    } else {
                        useContent = ByteSequence.create((byte[])((TruffleFile)file).readAllBytes());
                    }
                }
                break block24;
            }
            if (useOrigin instanceof URL) {
                URI tmpUri;
                useUrl = (URL)useOrigin;
                String urlPath = useUrl.getPath();
                int lastIndex = urlPath.lastIndexOf(47);
                useName = useName == null && lastIndex != -1 ? useUrl.getPath().substring(lastIndex + 1) : useName;
                try {
                    tmpUri = useUrl.toURI();
                }
                catch (URISyntaxException ex) {
                    throw new IOException("Bad URL: " + useUrl, ex);
                }
                useUri = useUri == null ? tmpUri : useUri;
                usePath = usePath == null ? useUrl.getPath() : usePath;
                try {
                    TruffleFile truffleFile = SourceAccessor.getTruffleFile(tmpUri, fileSystemContext.get());
                    if (legacy) {
                        useMimeType = useMimeType == null ? SourceAccessor.getMimeType(truffleFile, Source.getValidMimeTypes(language)) : useMimeType;
                        useMimeType = useMimeType == null ? UNKNOWN_MIME_TYPE : useMimeType;
                        useEncoding = useEncoding == null ? Source.getEncoding(truffleFile, useMimeType) : useEncoding;
                        useContent = useContent == CONTENT_UNSET ? Source.read(truffleFile, useEncoding) : useContent;
                        break block24;
                    }
                    if (useContent != CONTENT_UNSET) break block24;
                    if (Source.isCharacterBased(language, useMimeType)) {
                        useEncoding = useEncoding == null ? Source.getEncoding(truffleFile, useMimeType) : useEncoding;
                        useContent = Source.read(truffleFile, useEncoding);
                        break block24;
                    }
                    useContent = ByteSequence.create((byte[])truffleFile.readAllBytes());
                }
                catch (FileSystemNotFoundException fsnf) {
                    if (!ALLOW_IO) throw new SecurityException("Reading of URL " + useUrl + " is not allowed.");
                    if (!SourceAccessor.isDefaultFileSystem(fileSystemContext.get())) throw new SecurityException("Reading of URL " + useUrl + " is not allowed.");
                    URLConnection connection = useUrl.openConnection();
                    Charset charset = useEncoding = useEncoding == null ? StandardCharsets.UTF_8 : useEncoding;
                    if (legacy) {
                        useMimeType = useMimeType == null ? Source.findMimeType(useUrl, connection, Source.getValidMimeTypes(language), fileSystemContext.get()) : useMimeType;
                        useMimeType = useMimeType == null ? UNKNOWN_MIME_TYPE : useMimeType;
                        useContent = useContent == CONTENT_UNSET ? Source.read(new InputStreamReader(connection.getInputStream(), useEncoding)) : useContent;
                        break block24;
                    }
                    if (useContent != CONTENT_UNSET) break block24;
                    if (Source.isCharacterBased(language, useMimeType)) {
                        useContent = Source.read(new InputStreamReader(connection.getInputStream(), useEncoding));
                        break block24;
                    }
                    useContent = ByteSequence.create((byte[])Source.readBytes(connection));
                }
            } else if (useOrigin instanceof Reader) {
                Reader r = (Reader)useOrigin;
                useContent = useContent == CONTENT_UNSET ? Source.read(r) : useContent;
            } else if (useOrigin instanceof ByteSequence) {
                useContent = useContent == CONTENT_UNSET ? useOrigin : useContent;
            } else {
                assert (useOrigin instanceof CharSequence);
                Object object = useContent = useContent == CONTENT_UNSET ? useOrigin : useContent;
            }
        }
        if (!legacy && useName == null) {
            useName = "Unnamed";
        }
        useContent = Source.enforceInterfaceContracts(useContent);
        SourceImpl.Key key = new SourceImpl.Key(useContent, useMimeType, language, useUrl, useUri, useName, usePath, internal, interactive, cached, legacy);
        return SOURCES.intern(key);
    }

    static byte[] readBytes(URLConnection connection) throws IOException {
        long size = connection.getContentLengthLong();
        if (size < 0L) {
            size = 8192L;
        } else if (size > Integer.MAX_VALUE) {
            throw new OutOfMemoryError("Too many bytes.");
        }
        try (InputStream inputStream = connection.getInputStream();){
            byte[] byArray = Source.readBytes(inputStream, (int)size);
            return byArray;
        }
    }

    private static byte[] readBytes(InputStream source, int initialSize) throws IOException {
        int capacity = initialSize;
        byte[] buf = new byte[capacity];
        int nread = 0;
        while (true) {
            int n;
            if ((n = source.read(buf, nread, capacity - nread)) > 0) {
                nread += n;
                continue;
            }
            if (n < 0 || (n = source.read()) < 0) break;
            if (capacity <= 0x7FFFFFF7 - capacity) {
                capacity = Math.max(capacity << 1, 8192);
            } else {
                if (capacity == 0x7FFFFFF7) {
                    throw new OutOfMemoryError("Required array size too large");
                }
                capacity = 0x7FFFFFF7;
            }
            buf = Arrays.copyOf(buf, capacity);
            buf[nread++] = (byte)n;
        }
        return capacity == nread ? buf : Arrays.copyOf(buf, nread);
    }

    static String read(TruffleFile file, Charset encoding) throws IOException {
        return new String(file.readAllBytes(), encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String read(Reader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[1024];
        try {
            int n;
            while ((n = reader.read(buffer)) != -1) {
                builder.append(buffer, 0, n);
            }
        }
        finally {
            reader.close();
        }
        return builder.toString();
    }

    static String digest(byte[] message, int from, int length) {
        int[] m = new int[19];
        int[] x = new int[48];
        int[] c = new int[16];
        int loop = 1;
        int start = 0;
        int bytes = 0;
        for (int i = 0; i < 16; ++i) {
            c[i] = 0;
            x[i] = 0;
        }
        int last = 0;
        int index = from;
        m[18] = 0;
        m[17] = 0;
        m[16] = 0;
        while (loop == 1) {
            int t;
            int i;
            m[0] = m[16];
            m[1] = m[17];
            m[2] = m[18];
            for (i = 3; i < 16; ++i) {
                m[i] = 0;
            }
            i = start;
            while (index < length && i < 16) {
                int code = message[index];
                if (code < 0) {
                    code += 256;
                }
                m[i++] = code;
                ++index;
            }
            bytes += i - start;
            start = i - 16;
            if (index == length && i < 16) {
                loop = 2;
                t = 16 - (bytes & 0xF);
                while (i < 16) {
                    m[i] = t;
                    ++i;
                }
            }
            for (i = 0; i < 16; ++i) {
                int n = i;
                c[n] = c[n] ^ S[m[i] ^ last];
                last = c[i];
            }
            for (i = 0; i < loop; ++i) {
                int[] mOrC = i == 0 ? m : c;
                x[16] = mOrC[0];
                x[32] = x[16] ^ x[0];
                x[17] = mOrC[1];
                x[33] = x[17] ^ x[1];
                x[18] = mOrC[2];
                x[34] = x[18] ^ x[2];
                x[19] = mOrC[3];
                x[35] = x[19] ^ x[3];
                x[20] = mOrC[4];
                x[36] = x[20] ^ x[4];
                x[21] = mOrC[5];
                x[37] = x[21] ^ x[5];
                x[22] = mOrC[6];
                x[38] = x[22] ^ x[6];
                x[23] = mOrC[7];
                x[39] = x[23] ^ x[7];
                x[24] = mOrC[8];
                x[40] = x[24] ^ x[8];
                x[25] = mOrC[9];
                x[41] = x[25] ^ x[9];
                x[26] = mOrC[10];
                x[42] = x[26] ^ x[10];
                x[27] = mOrC[11];
                x[43] = x[27] ^ x[11];
                x[28] = mOrC[12];
                x[44] = x[28] ^ x[12];
                x[29] = mOrC[13];
                x[45] = x[29] ^ x[13];
                x[30] = mOrC[14];
                x[46] = x[30] ^ x[14];
                x[31] = mOrC[15];
                x[47] = x[31] ^ x[15];
                t = 0;
                for (int j = 0; j < 18; ++j) {
                    for (int k = 0; k < 48; ++k) {
                        x[k] = t = x[k] ^ S[t];
                    }
                    t = t + j & 0xFF;
                }
            }
        }
        StringBuilder result = new StringBuilder(32);
        for (int i = 0; i < 16; ++i) {
            String hex = Integer.toHexString(x[i]);
            if (result.length() == 0) {
                if (hex.equals("0")) {
                    continue;
                }
            } else if (hex.length() == 1) {
                result.append("0");
            }
            result.append(hex);
        }
        return result.toString();
    }

    static <E extends Exception> E raise(Class<E> type, Exception ex) throws E {
        throw ex;
    }

    static Object enforceInterfaceContracts(Object sequence) {
        boolean assertions = false;
        if (!$assertionsDisabled) {
            assertions = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertions) {
            if (sequence instanceof CharSequence) {
                return Source.enforceCharSequenceContracts((CharSequence)sequence);
            }
            if (sequence != null) {
                assert (sequence instanceof ByteSequence);
                return Source.enforceByteSequenceContracts((ByteSequence)sequence);
            }
        }
        return sequence;
    }

    static ByteSequence enforceByteSequenceContracts(ByteSequence sequence) {
        if (BYTE_SEQUENCE_CLASS.isInstance(sequence)) {
            return sequence;
        }
        if (sequence instanceof ByteSequenceWrapper) {
            return sequence;
        }
        return new ByteSequenceWrapper(sequence);
    }

    static CharSequence enforceCharSequenceContracts(CharSequence sequence) {
        if (sequence instanceof String) {
            return sequence;
        }
        if (sequence instanceof CharSequenceWrapper) {
            return sequence;
        }
        return new CharSequenceWrapper(sequence);
    }

    static String findMimeType(URL url, URLConnection connection, Set<String> validMimeTypes, Object fileSystemContext) throws IOException {
        try {
            URI uri = url.toURI();
            TruffleFile file = SourceAccessor.getTruffleFile(uri, fileSystemContext);
            String firstGuess = SourceAccessor.getMimeType(file, validMimeTypes);
            if (firstGuess != null) {
                return firstGuess;
            }
        }
        catch (IllegalArgumentException | URISyntaxException | FileSystemNotFoundException uri) {
            // empty catch block
        }
        if (!ALLOW_IO || !SourceAccessor.isDefaultFileSystem(fileSystemContext)) {
            throw new SecurityException("Reading of URL " + url + " is not allowed.");
        }
        String contentType = connection.getContentType();
        if (contentType != null && (validMimeTypes == null || validMimeTypes.contains(contentType))) {
            return contentType;
        }
        return null;
    }

    static boolean isCharacterBased(String language, String mimeType) {
        if (language == null) {
            return true;
        }
        Accessor.EngineSupport support = SourceAccessor.ACCESSOR.engineSupport();
        if (support == null) {
            return true;
        }
        return support.isCharacterBasedSource(language, mimeType);
    }

    static Set<String> getValidMimeTypes(String language) {
        Accessor.EngineSupport support = SourceAccessor.ACCESSOR.engineSupport();
        if (support == null) {
            return null;
        }
        return support.getValidMimeTypes(language);
    }

    private static void validateMimeType(String mimeType) {
        if (mimeType == null) {
            return;
        }
        int index = mimeType.indexOf(47);
        if (index == -1 || index == 0 || index == mimeType.length() - 1) {
            throw Source.invalidMimeType();
        }
        if (mimeType.indexOf(47, index + 1) != -1) {
            throw Source.invalidMimeType();
        }
    }

    static <E extends Exception> RuntimeException silenceException(Class<E> type, Exception ex) throws E {
        throw ex;
    }

    private static Charset getEncoding(TruffleFile file, String mimeType) throws IOException {
        Charset encoding = SourceAccessor.getEncoding(file, mimeType);
        encoding = encoding == null ? StandardCharsets.UTF_8 : encoding;
        return encoding;
    }

    private static Object getSourceContent(Source source) {
        Object content = ((SourceImpl)source).toKey().content;
        if (content == CONTENT_NONE) {
            return CONTENT_UNSET;
        }
        return content;
    }

    static /* synthetic */ CharSequence access$000() {
        return CONTENT_UNSET;
    }

    static {
        SourceAccessor.allLoaders();
    }

    private static final class FileSystemContextSupplier
    implements Supplier<Object> {
        private Object fileSystemContext;

        FileSystemContextSupplier(Object fileSystemContext) {
            this.fileSystemContext = fileSystemContext;
        }

        @Override
        public Object get() {
            return this.fileSystemContext == null ? SourceAccessor.getCurrentFileSystemContext() : this.fileSystemContext;
        }
    }

    @Deprecated
    public class Builder<E1 extends Exception, E2 extends Exception, E3 extends Exception> {
        private final Object origin;
        private URI uri;
        private String name;
        private String mime;
        private String language;
        private CharSequence characters = Source.access$000();
        private boolean internal;
        private boolean interactive;
        private boolean cached = true;

        Builder(Object origin) {
            this.origin = origin;
        }

        @Deprecated
        public Builder<E1, E2, RuntimeException> name(String newName) {
            Objects.requireNonNull(newName);
            this.name = newName;
            return this;
        }

        @Deprecated
        public Builder<E1, RuntimeException, E3> mimeType(String newMimeType) {
            Objects.requireNonNull(newMimeType);
            this.mime = newMimeType;
            return this;
        }

        @Deprecated
        public Builder<E1, E2, E3> cached(boolean cached) {
            this.cached = cached;
            return this;
        }

        @Deprecated
        public Builder<E1, RuntimeException, E3> language(String newLanguage) {
            Objects.requireNonNull(newLanguage);
            if (this.mime == null) {
                this.mime = "x-unknown";
            }
            this.language = newLanguage;
            return this;
        }

        @Deprecated
        public Builder<E1, E2, E3> internal() {
            this.internal = true;
            return this;
        }

        @Deprecated
        public Builder<E1, E2, E3> interactive() {
            this.interactive = true;
            return this;
        }

        @Deprecated
        public Builder<E1, E2, E3> uri(URI ownUri) {
            Objects.requireNonNull(ownUri);
            this.uri = ownUri;
            return this;
        }

        @Deprecated
        public Builder<RuntimeException, E2, E3> content(String code) {
            this.characters = code;
            return this;
        }

        @Deprecated
        public Builder<RuntimeException, E2, E3> content(CharSequence code) {
            this.characters = code;
            return this;
        }

        @Deprecated
        public Source build() throws E1, E2, E3 {
            try {
                Source source = Source.buildSource(this.language, this.origin, this.name, null, this.mime, this.characters, null, this.uri, null, this.internal, this.interactive, this.cached, true, new FileSystemContextSupplier(null));
                assert (source.hasCharacters());
                this.characters = source.getCharacters();
                if (source.getMimeType() == null) {
                    throw Source.raise(RuntimeException.class, new MissingMIMETypeException());
                }
                if (source.getName() == null) {
                    throw Source.raise(RuntimeException.class, new MissingNameException());
                }
                return source;
            }
            catch (IOException ex) {
                throw Source.raise(RuntimeException.class, ex);
            }
        }
    }

    public final class LiteralBuilder
    extends SourceBuilder {
        LiteralBuilder(String language, Object origin) {
            super(language, origin);
        }

        LiteralBuilder(Source source) {
            super(source.getLanguage(), Source.getSourceContent(source));
            this.cached(source.isCached());
            this.interactive(source.isInteractive());
            this.internal(source.isInternal());
            this.mimeType(source.getMimeType());
            this.name(source.getName());
            this.uri(((SourceImpl)source).toKey().uri);
            this.path = source.getPath();
            this.url = source.getURL();
        }

        @Override
        public LiteralBuilder name(String newName) {
            return (LiteralBuilder)super.name(newName);
        }

        @Override
        public LiteralBuilder mimeType(String newMimeType) {
            return (LiteralBuilder)super.mimeType(newMimeType);
        }

        @Override
        public LiteralBuilder cached(boolean cached) {
            return (LiteralBuilder)super.cached(cached);
        }

        @Override
        public LiteralBuilder internal(boolean enabled) {
            return (LiteralBuilder)super.internal(enabled);
        }

        @Override
        public LiteralBuilder interactive(boolean enabled) {
            return (LiteralBuilder)super.interactive(enabled);
        }

        @Override
        public LiteralBuilder uri(URI ownUri) {
            return (LiteralBuilder)super.uri(ownUri);
        }

        @Override
        public LiteralBuilder encoding(Charset encoding) {
            return (LiteralBuilder)super.encoding(encoding);
        }

        @Override
        public Source build() {
            try {
                return super.build();
            }
            catch (IOException e) {
                throw Source.silenceException(RuntimeException.class, e);
            }
        }
    }

    public class SourceBuilder {
        private final String language;
        private final Object origin;
        private URI uri;
        URL url;
        private String name;
        String path;
        private String mimeType;
        private Object content = Source.access$000();
        private boolean internal;
        private boolean interactive;
        private boolean cached = true;
        private Charset fileEncoding;
        private Object embedderFileSystemContext;

        SourceBuilder(String language, Object origin) {
            Objects.requireNonNull(language);
            Objects.requireNonNull(origin);
            this.language = language;
            this.origin = origin;
        }

        public SourceBuilder name(String newName) {
            this.name = newName;
            return this;
        }

        public LiteralBuilder content(CharSequence characters) {
            this.content = characters;
            return (LiteralBuilder)this;
        }

        public LiteralBuilder content(ByteSequence bytes) {
            this.content = bytes;
            return (LiteralBuilder)this;
        }

        public SourceBuilder mimeType(String mimeType) {
            Source.validateMimeType(mimeType);
            this.mimeType = mimeType;
            return this;
        }

        public SourceBuilder cached(boolean enabled) {
            this.cached = enabled;
            return this;
        }

        public SourceBuilder internal(boolean enabled) {
            this.internal = enabled;
            return this;
        }

        public SourceBuilder interactive(boolean enabled) {
            this.interactive = enabled;
            return this;
        }

        public SourceBuilder uri(URI ownUri) {
            this.uri = ownUri;
            return this;
        }

        public SourceBuilder encoding(Charset encoding) {
            this.fileEncoding = encoding;
            return this;
        }

        SourceBuilder embedderFileSystemContext(Object fileSystemContext) {
            this.embedderFileSystemContext = fileSystemContext;
            return this;
        }

        public Source build() throws IOException {
            assert (this.language != null);
            Source source = Source.buildSource(this.language, this.origin, this.name, this.path, this.mimeType, this.content, this.url, this.uri, this.fileEncoding, this.internal, this.interactive, this.cached, false, new FileSystemContextSupplier(this.embedderFileSystemContext));
            if (source.hasBytes()) {
                this.content = source.getBytes();
            } else if (source.hasCharacters()) {
                this.content = source.getCharacters();
            }
            assert (source.getName() != null);
            assert (!source.hasCharacters() || source.getCharacters() != null);
            assert (!source.hasBytes() || source.getBytes() != null);
            assert (source.getLanguage() != null);
            return source;
        }
    }
}

