/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeAccessor;
import java.util.concurrent.locks.Lock;

public abstract class ExecutableNode
extends Node {
    @CompilerDirectives.CompilationFinal
    Object sourceVM;
    final TruffleLanguage<?> language;
    @CompilerDirectives.CompilationFinal
    ReferenceCache referenceCache;
    private static final ReferenceCache GENERIC = new ReferenceCache(null, null, null);

    protected ExecutableNode(TruffleLanguage<?> language) {
        CompilerAsserts.neverPartOfCompilation();
        this.language = language;
        this.sourceVM = this.language != null ? NodeAccessor.ACCESSOR.engineSupport().getVMFromLanguageObject(NodeAccessor.ACCESSOR.languageSupport().getVMObject(this.language)) : ExecutableNode.getCurrentVM();
        if (language != null && this.getLanguageInfo() == null) {
            throw new IllegalArgumentException("Truffle language instance is not initialized.");
        }
    }

    private static Object getCurrentVM() {
        Accessor.EngineSupport engine = NodeAccessor.ACCESSOR.engineSupport();
        if (engine != null) {
            return engine.getCurrentVM();
        }
        return null;
    }

    public abstract Object execute(VirtualFrame var1);

    public final LanguageInfo getLanguageInfo() {
        if (this.language != null) {
            return NodeAccessor.ACCESSOR.languageSupport().getLanguageInfo(this.language);
        }
        return null;
    }

    @Deprecated
    public final <C extends TruffleLanguage> C getLanguage(Class<C> languageClass) {
        if (this.language == null) {
            return null;
        }
        TruffleLanguage<?> spi = this.language;
        if (!(spi.getClass() == languageClass || languageClass.isInstance(spi) && languageClass != TruffleLanguage.class && TruffleLanguage.class.isAssignableFrom(languageClass))) {
            CompilerDirectives.transferToInterpreter();
            throw new ClassCastException("Illegal language class specified. Expected " + spi.getClass().getName() + ".");
        }
        return (C)spi;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    final ReferenceCache lookupReferenceCache(Class<? extends TruffleLanguage> languageClass) {
        ReferenceCache current;
        while ((current = this.referenceCache) != GENERIC) {
            while (current != null) {
                if (current.languageClass == languageClass) {
                    return current;
                }
                current = current.next;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.specializeReferenceCache(languageClass);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void specializeReferenceCache(Class<? extends TruffleLanguage> languageClass) {
        Lock lock = this.getLock();
        lock.lock();
        try {
            ReferenceCache current = this.referenceCache;
            if (current == null) {
                this.referenceCache = new ReferenceCache(this, languageClass, null);
            } else if (this.sourceVM == null) {
                this.referenceCache = GENERIC;
            } else {
                int count = 0;
                ReferenceCache original = current;
                do {
                    ++count;
                } while ((current = current.next) != null);
                this.referenceCache = count >= 5 ? GENERIC : new ReferenceCache(this, languageClass, original);
            }
        }
        finally {
            lock.unlock();
        }
    }

    static final class ReferenceCache {
        final Class<?> languageClass;
        final TruffleLanguage.LanguageReference<?> languageReference;
        final TruffleLanguage.ContextReference<?> contextReference;
        final ReferenceCache next;

        ReferenceCache(ExecutableNode executableNode, Class<? extends TruffleLanguage> languageClass, ReferenceCache next) {
            this.languageClass = languageClass;
            if (languageClass != null) {
                this.languageReference = NodeAccessor.ACCESSOR.engineSupport().lookupLanguageReference(executableNode.sourceVM, executableNode.language, languageClass);
                this.contextReference = NodeAccessor.ACCESSOR.engineSupport().lookupContextReference(executableNode.sourceVM, executableNode.language, languageClass);
            } else {
                this.languageReference = null;
                this.contextReference = null;
            }
            this.next = next;
        }
    }
}

