/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static int indexOf(String haystack, int fromIndex, int maxIndex, char ... needle) {
        ArrayUtils.checkArgs(haystack.length(), fromIndex, maxIndex, needle.length);
        return ArrayUtils.runIndexOf(haystack, fromIndex, maxIndex, needle);
    }

    private static int runIndexOf(String haystack, int fromIndex, int maxIndex, char[] needle) {
        for (int i = fromIndex; i < maxIndex; ++i) {
            for (char c : needle) {
                if (haystack.charAt(i) != c) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(char[] haystack, int fromIndex, int maxIndex, char ... needle) {
        ArrayUtils.checkArgs(haystack.length, fromIndex, maxIndex, needle.length);
        return ArrayUtils.runIndexOf(haystack, fromIndex, maxIndex, needle);
    }

    private static int runIndexOf(char[] haystack, int fromIndex, int maxIndex, char[] needle) {
        for (int i = fromIndex; i < maxIndex; ++i) {
            for (char c : needle) {
                if (haystack[i] != c) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(byte[] haystack, int fromIndex, int maxIndex, byte ... needle) {
        ArrayUtils.checkArgs(haystack.length, fromIndex, maxIndex, needle.length);
        return ArrayUtils.runIndexOf(haystack, fromIndex, maxIndex, needle);
    }

    private static int runIndexOf(byte[] haystack, int fromIndex, int maxIndex, byte[] needle) {
        for (int i = fromIndex; i < maxIndex; ++i) {
            for (byte c : needle) {
                if (haystack[i] != c) continue;
                return i;
            }
        }
        return -1;
    }

    private static void checkArgs(int length, int fromIndex, int maxIndex, int nValues) {
        if (fromIndex < 0) {
            throw new IllegalArgumentException("fromIndex must be positive");
        }
        if (maxIndex > length || maxIndex < fromIndex) {
            throw new IllegalArgumentException("maxIndex out of range");
        }
        if (nValues == 0) {
            throw new IllegalArgumentException("no search values provided");
        }
    }
}

