/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativeimage.impl;

import java.util.Objects;

public final class ConfigurationCondition {
    private static final ConfigurationCondition JAVA_LANG_OBJECT_REACHED = new ConfigurationCondition(Object.class, true);
    private final Class<?> type;
    private final boolean runtimeChecked;

    public static ConfigurationCondition alwaysTrue() {
        return JAVA_LANG_OBJECT_REACHED;
    }

    public static ConfigurationCondition create(Class<?> type, boolean runtimeChecked) {
        Objects.requireNonNull(type);
        if (JAVA_LANG_OBJECT_REACHED.getType().equals(type)) {
            return JAVA_LANG_OBJECT_REACHED;
        }
        return new ConfigurationCondition(type, runtimeChecked);
    }

    public boolean isAlwaysTrue() {
        return ConfigurationCondition.alwaysTrue().equals(this);
    }

    private ConfigurationCondition(Class<?> type, boolean runtimeChecked) {
        this.runtimeChecked = runtimeChecked;
        this.type = type;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isRuntimeChecked() {
        return this.runtimeChecked;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationCondition that = (ConfigurationCondition)o;
        return this.runtimeChecked == that.runtimeChecked && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.runtimeChecked);
    }

    public String toString() {
        return "ConfigurationCondition(type=" + String.valueOf(this.type) + ", runtimeChecked=" + this.runtimeChecked + ")";
    }
}

