/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativebridge;

import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNICalls;
import org.graalvm.jniutils.JNIExceptionWrapper;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativebridge.ForeignExceptionEndPoints;
import org.graalvm.nativebridge.JNIClassCache;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.WordFactory;

public final class ForeignException
extends RuntimeException {
    static final byte UNDEFINED = 0;
    static final byte HOST_TO_GUEST = 1;
    static final byte GUEST_TO_HOST = 2;
    private static final ThreadLocal<ForeignException> pendingException = new ThreadLocal();
    private static final JNIMethodResolver CreateForeignException = new JNIMethodResolver("createForeignException", "([B)Ljava/lang/Throwable;");
    private static final JNIMethodResolver ToByteArray = new JNIMethodResolver("toByteArray", "(Lorg/graalvm/nativebridge/ForeignException;)[B");
    private static final JNIMethodResolver GetStackOverflowErrorClass = new JNIMethodResolver("getStackOverflowErrorClass", "()Ljava/lang/Class;");
    private static final ForeignException MARSHALLING_FAILED = new ForeignException(null, 0, false);
    private static volatile JNICalls jniCalls;
    private final byte kind;
    private final byte[] rawData;

    private ForeignException(byte[] rawData, byte kind, boolean writableStackTrace) {
        super(null, null, true, writableStackTrace);
        this.rawData = rawData;
        this.kind = kind;
    }

    public void throwUsingJNI(JNI.JNIEnv env) {
        JNIUtil.Throw((JNI.JNIEnv)env, (JNI.JThrowable)ForeignException.callCreateForeignException(env, JNIUtil.createHSArray((JNI.JNIEnv)env, (byte[])this.rawData)));
    }

    public RuntimeException throwOriginalException(BinaryMarshaller<? extends Throwable> marshaller) {
        try {
            if (this.rawData == null) {
                throw new RuntimeException("Failed to marshall foreign throwable.");
            }
            BinaryInput in = BinaryInput.create(this.rawData);
            Throwable t = marshaller.read(in);
            throw ForeignException.silenceException(RuntimeException.class, t);
        }
        catch (Throwable throwable) {
            ForeignException.clearPendingException();
            throw throwable;
        }
    }

    public static StackTraceElement[] mergeStackTrace(StackTraceElement[] foreignExceptionStack) {
        if (foreignExceptionStack.length == 0) {
            return foreignExceptionStack;
        }
        ForeignException localException = pendingException.get();
        if (localException != null) {
            switch (localException.kind) {
                case 1: {
                    return JNIExceptionWrapper.mergeStackTraces((StackTraceElement[])localException.getStackTrace(), (StackTraceElement[])foreignExceptionStack, (boolean)false);
                }
                case 2: {
                    return JNIExceptionWrapper.mergeStackTraces((StackTraceElement[])foreignExceptionStack, (StackTraceElement[])localException.getStackTrace(), (boolean)true);
                }
            }
            throw new IllegalStateException("Unsupported kind " + localException.kind);
        }
        return foreignExceptionStack;
    }

    public static ForeignException forThrowable(Throwable exception, BinaryMarshaller<? super Throwable> marshaller) {
        try {
            BinaryOutput.ByteArrayBinaryOutput out = BinaryOutput.ByteArrayBinaryOutput.create(marshaller.inferSize(exception));
            marshaller.write(out, exception);
            return new ForeignException(out.getArray(), 0, false);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            return MARSHALLING_FAILED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JNICalls getJNICalls() {
        JNICalls res = jniCalls;
        if (res != null) return res;
        Class<ForeignException> clazz = ForeignException.class;
        synchronized (ForeignException.class) {
            res = jniCalls;
            if (res != null) return res;
            JNIMethodScope scope = JNIMethodScope.scopeOrNull();
            JNI.JNIEnv env = scope != null ? scope.getEnv() : (JNI.JNIEnv)WordFactory.nullPointer();
            res = ForeignException.createJNICalls(env);
            if (scope == null) return res;
            jniCalls = res;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JNIMethodScope openJNIMethodScope(String scopeName, JNI.JNIEnv env) {
        if (jniCalls != null) return new JNIMethodScope(scopeName, env);
        Class<ForeignException> clazz = ForeignException.class;
        synchronized (ForeignException.class) {
            if (jniCalls != null) return new JNIMethodScope(scopeName, env);
            jniCalls = ForeignException.createJNICalls(env);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return new JNIMethodScope(scopeName, env);
        }
    }

    byte[] toByteArray() {
        return this.rawData;
    }

    static ForeignException create(byte[] rawData, byte kind) {
        ForeignException exception = new ForeignException(rawData, kind, true);
        pendingException.set(exception);
        return exception;
    }

    private static void clearPendingException() {
        pendingException.set(null);
    }

    private static <T extends Throwable> T silenceException(Class<T> type, Throwable t) throws T {
        throw t;
    }

    private static JNICalls createJNICalls(JNI.JNIEnv env) {
        JNI.JClass stackOverflowError = env.isNonNull() ? (JNI.JClass)JNIUtil.NewGlobalRef((JNI.JNIEnv)env, (JNI.JObject)ForeignException.callGetStackOverflowErrorClass(env), (String)StackOverflowError.class.getName()) : (JNI.JClass)WordFactory.nullPointer();
        return JNICalls.createWithExceptionHandler((JNIExceptionWrapper.ExceptionHandler)new ForeignExceptionHandler(stackOverflowError));
    }

    private static JNI.JThrowable callCreateForeignException(JNI.JNIEnv env, JNI.JByteArray rawValue) {
        JNI.JValue args = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
        args.addressOf(0).setJObject((JNI.JObject)rawValue);
        return (JNI.JThrowable)JNICalls.getDefault().callStaticJObject(env, CreateForeignException.getEntryPoints(env), (JNICalls.JNIMethod)CreateForeignException.resolve(env), args);
    }

    private static JNI.JByteArray callToByteArray(JNI.JNIEnv env, JNI.JObject p0) {
        JNI.JValue args = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
        args.addressOf(0).setJObject(p0);
        return (JNI.JByteArray)JNICalls.getDefault().callStaticJObject(env, ToByteArray.getEntryPoints(env), (JNICalls.JNIMethod)ToByteArray.resolve(env), args);
    }

    private static JNI.JClass callGetStackOverflowErrorClass(JNI.JNIEnv env) {
        return (JNI.JClass)JNICalls.getDefault().callStaticJObject(env, GetStackOverflowErrorClass.getEntryPoints(env), (JNICalls.JNIMethod)GetStackOverflowErrorClass.resolve(env), (JNI.JValue)WordFactory.nullPointer());
    }

    private static final class ForeignExceptionHandler
    implements JNIExceptionWrapper.ExceptionHandler {
        private static final StackOverflowError JNI_STACK_OVERFLOW_ERROR = new StackOverflowError("Stack overflow in transition from Native to Java."){

            @Override
            public Throwable fillInStackTrace() {
                return this;
            }
        };
        private final JNI.JClass stackOverflowError;

        ForeignExceptionHandler(JNI.JClass stackOverflowError) {
            this.stackOverflowError = stackOverflowError;
        }

        public void handleException(JNIExceptionWrapper.ExceptionHandlerContext context) {
            JNI.JNIEnv env = context.getEnv();
            JNI.JThrowable exception = context.getThrowable();
            if (this.stackOverflowError.isNonNull() && JNIUtil.IsSameObject((JNI.JNIEnv)env, (JNI.JObject)this.stackOverflowError, (JNI.JObject)JNIUtil.GetObjectClass((JNI.JNIEnv)env, (JNI.JObject)exception))) {
                throw JNI_STACK_OVERFLOW_ERROR;
            }
            if (ForeignException.class.getName().equals(context.getThrowableClassName())) {
                byte[] marshalledData = JNIUtil.createArray((JNI.JNIEnv)env, (JNI.JByteArray)ForeignException.callToByteArray(env, (JNI.JObject)exception));
                throw ForeignException.create(marshalledData, (byte)2);
            }
            context.throwJNIExceptionWrapper();
        }
    }

    private static final class JNIMethodResolver
    implements JNICalls.JNIMethod {
        private final String methodName;
        private final String methodSignature;
        private volatile JNI.JClass entryPointsClass;
        private volatile JNI.JMethodID methodId;

        JNIMethodResolver(String methodName, String methodSignature) {
            this.methodName = methodName;
            this.methodSignature = methodSignature;
        }

        JNIMethodResolver resolve(JNI.JNIEnv jniEnv) {
            JNI.JMethodID res = this.methodId;
            if (res.isNull()) {
                JNI.JClass entryPointClass = this.getEntryPoints(jniEnv);
                try (CTypeConversion.CCharPointerHolder name = CTypeConversion.toCString((CharSequence)this.methodName);
                     CTypeConversion.CCharPointerHolder sig = CTypeConversion.toCString((CharSequence)this.methodSignature);){
                    res = JNIUtil.GetStaticMethodID((JNI.JNIEnv)jniEnv, (JNI.JClass)entryPointClass, (CCharPointer)name.get(), (CCharPointer)sig.get());
                    if (res.isNull()) {
                        throw new InternalError("No such method: " + this.methodName);
                    }
                    this.methodId = res;
                }
            }
            return this;
        }

        JNI.JClass getEntryPoints(JNI.JNIEnv env) {
            JNI.JClass res = this.entryPointsClass;
            if (res.isNull()) {
                this.entryPointsClass = res = JNIClassCache.lookupClass(env, ForeignExceptionEndPoints.class);
            }
            return res;
        }

        public JNI.JMethodID getJMethodID() {
            return this.methodId;
        }

        public String getDisplayName() {
            return this.methodName;
        }
    }
}

