/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.common.option.CommonOptionParser;
import com.oracle.svm.core.graal.code.SubstrateCompilationResult;
import com.oracle.svm.core.option.RuntimeOptionParser;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.graal.SubstrateGraalUtils;
import com.oracle.svm.graal.TruffleRuntimeCompilationSupport;
import com.oracle.svm.truffle.SubstrateTruffleCompilationIdentifier;
import com.oracle.svm.truffle.TruffleSupport;
import com.oracle.svm.truffle.api.SubstrateCompilableTruffleAST;
import com.oracle.svm.truffle.api.SubstratePostPartialEvaluationSuite;
import com.oracle.svm.truffle.api.SubstrateTruffleCompiler;
import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilationTask;
import java.io.PrintStream;
import java.util.Map;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.core.CompilationWrapper;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.core.target.Backend;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DiagnosticsOutputDirectory;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.PhaseSuite;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.graal.compiler.truffle.PartialEvaluator;
import jdk.graal.compiler.truffle.PostPartialEvaluationSuite;
import jdk.graal.compiler.truffle.TruffleCompilationIdentifier;
import jdk.graal.compiler.truffle.TruffleCompilerConfiguration;
import jdk.graal.compiler.truffle.TruffleCompilerImpl;
import jdk.graal.compiler.truffle.TruffleCompilerOptions;
import jdk.graal.compiler.truffle.TruffleTierConfiguration;
import jdk.graal.compiler.truffle.phases.InstrumentationSuite;
import jdk.graal.compiler.truffle.phases.TruffleTier;
import jdk.vm.ci.code.InstalledCode;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstrateTruffleCompilerImpl
extends TruffleCompilerImpl
implements SubstrateTruffleCompiler {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateTruffleCompilerImpl(TruffleCompilerConfiguration config) {
        super(config);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected PartialEvaluator createPartialEvaluator(TruffleCompilerConfiguration configuration) {
        return TruffleSupport.singleton().createPartialEvaluator(configuration, this.builderConfig);
    }

    public void initialize(TruffleCompilable compilable, boolean firstInitialization) {
        super.initialize(compilable, firstInitialization);
        for (Backend backend : this.getConfig().backends()) {
            SubstrateGraalUtils.updateGraalArchitectureWithHostCPUFeatures((Backend)backend);
        }
    }

    protected TruffleTier newTruffleTier(OptionValues options) {
        return new TruffleTier(options, this.partialEvaluator, new InstrumentationSuite(this.partialEvaluator.instrumentationCfg, this.partialEvaluator.getInstrumentation()), (PostPartialEvaluationSuite)new SubstratePostPartialEvaluationSuite(this.getGraalOptions(), (Boolean)TruffleCompilerOptions.IterativePartialEscape.getValue(options)));
    }

    public PhaseSuite<HighTierContext> createGraphBuilderSuite(TruffleTierConfiguration tier) {
        return null;
    }

    protected OptionValues getGraalOptions() {
        return RuntimeOptionValues.singleton();
    }

    protected void parseGraalOptions(String[] options, EconomicMap<OptionKey<?>, Object> values) {
        CommonOptionParser.BooleanOptionFormat booleanFormat = CommonOptionParser.BooleanOptionFormat.NAME_VALUE;
        for (String option : options) {
            RuntimeOptionParser.singleton().parseOptionAtRuntime(option, "", booleanFormat, values, false);
        }
    }

    @Override
    public void teardown() {
    }

    protected CompilationResult createCompilationResult(String name, CompilationIdentifier compilationIdentifier, TruffleCompilable compilable) {
        return new SubstrateCompilationResult(compilationIdentifier, name);
    }

    public TruffleCompilationIdentifier createCompilationIdentifier(TruffleCompilationTask task, TruffleCompilable compilable) {
        return new SubstrateTruffleCompilationIdentifier(task, compilable);
    }

    public DebugContext createDebugContext(OptionValues options, CompilationIdentifier compilationId, TruffleCompilable callTarget, PrintStream logStream) {
        return TruffleRuntimeCompilationSupport.get().openDebugContext(options, compilationId, (Object)callTarget, logStream);
    }

    protected DiagnosticsOutputDirectory getDebugOutputDirectory() {
        return TruffleRuntimeCompilationSupport.get().getDebugOutputDirectory();
    }

    protected Map<CompilationWrapper.ExceptionAction, Integer> getCompilationProblemsPerAction() {
        return TruffleRuntimeCompilationSupport.get().getCompilationProblemsPerAction();
    }

    protected InstalledCode createInstalledCode(TruffleCompilable compilable) {
        return ((SubstrateCompilableTruffleAST)compilable).createPreliminaryInstalledCode();
    }
}

