/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.nfi;

import com.oracle.svm.core.handles.PrimitiveArrayView;
import com.oracle.svm.truffle.nfi.TruffleNFISupport;
import com.oracle.svm.truffle.nfi.TruffleObjectHandle;
import com.oracle.truffle.api.CompilerDirectives;
import java.util.ArrayList;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public final class LocalNativeScope
implements AutoCloseable {
    private final LocalNativeScope parent;
    private final short scopeId;
    private int pinCount;
    private final PrimitiveArrayView[] references;
    private ArrayList<Object> localHandles;

    LocalNativeScope(LocalNativeScope parent, int patchCount) {
        this.parent = parent;
        if (parent == null) {
            this.scopeId = 1;
        } else {
            assert (parent.scopeId < Short.MAX_VALUE);
            this.scopeId = (short)(parent.scopeId + 1);
        }
        this.pinCount = 0;
        this.references = patchCount > 0 ? new PrimitiveArrayView[patchCount] : null;
        this.localHandles = null;
    }

    public TruffleObjectHandle createLocalHandle(Object obj) {
        if (this.localHandles == null) {
            this.localHandles = new ArrayList();
        }
        int idx = this.localHandles.size();
        this.localHandles.add(obj);
        assert (this.localHandles.get(idx) == obj);
        return (TruffleObjectHandle)WordFactory.unsigned((int)idx).shiftLeft(16).or(this.scopeId & 0xFFFF).not();
    }

    private LocalNativeScope findScope(short id) {
        LocalNativeScope cur = this;
        while (cur != null && cur.scopeId > id) {
            cur = cur.parent;
        }
        if (cur != null && cur.scopeId == id) {
            return cur;
        }
        return null;
    }

    public Object resolveLocalHandle(TruffleObjectHandle handle) {
        Word word = ((Word)handle).not();
        short handleScopeId = (short)word.and(65535).rawValue();
        LocalNativeScope scope = this.findScope(handleScopeId);
        if (scope != null) {
            int idx = (int)word.unsignedShiftRight(16).rawValue();
            return scope.localHandles.get(idx);
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    PointerBase refArray(Object arr) {
        return this.refArray(arr, false);
    }

    @CompilerDirectives.TruffleBoundary
    PointerBase refArray(Object arr, boolean detached) {
        PrimitiveArrayView ret = detached ? PrimitiveArrayView.createForReading((Object)arr) : PrimitiveArrayView.createForReadingAndWriting((Object)arr);
        this.references[this.pinCount++] = ret;
        return ret.addressOfArrayElement(0);
    }

    @CompilerDirectives.TruffleBoundary
    PointerBase refString(String str) {
        byte[] array = TruffleNFISupport.javaStringToUtf8(str);
        return this.refArray(array, true);
    }

    @Override
    public void close() {
        for (int i = 0; i < this.pinCount; ++i) {
            this.references[i].close();
        }
        TruffleNFISupport.closeLocalScope(this, this.parent);
    }
}

