/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.isolated;

import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.CompilerHandle;
import com.oracle.svm.graal.isolated.ImageHeapObjects;
import com.oracle.svm.graal.isolated.ImageHeapRef;
import com.oracle.svm.graal.isolated.IsolatedCodeInstallBridge;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.graal.isolated.IsolatedHandles;
import com.oracle.svm.graal.isolated.IsolatedObjectConstant;
import com.oracle.svm.truffle.api.SubstrateCompilableTruffleAST;
import com.oracle.svm.truffle.api.SubstrateTruffleRuntime;
import com.oracle.svm.truffle.isolated.IsolatedCompilableTruffleAST;
import com.oracle.svm.truffle.isolated.IsolatedStringSupplier;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.compiler.OptimizedAssumptionDependency;
import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.runtime.OptimizedAssumption;
import com.oracle.truffle.runtime.OptimizedCallTarget;
import com.oracle.truffle.runtime.OptimizedDirectCallNode;
import java.util.function.Consumer;
import java.util.function.Supplier;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.word.ComparableWord;

public final class IsolatedTruffleRuntimeSupport {
    public static Consumer<OptimizedAssumptionDependency> registerOptimizedAssumptionDependency(JavaConstant optimizedAssumptionConstant) {
        ClientHandle<Consumer<OptimizedAssumptionDependency>> consumerHandle;
        if (optimizedAssumptionConstant instanceof IsolatedObjectConstant) {
            ClientHandle assumptionHandle = ((IsolatedObjectConstant)optimizedAssumptionConstant).getHandle();
            consumerHandle = IsolatedTruffleRuntimeSupport.registerOptimizedAssumptionDependency0(IsolatedCompileContext.get().getClient(), (ClientHandle<OptimizedAssumption>)assumptionHandle);
        } else {
            ImageHeapRef assumptionRef = ImageHeapObjects.ref((Object)((OptimizedAssumption)SubstrateObjectConstant.asObject(OptimizedAssumption.class, (JavaConstant)optimizedAssumptionConstant)));
            consumerHandle = IsolatedTruffleRuntimeSupport.registerImageHeapOptimizedAssumptionDependency0(IsolatedCompileContext.get().getClient(), (ImageHeapRef<OptimizedAssumption>)assumptionRef);
        }
        if (consumerHandle.equal((ComparableWord)IsolatedHandles.nullHandle())) {
            return null;
        }
        return new Consumer<OptimizedAssumptionDependency>(){

            @Override
            public void accept(OptimizedAssumptionDependency codeInstallBridge) {
                ClientHandle installedCodeHandle = (ClientHandle)IsolatedHandles.nullHandle();
                if (codeInstallBridge != null) {
                    installedCodeHandle = ((IsolatedCodeInstallBridge)codeInstallBridge).getSubstrateInstalledCodeHandle();
                }
                ClientHandle dependencyAccessHandle = installedCodeHandle;
                IsolatedTruffleRuntimeSupport.notifyAssumption0(IsolatedCompileContext.get().getClient(), (ClientHandle<Consumer<OptimizedAssumptionDependency>>)consumerHandle, (ClientHandle<? extends OptimizedAssumptionDependency>)dependencyAccessHandle);
            }
        };
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static ClientHandle<Consumer<OptimizedAssumptionDependency>> registerOptimizedAssumptionDependency0(ClientIsolateThread client, ClientHandle<OptimizedAssumption> assumptionHandle) {
        OptimizedAssumption assumption = (OptimizedAssumption)IsolatedCompileClient.get().unhand(assumptionHandle);
        return IsolatedTruffleRuntimeSupport.registerOptimizedAssumptionDependency1(assumption);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static ClientHandle<Consumer<OptimizedAssumptionDependency>> registerImageHeapOptimizedAssumptionDependency0(ClientIsolateThread client, ImageHeapRef<OptimizedAssumption> assumptionRef) {
        OptimizedAssumption assumption = (OptimizedAssumption)ImageHeapObjects.deref(assumptionRef);
        return IsolatedTruffleRuntimeSupport.registerOptimizedAssumptionDependency1(assumption);
    }

    private static ClientHandle<Consumer<OptimizedAssumptionDependency>> registerOptimizedAssumptionDependency1(OptimizedAssumption assumption) {
        Consumer observer = assumption.registerDependency();
        return IsolatedCompileClient.get().hand((Object)observer);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static void notifyAssumption0(ClientIsolateThread client, ClientHandle<Consumer<OptimizedAssumptionDependency>> consumerHandle, ClientHandle<? extends OptimizedAssumptionDependency> dependencyHandle) {
        OptimizedAssumptionDependency dependency = null;
        if (dependencyHandle.notEqual((ComparableWord)IsolatedHandles.nullHandle())) {
            dependency = (OptimizedAssumptionDependency)IsolatedCompileClient.get().unhand(dependencyHandle);
        }
        ((Consumer)IsolatedCompileClient.get().unhand(consumerHandle)).accept(dependency);
    }

    public static JavaConstant getCallTargetForCallNode(JavaConstant callNodeConstant) {
        ClientHandle callNodeHandle = ((IsolatedObjectConstant)callNodeConstant).getHandle();
        return new IsolatedObjectConstant(IsolatedTruffleRuntimeSupport.getCallTargetForCallNode0(IsolatedCompileContext.get().getClient(), (ClientHandle<OptimizedDirectCallNode>)callNodeHandle), false);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static ClientHandle<OptimizedCallTarget> getCallTargetForCallNode0(ClientIsolateThread client, ClientHandle<OptimizedDirectCallNode> callNode) {
        OptimizedDirectCallNode node = (OptimizedDirectCallNode)IsolatedCompileClient.get().unhand(callNode);
        OptimizedCallTarget callTarget = node.getCallTarget();
        return IsolatedCompileClient.get().hand((Object)callTarget);
    }

    public static TruffleCompilable asCompilableTruffleAST(JavaConstant constant) {
        ClientHandle handle = ((IsolatedObjectConstant)constant).getHandle();
        return new IsolatedCompilableTruffleAST((ClientHandle<SubstrateCompilableTruffleAST>)handle);
    }

    public static boolean tryLog(String loggerId, TruffleCompilable compilable, String message) {
        if (compilable instanceof IsolatedCompilableTruffleAST) {
            ClientHandle id = IsolatedCompileContext.get().createStringInClient((CharSequence)loggerId);
            ClientHandle handle = ((IsolatedCompilableTruffleAST)compilable).getHandle();
            ClientHandle msg = IsolatedCompileContext.get().createStringInClient((CharSequence)message);
            IsolatedTruffleRuntimeSupport.log0(IsolatedCompileContext.get().getClient(), (ClientHandle<String>)id, (ClientHandle<SubstrateCompilableTruffleAST>)handle, (ClientHandle<String>)msg);
            return true;
        }
        return false;
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileClient.VoidExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileClient.ExceptionRethrowCallerEpilogue.class)
    private static void log0(ClientIsolateThread client, ClientHandle<String> id, ClientHandle<SubstrateCompilableTruffleAST> ast, ClientHandle<String> msg) {
        SubstrateTruffleRuntime runtime = (SubstrateTruffleRuntime)SubstrateTruffleRuntime.getRuntime();
        String loggerId = (String)IsolatedCompileClient.get().unhand(id);
        OptimizedCallTarget callTarget = (OptimizedCallTarget)IsolatedCompileClient.get().unhand(ast);
        String message = (String)IsolatedCompileClient.get().unhand(msg);
        runtime.log(loggerId, (TruffleCompilable)callTarget, message);
    }

    public static TriState tryIsSuppressedFailure(TruffleCompilable compilable, Supplier<String> serializedException) {
        if (compilable instanceof IsolatedCompilableTruffleAST) {
            ClientHandle handle = ((IsolatedCompilableTruffleAST)compilable).getHandle();
            return IsolatedTruffleRuntimeSupport.isSuppressedFailure0(IsolatedCompileContext.get().getClient(), (ClientHandle<SubstrateCompilableTruffleAST>)handle, (CompilerHandle<Supplier<String>>)IsolatedCompileContext.get().hand(serializedException)) ? TriState.TRUE : TriState.FALSE;
        }
        return TriState.UNDEFINED;
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileClient.BooleanExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileClient.ExceptionRethrowCallerEpilogue.class)
    private static boolean isSuppressedFailure0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> ast, CompilerHandle<Supplier<String>> serializedExceptionHandle) {
        IsolatedStringSupplier serializedException = new IsolatedStringSupplier(serializedExceptionHandle);
        SubstrateTruffleRuntime runtime = (SubstrateTruffleRuntime)SubstrateTruffleRuntime.getRuntime();
        return runtime.isSuppressedFailure((TruffleCompilable)IsolatedCompileClient.get().unhand(ast), serializedException);
    }

    private IsolatedTruffleRuntimeSupport() {
    }
}

