/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.RuntimeAssertionsSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.hosted.GraalGraphObjectReplacer;
import com.oracle.svm.graal.hosted.SubstrateGraalCompilerSetup;
import com.oracle.svm.graal.hosted.SubstrateProviders;
import com.oracle.svm.graal.meta.SubstrateUniverseFactory;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.heap.PodSupport;
import com.oracle.svm.hosted.snippets.SubstrateGraphBuilderPlugins;
import com.oracle.svm.truffle.ArrayBasedShapeGeneratorOffsetTransformer;
import com.oracle.svm.truffle.NodeClassSupport;
import com.oracle.svm.truffle.StaticPropertyOffsetTransformer;
import com.oracle.svm.truffle.SubstrateTruffleHostEnvironmentLookup;
import com.oracle.svm.truffle.Target_com_oracle_truffle_api_staticobject_StaticShape_Builder;
import com.oracle.svm.truffle.TruffleFeature;
import com.oracle.svm.util.ReflectionUtil;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleRuntime;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.impl.DefaultTruffleRuntime;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.GenerateLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.provider.DefaultExportProvider;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeClass;
import com.oracle.truffle.api.nodes.NodeInterface;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.Profile;
import com.oracle.truffle.api.staticobject.StaticProperty;
import com.oracle.truffle.api.staticobject.StaticShape;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.truffle.compiler.host.InjectImmutableFrameFieldsPhase;
import org.graalvm.compiler.truffle.compiler.host.TruffleHostEnvironment;
import org.graalvm.compiler.truffle.compiler.substitutions.TruffleInvocationPlugins;
import org.graalvm.home.HomeFinder;
import org.graalvm.home.Version;
import org.graalvm.home.impl.DefaultHomeFinder;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeResourceSupport;
import org.graalvm.polyglot.Engine;

public final class TruffleBaseFeature
implements InternalFeature {
    private static final MethodHandle VERSION_GET_COMPONENT = TruffleBaseFeature.findVersionGetComponent();
    private static final String NATIVE_IMAGE_FILELIST_FILE_NAME = "native-image-resources.filelist";
    private static final Version NEXT_POLYGLOT_VERSION_UPDATE = Version.create((int[])new int[]{25, 1});
    private static final int MAX_JDK_VERSION = 25;
    private static final Method NODE_CLASS_getAccesssedFields = ReflectionUtil.lookupMethod(NodeClass.class, (String)"getAccessedFields", (Class[])new Class[0]);
    private static final Field UNSAFE_FIELD_name = ReflectionUtil.lookupField(InlineSupport.InlinableField.class.getSuperclass(), (String)"name");
    private static final Field UNSAFE_FIELD_declaringClass = ReflectionUtil.lookupField(InlineSupport.InlinableField.class.getSuperclass(), (String)"declaringClass");
    private ClassLoader imageClassLoader;
    private AnalysisMetaAccess metaAccess;
    private GraalGraphObjectReplacer graalGraphObjectReplacer;
    private final Set<Class<?>> registeredClasses = new HashSet();
    private final Map<Class<?>, PossibleReplaceCandidatesSubtypeHandler> subtypeChecks = new HashMap();
    private boolean profilingEnabled;
    private boolean needsAllEncodings;
    private Field layoutInfoMapField;
    private Field layoutMapField;
    private Field libraryFactoryCacheField;
    private Map<String, Path> languageHomesToCopy;
    private Consumer<Field> markAsUnsafeAccessed;
    private final ConcurrentMap<Object, Boolean> processedInlinedFields = new ConcurrentHashMap<Object, Boolean>();
    private final Set<Class<?>> dynamicObjectClasses = new HashSet();

    private static MethodHandle findVersionGetComponent() {
        try {
            return MethodHandles.lookup().findVirtual(Version.class, "getComponent", MethodType.methodType(Integer.TYPE, Integer.TYPE));
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    public String getURL() {
        return "https://github.com/oracle/graal/blob/master/substratevm/src/com.oracle.svm.truffle/src/com/oracle/svm/truffle/TruffleBaseFeature.java";
    }

    public String getDescription() {
        return "Provides support for Truffle languages";
    }

    public static Class<?> lookupClass(String className) {
        try {
            return Class.forName(className, false, TruffleBaseFeature.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private static void initializeTruffleReflectively(ClassLoader imageClassLoader) {
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.api.impl.Accessor", "getTVMCI", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.polyglot.InternalResourceCache", "initializeNativeImageState", Collections.singletonList(ClassLoader.class), imageClassLoader);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.polyglot.LanguageCache", "initializeNativeImageState", Collections.singletonList(ClassLoader.class), imageClassLoader);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.polyglot.InstrumentCache", "initializeNativeImageState", Collections.singletonList(ClassLoader.class), imageClassLoader);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.api.impl.TruffleLocator", "initializeNativeImageState", Collections.emptyList(), new Object[0]);
    }

    private static void initializeHomeFinder() {
        Set languages = (Set)TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.polyglot.LanguageCache", "collectLanguages", Collections.emptyList(), new Object[0]);
        Set tools = (Set)TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.polyglot.InstrumentCache", "collectInstruments", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod(DefaultHomeFinder.class.getName(), "setNativeImageLanguages", List.of(Set.class), languages);
        TruffleBaseFeature.invokeStaticMethod(DefaultHomeFinder.class.getName(), "setNativeImageTools", List.of(Set.class), tools);
    }

    public static void removeTruffleLanguage(String mimeType) {
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.polyglot.LanguageCache", "removeLanguageFromNativeImage", Collections.singletonList(String.class), mimeType);
    }

    static <T> T invokeStaticMethod(String className, String methodName, Collection<Class<?>> parameterTypes, Object ... args) {
        try {
            Class<?> clazz = Class.forName(className);
            Method method = ReflectionUtil.lookupMethod(clazz, (String)methodName, (Class[])parameterTypes.toArray(new Class[0]));
            return (T)method.invoke(null, args);
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere((Throwable)e);
        }
    }

    private Object processInlinedField(Object obj) {
        if (obj instanceof InlineSupport.InlinableField && this.processedInlinedFields.putIfAbsent(obj, true) == null) {
            VMError.guarantee((this.markAsUnsafeAccessed != null ? 1 : 0) != 0, (String)"New InlinedField found after static analysis");
            try {
                String name = (String)UNSAFE_FIELD_name.get(obj);
                Class declaringClass = (Class)UNSAFE_FIELD_declaringClass.get(obj);
                this.markAsUnsafeAccessed.accept(declaringClass.getDeclaredField(name));
            }
            catch (ReflectiveOperationException ex) {
                throw VMError.shouldNotReachHere((Throwable)ex);
            }
        }
        return obj;
    }

    public void afterRegistration(Feature.AfterRegistrationAccess a) {
        if (!Boolean.getBoolean("polyglotimpl.DisableVersionChecks")) {
            Version truffleVersion = TruffleBaseFeature.getTruffleVersion(a);
            Version truffleMajorMinorVersion = TruffleBaseFeature.stripUpdateVersion(truffleVersion);
            Version featureVersion = this.getSVMFeatureVersion();
            Version featureMajorMinorVersion = TruffleBaseFeature.stripUpdateVersion(featureVersion);
            if (featureVersion.compareTo(NEXT_POLYGLOT_VERSION_UPDATE) >= 0) {
                throw new AssertionError((Object)"MAX_JDK_VERSION must be updated, please contact the Truffle team!");
            }
            if (featureMajorMinorVersion.compareTo(truffleMajorMinorVersion) > 0) {
                throw TruffleBaseFeature.throwVersionError("Your Java runtime '%s' with native-image feature version '%s' is incompatible with polyglot version '%s'.\nUpdate the org.graalvm.polyglot versions to at least '%s' to resolve this.\n", Runtime.version(), featureVersion, truffleVersion, featureVersion);
            }
            if (truffleVersion.compareTo(NEXT_POLYGLOT_VERSION_UPDATE) >= 0) {
                throw TruffleBaseFeature.throwVersionError("Your Java runtime '%s' with native-image feature version '%s' is incompatible with polyglot version '%s'.\nThe Java runtime version must be greater or equal to JDK '%d'.\nUpdate your Java runtime to resolve this.\n", Runtime.version(), featureVersion, truffleVersion, 25);
            }
        }
        this.imageClassLoader = a.getApplicationClassLoader();
        TruffleRuntime runtime = Truffle.getRuntime();
        UserError.guarantee((runtime != null ? 1 : 0) != 0, (String)"TruffleRuntime not available via Truffle.getRuntime()", (Object[])new Object[0]);
        UserError.guarantee((TruffleBaseFeature.isSubstrateRuntime(runtime) || runtime instanceof DefaultTruffleRuntime ? 1 : 0) != 0, (String)"Unsupported TruffleRuntime %s (only SubstrateTruffleRuntime or DefaultTruffleRuntime allowed)", (Object[])new Object[]{runtime.getClass().getName()});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"com.oracle.graalvm.locator", "Truffle classes are always initialized at build time"});
        TruffleBaseFeature.initializeTruffleReflectively(this.imageClassLoader);
        TruffleBaseFeature.initializeHomeFinder();
        this.needsAllEncodings = (Boolean)TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.polyglot.LanguageCache", "getNeedsAllEncodings", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.api.library.LibraryFactory", "reinitializeNativeImageState", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.api.TruffleLogger$LoggerCache", "getInstance", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.polyglot.InternalResourceCacheSymbol", "initialize", List.of(), new Object[0]);
        this.profilingEnabled = false;
    }

    private static Version getTruffleVersion(Feature.AfterRegistrationAccess config) {
        Class polyglotImplClass = config.findClassByName("com.oracle.truffle.polyglot.PolyglotImpl");
        Field versionField = ReflectionUtil.lookupField((boolean)true, (Class)polyglotImplClass, (String)"TRUFFLE_VERSION");
        if (versionField != null) {
            try {
                return Version.parse((String)((String)versionField.get(null)));
            }
            catch (ReflectiveOperationException e) {
                throw VMError.shouldNotReachHere((Throwable)e);
            }
        }
        return Version.create((int[])new int[]{23, 1, 1});
    }

    private Version getSVMFeatureVersion() {
        Version version;
        InputStream in = this.getClass().getResourceAsStream("/META-INF/graalvm/org.graalvm.truffle.runtime.svm/version");
        if (in == null) {
            throw VMError.shouldNotReachHere((String)"Truffle native image feature must have a version file.");
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        try {
            version = Version.parse((String)r.readLine());
        }
        catch (Throwable throwable) {
            try {
                try {
                    r.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw VMError.shouldNotReachHere((Throwable)ioe);
            }
        }
        r.close();
        return version;
    }

    private static Version stripUpdateVersion(Version version) {
        if (VERSION_GET_COMPONENT != null) {
            int minor;
            int major;
            try {
                major = VERSION_GET_COMPONENT.invoke(version, 0);
                minor = VERSION_GET_COMPONENT.invoke(version, 1);
            }
            catch (Throwable t) {
                throw new AssertionError((Object)t);
            }
            if (major != 0 || minor != 0) {
                return Version.create((int[])new int[]{major, minor});
            }
        }
        return version;
    }

    private static RuntimeException throwVersionError(String errorFormat, Object ... args) {
        StringBuilder errorMessage = new StringBuilder("Polyglot version compatibility check failed.\n");
        errorMessage.append(String.format(errorFormat, args));
        errorMessage.append("To disable this version check the '-Dpolyglotimpl.DisableVersionChecks=true' system property can be used.\nIt is not recommended to disable version checks.\n");
        throw new IllegalStateException(errorMessage.toString());
    }

    private static boolean isSubstrateRuntime(TruffleRuntime runtime) {
        return runtime.getClass().getName().equals("com.oracle.svm.truffle.api.SubstrateTruffleRuntime");
    }

    public void setProfilingEnabled(boolean profilingEnabled) {
        this.profilingEnabled = profilingEnabled;
    }

    public void cleanup() {
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.polyglot.PolyglotFastThreadLocals", "resetNativeImageState", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.polyglot.LanguageCache", "resetNativeImageState", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.polyglot.InstrumentCache", "resetNativeImageState", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.polyglot.InternalResourceCache", "resetNativeImageState", List.of(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod("org.graalvm.polyglot.Engine$ImplHolder", "resetPreInitializedEngine", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.api.impl.TruffleLocator", "resetNativeImageState", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.api.impl.ThreadLocalHandshake", "resetNativeImageState", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.api.library.LibraryFactory", "resetNativeImageState", Collections.singletonList(ClassLoader.class), this.imageClassLoader);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.api.source.Source", "resetNativeImageState", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.object.LayoutImpl", "resetNativeImageState", Collections.emptyList(), new Object[0]);
    }

    public void registerInvocationPlugins(Providers providers, SnippetReflectionProvider snippetReflection, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        StaticObjectSupport.registerInvocationPlugins(plugins, reason);
        TruffleInvocationPlugins.register((Architecture)providers.getLowerer().getTarget().arch, (InvocationPlugins)plugins.getInvocationPlugins(), (Replacements)providers.getReplacements());
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), Profile.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("isProfilingEnabled", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)TruffleBaseFeature.this.profilingEnabled));
                return true;
            }
        });
        if (reason != ParsingReason.JITCompilation) {
            r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), CompilerDirectives.class);
            SubstrateGraphBuilderPlugins.registerCastExact((InvocationPlugins.Registration)r);
        }
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        if (!ImageSingletons.contains(TruffleFeature.class) && TruffleBaseFeature.isSubstrateRuntime(Truffle.getRuntime())) {
            VMError.shouldNotReachHere((String)"TruffleFeature is required for SubstrateTruffleRuntime.");
        }
        access.registerObjectReplacer(this::processInlinedField);
        StaticObjectSupport.duringSetup(access);
        HomeFinder hf = HomeFinder.getInstance();
        if (((Boolean)SubstrateOptions.TruffleStableOptions.CopyLanguageResources.getValue()).booleanValue()) {
            if (!(hf instanceof DefaultHomeFinder)) {
                VMError.shouldNotReachHere((String)String.format("HomeFinder %s cannot be used if CopyLanguageResources option of TruffleBaseFeature is enabled", hf.getClass().getName()));
            }
            Map languageHomes = hf.getLanguageHomes();
            Set includedLanguages = (Set)TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.polyglot.LanguageCache", "collectLanguages", Collections.emptyList(), new Object[0]);
            for (Map.Entry languageHomeEntry : languageHomes.entrySet()) {
                String languageId = (String)languageHomeEntry.getKey();
                if (!includedLanguages.contains(languageId)) continue;
                Path languageHome = (Path)languageHomeEntry.getValue();
                Path fileListFile = languageHome.resolve(NATIVE_IMAGE_FILELIST_FILE_NAME);
                try {
                    if (!Files.exists(fileListFile, new LinkOption[0]) || Files.size(fileListFile) <= 0L) continue;
                    Path homeRelativePath = Paths.get("resources", "languages", languageId);
                    boolean relativeHomeSet = (Boolean)TruffleBaseFeature.invokeStaticMethod(DefaultHomeFinder.class.getName(), "setRelativeLanguageHomeIfNotAlreadySet", Arrays.asList(String.class, Path.class), languageId, homeRelativePath);
                    if (!relativeHomeSet) continue;
                    if (this.languageHomesToCopy == null) {
                        this.languageHomesToCopy = new LinkedHashMap<String, Path>();
                    }
                    this.languageHomesToCopy.put(languageId, homeRelativePath);
                }
                catch (IOException ioe) {
                    throw VMError.shouldNotReachHere((String)String.format("Cannot read the %s file for language %s.", NATIVE_IMAGE_FILELIST_FILE_NAME, languageId), (Throwable)ioe);
                }
            }
        }
        ImageSingletons.add(NodeClassSupport.class, (Object)new NodeClassSupport());
        if (!ImageSingletons.contains(SubstrateGraalCompilerSetup.class)) {
            ImageSingletons.add(SubstrateGraalCompilerSetup.class, (Object)new SubstrateGraalCompilerSetup());
        }
        FeatureImpl.DuringSetupAccessImpl config = (FeatureImpl.DuringSetupAccessImpl)access;
        this.metaAccess = config.getMetaAccess();
        this.layoutInfoMapField = config.findField("com.oracle.truffle.object.DefaultLayout$LayoutInfo", "LAYOUT_INFO_MAP");
        this.layoutMapField = config.findField("com.oracle.truffle.object.DefaultLayout", "LAYOUT_MAP");
        this.libraryFactoryCacheField = config.findField("com.oracle.truffle.api.library.LibraryFactory$ResolvedDispatch", "CACHE");
        if (((Boolean)Options.TruffleCheckPreinitializedFiles.getValue()).booleanValue()) {
            access.registerObjectReplacer((Function)new TruffleFileCheck(((FeatureImpl.DuringSetupAccessImpl)access).getHostVM().getClassInitializationSupport()));
        }
    }

    void setGraalGraphObjectReplacer(GraalGraphObjectReplacer graalGraphObjectReplacer) {
        assert (this.graalGraphObjectReplacer == null);
        this.graalGraphObjectReplacer = graalGraphObjectReplacer;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        FeatureImpl.BeforeAnalysisAccessImpl config;
        if (this.graalGraphObjectReplacer == null) {
            config = (FeatureImpl.BeforeAnalysisAccessImpl)access;
            SubstrateProviders substrateProviders = ((SubstrateGraalCompilerSetup)ImageSingletons.lookup(SubstrateGraalCompilerSetup.class)).getSubstrateProviders(this.metaAccess);
            this.graalGraphObjectReplacer = new GraalGraphObjectReplacer(config.getUniverse(), substrateProviders, new SubstrateUniverseFactory());
            this.graalGraphObjectReplacer.setAnalysisAccess(config);
        }
        TruffleHostEnvironment.overrideLookup((TruffleHostEnvironment.Lookup)new SubstrateTruffleHostEnvironmentLookup());
        StaticObjectSupport.beforeAnalysis(access);
        this.markAsUnsafeAccessed = arg_0 -> ((Feature.BeforeAnalysisAccess)access).registerAsUnsafeAccessed(arg_0);
        config = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        config.registerHierarchyForReflectiveInstantiation(DefaultExportProvider.class);
        config.registerHierarchyForReflectiveInstantiation(TruffleInstrument.class);
        TruffleBaseFeature.registerDynamicObjectFields(config);
        config.registerSubtypeReachabilityHandler(TruffleBaseFeature::registerTruffleLibrariesAsInHeap, LibraryFactory.class);
        config.registerSubtypeReachabilityHandler(TruffleBaseFeature::registerTruffleLibrariesAsInHeap, LibraryExport.class);
        if (this.needsAllEncodings) {
            ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResources(ConfigurationCondition.alwaysTrue(), "org/graalvm/shadowed/org/jcodings/tables/.*bin$");
        }
        Class frameClass = config.findClassByName("com.oracle.truffle.api.impl.FrameWithoutBoxing");
        config.registerFieldValueTransformer(config.findField(frameClass, "ASSERTIONS_ENABLED"), (FieldValueTransformer)new AssertionStatusFieldTransformer(frameClass));
        TruffleBaseFeature.registerInternalResourceFieldValueTransformers(config);
    }

    private static void registerInternalResourceFieldValueTransformers(FeatureImpl.BeforeAnalysisAccessImpl config) {
        Class internalResourceCacheClass = config.findClassByName("com.oracle.truffle.polyglot.InternalResourceCache");
        Class internalResourceRootsClass = config.findClassByName("com.oracle.truffle.polyglot.InternalResourceRoots");
        Class resetableCacheRootClass = config.findClassByName("com.oracle.truffle.polyglot.InternalResourceCache$ResettableCachedRoot");
        Field cacheRootField = ReflectionUtil.lookupField((boolean)true, (Class)internalResourceCacheClass, (String)"cacheRoot");
        if (cacheRootField != null) {
            assert (internalResourceRootsClass == null);
            config.registerFieldValueTransformer(cacheRootField, ResetFieldValueTransformer.INSTANCE);
            config.registerFieldValueTransformer(ReflectionUtil.lookupField((boolean)false, (Class)resetableCacheRootClass, (String)"resourceCacheRoot"), ResetFieldValueTransformer.INSTANCE);
        } else {
            assert (resetableCacheRootClass == null);
            config.registerFieldValueTransformer(ReflectionUtil.lookupField((boolean)false, (Class)internalResourceCacheClass, (String)"owningRoot"), ResetFieldValueTransformer.INSTANCE);
            config.registerFieldValueTransformer(ReflectionUtil.lookupField((boolean)false, (Class)internalResourceCacheClass, (String)"path"), ResetFieldValueTransformer.INSTANCE);
            config.registerFieldValueTransformer(ReflectionUtil.lookupField((boolean)false, (Class)internalResourceRootsClass, (String)"roots"), ResetFieldValueTransformer.INSTANCE);
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.markAsUnsafeAccessed = null;
    }

    public static void preInitializeEngine() {
        TruffleBaseFeature.invokeStaticMethod("org.graalvm.polyglot.Engine$ImplHolder", "preInitializeEngine", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.api.impl.ThreadLocalHandshake", "resetNativeImageState", Collections.emptyList(), new Object[0]);
    }

    private static void registerTruffleLibrariesAsInHeap(Feature.DuringAnalysisAccess a, Class<?> clazz) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        assert (access.isReachable(clazz)) : clazz;
        assert (LibraryFactory.class.isAssignableFrom(clazz) || LibraryExport.class.isAssignableFrom(clazz)) : clazz;
        if (!Modifier.isAbstract(clazz.getModifiers())) {
            access.registerAsInHeap(clazz, (Object)"Truffle library class registered by TruffleBaseFeature.");
        }
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        StaticObjectSupport.duringAnalysis(a);
        for (Class clazz : access.reachableSubtypes(Node.class)) {
            this.registerUnsafeAccess((Feature.DuringAnalysisAccess)access, clazz.asSubclass(Node.class));
            AnalysisType type = access.getMetaAccess().lookupJavaType(clazz);
            if (!type.isInstantiated()) continue;
            this.graalGraphObjectReplacer.createType((JavaType)type);
        }
        for (AnalysisType type : access.getBigBang().getUniverse().getTypes()) {
            if (!a.isReachable(type.getJavaClass())) continue;
            TruffleBaseFeature.initializeTruffleLibrariesAtBuildTime(type);
            this.initializeDynamicObjectLayouts(type);
        }
        access.rescanRoot(this.layoutInfoMapField);
        access.rescanRoot(this.layoutMapField);
        access.rescanRoot(this.libraryFactoryCacheField);
    }

    public void registerGraalPhases(Providers providers, SnippetReflectionProvider snippetReflection, Suites suites, boolean hosted) {
        if (hosted) {
            InjectImmutableFrameFieldsPhase.install((PhaseSuite)suites.getHighTier(), (OptionValues)HostedOptionValues.singleton());
        }
    }

    public void afterCompilation(Feature.AfterCompilationAccess access) {
        FeatureImpl.AfterCompilationAccessImpl config = (FeatureImpl.AfterCompilationAccessImpl)access;
        this.graalGraphObjectReplacer.updateSubstrateDataAfterCompilation(config.getUniverse(), config.getProviders());
        this.graalGraphObjectReplacer.registerImmutableObjects((Feature.CompilationAccess)access);
    }

    private void registerUnsafeAccess(Feature.DuringAnalysisAccess access, Class<? extends Node> clazz) {
        Field[] fields;
        if (this.registeredClasses.contains(clazz)) {
            return;
        }
        this.registeredClasses.add(clazz);
        NodeClass nodeClass = NodeClass.get(clazz);
        NodeClassSupport.singleton().nodeClasses.put(clazz, (Object)nodeClass);
        try {
            fields = (Field[])NODE_CLASS_getAccesssedFields.invoke((Object)nodeClass, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere((Throwable)e);
        }
        for (Field field : fields) {
            Class<?> type;
            access.registerAsAccessed(field);
            if (field.getAnnotation(Node.Child.class) == null || Modifier.isFinal((type = field.getType()).getModifiers())) continue;
            if (type == Node.class || type == NodeInterface.class) {
                access.registerAsUnsafeAccessed(field);
                continue;
            }
            PossibleReplaceCandidatesSubtypeHandler detector = this.subtypeChecks.get(type);
            if (detector == null) {
                detector = new PossibleReplaceCandidatesSubtypeHandler(type);
                access.registerSubtypeReachabilityHandler((BiConsumer)detector, type);
                this.subtypeChecks.put(type, detector);
            }
            detector.addField(access, field);
        }
        access.requireAnalysisIteration();
    }

    private static void initializeTruffleLibrariesAtBuildTime(AnalysisType type) {
        if (type.isAnnotationPresent(GenerateLibrary.class)) {
            LibraryFactory factory = LibraryFactory.resolve(type.getJavaClass().asSubclass(Library.class));
            factory.getUncached();
        }
        if (type.isAnnotationPresent(ExportLibrary.class) || type.isAnnotationPresent(ExportLibrary.Repeat.class)) {
            TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.api.library.LibraryFactory$ResolvedDispatch", "lookup", Collections.singleton(Class.class), type.getJavaClass());
        }
    }

    private void initializeDynamicObjectLayouts(AnalysisType type) {
        Class javaClass;
        if (type.isInstantiated() && DynamicObject.class.isAssignableFrom(javaClass = type.getJavaClass()) && this.dynamicObjectClasses.add(javaClass)) {
            TruffleBaseFeature.initializeDynamicObjectLayoutImpl(javaClass);
        }
    }

    private static void initializeDynamicObjectLayoutImpl(Class<?> javaClass) {
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.object.LayoutImpl", "initializeDynamicObjectLayout", Collections.singleton(Class.class), javaClass);
    }

    private static void registerDynamicObjectFields(FeatureImpl.BeforeAnalysisAccessImpl config) {
        Class dynamicFieldClass = config.findClassByName(DynamicObject.class.getName().concat("$DynamicField"));
        if (dynamicFieldClass == null) {
            throw VMError.shouldNotReachHere((String)"DynamicObject.DynamicField annotation not found.");
        }
        for (Field field : config.findAnnotatedFields(dynamicFieldClass.asSubclass(Annotation.class))) {
            config.registerAsUnsafeAccessed(field);
        }
    }

    public void afterImageWrite(Feature.AfterImageWriteAccess access) {
        Path parent;
        Path buildDir;
        if (((Boolean)SubstrateOptions.TruffleStableOptions.CopyLanguageResources.getValue()).booleanValue() && (buildDir = access.getImagePath()) != null && (parent = buildDir.getParent()) != null) {
            this.copyResources(parent);
        }
    }

    private void copyResources(Path buildDir) {
        Path resourcesDir = buildDir.resolve("resources");
        if (this.languageHomesToCopy != null) {
            Path languagesDir = resourcesDir.resolve("languages");
            if (Files.exists(languagesDir, new LinkOption[0])) {
                try (Stream<Path> filesToDelete = Files.walk(languagesDir, new FileVisitOption[0]);){
                    filesToDelete.sorted(Comparator.reverseOrder()).forEach(f -> {
                        try {
                            Files.deleteIfExists(f);
                        }
                        catch (IOException ioe) {
                            throw VMError.shouldNotReachHere((String)"Deletion of previous language resources directory failed.", (Throwable)ioe);
                        }
                    });
                }
                catch (IOException ioe) {
                    throw VMError.shouldNotReachHere((String)"Deletion of previous language resources directory failed.", (Throwable)ioe);
                }
            }
            HomeFinder hf = HomeFinder.getInstance();
            Map languageHomes = hf.getLanguageHomes();
            this.languageHomesToCopy.forEach((s, path) -> {
                Path copyTo = buildDir.resolve((Path)path);
                Path copyFrom = (Path)languageHomes.get(s);
                Path fileListFile = copyFrom.resolve(NATIVE_IMAGE_FILELIST_FILE_NAME);
                try {
                    Files.lines(fileListFile).forEach(fileName -> TruffleBaseFeature.copy(s, copyFrom.resolve((String)fileName), copyTo.resolve((String)fileName)));
                }
                catch (IOException ioe) {
                    throw VMError.shouldNotReachHere((String)String.format("Copying of language resources failed for language %s.", s), (Throwable)ioe);
                }
                BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.LANGUAGE_HOME, copyTo);
            });
        }
        try {
            if (Engine.copyResources((Path)resourcesDir, (String[])new String[0])) {
                BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.LANGUAGE_INTERNAL_RESOURCES, resourcesDir);
            }
        }
        catch (IOException ioe) {
            throw VMError.shouldNotReachHere((String)"Copying of internal resources failed.", (Throwable)ioe);
        }
    }

    private static void copy(String language, Path source, Path dest) {
        try {
            if (!Files.isDirectory(source, new LinkOption[0]) || !Files.exists(dest, new LinkOption[0])) {
                if (!Files.isDirectory(source, new LinkOption[0])) {
                    Path dir = dest.getParent();
                    assert (dir != null);
                    Files.createDirectories(dir, new FileAttribute[0]);
                }
                Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException ioe) {
            throw VMError.shouldNotReachHere((String)String.format("Copying of language resources failed for language %s.", language), (Throwable)ioe);
        }
    }

    static final class StaticObjectSupport {
        private static final Method VALIDATE_CLASSES = ReflectionUtil.lookupMethod(StaticShape.Builder.class, (String)"validateClasses", (Class[])new Class[]{Class.class, Class.class});

        StaticObjectSupport() {
        }

        static void duringSetup(Feature.DuringSetupAccess access) {
            StaticObjectArrayBasedSupport.duringSetup(access);
        }

        static void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
            StaticObjectArrayBasedSupport.beforeAnalysis(access);
        }

        static void registerInvocationPlugins(GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
            if (reason.duringAnalysis()) {
                InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), StaticShape.Builder.class);
                r.register((InvocationPlugin)new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("build", new Type[]{InvocationPlugin.Receiver.class, Class.class, Class.class}){

                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                        Class<?> factoryInterface;
                        Class<?> storageSuperClass = StaticObjectSupport.getArgumentClass(b, targetMethod, 1, arg1);
                        if (StaticObjectSupport.validateClasses(storageSuperClass, factoryInterface = StaticObjectSupport.getArgumentClass(b, targetMethod, 2, arg2))) {
                            StaticObjectArrayBasedSupport.onBuildInvocation(storageSuperClass, factoryInterface);
                            StaticObjectPodBasedSupport.onBuildInvocation(storageSuperClass, factoryInterface);
                        }
                        return false;
                    }
                });
            }
        }

        static void duringAnalysis(Feature.DuringAnalysisAccess access) {
            StaticObjectArrayBasedSupport.duringAnalysis(access);
        }

        private static Class<?> getArgumentClass(GraphBuilderContext b, ResolvedJavaMethod targetMethod, int parameterIndex, ValueNode arg) {
            SubstrateGraphBuilderPlugins.checkParameterUsage((boolean)arg.isConstant(), (GraphBuilderContext)b, (ResolvedJavaMethod)targetMethod, (int)parameterIndex, (String)"parameter is not a compile time constant");
            return OriginalClassProvider.getJavaClass((ResolvedJavaType)b.getConstantReflection().asJavaType((Constant)arg.asJavaConstant()));
        }

        private static boolean validateClasses(Class<?> storageSuperClass, Class<?> factoryInterface) {
            try {
                VALIDATE_CLASSES.invoke(null, storageSuperClass, factoryInterface);
                return true;
            }
            catch (ReflectiveOperationException e) {
                if (e instanceof InvocationTargetException && e.getCause() instanceof IllegalArgumentException) {
                    Target_com_oracle_truffle_api_staticobject_StaticShape_Builder.ExceptionCache.set(storageSuperClass, factoryInterface, (IllegalArgumentException)e.getCause());
                    return false;
                }
                throw VMError.shouldNotReachHere((Throwable)e);
            }
        }

        static final class StaticObjectArrayBasedSupport {
            private static final Method STORAGE_CLASS_NAME = ReflectionUtil.lookupMethod(StaticShape.Builder.class, (String)"storageClassName", (Class[])new Class[0]);
            private static final Class<?> GENERATOR_CLASS_LOADERS_CLASS = StaticObjectArrayBasedSupport.loadClass("com.oracle.truffle.api.staticobject.GeneratorClassLoaders");
            private static final Constructor<?> GENERATOR_CLASS_LOADERS_CONSTRUCTOR = ReflectionUtil.lookupConstructor(GENERATOR_CLASS_LOADERS_CLASS, (Class[])new Class[]{Class.class});
            private static final Class<?> ARRAY_BASED_STATIC_SHAPE = StaticObjectArrayBasedSupport.loadClass("com.oracle.truffle.api.staticobject.ArrayBasedStaticShape");
            private static final Class<?> ARRAY_BASED_SHAPE_GENERATOR = StaticObjectArrayBasedSupport.loadClass("com.oracle.truffle.api.staticobject.ArrayBasedShapeGenerator");
            private static final Method GET_ARRAY_BASED_SHAPE_GENERATOR = ReflectionUtil.lookupMethod(ARRAY_BASED_SHAPE_GENERATOR, (String)"getShapeGenerator", (Class[])new Class[]{TruffleLanguage.class, GENERATOR_CLASS_LOADERS_CLASS, Class.class, Class.class, String.class});
            private static final Map<Class<?>, Object> GENERATOR_CLASS_LOADERS_MAP = new ConcurrentHashMap();
            private static final int ALIGNMENT_CORRECTION;
            private static Feature.BeforeAnalysisAccess beforeAnalysisAccess;
            private static final IdentityHashMap<Object, Object> registeredShapeGenerators;
            static volatile ConcurrentHashMap<Object, Object> replacements;
            private static final Class<?> FACTORY_CLASS_LOADER;

            StaticObjectArrayBasedSupport() {
            }

            static void duringSetup(Feature.DuringSetupAccess access) {
                if (ALIGNMENT_CORRECTION != 0) {
                    access.registerObjectReplacer(obj -> {
                        Object replacement;
                        boolean isByteArray;
                        if (!replacements.isEmpty() && ((isByteArray = obj instanceof byte[]) || FACTORY_CLASS_LOADER.isInstance(obj.getClass().getClassLoader())) && (replacement = replacements.get(obj)) != null) {
                            if (replacement == obj) {
                                if (isByteArray) {
                                    byte[] oldArray = (byte[])obj;
                                    byte[] newArray = new byte[oldArray.length + ALIGNMENT_CORRECTION];
                                    System.arraycopy(oldArray, 0, newArray, ALIGNMENT_CORRECTION, oldArray.length);
                                    replacement = newArray;
                                } else {
                                    Object newFactory;
                                    Class<?> factoryClass = obj.getClass();
                                    StaticShape shape = (StaticShape)ReflectionUtil.readField(factoryClass, (String)"shape", (Object)obj);
                                    int primitiveArraySize = (Integer)ReflectionUtil.readField(factoryClass, (String)"primitiveArraySize", (Object)obj);
                                    int objectArraySize = (Integer)ReflectionUtil.readField(factoryClass, (String)"objectArraySize", (Object)obj);
                                    Constructor constructor = ReflectionUtil.lookupConstructor(factoryClass, (Class[])new Class[]{shape.getClass(), Integer.TYPE, Integer.TYPE, Boolean.TYPE});
                                    replacement = newFactory = ReflectionUtil.newInstance((Constructor)constructor, (Object[])new Object[]{shape, primitiveArraySize + ALIGNMENT_CORRECTION, objectArraySize, false});
                                }
                                if (!replacements.replace(obj, obj, replacement)) {
                                    replacement = replacements.get(obj);
                                }
                            }
                            return replacement;
                        }
                        return obj;
                    });
                }
            }

            static void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
                beforeAnalysisAccess = access;
                access.registerFieldValueTransformer(ReflectionUtil.lookupField(ArrayBasedShapeGeneratorOffsetTransformer.SHAPE_GENERATOR, (String)"byteArrayOffset"), (FieldValueTransformer)new ArrayBasedShapeGeneratorOffsetTransformer("primitive"));
                access.registerFieldValueTransformer(ReflectionUtil.lookupField(ArrayBasedShapeGeneratorOffsetTransformer.SHAPE_GENERATOR, (String)"objectArrayOffset"), (FieldValueTransformer)new ArrayBasedShapeGeneratorOffsetTransformer("object"));
                access.registerFieldValueTransformer(ReflectionUtil.lookupField(ArrayBasedShapeGeneratorOffsetTransformer.SHAPE_GENERATOR, (String)"shapeOffset"), (FieldValueTransformer)new ArrayBasedShapeGeneratorOffsetTransformer("shape"));
                access.registerFieldValueTransformer(ReflectionUtil.lookupField(StaticProperty.class, (String)"offset"), (FieldValueTransformer)new StaticPropertyOffsetTransformer(ALIGNMENT_CORRECTION));
            }

            static void onBuildInvocation(Class<?> storageSuperClass, Class<?> factoryInterface) {
                try {
                    Object gcls = StaticObjectArrayBasedSupport.getGeneratorClassLoaders(factoryInterface);
                    StaticObjectArrayBasedSupport.getGetShapeGenerator(gcls, storageSuperClass, factoryInterface);
                }
                catch (ReflectiveOperationException e) {
                    throw VMError.shouldNotReachHere((Throwable)e);
                }
            }

            static void duringAnalysis(Feature.DuringAnalysisAccess access) {
                boolean requiresIteration = false;
                ConcurrentHashMap generatorCache = (ConcurrentHashMap)ReflectionUtil.readStaticField(ARRAY_BASED_SHAPE_GENERATOR, (String)"generatorCache");
                for (Map.Entry entry : generatorCache.entrySet()) {
                    Object shapeGenerator = entry.getValue();
                    if (registeredShapeGenerators.containsKey(shapeGenerator)) continue;
                    registeredShapeGenerators.put(shapeGenerator, shapeGenerator);
                    requiresIteration = true;
                    Class storageClass = (Class)ReflectionUtil.readField(ARRAY_BASED_SHAPE_GENERATOR, (String)"generatedStorageClass", shapeGenerator);
                    Class factoryClass = (Class)ReflectionUtil.readField(ARRAY_BASED_SHAPE_GENERATOR, (String)"generatedFactoryClass", shapeGenerator);
                    for (Constructor<?> c : factoryClass.getDeclaredConstructors()) {
                        RuntimeReflection.register((Executable[])new Executable[]{c});
                    }
                    for (String fieldName : new String[]{"primitive", "object", "shape"}) {
                        beforeAnalysisAccess.registerAsUnsafeAccessed(ReflectionUtil.lookupField((Class)storageClass, (String)fieldName));
                    }
                }
                if (requiresIteration) {
                    access.requireAnalysisIteration();
                }
            }

            private static Object getGeneratorClassLoaders(Class<?> factoryInterface) throws ReflectiveOperationException {
                Object newGCLs;
                Object gcls = GENERATOR_CLASS_LOADERS_MAP.get(factoryInterface);
                if (gcls == null && (gcls = GENERATOR_CLASS_LOADERS_MAP.putIfAbsent(factoryInterface, newGCLs = GENERATOR_CLASS_LOADERS_CONSTRUCTOR.newInstance(factoryInterface))) == null) {
                    gcls = newGCLs;
                }
                return gcls;
            }

            private static void getGetShapeGenerator(Object gcls, Class<?> storageSuperClass, Class<?> factoryInterface) throws ReflectiveOperationException {
                String storageClassName = (String)STORAGE_CLASS_NAME.invoke(null, new Object[0]);
                GET_ARRAY_BASED_SHAPE_GENERATOR.invoke(null, null, gcls, storageSuperClass, factoryInterface, storageClassName);
            }

            private static Class<?> loadClass(String name) {
                try {
                    return Class.forName(name);
                }
                catch (ClassNotFoundException e) {
                    throw VMError.shouldNotReachHere((Throwable)e);
                }
            }

            static {
                registeredShapeGenerators = new IdentityHashMap();
                int longIndexScale = ConfigurationValues.getObjectLayout().getArrayIndexScale(JavaKind.Long);
                int misalignment = ConfigurationValues.getObjectLayout().getArrayBaseOffset(JavaKind.Byte) % longIndexScale;
                int n = ALIGNMENT_CORRECTION = misalignment == 0 ? 0 : longIndexScale - misalignment;
                if (ALIGNMENT_CORRECTION != 0) {
                    replacements = new ConcurrentHashMap();
                    ReflectionUtil.writeStaticField(ARRAY_BASED_STATIC_SHAPE, (String)"replacements", replacements);
                    FACTORY_CLASS_LOADER = StaticObjectArrayBasedSupport.loadClass("com.oracle.truffle.api.staticobject.GeneratorClassLoaders$FactoryClassLoader");
                } else {
                    replacements = null;
                    FACTORY_CLASS_LOADER = null;
                }
            }
        }

        private static final class StaticObjectPodBasedSupport {
            private StaticObjectPodBasedSupport() {
            }

            static void onBuildInvocation(Class<?> storageSuperClass, Class<?> factoryInterface) {
                PodSupport.singleton().registerSuperclass(storageSuperClass, factoryInterface);
            }
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> TruffleCheckPreinitializedFiles = new HostedOptionKey((Object)true);
    }

    private static final class TruffleFileCheck
    implements Function<Object, Object> {
        private final ClassInitializationSupport classInitializationSupport;

        TruffleFileCheck(ClassInitializationSupport classInitializationSupport) {
            this.classInitializationSupport = classInitializationSupport;
        }

        @Override
        public Object apply(Object object) {
            TruffleFile file;
            if (object instanceof TruffleFile && (file = (TruffleFile)object).isAbsolute()) {
                UserError.abort((String)("Detected an absolute TruffleFile %s in the image heap. Files with an absolute path created during the context pre-initialization may not be valid at the image execution time. This check can be disabled using -H:-TruffleCheckPreinitializedFiles." + this.classInitializationSupport.objectInstantiationTraceMessage(object, "", culprit -> "")), (Object[])new Object[]{file.getPath()});
            }
            return object;
        }
    }

    private static class AssertionStatusFieldTransformer
    implements FieldValueTransformer {
        private final Class<?> clazz;

        AssertionStatusFieldTransformer(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Object transform(Object receiver, Object originalValue) {
            boolean assertionsEnabled = RuntimeAssertionsSupport.singleton().desiredAssertionStatus(this.clazz);
            return assertionsEnabled;
        }
    }

    private static final class ResetFieldValueTransformer
    implements FieldValueTransformer {
        private static final FieldValueTransformer INSTANCE = new ResetFieldValueTransformer();

        private ResetFieldValueTransformer() {
        }

        public Object transform(Object receiver, Object originalValue) {
            return null;
        }
    }

    static class PossibleReplaceCandidatesSubtypeHandler
    implements BiConsumer<Feature.DuringAnalysisAccess, Class<?>> {
        List<Field> fields = new ArrayList<Field>();
        final Class<?> fieldType;
        final AtomicInteger candidateCount = new AtomicInteger(0);

        PossibleReplaceCandidatesSubtypeHandler(Class<?> fieldType) {
            this.fieldType = fieldType;
        }

        void addField(Feature.DuringAnalysisAccess access, Field field) {
            assert (field.getType() == this.fieldType);
            if (this.candidateCount.get() > 1) {
                access.registerAsUnsafeAccessed(field);
            } else {
                this.fields.add(field);
            }
        }

        @Override
        public void accept(Feature.DuringAnalysisAccess t, Class<?> u) {
            if (AnnotationAccess.getAnnotation(u, DenyReplace.class) != null) {
                return;
            }
            if (Modifier.isAbstract(u.getModifiers())) {
                return;
            }
            if (this.candidateCount.incrementAndGet() == 2) {
                for (Field field : this.fields) {
                    t.registerAsUnsafeAccessed(field);
                }
                this.fields = null;
            }
        }
    }

    public static final class IsCreateProcessDisabled
    implements BooleanSupplier {
        static final boolean ALLOW_CREATE_PROCESS = IsCreateProcessDisabled.query();

        static boolean query() {
            try {
                Class<?> clazz = Class.forName("com.oracle.truffle.polyglot.PolyglotEngineImpl");
                boolean allowCreateProcess = (Boolean)ReflectionUtil.readField(clazz, (String)"ALLOW_CREATE_PROCESS", null);
                return !allowCreateProcess;
            }
            catch (ReflectiveOperationException e) {
                throw VMError.shouldNotReachHere((Throwable)e);
            }
        }

        @Override
        public boolean getAsBoolean() {
            return ALLOW_CREATE_PROCESS;
        }
    }

    public static final class IsEnabled
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return ImageSingletons.contains(TruffleBaseFeature.class);
        }
    }
}

