/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.thread;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.SubstrateReferenceMap;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.threadlocal.FastThreadLocal;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import com.oracle.svm.core.util.ObservableImageHeapMapProvider;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;

public class VMThreadLocalCollector
implements Function<Object, Object>,
LayeredImageSingleton {
    Map<FastThreadLocal, VMThreadLocalInfo> threadLocals;
    Map<VMThreadLocalInfo, FastThreadLocal> infoToThreadLocals;
    private boolean sealed;
    final boolean validateUniqueNames;
    final Set<String> seenNames;
    private List<VMThreadLocalInfo> sortedThreadLocalInfos;
    private SubstrateReferenceMap referenceMap;

    public VMThreadLocalCollector() {
        this(false);
    }

    protected VMThreadLocalCollector(boolean validateUniqueNames) {
        this.validateUniqueNames = validateUniqueNames || Options.ValidateUniqueThreadLocalNames.getValue() != false;
        this.seenNames = validateUniqueNames ? ConcurrentHashMap.newKeySet() : null;
    }

    public void installThreadLocalMap() {
        assert (this.threadLocals == null) : this.threadLocals;
        this.threadLocals = ObservableImageHeapMapProvider.create();
        this.infoToThreadLocals = new ConcurrentHashMap<VMThreadLocalInfo, FastThreadLocal>();
    }

    public VMThreadLocalInfo forFastThreadLocal(FastThreadLocal threadLocal) {
        VMThreadLocalInfo localInfo = this.threadLocals.get(threadLocal);
        if (localInfo == null) {
            if (this.sealed) {
                throw VMError.shouldNotReachHere("VMThreadLocal must have been discovered during static analysis");
            }
            VMThreadLocalInfo newInfo = new VMThreadLocalInfo(threadLocal);
            localInfo = this.threadLocals.computeIfAbsent(threadLocal, tl -> {
                this.infoToThreadLocals.putIfAbsent(newInfo, threadLocal);
                return newInfo;
            });
            if (localInfo == newInfo && this.validateUniqueNames) {
                VMError.guarantee(this.seenNames.add(threadLocal.getName()), "Two VMThreadLocals have the same name: %s", threadLocal.getName());
            }
        }
        return localInfo;
    }

    @Override
    public Object apply(Object source) {
        if (source instanceof FastThreadLocal) {
            FastThreadLocal fastThreadLocal = (FastThreadLocal)source;
            this.forFastThreadLocal(fastThreadLocal);
        }
        return source;
    }

    public int getOffset(FastThreadLocal threadLocal) {
        VMThreadLocalInfo result = this.threadLocals.get(threadLocal);
        return result.offset;
    }

    public VMThreadLocalInfo findInfo(GraphBuilderContext b, ValueNode threadLocalNode) {
        if (!threadLocalNode.isConstant()) {
            throw VMError.shouldNotReachHere("Accessed VMThreadLocal is not a compile time constant: " + String.valueOf(b.getMethod().asStackTraceElement(b.bci())) + " - node " + String.valueOf(VMThreadLocalCollector.unPi(threadLocalNode)));
        }
        FastThreadLocal threadLocal = (FastThreadLocal)b.getSnippetReflection().asObject(FastThreadLocal.class, threadLocalNode.asJavaConstant());
        VMThreadLocalInfo result = this.threadLocals.get(threadLocal);
        assert (result != null);
        return result;
    }

    public FastThreadLocal getThreadLocal(VMThreadLocalInfo vmThreadLocalInfo) {
        return this.infoToThreadLocals.get(vmThreadLocalInfo);
    }

    protected static int calculateSize(VMThreadLocalInfo info) {
        if (info.sizeSupplier != null) {
            int unalignedSize = info.sizeSupplier.getAsInt();
            assert (unalignedSize > 0);
            return NumUtil.roundUp((int)unalignedSize, (int)8);
        }
        return ConfigurationValues.getObjectLayout().sizeInBytes(info.storageKind);
    }

    public void sortThreadLocals() {
        assert (this.sortedThreadLocalInfos == null && this.referenceMap == null);
        this.sealed = true;
        for (VMThreadLocalInfo info : this.threadLocals.values()) {
            assert (info.sizeInBytes == -1);
            info.sizeInBytes = VMThreadLocalCollector.calculateSize(info);
        }
        this.sortedThreadLocalInfos = new ArrayList<VMThreadLocalInfo>(this.threadLocals.values());
        this.sortedThreadLocalInfos.sort(VMThreadLocalCollector::compareThreadLocal);
    }

    public int sortAndAssignOffsets() {
        this.sortThreadLocals();
        this.referenceMap = new SubstrateReferenceMap();
        int nextOffset = 0;
        for (VMThreadLocalInfo info : this.sortedThreadLocalInfos) {
            int alignment = Math.min(8, info.sizeInBytes);
            nextOffset = NumUtil.roundUp((int)nextOffset, (int)alignment);
            if (info.isObject) {
                this.referenceMap.markReferenceAtOffset(nextOffset, true);
            }
            info.offset = nextOffset;
            nextOffset += info.sizeInBytes;
            if (info.offset <= info.maxOffset) continue;
            VMError.shouldNotReachHere("Too many thread local variables with maximum offset " + info.maxOffset + " defined");
        }
        return nextOffset;
    }

    public SubstrateReferenceMap getReferenceMap() {
        assert (this.referenceMap != null);
        return this.referenceMap;
    }

    public List<VMThreadLocalInfo> getSortedThreadLocalInfos() {
        assert (this.sortedThreadLocalInfos != null);
        return this.sortedThreadLocalInfos;
    }

    private static int compareThreadLocal(VMThreadLocalInfo info1, VMThreadLocalInfo info2) {
        if (info1 == info2) {
            return 0;
        }
        int result = Integer.compare(info1.maxOffset, info2.maxOffset);
        if (result == 0 && (result = -Integer.compare(info1.sizeInBytes, info2.sizeInBytes)) == 0 && (result = -Boolean.compare(info1.isObject, info2.isObject)) == 0) {
            result = info1.name.compareTo(info2.name);
        }
        return result;
    }

    private static ValueNode unPi(ValueNode n) {
        ValueNode cur = n;
        while (cur instanceof PiNode) {
            cur = ((PiNode)cur).object();
        }
        return cur;
    }

    @Override
    public final EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
    }

    @Override
    public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
        return LayeredImageSingleton.PersistFlags.NOTHING;
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> ValidateUniqueThreadLocalNames = new HostedOptionKey<Boolean>(false);
    }
}

