/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.util.ClassUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class SubstitutionInvocationPlugins
extends InvocationPlugins {
    private final AnnotationSubstitutionProcessor annotationSubstitutionProcessor;
    private EconomicMap<String, Integer> missingIntrinsicMetrics;

    public SubstitutionInvocationPlugins(AnnotationSubstitutionProcessor annotationSubstitutionProcessor) {
        this.annotationSubstitutionProcessor = annotationSubstitutionProcessor;
        this.missingIntrinsicMetrics = null;
    }

    protected void register(Type declaringClass, InvocationPlugin plugin, boolean allowOverwrite) {
        Class<?> targetClass;
        if (declaringClass instanceof Class) {
            Class annotatedClass = declaringClass;
            targetClass = this.annotationSubstitutionProcessor.getTargetClass(annotatedClass);
            if (targetClass != declaringClass) {
                Executable annotatedMethod = plugin.name.equals("<init>") ? SubstitutionInvocationPlugins.resolveConstructor((Class)annotatedClass, (InvocationPlugin)plugin) : SubstitutionInvocationPlugins.resolveMethod((Class)annotatedClass, (InvocationPlugin)plugin);
                String originalName = this.annotationSubstitutionProcessor.findOriginalElementName(annotatedMethod, targetClass);
                if (originalName == null) {
                    return;
                }
                if (!originalName.equals(plugin.name)) {
                    throw VMError.unimplemented(String.format("InvocationPlugins cannot yet deal with substitution methods that set the target name via the @TargetElement(name = ...) property.\nAnnotated method \"%s\" vs target method \"%s\".", plugin.name, originalName));
                }
            }
        } else {
            targetClass = declaringClass;
        }
        super.register((Type)targetClass, plugin, allowOverwrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyNoPlugin(ResolvedJavaMethod targetMethod, OptionValues options) {
        if (((Boolean)InvocationPlugins.Options.WarnMissingIntrinsic.getValue(options)).booleanValue()) {
            for (Class annotationType : AnnotationAccess.getAnnotationTypes((AnnotatedElement)targetMethod)) {
                if (!ClassUtil.getUnqualifiedName((Class)annotationType).contains("IntrinsicCandidate")) continue;
                String method = String.format("%s.%s%s", targetMethod.getDeclaringClass().toJavaName().replace('.', '/'), targetMethod.getName(), targetMethod.getSignature().toMethodDescriptor());
                SubstitutionInvocationPlugins substitutionInvocationPlugins = this;
                synchronized (substitutionInvocationPlugins) {
                    if (this.missingIntrinsicMetrics == null) {
                        this.missingIntrinsicMetrics = EconomicMap.create();
                        try {
                            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                                if (this.missingIntrinsicMetrics.size() > 0) {
                                    System.out.format("[Warning] Missing intrinsics found: %d%n", this.missingIntrinsicMetrics.size());
                                    ArrayList<Pair> data = new ArrayList<Pair>();
                                    MapCursor cursor = this.missingIntrinsicMetrics.getEntries();
                                    while (cursor.advance()) {
                                        data.add(Pair.create((Object)((String)cursor.getKey()), (Object)((Integer)cursor.getValue())));
                                    }
                                    data.stream().sorted(Comparator.comparing(Pair::getRight, Comparator.reverseOrder())).forEach(pair -> System.out.format("        - %d occurrences during parsing: %s%n", pair.getRight(), pair.getLeft()));
                                }
                            }));
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                    if (this.missingIntrinsicMetrics.containsKey((Object)method)) {
                        this.missingIntrinsicMetrics.put((Object)method, (Object)((Integer)this.missingIntrinsicMetrics.get((Object)method) + 1));
                    } else {
                        System.out.format("[Warning] Missing intrinsic %s found during parsing.%n", method);
                        this.missingIntrinsicMetrics.put((Object)method, (Object)1);
                    }
                    break;
                }
            }
        }
    }
}

