/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.image.NativeImageHeap;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

class ObjectInfoGraph {
    protected final Map<NativeImageHeap.ObjectInfo, NodeData> nodes = new IdentityHashMap<NativeImageHeap.ObjectInfo, NodeData>();

    ObjectInfoGraph() {
    }

    private void doConnect(NativeImageHeap.ObjectInfo from, NativeImageHeap.ObjectInfo to) {
        if (from == null || to == null) {
            throw VMError.shouldNotReachHere("Trying to connect null");
        }
        NodeData fromNodeData = this.addNode(from);
        this.addNode(to);
        fromNodeData.getNeighbours().add(to);
    }

    void connect(NativeImageHeap.ObjectInfo a, NativeImageHeap.ObjectInfo b) {
        this.doConnect(a, b);
        this.doConnect(b, a);
    }

    NodeData addNode(NativeImageHeap.ObjectInfo a) {
        if (this.nodes.containsKey(a)) {
            return this.nodes.get(a);
        }
        return this.nodes.computeIfAbsent(a, objectInfo -> new NodeData(this.nodes.size()));
    }

    Set<NativeImageHeap.ObjectInfo> getNodesSet() {
        return this.nodes.keySet();
    }

    int getNodeId(NativeImageHeap.ObjectInfo objectInfo) {
        NodeData nodeData = this.nodes.get(objectInfo);
        if (nodeData == null) {
            return -1;
        }
        return nodeData.getNodeId();
    }

    Set<NativeImageHeap.ObjectInfo> getNeighbours(NativeImageHeap.ObjectInfo a) {
        NodeData nodeData = this.nodes.get(a);
        if (nodeData == null) {
            return Collections.emptySet();
        }
        return nodeData.getNeighbours();
    }

    int getNumberOfNodes() {
        return this.nodes.size();
    }

    private static final class NodeData {
        private final Set<NativeImageHeap.ObjectInfo> neighbours = Collections.newSetFromMap(new IdentityHashMap());
        private final int nodeId;

        private NodeData(int nodeId) {
            this.nodeId = nodeId;
        }

        private Set<NativeImageHeap.ObjectInfo> getNeighbours() {
            return this.neighbours;
        }

        private int getNodeId() {
            return this.nodeId;
        }
    }
}

