/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.hosted.code.CodeSectionLayouter;
import com.oracle.svm.hosted.code.DefaultCodeSectionLayouter;
import com.oracle.svm.hosted.code.SortByMethodNameCodeSectionLayouter;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class CodeLayoutOptimizationFeature
implements InternalFeature {
    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        ImageSingletons.add(CodeSectionLayouter.class, (Object)this.createCodeSectionLayoutOptimizer());
    }

    protected CodeSectionLayouter createCodeSectionLayoutOptimizer() {
        if (SubstrateOptions.useLLVMBackend()) {
            return new DefaultCodeSectionLayouter();
        }
        return new SortByMethodNameCodeSectionLayouter();
    }
}

