/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.ClassLoaderSupport;
import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.configure.ConditionalRuntimeValue;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.ResourceConfigurationParser;
import com.oracle.svm.core.configure.ResourcesRegistry;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.resources.CompressedGlobTrie.CompressedGlobTrie;
import com.oracle.svm.core.jdk.resources.CompressedGlobTrie.GlobTrieNode;
import com.oracle.svm.core.jdk.resources.CompressedGlobTrie.GlobUtils;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.OptionMigrationMessage;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ConditionalConfigurationRegistry;
import com.oracle.svm.hosted.DeadlockWatchdog;
import com.oracle.svm.hosted.EmbeddedResourceExporter;
import com.oracle.svm.hosted.EmbeddedResourcesInfo;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.LinkAtBuildTimeSupport;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.ReachabilityRegistrationNode;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.jdk.localization.LocalizationFeature;
import com.oracle.svm.hosted.reflect.NativeImageConditionResolver;
import com.oracle.svm.hosted.snippets.SubstrateGraphBuilderPlugins;
import com.oracle.svm.hosted.util.ResourcesUtils;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ResolvedModule;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.util.json.JsonWriter;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeResourceAccess;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeResourceSupport;

@AutomaticallyRegisteredFeature
public class ResourcesFeature
implements InternalFeature {
    static final String MODULE_NAME_ALL_UNNAMED = "ALL-UNNAMED";
    private boolean sealed = false;
    private Set<ConditionalPattern> resourcePatternWorkSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<ConditionalPattern> globWorkSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> excludedResourcePatterns = Collections.newSetFromMap(new ConcurrentHashMap());
    private int loadedConfigurations;
    private ImageClassLoader imageClassLoader;

    public void afterRegistration(Feature.AfterRegistrationAccess a) {
        FeatureImpl.AfterRegistrationAccessImpl access = (FeatureImpl.AfterRegistrationAccessImpl)a;
        this.imageClassLoader = access.getImageClassLoader();
        ResourcesRegistryImpl resourcesRegistry = new ResourcesRegistryImpl();
        ImageSingletons.add(ResourcesRegistry.class, (Object)resourcesRegistry);
        ImageSingletons.add(RuntimeResourceSupport.class, (Object)resourcesRegistry);
        EmbeddedResourcesInfo embeddedResourcesInfo = new EmbeddedResourcesInfo();
        ImageSingletons.add(EmbeddedResourcesInfo.class, (Object)embeddedResourcesInfo);
    }

    private static ResourcesRegistryImpl resourceRegistryImpl() {
        return (ResourcesRegistryImpl)ImageSingletons.lookup(ResourcesRegistry.class);
    }

    protected boolean collectEmbeddedResourcesInfo() {
        return Options.GenerateEmbeddedResourcesFile.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        NativeImageConditionResolver conditionResolver = new NativeImageConditionResolver(access.getImageClassLoader(), ClassInitializationSupport.singleton());
        ResourceConfigurationParser<ConfigurationCondition> parser = ResourceConfigurationParser.create(true, conditionResolver, ResourcesRegistry.singleton(), ConfigurationFiles.Options.StrictConfiguration.getValue());
        this.loadedConfigurations = ConfigurationParserUtils.parseAndRegisterConfigurationsFromCombinedFile(parser, this.imageClassLoader, "resource");
        ResourceConfigurationParser<ConfigurationCondition> legacyParser = ResourceConfigurationParser.create(false, conditionResolver, ResourcesRegistry.singleton(), ConfigurationFiles.Options.StrictConfiguration.getValue());
        this.loadedConfigurations += ConfigurationParserUtils.parseAndRegisterConfigurations(legacyParser, this.imageClassLoader, "resource", ConfigurationFiles.Options.ResourceConfigurationFiles, ConfigurationFiles.Options.ResourceConfigurationResources, ConfigurationFile.RESOURCES.getFileName());
        List patternsWithInfo = this.globWorkSet.stream().map(entry -> new CompressedGlobTrie.GlobWithInfo<ClassLoaderSupport.ConditionWithOrigin>(entry.pattern(), new ClassLoaderSupport.ConditionWithOrigin(entry.condition(), entry.origin()))).toList();
        GlobTrieNode<ClassLoaderSupport.ConditionWithOrigin> trie = CompressedGlobTrie.CompressedGlobTrieBuilder.build(patternsWithInfo);
        Resources.singleton().setResourcesTrieRoot(trie);
        if (HostedImageLayerBuildingSupport.buildingSharedLayer()) {
            String reason = "Included in the base image";
            access.getMetaAccess().lookupJavaType(ReflectionUtil.lookupClass((boolean)false, (String)"com.oracle.svm.core.jdk.resources.CompressedGlobTrie.LiteralNode")).registerAsInstantiated((Object)reason);
            access.getMetaAccess().lookupJavaType(ReflectionUtil.lookupClass((boolean)false, (String)"com.oracle.svm.core.jdk.resources.CompressedGlobTrie.DoubleStarNode")).registerAsInstantiated((Object)reason);
            access.getMetaAccess().lookupJavaType(ReflectionUtil.lookupClass((boolean)false, (String)"com.oracle.svm.core.jdk.resources.CompressedGlobTrie.StarTrieNode")).registerAsInstantiated((Object)reason);
        }
        this.resourcePatternWorkSet.addAll(Options.IncludeResources.getValue().getValuesWithOrigins().map(e -> new ConditionalPattern(ConfigurationCondition.alwaysTrue(), (String)e.value(), e.origin())).toList());
        Set<CompiledConditionalPattern> includePatterns = this.resourcePatternWorkSet.stream().map(e -> new CompiledConditionalPattern(e.condition(), this.makeResourcePattern(e.pattern()), e.origin())).collect(Collectors.toSet());
        this.excludedResourcePatterns.addAll(Options.ExcludeResources.getValue().values());
        ResourcePattern[] excludePatterns = this.compilePatterns(this.excludedResourcePatterns);
        ResourceCollectorImpl collector = new ResourceCollectorImpl(includePatterns, excludePatterns);
        if (MissingRegistrationUtils.throwMissingRegistrationErrors()) {
            includePatterns.forEach(resourcePattern -> collector.registerIncludePattern(resourcePattern.condition, resourcePattern.compiledPattern.moduleName(), resourcePattern.compiledPattern.pattern.pattern()));
        }
        if (!this.resourcePatternWorkSet.isEmpty() || !this.globWorkSet.isEmpty()) {
            try {
                collector.prepareProgressReporter();
                ((ClassLoaderSupport)ImageSingletons.lookup(ClassLoaderSupport.class)).collectResources(collector);
                collector.setAnalysisAccess(access);
            }
            finally {
                collector.shutDownProgressReporter();
            }
        }
        this.resourcePatternWorkSet = Set.of();
        this.globWorkSet = Set.of();
        ResourcesFeature.resourceRegistryImpl().setAnalysisAccess(access);
    }

    private ResourcePattern[] compilePatterns(Set<String> patterns) {
        return patterns.stream().filter(s -> s.length() > 0).map(this::makeResourcePattern).toList().toArray(new ResourcePattern[0]);
    }

    private ResourcePattern makeResourcePattern(String rawPattern) {
        String[] moduleNameWithPattern = SubstrateUtil.split(rawPattern, ":", 2);
        if (moduleNameWithPattern.length < 2) {
            return new ResourcePattern(null, Pattern.compile(moduleNameWithPattern[0]));
        }
        String moduleName = moduleNameWithPattern[0];
        return new ResourcePattern(moduleName, Pattern.compile(moduleNameWithPattern[1]));
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.sealed = true;
        if (Options.GenerateEmbeddedResourcesFile.getValue().booleanValue()) {
            Path reportLocation = NativeImageGenerator.generatedFiles(HostedOptionValues.singleton()).resolve("embedded-resources.json");
            try (JsonWriter writer = new JsonWriter(reportLocation, new OpenOption[0]);){
                EmbeddedResourceExporter.printReport(writer);
            }
            catch (IOException e) {
                throw VMError.shouldNotReachHere("Json writer cannot write to: " + String.valueOf(reportLocation), e);
            }
            BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.BUILD_INFO, reportLocation);
        }
        GlobTrieNode<ClassLoaderSupport.ConditionWithOrigin> root = Resources.singleton().getResourcesTrieRoot();
        CompressedGlobTrie.removeNodes(root, conditionWithOrigin -> !access.isReachable(conditionWithOrigin.condition().getType()));
        CompressedGlobTrie.finalize(root);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (!ImageSingletons.contains(FallbackFeature.class)) {
            return;
        }
        FallbackFeature.FallbackImageRequest resourceFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).resourceFallback;
        if (resourceFallback != null && Options.IncludeResources.getValue().values().isEmpty() && this.loadedConfigurations == 0) {
            throw resourceFallback;
        }
    }

    @Override
    public void registerInvocationPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        if (!reason.duringAnalysis() || reason == ParsingReason.JITCompilation) {
            return;
        }
        Method[] resourceMethods = new Method[]{ReflectionUtil.lookupMethod(Class.class, (String)"getResource", (Class[])new Class[]{String.class}), ReflectionUtil.lookupMethod(Class.class, (String)"getResourceAsStream", (Class[])new Class[]{String.class})};
        Method resolveResourceName = ReflectionUtil.lookupMethod(Class.class, (String)"resolveName", (Class[])new Class[]{String.class});
        for (Method method : resourceMethods) {
            this.registerResourceRegistrationPlugin(plugins.getInvocationPlugins(), method, resolveResourceName, reason);
        }
    }

    private void registerResourceRegistrationPlugin(InvocationPlugins plugins, Method method, final Method resolveResourceName, final ParsingReason reason) {
        ArrayList parameterTypes = new ArrayList();
        assert (!Modifier.isStatic(method.getModifiers()));
        parameterTypes.add(InvocationPlugin.Receiver.class);
        parameterTypes.addAll(Arrays.asList(method.getParameterTypes()));
        plugins.register(method.getDeclaringClass(), (InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, method.getName(), parameterTypes.toArray(new Class[0])){
            final /* synthetic */ ResourcesFeature this$0;
            {
                this.this$0 = this$0;
                super(name, argumentTypes);
            }

            public boolean isDecorator() {
                return true;
            }

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                VMError.guarantee(!this.this$0.sealed, "All bytecode parsing happens before the analysis, i.e., before the registry is sealed");
                Class clazz = SubstrateGraphBuilderPlugins.asConstantObject(b, Class.class, receiver.get(false));
                String resource = SubstrateGraphBuilderPlugins.asConstantObject(b, String.class, arg);
                if (clazz != null && resource != null) {
                    String resourceName;
                    try {
                        resourceName = (String)resolveResourceName.invoke((Object)clazz, resource);
                    }
                    catch (ReflectiveOperationException e) {
                        throw VMError.shouldNotReachHere(e);
                    }
                    b.add((Node)ReachabilityRegistrationNode.create(() -> RuntimeResourceAccess.addResource((Module)clazz.getModule(), (String)resourceName), reason));
                    return true;
                }
                return false;
            }
        });
    }

    private class ResourcesRegistryImpl
    extends ConditionalConfigurationRegistry
    implements ResourcesRegistry<ConfigurationCondition> {
        private final ClassInitializationSupport classInitializationSupport = ClassInitializationSupport.singleton();
        private final Set<String> alreadyAddedResources = new HashSet<String>();

        ResourcesRegistryImpl() {
        }

        public void addResources(ConfigurationCondition condition, String pattern, Object origin) {
            try {
                ResourcesFeature.this.resourcePatternWorkSet.add(new ConditionalPattern(condition, pattern, origin));
            }
            catch (UnsupportedOperationException e) {
                throw UserError.abort("Resource registration should be performed before beforeAnalysis phase.", new Object[0]);
            }
        }

        public void addGlob(ConfigurationCondition condition, String module, String glob, Object origin) {
            String canonicalGlob = Resources.toCanonicalForm(glob);
            String resolvedGlob = GlobUtils.transformToTriePath(canonicalGlob, module);
            ResourcesFeature.this.globWorkSet.add(new ConditionalPattern(condition, resolvedGlob, origin));
        }

        public void addCondition(ConfigurationCondition condition, Module module, String resourcePath) {
            ConditionalRuntimeValue conditionalResource = (ConditionalRuntimeValue)Resources.singleton().getResourceStorage().get((Object)Resources.createStorageKey(module, resourcePath));
            if (conditionalResource != null) {
                this.classInitializationSupport.addForTypeReachedTracking(condition.getType());
                conditionalResource.getConditions().addCondition(condition);
            }
        }

        public void addResourceEntry(Module module, String resourcePath, Object origin) {
            if (!this.shouldRegisterResource(module, resourcePath)) {
                return;
            }
            if (module != null && module.isNamed()) {
                this.processResourceFromModule(module, resourcePath, origin);
            } else {
                this.processResourceFromClasspath(resourcePath, origin);
            }
        }

        public void injectResource(Module module, String resourcePath, byte[] resourceContent, Object origin) {
            EmbeddedResourcesInfo.singleton().declareResourceAsRegistered(module, resourcePath, "INJECTED", origin);
            Resources.singleton().registerResource(module, resourcePath, resourceContent);
        }

        @Override
        public void ignoreResources(ConfigurationCondition condition, String pattern) {
            this.registerConditionalConfiguration(condition, cnd -> {
                UserError.guarantee(!ResourcesFeature.this.sealed, "Resources ignored too late: %s", pattern);
                ResourcesFeature.this.excludedResourcePatterns.add(pattern);
            });
        }

        @Override
        public void addResourceBundles(ConfigurationCondition condition, String name) {
            this.registerConditionalConfiguration(condition, cnd -> ((LocalizationFeature)ImageSingletons.lookup(LocalizationFeature.class)).prepareBundle((ConfigurationCondition)cnd, name));
        }

        @Override
        public void addClassBasedResourceBundle(ConfigurationCondition condition, String basename, String className) {
            this.registerConditionalConfiguration(condition, cnd -> ((LocalizationFeature)ImageSingletons.lookup(LocalizationFeature.class)).prepareClassResourceBundle(basename, className));
        }

        @Override
        public void addResourceBundles(ConfigurationCondition condition, String basename, Collection<Locale> locales) {
            this.registerConditionalConfiguration(condition, cnd -> ((LocalizationFeature)ImageSingletons.lookup(LocalizationFeature.class)).prepareBundle((ConfigurationCondition)cnd, basename, locales));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shouldRegisterResource(Module module, String resourceName) {
            if (module == null || !module.isNamed()) {
                if (this.alreadyAddedResources.contains(resourceName)) {
                    return false;
                }
                Set<String> set = this.alreadyAddedResources;
                synchronized (set) {
                    if (!this.alreadyAddedResources.contains(resourceName)) {
                        this.alreadyAddedResources.add(resourceName);
                        return true;
                    }
                    return false;
                }
            }
            return true;
        }

        private void processResourceFromModule(Module module, String resourcePath, Object origin) {
            try {
                boolean isDirectory;
                String resourcePackage = jdk.internal.module.Resources.toPackageName(resourcePath);
                if (!resourcePackage.isEmpty() && module.getPackages().contains(resourcePackage)) {
                    ModuleSupport.accessModuleByClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, ResourcesFeature.class, (Module)module, (String)resourcePackage);
                }
                if (isDirectory = Files.isDirectory(Path.of(resourcePath, new String[0]), new LinkOption[0])) {
                    String content = ResourcesUtils.getDirectoryContent(resourcePath, false);
                    Resources.singleton().registerDirectoryResource(module, resourcePath, content, false);
                } else {
                    InputStream is = module.getResourceAsStream(resourcePath);
                    this.registerResource(module, resourcePath, false, is);
                }
                Optional<ResolvedModule> resolvedModule = module.getLayer().configuration().findModule(module.getName());
                if (resolvedModule.isPresent()) {
                    Optional<URI> location = resolvedModule.get().reference().location();
                    location.ifPresent(uri -> EmbeddedResourcesInfo.singleton().declareResourceAsRegistered(module, resourcePath, uri.toString(), origin));
                }
            }
            catch (IOException e) {
                Resources.singleton().registerIOException(module, resourcePath, e, LinkAtBuildTimeSupport.singleton().packageOrClassAtBuildTime(resourcePath));
            }
        }

        private void processResourceFromClasspath(String resourcePath, Object origin) {
            Enumeration<URL> urls;
            try {
                urls = ResourcesFeature.this.imageClassLoader.getClassLoader().getResources(resourcePath);
            }
            catch (IOException e) {
                throw VMError.shouldNotReachHere("getResources for resourcePath " + resourcePath + " failed", e);
            }
            HashSet<String> alreadyProcessedResources = new HashSet<String>();
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (alreadyProcessedResources.contains(url.toString())) continue;
                alreadyProcessedResources.add(url.toString());
                try {
                    boolean fromJar = url.getProtocol().equalsIgnoreCase("jar");
                    boolean isDirectory = ResourcesUtils.resourceIsDirectory(url, fromJar);
                    if (isDirectory) {
                        String content = ResourcesUtils.getDirectoryContent(fromJar ? url.toString() : Paths.get(url.toURI()).toString(), fromJar);
                        Resources.singleton().registerDirectoryResource(null, resourcePath, content, fromJar);
                    } else {
                        InputStream is = url.openStream();
                        this.registerResource(null, resourcePath, fromJar, is);
                    }
                    String source = ResourcesUtils.getResourceSource(url, resourcePath, fromJar);
                    EmbeddedResourcesInfo.singleton().declareResourceAsRegistered(null, resourcePath, source, origin);
                }
                catch (IOException e) {
                    Resources.singleton().registerIOException(null, resourcePath, e, LinkAtBuildTimeSupport.singleton().packageOrClassAtBuildTime(resourcePath));
                    return;
                }
                catch (URISyntaxException e) {
                    throw VMError.shouldNotReachHere("resourceIsDirectory for resourcePath " + resourcePath + " failed", e);
                }
            }
        }

        private void registerResource(Module module, String resourcePath, boolean fromJar, InputStream is) {
            if (is == null) {
                Resources.singleton().registerNegativeQuery(module, resourcePath);
                return;
            }
            Resources.singleton().registerResource(module, resourcePath, is, fromJar);
            try {
                is.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Options {
        @OptionMigrationMessage(value="Use a resource-config.json in your META-INF/native-image/<groupID>/<artifactID> directory instead.")
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> IncludeResources = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.build());
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> ExcludeResources = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.build());
        private static final String EMBEDDED_RESOURCES_FILE_NAME = "embedded-resources.json";
        public static final HostedOptionKey<Boolean> GenerateEmbeddedResourcesFile = new HostedOptionKey<Boolean>(false);
    }

    private record ResourcePattern(String moduleName, Pattern pattern) {
        boolean moduleNameMatches(String resourceContainerModuleName) {
            if (this.moduleName == null) {
                return true;
            }
            if (this.moduleName.equals(ResourcesFeature.MODULE_NAME_ALL_UNNAMED)) {
                return resourceContainerModuleName == null;
            }
            return this.moduleName.equals(resourceContainerModuleName);
        }
    }

    private static final class ResourceCollectorImpl
    extends ConditionalConfigurationRegistry
    implements ClassLoaderSupport.ResourceCollector {
        private final Set<CompiledConditionalPattern> includePatterns;
        private final ResourcePattern[] excludePatterns;
        private static final int WATCHDOG_RESET_AFTER_EVERY_N_RESOURCES = 1000;
        private static final int WATCHDOG_INITIAL_WARNING_AFTER_N_SECONDS = 60;
        private static final int WATCHDOG_WARNING_AFTER_EVERY_N_SECONDS = 20;
        private final LongAdder reachedResourceEntries;
        private boolean initialReport;
        private volatile String currentlyProcessedEntry;
        ScheduledExecutorService scheduledExecutor;

        private ResourceCollectorImpl(Set<CompiledConditionalPattern> includePatterns, ResourcePattern[] excludePatterns) {
            this.includePatterns = includePatterns;
            this.excludePatterns = excludePatterns;
            this.reachedResourceEntries = new LongAdder();
            this.initialReport = true;
            this.currentlyProcessedEntry = null;
        }

        private void prepareProgressReporter() {
            this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
            this.scheduledExecutor.scheduleAtFixedRate(() -> {
                if (this.initialReport) {
                    this.initialReport = false;
                    LogUtils.warning((String)"Resource scanning is taking a long time. This can be caused by class-path or module-path entries that point to large directory structures. Please make sure class-/module-path entries are easily accessible to native-image");
                }
                System.out.println("Total scanned entries: " + String.valueOf(this.reachedResourceEntries) + ", current entry: " + (this.currentlyProcessedEntry != null ? this.currentlyProcessedEntry : "Unknown resource"));
            }, 60L, 20L, TimeUnit.SECONDS);
        }

        private void shutDownProgressReporter() {
            if (!this.scheduledExecutor.isShutdown()) {
                this.scheduledExecutor.shutdown();
            }
        }

        @Override
        public List<ClassLoaderSupport.ConditionWithOrigin> isIncluded(Module module, String resourceName, URI resource) {
            this.currentlyProcessedEntry = resource.getScheme().equals("jrt") ? String.valueOf(resource) + "/" + resourceName : resource.toString();
            this.reachedResourceEntries.increment();
            if (this.reachedResourceEntries.longValue() % 1000L == 0L) {
                DeadlockWatchdog.singleton().recordActivity();
            }
            String relativePathWithTrailingSlash = resourceName + "/";
            String moduleName = module == null ? null : module.getName();
            for (ResourcePattern rp : this.excludePatterns) {
                if (!rp.moduleNameMatches(moduleName) || !rp.pattern.matcher(resourceName).matches() && !rp.pattern.matcher(relativePathWithTrailingSlash).matches()) continue;
                return List.of();
            }
            ArrayList<ClassLoaderSupport.ConditionWithOrigin> conditions = new ArrayList<ClassLoaderSupport.ConditionWithOrigin>();
            for (CompiledConditionalPattern rp : this.includePatterns) {
                if (!rp.compiledPattern().moduleNameMatches(moduleName) || !rp.compiledPattern().pattern.matcher(resourceName).matches() && !rp.compiledPattern().pattern.matcher(relativePathWithTrailingSlash).matches()) continue;
                conditions.add(new ClassLoaderSupport.ConditionWithOrigin(rp.condition(), rp.origin()));
            }
            conditions.addAll(ResourceCollectorImpl.getConditionsFromGlobTrie(module, resourceName));
            return conditions;
        }

        private static List<ClassLoaderSupport.ConditionWithOrigin> getConditionsFromGlobTrie(Module module, String resourceName) {
            String pattern = GlobUtils.transformToTriePath(resourceName, module == null ? "" : module.getName());
            List<ClassLoaderSupport.ConditionWithOrigin> types = CompressedGlobTrie.getHostedOnlyContentIfMatched(Resources.singleton().getResourcesTrieRoot(), pattern);
            if (types == null) {
                return Collections.emptyList();
            }
            return types;
        }

        @Override
        public void addResourceEntry(Module module, String resourceName, Object origin) {
            ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResourceEntry(module, resourceName, origin);
        }

        @Override
        public void addResourceConditionally(Module module, String resourceName, ConfigurationCondition condition, Object origin) {
            this.registerConditionalConfiguration(condition, cnd -> {
                this.addResourceEntry(module, resourceName, origin);
                ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addCondition(cnd, module, resourceName);
            });
        }

        @Override
        public void registerIOException(Module module, String resourceName, IOException e, boolean linkAtBuildTime) {
            Resources.singleton().registerIOException(module, resourceName, e, linkAtBuildTime);
        }

        @Override
        public void registerNegativeQuery(Module module, String resourceName) {
            EmbeddedResourcesInfo.singleton().declareResourceAsRegistered(module, resourceName, "", "");
            Resources.singleton().registerNegativeQuery(module, resourceName);
        }

        public void registerIncludePattern(ConfigurationCondition condition, String module, String pattern) {
            this.registerConditionalConfiguration(condition, cnd -> Resources.singleton().registerIncludePattern((ConfigurationCondition)cnd, module, pattern));
        }
    }

    private record CompiledConditionalPattern(ConfigurationCondition condition, ResourcePattern compiledPattern, Object origin) {
    }

    private record ConditionalPattern(ConfigurationCondition condition, String pattern, Object origin) {
    }
}

