/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import com.oracle.svm.core.option.BundleMember;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.SubstitutionReportFeature;
import com.oracle.svm.hosted.classinitialization.ClassInitializationOptions;
import com.oracle.svm.hosted.util.CPUType;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.StringUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ForkJoinPool;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.serviceprovider.GraalServices;
import org.graalvm.collections.EconomicMap;

public class NativeImageOptions {
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> CPUFeatures = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
    @APIOption(name={"list-cpu-features"})
    public static final HostedOptionKey<Boolean> ListCPUFeatures = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> RuntimeCheckedCPUFeatures = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
    public static final String MICRO_ARCHITECTURE_NATIVE = "native";
    public static final String MICRO_ARCHITECTURE_COMPATIBILITY = "compatibility";
    public static final String MICRO_ARCHITECTURE_LIST = "list";
    @APIOption(name={"-march"})
    public static final HostedOptionKey<String> MicroArchitecture = new HostedOptionKey<String>(null){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, String oldValue, String newValue) {
            if (NativeImageOptions.MICRO_ARCHITECTURE_LIST.equals(newValue)) {
                CPUType.printList();
                throw new InterruptImageBuilding("");
            }
        }
    };
    public static final HostedOptionKey<Boolean> NativeArchitecture = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
            MicroArchitecture.update(values, newValue != false ? NativeImageOptions.MICRO_ARCHITECTURE_NATIVE : null);
        }
    };
    public static final HostedOptionKey<Boolean> PrintUniverse = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> PrintAOTCompilation = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> PrintHeapHistogram = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> PrintMethodHistogram = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> PrintImageElementSizes = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> PrintImageHeapPartitionSizes = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> PrintFeatures = new HostedOptionKey<Boolean>(false);
    @BundleMember(role=BundleMember.Role.Output)
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths> TempDirectory = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths>(AccumulatingLocatableMultiOptionValue.Paths.build());
    public static final HostedOptionKey<Boolean> SuppressStderr = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> SuppressStdout = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> AllowFoldMethods = new HostedOptionKey<Boolean>(false);
    @APIOption(name={"report-unsupported-elements-at-runtime"}, deprecated="The option is deprecated and will be removed in the future. The use of unsupported elements is always reported at run time.")
    public static final HostedOptionKey<Boolean> ReportUnsupportedElementsAtRuntime = new HostedOptionKey<Boolean>(true);
    @APIOption(name={"allow-incomplete-classpath"}, deprecated="Allowing an incomplete classpath is now the default. Use --link-at-build-time to report linking errors at image build time for a class or package.")
    static final HostedOptionKey<Boolean> AllowIncompleteClasspath = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<String> CStandard = new HostedOptionKey<String>("C89");
    private static final String PARALLELISM_OPTION_NAME = "parallelism";
    @APIOption(name={"parallelism"})
    public static final HostedOptionKey<Integer> NumberOfThreads = new HostedOptionKey<Integer>(Math.max(1, Math.min(Runtime.getRuntime().availableProcessors(), 32)), key -> {
        int numberOfThreads = (Integer)key.getValue();
        if (numberOfThreads < 1) {
            throw UserError.abort("The number of threads was set to %s. Please set the '--%s' option to at least 1.", numberOfThreads, PARALLELISM_OPTION_NAME);
        }
    });
    public static final HostedOptionKey<Integer> NumberOfAnalysisThreads = new HostedOptionKey<Integer>(-1);
    public static final HostedOptionKey<Boolean> ReturnAfterAnalysis = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> ExitAfterAnalysis = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> ExitAfterRelocatableImageWrite = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> ThrowUnsafeOffsetErrors = new HostedOptionKey<Boolean>(true);
    public static final HostedOptionKey<Boolean> ReportUnsafeOffsetWarnings = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> UnsafeOffsetWarningsAreFatal = new HostedOptionKey<Boolean>(false);
    private static final String DEFAULT_ERROR_FILE_NAME = "svm_err_b_%t_pid%p.md";
    public static final HostedOptionKey<String> ErrorFile = new HostedOptionKey<String>("svm_err_b_%t_pid%p.md");
    public static final HostedOptionKey<Boolean> ReportExceptionStackTraces = new HostedOptionKey<Boolean>(NativeImageOptions.areAssertionsEnabled());
    public static final HostedOptionKey<Integer> MaxReachableTypes = new HostedOptionKey<Integer>(-1);
    @BundleMember(role=BundleMember.Role.Output)
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths> DiagnosticsDir = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths>(AccumulatingLocatableMultiOptionValue.Paths.buildWithDefaults(Paths.get("reports", ReportUtils.timeStampedFileName((String)"diagnostics", (String)""))));
    public static final HostedOptionKey<Boolean> DiagnosticsMode = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                ClassInitializationOptions.PrintClassInitialization.update(values, true);
                SubstitutionReportFeature.Options.ReportPerformedSubstitutions.update(values, true);
                SubstrateOptions.DumpTargetInfo.update(values, true);
                PrintFeatures.update(values, true);
                ReportExceptionStackTraces.update(values, true);
            }
        }
    };
    public static final HostedOptionKey<String> LibGraalClassLoader = new HostedOptionKey<String>("");

    private static boolean areAssertionsEnabled() {
        boolean assertsEnabled = false;
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return assertsEnabled;
    }

    public static CStandards getCStandard() {
        try {
            return CStandards.valueOf(CStandard.getValue());
        }
        catch (IllegalArgumentException e) {
            throw UserError.abort("C standard '%s' is not supported. Supported standards are %s.", CStandard.getValue(), StringUtil.joinSingleQuoted((Object[])CStandards.values()));
        }
    }

    public static int getActualNumberOfThreads() {
        int commonThreadParallelism = ForkJoinPool.getCommonPoolParallelism();
        if (NumberOfThreads.getValue() == 1) {
            assert (commonThreadParallelism == 1) : "Disabled common pool expected to report parallelism of 1";
            commonThreadParallelism = 0;
        }
        return 1 + commonThreadParallelism;
    }

    public static void setCommonPoolParallelism(OptionValues optionValues) {
        boolean isSingleThreadedMode;
        int numberOfCommonPoolThreads = (Integer)NumberOfThreads.getValueOrDefault(optionValues.getMap()) - 1;
        String commonPoolParallelismProperty = "java.util.concurrent.ForkJoinPool.common.parallelism";
        assert (System.getProperty(commonPoolParallelismProperty) == null) : commonPoolParallelismProperty + " already set";
        System.setProperty(commonPoolParallelismProperty, "" + numberOfCommonPoolThreads);
        int actualCommonPoolParallelism = ForkJoinPool.commonPool().getParallelism();
        boolean bl = isSingleThreadedMode = numberOfCommonPoolThreads == 0 && actualCommonPoolParallelism == 1;
        if (!isSingleThreadedMode && actualCommonPoolParallelism != numberOfCommonPoolThreads) {
            String warning = "Failed to set parallelism of common pool (actual parallelism is %s).".formatted(actualCommonPoolParallelism);
            assert (false) : warning;
            LogUtils.warning((String)warning);
        }
    }

    public static final Path getErrorFilePath(OptionValues hostedOptionValues) {
        String errorFile = (String)ErrorFile.getValue(hostedOptionValues);
        Path expandedErrorFile = NativeImageOptions.expandErrorFile(errorFile);
        if (expandedErrorFile.isAbsolute()) {
            throw UserError.abort("The error filename mask specified with " + SubstrateOptionsParser.commandArgument(ErrorFile, errorFile) + " is not allowed to be an absolute path.", new Object[0]);
        }
        return NativeImageGenerator.generatedFiles(hostedOptionValues).resolve(expandedErrorFile);
    }

    private static Path expandErrorFile(String errorFile) {
        String timestamp = new SimpleDateFormat("yyyyMMdd'T'HHmmss.SSS").format(new Date(GraalServices.getGlobalTimeStamp()));
        return Path.of(errorFile.replaceAll("%p", GraalServices.getExecutionID()).replaceAll("%t", timestamp), new String[0]);
    }

    public static enum CStandards {
        C89,
        C99,
        C11;


        public boolean compatibleWith(CStandards standard) {
            return this.compareTo(standard) >= 0;
        }
    }
}

