/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.ImageHeapObjects;
import com.oracle.svm.graal.isolated.ImageHeapRef;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.graal.isolated.IsolatedHandles;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.word.ComparableWord;

public final class IsolatedObjectConstant
extends SubstrateObjectConstant {
    private final ClientHandle<?> handle;
    private Class<?> cachedClass = null;
    private int cachedIdentityHash = 0;

    public IsolatedObjectConstant(ClientHandle<?> handle, boolean compressed) {
        super(compressed);
        this.handle = handle;
        assert (handle.notEqual((ComparableWord)IsolatedHandles.nullHandle()));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public ClientHandle<?> getHandle() {
        return this.handle;
    }

    @Override
    public ResolvedJavaType getType(MetaAccessProvider provider) {
        return provider.lookupJavaType(this.getObjectClass());
    }

    private Class<?> getObjectClass() {
        if (this.cachedClass == null) {
            this.cachedClass = ImageHeapObjects.deref(IsolatedObjectConstant.getObjectClass0(IsolatedCompileContext.get().getClient(), this.handle));
        }
        return this.cachedClass;
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static ImageHeapRef<Class<?>> getObjectClass0(ClientIsolateThread client, ClientHandle<?> h) {
        Object target = IsolatedCompileClient.get().unhand(h);
        return ImageHeapObjects.ref(target.getClass());
    }

    @Override
    public IsolatedObjectConstant compress() {
        assert (!this.compressed);
        return new IsolatedObjectConstant(this.handle, true);
    }

    @Override
    public IsolatedObjectConstant uncompress() {
        assert (this.compressed);
        return new IsolatedObjectConstant(this.handle, false);
    }

    public String toValueString() {
        return this.getObjectClass().getName();
    }

    @Override
    public int getIdentityHashCode() {
        int h = this.cachedIdentityHash;
        if (h == 0) {
            h = IsolatedObjectConstant.getIdentityHashCode0(IsolatedCompileContext.get().getClient(), this.handle);
            this.cachedIdentityHash = h = h == 0 ? 31 : h;
        }
        return h;
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static int getIdentityHashCode0(ClientIsolateThread client, ClientHandle<?> h) {
        Object target = IsolatedCompileClient.get().unhand(h);
        return IsolatedObjectConstant.computeIdentityHashCode(target);
    }
}

