/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hosted.runtimecompilation;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.InvokeInfo;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import java.util.ArrayList;
import java.util.Collection;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class RuntimeCompiledMethod {
    final AnalysisMethod runtimeMethod;
    final AnalysisMethod originalMethod;
    final Collection<AnalysisMethod> inlinedMethods;

    RuntimeCompiledMethod(AnalysisMethod runtimeMethod, Collection<AnalysisMethod> inlinedMethods) {
        this.runtimeMethod = runtimeMethod;
        assert (SubstrateCompilationDirectives.isRuntimeCompiledMethod((ResolvedJavaMethod)runtimeMethod)) : runtimeMethod;
        this.originalMethod = runtimeMethod.getMultiMethod(MultiMethod.ORIGINAL_METHOD);
        assert (this.originalMethod != null);
        this.inlinedMethods = inlinedMethods;
    }

    public AnalysisMethod getRuntimeMethod() {
        return this.runtimeMethod;
    }

    public AnalysisMethod getOriginalMethod() {
        return this.originalMethod;
    }

    public Collection<AnalysisMethod> getInlinedMethods() {
        return this.inlinedMethods;
    }

    public Collection<ResolvedJavaMethod> getInvokeTargets() {
        ArrayList<ResolvedJavaMethod> targets = new ArrayList<ResolvedJavaMethod>();
        for (InvokeInfo invoke : this.runtimeMethod.getInvokes()) {
            if (invoke.isDeoptInvokeTypeFlow()) continue;
            targets.add((ResolvedJavaMethod)invoke.getTargetMethod());
        }
        return targets;
    }
}

