/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect.target;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.reflect.RuntimeMetadataDecoder;
import com.oracle.svm.core.reflect.target.Target_jdk_internal_reflect_ConstantPool;
import com.oracle.svm.core.reflect.target.Target_sun_reflect_annotation_AnnotationTypeMismatchExceptionProxy;
import com.oracle.svm.core.util.VMError;
import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.EnumConstantNotPresentExceptionProxy;
import sun.reflect.annotation.ExceptionProxy;

@TargetClass(value=AnnotationParser.class)
final class Target_sun_reflect_annotation_AnnotationParser {
    Target_sun_reflect_annotation_AnnotationParser() {
    }

    @Substitute
    private static Annotation parseAnnotation2(ByteBuffer buf, Target_jdk_internal_reflect_ConstantPool constPool, Class<?> container, boolean exceptionOnMissingAnnotationClass, Class<? extends Annotation>[] selectAnnotationClasses) {
        AnnotationType type;
        Class<?> annotationClass;
        int typeIndex = buf.getInt();
        if (typeIndex < 0) {
            throw new AnnotationFormatError("Annotations could not be parsed at image build time");
        }
        try {
            annotationClass = RuntimeMetadataDecoder.MetadataAccessor.singleton().getClass(typeIndex);
        }
        catch (Throwable e) {
            if (exceptionOnMissingAnnotationClass) {
                throw new TypeNotPresentException("[unknown]", e);
            }
            Target_sun_reflect_annotation_AnnotationParser.skipAnnotation(buf, false);
            return null;
        }
        if (selectAnnotationClasses != null && !Target_sun_reflect_annotation_AnnotationParser.contains(selectAnnotationClasses, annotationClass)) {
            Target_sun_reflect_annotation_AnnotationParser.skipAnnotation(buf, false);
            return null;
        }
        try {
            type = AnnotationType.getInstance(annotationClass);
        }
        catch (IllegalArgumentException e) {
            Target_sun_reflect_annotation_AnnotationParser.skipAnnotation(buf, false);
            return null;
        }
        Map<String, Class<?>> memberTypes = type.memberTypes();
        LinkedHashMap<String, Object> memberValues = new LinkedHashMap<String, Object>(type.memberDefaults());
        int numMembers = buf.getShort() & 0xFFFF;
        for (int i = 0; i < numMembers; ++i) {
            int memberNameIndex = buf.getInt();
            String memberName = RuntimeMetadataDecoder.MetadataAccessor.singleton().getMemberName(memberNameIndex);
            Class<?> memberType = memberTypes.get(memberName);
            if (memberType == null) {
                Target_sun_reflect_annotation_AnnotationParser.skipMemberValue(buf);
                continue;
            }
            Object value = Target_sun_reflect_annotation_AnnotationParser.parseMemberValue(memberType, buf, constPool, container);
            if (value instanceof Target_sun_reflect_annotation_AnnotationTypeMismatchExceptionProxy) {
                ((Target_sun_reflect_annotation_AnnotationTypeMismatchExceptionProxy)value).setMember(type.members().get(memberName));
            }
            memberValues.put(memberName, value);
        }
        return Target_sun_reflect_annotation_AnnotationParser.annotationForMap(annotationClass, memberValues);
    }

    @Alias
    public static native Object parseMemberValue(Class<?> var0, ByteBuffer var1, Target_jdk_internal_reflect_ConstantPool var2, Class<?> var3);

    @Substitute
    private static Object parseClassValue(ByteBuffer buf, Target_jdk_internal_reflect_ConstantPool constPool, Class<?> container) {
        int classIndex = buf.getInt();
        try {
            return RuntimeMetadataDecoder.MetadataAccessor.singleton().getClass(classIndex);
        }
        catch (Throwable t) {
            throw VMError.shouldNotReachHereSubstitution();
        }
    }

    @Substitute
    private static Object parseEnumValue(Class<? extends Enum> enumType, ByteBuffer buf, Target_jdk_internal_reflect_ConstantPool constPool, Class<?> container) {
        int typeIndex = buf.getInt();
        int constNameIndex = buf.getInt();
        String constName = RuntimeMetadataDecoder.MetadataAccessor.singleton().getMemberName(constNameIndex);
        if (!enumType.isEnum() || enumType != RuntimeMetadataDecoder.MetadataAccessor.singleton().getClass(typeIndex)) {
            Target_sun_reflect_annotation_AnnotationTypeMismatchExceptionProxy e = new Target_sun_reflect_annotation_AnnotationTypeMismatchExceptionProxy();
            e.constructor(enumType.getTypeName() + "." + constName);
            return e;
        }
        try {
            return Enum.valueOf(enumType, constName);
        }
        catch (IllegalArgumentException e) {
            return new EnumConstantNotPresentExceptionProxy(enumType, constName);
        }
    }

    @Substitute
    private static Object parseConst(int tag, ByteBuffer buf, Target_jdk_internal_reflect_ConstantPool constPool) {
        switch (tag) {
            case 66: {
                return buf.get();
            }
            case 67: {
                return Character.valueOf(buf.getChar());
            }
            case 68: {
                return buf.getDouble();
            }
            case 70: {
                return Float.valueOf(buf.getFloat());
            }
            case 73: {
                return buf.getInt();
            }
            case 74: {
                return buf.getLong();
            }
            case 83: {
                return buf.getShort();
            }
            case 90: {
                byte value = buf.get();
                assert (value == 1 || value == 0);
                return value == 1;
            }
            case 115: {
                return RuntimeMetadataDecoder.MetadataAccessor.singleton().getOtherString(buf.getInt());
            }
            case 69: {
                return RuntimeMetadataDecoder.MetadataAccessor.singleton().getObject(buf.getInt());
            }
        }
        throw new AnnotationFormatError("Invalid member-value tag in annotation: " + tag);
    }

    @Substitute
    private static Object parseByteArray(int length, ByteBuffer buf, Target_jdk_internal_reflect_ConstantPool constPool) {
        byte[] result = new byte[length];
        boolean typeMismatch = false;
        byte tag = 0;
        for (int i = 0; i < length; ++i) {
            tag = buf.get();
            if (tag == 66) {
                result[i] = buf.get();
                continue;
            }
            Target_sun_reflect_annotation_AnnotationParser.skipMemberValue(tag, buf);
            typeMismatch = true;
        }
        return typeMismatch ? (Object)Target_sun_reflect_annotation_AnnotationParser.exceptionProxy(tag) : result;
    }

    @Substitute
    private static Object parseCharArray(int length, ByteBuffer buf, Target_jdk_internal_reflect_ConstantPool constPool) {
        char[] result = new char[length];
        boolean typeMismatch = false;
        byte tag = 0;
        for (int i = 0; i < length; ++i) {
            tag = buf.get();
            if (tag == 67) {
                result[i] = buf.getChar();
                continue;
            }
            Target_sun_reflect_annotation_AnnotationParser.skipMemberValue(tag, buf);
            typeMismatch = true;
        }
        return typeMismatch ? (Object)Target_sun_reflect_annotation_AnnotationParser.exceptionProxy(tag) : result;
    }

    @Substitute
    private static Object parseDoubleArray(int length, ByteBuffer buf, Target_jdk_internal_reflect_ConstantPool constPool) {
        double[] result = new double[length];
        boolean typeMismatch = false;
        byte tag = 0;
        for (int i = 0; i < length; ++i) {
            tag = buf.get();
            if (tag == 68) {
                result[i] = buf.getDouble();
                continue;
            }
            Target_sun_reflect_annotation_AnnotationParser.skipMemberValue(tag, buf);
            typeMismatch = true;
        }
        return typeMismatch ? (Object)Target_sun_reflect_annotation_AnnotationParser.exceptionProxy(tag) : result;
    }

    @Substitute
    private static Object parseFloatArray(int length, ByteBuffer buf, Target_jdk_internal_reflect_ConstantPool constPool) {
        float[] result = new float[length];
        boolean typeMismatch = false;
        byte tag = 0;
        for (int i = 0; i < length; ++i) {
            tag = buf.get();
            if (tag == 70) {
                result[i] = buf.getFloat();
                continue;
            }
            Target_sun_reflect_annotation_AnnotationParser.skipMemberValue(tag, buf);
            typeMismatch = true;
        }
        return typeMismatch ? (Object)Target_sun_reflect_annotation_AnnotationParser.exceptionProxy(tag) : result;
    }

    @Substitute
    private static Object parseIntArray(int length, ByteBuffer buf, Target_jdk_internal_reflect_ConstantPool constPool) {
        int[] result = new int[length];
        boolean typeMismatch = false;
        byte tag = 0;
        for (int i = 0; i < length; ++i) {
            tag = buf.get();
            if (tag == 73) {
                result[i] = buf.getInt();
                continue;
            }
            Target_sun_reflect_annotation_AnnotationParser.skipMemberValue(tag, buf);
            typeMismatch = true;
        }
        return typeMismatch ? (Object)Target_sun_reflect_annotation_AnnotationParser.exceptionProxy(tag) : result;
    }

    @Substitute
    private static Object parseLongArray(int length, ByteBuffer buf, Target_jdk_internal_reflect_ConstantPool constPool) {
        long[] result = new long[length];
        boolean typeMismatch = false;
        byte tag = 0;
        for (int i = 0; i < length; ++i) {
            tag = buf.get();
            if (tag == 74) {
                result[i] = buf.getLong();
                continue;
            }
            Target_sun_reflect_annotation_AnnotationParser.skipMemberValue(tag, buf);
            typeMismatch = true;
        }
        return typeMismatch ? (Object)Target_sun_reflect_annotation_AnnotationParser.exceptionProxy(tag) : result;
    }

    @Substitute
    private static Object parseShortArray(int length, ByteBuffer buf, Target_jdk_internal_reflect_ConstantPool constPool) {
        short[] result = new short[length];
        boolean typeMismatch = false;
        byte tag = 0;
        for (int i = 0; i < length; ++i) {
            tag = buf.get();
            if (tag == 83) {
                result[i] = buf.getShort();
                continue;
            }
            Target_sun_reflect_annotation_AnnotationParser.skipMemberValue(tag, buf);
            typeMismatch = true;
        }
        return typeMismatch ? (Object)Target_sun_reflect_annotation_AnnotationParser.exceptionProxy(tag) : result;
    }

    @Substitute
    private static Object parseBooleanArray(int length, ByteBuffer buf, Target_jdk_internal_reflect_ConstantPool constPool) {
        boolean[] result = new boolean[length];
        boolean typeMismatch = false;
        byte tag = 0;
        for (int i = 0; i < length; ++i) {
            tag = buf.get();
            if (tag == 90) {
                byte value = buf.get();
                if (value != 0 && value != 1) {
                    Target_sun_reflect_annotation_AnnotationParser.skipMemberValue(tag, buf);
                    typeMismatch = true;
                }
                result[i] = value == 1;
                continue;
            }
            Target_sun_reflect_annotation_AnnotationParser.skipMemberValue(tag, buf);
            typeMismatch = true;
        }
        return typeMismatch ? (Object)Target_sun_reflect_annotation_AnnotationParser.exceptionProxy(tag) : result;
    }

    @Substitute
    private static Object parseStringArray(int length, ByteBuffer buf, Target_jdk_internal_reflect_ConstantPool constPool) {
        String[] result = new String[length];
        boolean typeMismatch = false;
        byte tag = 0;
        for (int i = 0; i < length; ++i) {
            tag = buf.get();
            if (tag == 115) {
                int index = buf.getInt();
                result[i] = RuntimeMetadataDecoder.MetadataAccessor.singleton().getOtherString(index);
                continue;
            }
            Target_sun_reflect_annotation_AnnotationParser.skipMemberValue(tag, buf);
            typeMismatch = true;
        }
        return typeMismatch ? Target_sun_reflect_annotation_AnnotationParser.exceptionProxy(tag) : result;
    }

    @Substitute
    private static void skipAnnotation(ByteBuffer buf, boolean complete) {
        if (complete) {
            buf.getInt();
        }
        int numMembers = buf.getShort() & 0xFFFF;
        for (int i = 0; i < numMembers; ++i) {
            buf.getInt();
            Target_sun_reflect_annotation_AnnotationParser.skipMemberValue(buf);
        }
    }

    @Alias
    private static native void skipMemberValue(ByteBuffer var0);

    @Substitute
    private static void skipMemberValue(int tag, ByteBuffer buf) {
        block0 : switch (tag) {
            case 101: {
                buf.getLong();
                break;
            }
            case 64: {
                Target_sun_reflect_annotation_AnnotationParser.skipAnnotation(buf, true);
                break;
            }
            case 91: {
                Target_sun_reflect_annotation_AnnotationParser.skipArray(buf);
                break;
            }
            case 99: 
            case 115: {
                buf.getInt();
                break;
            }
            default: {
                switch (tag) {
                    case 66: 
                    case 90: {
                        buf.get();
                        break block0;
                    }
                    case 67: 
                    case 83: {
                        buf.getShort();
                        break block0;
                    }
                    case 70: 
                    case 73: {
                        buf.getInt();
                        break block0;
                    }
                    case 68: 
                    case 74: {
                        buf.getLong();
                    }
                }
            }
        }
    }

    @Alias
    private static native void skipArray(ByteBuffer var0);

    @Alias
    public static native Annotation annotationForMap(Class<? extends Annotation> var0, Map<String, Object> var1);

    @Alias
    private static native ExceptionProxy exceptionProxy(int var0);

    @Alias
    private static native boolean contains(Object[] var0, Object var1);
}

