/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect.target;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.reflect.MissingReflectionRegistrationUtils;
import com.oracle.svm.core.reflect.target.EncodedRuntimeMetadataSupplier;
import com.oracle.svm.core.reflect.target.ExecutableAccessorComputer;
import com.oracle.svm.core.reflect.target.ReflectionMetadataComputer;
import com.oracle.svm.core.reflect.target.Target_jdk_internal_reflect_ConstructorAccessor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import org.graalvm.nativeimage.ImageSingletons;
import sun.reflect.generics.repository.ConstructorRepository;

@TargetClass(value=Constructor.class)
public final class Target_java_lang_reflect_Constructor {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private ConstructorRepository genericInfo;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=AnnotationsComputer.class)
    byte[] annotations;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ParameterAnnotationsComputer.class)
    byte[] parameterAnnotations;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ExecutableAccessorComputer.class)
    Target_jdk_internal_reflect_ConstructorAccessor constructorAccessor;

    @Alias
    @TargetElement(name="<init>")
    native void constructor(Class<?> var1, Class<?>[] var2, Class<?>[] var3, int var4, int var5, String var6, byte[] var7, byte[] var8);

    @Alias
    native Target_java_lang_reflect_Constructor copy();

    @Substitute
    public Target_jdk_internal_reflect_ConstructorAccessor acquireConstructorAccessor() {
        if (this.constructorAccessor == null) {
            throw MissingReflectionRegistrationUtils.errorForQueriedOnlyExecutable(SubstrateUtil.cast(this, Executable.class));
        }
        return this.constructorAccessor;
    }

    static class ParameterAnnotationsComputer
    extends ReflectionMetadataComputer {
        ParameterAnnotationsComputer() {
        }

        public Object transform(Object receiver, Object originalValue) {
            return ((EncodedRuntimeMetadataSupplier)ImageSingletons.lookup(EncodedRuntimeMetadataSupplier.class)).getParameterAnnotationsEncoding((Executable)receiver);
        }
    }

    static class AnnotationsComputer
    extends ReflectionMetadataComputer {
        AnnotationsComputer() {
        }

        public Object transform(Object receiver, Object originalValue) {
            return ((EncodedRuntimeMetadataSupplier)ImageSingletons.lookup(EncodedRuntimeMetadataSupplier.class)).getAnnotationsEncoding((AccessibleObject)receiver);
        }
    }
}

