/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.posix.PosixSignalHandlerSupport;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.thread.NativeSpinLockUtils;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class IgnoreSignalsStartupHook
implements RuntimeSupport.Hook {
    private static final CGlobalData<Pointer> NOOP_HANDLERS_INSTALLED = CGlobalDataFactory.createWord();
    static final CEntryPointLiteral<Signal.SignalDispatcher> NOOP_SIGNAL_HANDLER = CEntryPointLiteral.create(IgnoreSignalsStartupHook.class, (String)"noopSignalHandler", (Class[])new Class[]{Integer.TYPE});

    IgnoreSignalsStartupHook() {
    }

    @CEntryPoint(publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    @Uninterruptible(reason="empty signal handler, Isolate is not set up")
    static void noopSignalHandler(int sig) {
    }

    @Override
    public void execute(boolean isFirstIsolate) {
        boolean isSignalHandlingAllowed = SubstrateOptions.EnableSignalHandling.getValue();
        if (isSignalHandlingAllowed && IgnoreSignalsStartupHook.isFirst()) {
            IgnoreSignalsStartupHook.installNoopHandler(Signal.SignalEnum.SIGPIPE, isSignalHandlingAllowed);
            IgnoreSignalsStartupHook.installNoopHandler(Signal.SignalEnum.SIGXFSZ, isSignalHandlingAllowed);
        }
    }

    private static boolean isFirst() {
        Word actual;
        Word expected = (Word)WordFactory.zero();
        return expected == (actual = (Word)NOOP_HANDLERS_INSTALLED.get().compareAndSwapWord(0, (WordBase)expected, (WordBase)((Word)WordFactory.unsigned((int)1)), LocationIdentity.ANY_LOCATION));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    private static void installNoopHandler(Signal.SignalEnum signal, boolean isSignalHandlingAllowed) {
        CIntPointer lock = PosixSignalHandlerSupport.LOCK.get();
        NativeSpinLockUtils.lockNoTransition(lock);
        try {
            int signum = signal.getCValue();
            PointerBase currentDispatcher = PosixSignalHandlerSupport.getCurrentDispatcher(signum);
            if (currentDispatcher == Signal.SIG_DFL()) {
                Signal.SignalDispatcher newDispatcher = PosixSignalHandlerSupport.getDefaultDispatcher(signum);
                assert (newDispatcher == NOOP_SIGNAL_HANDLER.getFunctionPointer());
                Signal.SignalDispatcher signalResult = PosixSignalHandlerSupport.installNativeSignalHandler0(signum, newDispatcher, Signal.SA_RESTART(), isSignalHandlingAllowed);
                VMError.guarantee(signalResult != Signal.SIG_ERR(), "IgnoreSignalsStartupHook: Could not install signal handler");
            }
        }
        finally {
            NativeSpinLockUtils.unlock(lock);
        }
    }
}

